/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceFolderType;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class CreateFileResourceQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.CreateFileResourceQuickFix");
    private final AndroidFacet myFacet;
    private final ResourceFolderType myResourceType;
    private final String myResourceName;
    private final PsiFile myFile;
    private final boolean myChooseResName;

    public CreateFileResourceQuickFix(@NotNull AndroidFacet facet2, @NotNull ResourceFolderType resourceType, @NotNull String resourceName, @NotNull PsiFile file, boolean chooseResName) {
        if (facet2 == null) {
            CreateFileResourceQuickFix.$$$reportNull$$$0(0);
        }
        if (resourceType == null) {
            CreateFileResourceQuickFix.$$$reportNull$$$0(1);
        }
        if (resourceName == null) {
            CreateFileResourceQuickFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            CreateFileResourceQuickFix.$$$reportNull$$$0(3);
        }
        this.myFacet = facet2;
        this.myResourceType = resourceType;
        this.myResourceName = resourceName;
        this.myFile = file;
        this.myChooseResName = chooseResName;
    }

    @NotNull
    public String getName() {
        String string = AndroidBundle.message("create.file.resource.quickfix.name", this.myResourceName, "'" + this.myResourceType.getName() + "' directory");
        if (string == null) {
            CreateFileResourceQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = AndroidBundle.message("create.file.resource.intention.name", this.myResourceType.getName(), this.myResourceName + ".xml");
        if (string == null) {
            CreateFileResourceQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = AndroidBundle.message("quick.fixes.family", new Object[0]);
        if (string == null) {
            CreateFileResourceQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            CreateFileResourceQuickFix.$$$reportNull$$$0(7);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            CreateFileResourceQuickFix.$$$reportNull$$$0(8);
        }
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> {
            XmlFile newFile = CreateResourceFileAction.createFileResource(this.myFacet, this.myResourceType, this.myResourceName + ".xml", null, null, this.myChooseResName, null, null, dataContext);
            if (newFile != null) {
                UndoUtil.markPsiFileForUndo((PsiFile)this.myFile);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        VirtualFile resourceDir;
        if (project == null) {
            CreateFileResourceQuickFix.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            CreateFileResourceQuickFix.$$$reportNull$$$0(10);
        }
        if ((resourceDir = ResourceFolderManager.getInstance(this.myFacet).getPrimaryFolder()) == null) {
            return;
        }
        final PsiDirectory psiResDir = PsiManager.getInstance((Project)project).findDirectory(resourceDir);
        if (psiResDir == null) {
            return;
        }
        final String resDirName = this.myResourceType.getName();
        PsiDirectory resSubdir = psiResDir.findSubdirectory(resDirName);
        if (resSubdir == null) {
            resSubdir = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                public PsiDirectory compute() {
                    return psiResDir.createSubdirectory(resDirName);
                }
            });
        }
        try {
            AndroidResourceUtil.createFileResource(this.myResourceName, resSubdir, CreateTypedResourceFileAction.getDefaultRootTagByResourceType(this.myResourceType), resDirName, false);
            UndoUtil.markPsiFileForUndo((PsiFile)this.myFile);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/CreateFileResourceQuickFix";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/CreateFileResourceQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

