/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.dom.resources.ResourcesDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class CreateValueResourceQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    private final AndroidFacet myFacet;
    private final ResourceType myResourceType;
    private final String myResourceName;
    private final PsiFile myFile;
    private final boolean myChooseName;

    public CreateValueResourceQuickFix(@NotNull AndroidFacet facet2, @NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull PsiFile file, boolean chooseName) {
        if (facet2 == null) {
            CreateValueResourceQuickFix.$$$reportNull$$$0(0);
        }
        if (resourceType == null) {
            CreateValueResourceQuickFix.$$$reportNull$$$0(1);
        }
        if (resourceName == null) {
            CreateValueResourceQuickFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            CreateValueResourceQuickFix.$$$reportNull$$$0(3);
        }
        this.myFacet = facet2;
        this.myResourceType = resourceType;
        this.myResourceName = resourceName;
        this.myFile = file;
        this.myChooseName = chooseName;
    }

    @NotNull
    public String getName() {
        String string = AndroidBundle.message("create.value.resource.quickfix.name", this.myResourceName, AndroidResourceUtil.getDefaultResourceFileName(this.myResourceType));
        if (string == null) {
            CreateValueResourceQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = AndroidBundle.message("create.value.resource.intention.name", this.myResourceType, this.myResourceName);
        if (string == null) {
            CreateValueResourceQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = AndroidBundle.message("quick.fixes.family", new Object[0]);
        if (string == null) {
            CreateValueResourceQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            CreateValueResourceQuickFix.$$$reportNull$$$0(7);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            CreateValueResourceQuickFix.$$$reportNull$$$0(8);
        }
        this.doInvoke();
    }

    protected boolean doInvoke() {
        Project project = this.myFile.getProject();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String fileName = AndroidResourceUtil.getDefaultResourceFileName(this.myResourceType);
            assert (fileName != null);
            VirtualFile resourceDir = ResourceFolderManager.getInstance(this.myFacet).getPrimaryFolder();
            assert (resourceDir != null);
            if (!AndroidResourceUtil.createValueResource(project, resourceDir, this.myResourceName, this.myResourceType, fileName, Collections.singletonList("values"), "a")) {
                return false;
            }
        } else {
            VirtualFile defaultFile;
            DomFileDescription description;
            String value2 = this.myResourceType == ResourceType.STYLEABLE || this.myResourceType == ResourceType.ATTR ? "\n" : null;
            VirtualFile defaultFileToCreate = null;
            if (this.myFile instanceof XmlFile && this.myFile.isWritable() && this.myFile.getManager().isInProject((PsiElement)this.myFile) && (description = DomManager.getDomManager((Project)project).getDomFileDescription((XmlFile)this.myFile)) instanceof ResourcesDomFileDescription && (defaultFile = this.myFile.getVirtualFile()) != null) {
                defaultFileToCreate = defaultFile;
            }
            CreateXmlResourceDialog dialog2 = new CreateXmlResourceDialog(this.myFacet.getModule(), this.myResourceType, this.myResourceName, value2, this.myChooseName, defaultFileToCreate, this.myFile.getVirtualFile());
            dialog2.setTitle("New " + StringUtil.capitalize((String)this.myResourceType.getDisplayName()) + " Value Resource");
            if (!dialog2.showAndGet()) {
                return false;
            }
            VirtualFile resourceDir = dialog2.getResourceDirectory();
            if (resourceDir == null) {
                AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", this.myFacet.getModule()));
                return false;
            }
            String fileName = dialog2.getFileName();
            List<String> dirNames = dialog2.getDirNames();
            String resValue = dialog2.getValue();
            String resName = dialog2.getResourceName();
            if (!AndroidResourceUtil.createValueResource(project, resourceDir, resName, this.myResourceType, fileName, dirNames, resValue)) {
                return false;
            }
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UndoUtil.markPsiFileForUndo((PsiFile)this.myFile);
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            CreateValueResourceQuickFix.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            CreateValueResourceQuickFix.$$$reportNull$$$0(10);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/CreateValueResourceQuickFix";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/CreateValueResourceQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

