/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Locale;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

public class AndroidCreateOnClickHandlerAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        String string = AndroidBundle.message("create.on.click.handler.intention.text", new Object[0]);
        if (string == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(1);
        }
        if (editor2 == null || !(file instanceof XmlFile)) {
            return false;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file);
        if (facet2 == null) {
            return false;
        }
        XmlAttributeValue attrValue = AndroidCreateOnClickHandlerAction.getXmlAttributeValue(file, editor2);
        if (attrValue == null) {
            return false;
        }
        PsiElement parent = attrValue.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return false;
        }
        GenericAttributeValue domValue = DomManager.getDomManager((Project)project).getDomElement((XmlAttribute)parent);
        if (domValue == null || !(domValue.getConverter() instanceof OnClickConverter)) {
            return false;
        }
        String methodName = attrValue.getValue();
        return methodName != null && StringUtil.isJavaIdentifier((String)methodName);
    }

    @Nullable
    private static XmlAttributeValue getXmlAttributeValue(PsiFile file, Editor editor2) {
        int offset = editor2.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        return element != null ? (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class) : null;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PsiClass selectedClass;
        if (project == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(2);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file);
        assert (facet2 != null);
        XmlAttributeValue attrValue = AndroidCreateOnClickHandlerAction.getXmlAttributeValue(file, editor2);
        assert (attrValue != null);
        String methodName = attrValue.getValue();
        assert (methodName != null);
        GenericAttributeValue domValue = DomManager.getDomManager((Project)project).getDomElement((XmlAttribute)attrValue.getParent());
        assert (domValue != null);
        OnClickConverter converter = (OnClickConverter)domValue.getConverter();
        PsiClass activityBaseClass = JavaPsiFacade.getInstance((Project)project).findClass("android.app.Activity", facet2.getModule().getModuleWithDependenciesAndLibrariesScope(false));
        if (activityBaseClass == null) {
            return;
        }
        GlobalSearchScope scope = facet2.getModule().getModuleScope(false);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Ref selClassRef = Ref.create();
            ClassInheritorsSearch.search((PsiClass)activityBaseClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach(psiClass -> {
                if (!psiClass.isInterface() && !psiClass.hasModifierProperty("abstract")) {
                    selClassRef.set(psiClass);
                    return false;
                }
                return true;
            });
            selectedClass = (PsiClass)selClassRef.get();
        } else {
            TreeClassChooser chooser2 = TreeClassChooserFactory.getInstance((Project)project).createInheritanceClassChooser("Choose Activity to Create the Method", scope, activityBaseClass, null, aClass -> !converter.findHandlerMethod(aClass, methodName));
            chooser2.showDialog();
            selectedClass = chooser2.getSelected();
        }
        if (selectedClass != null) {
            AndroidCreateOnClickHandlerAction.addHandlerMethodAndNavigate(project, selectedClass, methodName, converter.getDefaultMethodParameterType(selectedClass));
        }
    }

    @NotNull
    private static String suggestVarName(@NotNull String type) {
        if (type == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(3);
        }
        for (int i2 = type.length() - 1; i2 >= 0; --i2) {
            char c = type.charAt(i2);
            if (!Character.isUpperCase(c)) continue;
            String string = type.substring(i2).toLowerCase(Locale.US);
            if (string == null) {
                AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "o";
    }

    @Nullable
    public static PsiMethod addHandlerMethod(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull String methodName, @NotNull String methodParamType) {
        PsiFile file;
        if (project == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(5);
        }
        if (psiClass == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(6);
        }
        if (methodName == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(7);
        }
        if (methodParamType == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(8);
        }
        if ((file = psiClass.getContainingFile()) == null) {
            return null;
        }
        String varName = AndroidCreateOnClickHandlerAction.suggestVarName(methodParamType);
        Language language = psiClass.getLanguage();
        if (language.is((Language)JavaLanguage.INSTANCE)) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiMethod method = (PsiMethod)psiClass.add((PsiElement)factory.createMethodFromText("public void " + methodName + "(" + methodParamType + " " + varName + ") {}", (PsiElement)psiClass));
            PsiMethod method1 = (PsiMethod)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)method);
            method1 = (PsiMethod)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)method1);
            return (PsiMethod)method.replace((PsiElement)method1);
        }
        if (language.is((Language)KotlinLanguage.INSTANCE)) {
            if (!(psiClass instanceof KtLightClass)) {
                return null;
            }
            KtClassOrObject origin = (KtClassOrObject)((KtLightClass)psiClass).getKotlinOrigin();
            if (origin == null) {
                return null;
            }
            KtNamedFunction namedFunction = KtPsiFactoryKt.KtPsiFactory((PsiElement)origin).createFunction("fun " + methodName + "(" + varName + ": " + methodParamType + ") {}");
            KtDeclaration anchor = (KtDeclaration)Iterables.getLast((Iterable)origin.getDeclarations(), null);
            GenerateUtilKt.insertMember(null, (KtClassOrObject)origin, (KtDeclaration)namedFunction, (PsiElement)anchor);
        }
        return null;
    }

    public static void addHandlerMethodAndNavigate(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull String methodName, @NotNull String methodParamType) {
        if (project == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(9);
        }
        if (psiClass == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(10);
        }
        if (methodName == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(11);
        }
        if (methodParamType == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(12);
        }
        if (!AndroidUtils.isIdentifier(methodName)) {
            Messages.showErrorDialog((Project)project, (String)String.format("%1$s is not a valid Java identifier/method name.", methodName), (String)"Invalid Name");
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiJavaToken lBrace;
            PsiFile javaFile;
            PsiMethod method = AndroidCreateOnClickHandlerAction.addHandlerMethod(project, psiClass, methodName, methodParamType);
            if (method == null) {
                return;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                PsiNavigateUtil.navigate((PsiElement)method);
            }
            if ((javaFile = method.getContainingFile()) == null) {
                return;
            }
            Editor javaEditor = PsiEditorUtil.findEditor((PsiElement)method);
            if (javaEditor == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body != null && (lBrace = body.getLBrace()) != null) {
                javaEditor.getCaretModel().moveToOffset(lBrace.getTextRange().getEndOffset());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/intentions/AndroidCreateOnClickHandlerAction";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodParamType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/intentions/AndroidCreateOnClickHandlerAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVarName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestVarName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addHandlerMethod";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addHandlerMethodAndNavigate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

