/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.maven;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.maven.AndroidMavenProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public final class AndroidMavenUtil {
    @NonNls
    public static final String APKSOURCES_DEPENDENCY_TYPE = "apksources";
    @NonNls
    public static final String APKLIB_DEPENDENCY_AND_PACKAGING_TYPE = "apklib";
    @NonNls
    public static final String SO_PACKAGING_AND_DEPENDENCY_TYPE = "so";
    @NonNls
    public static final String APK_PACKAGING_TYPE = "apk";
    @NonNls
    public static final String AAR_DEPENDENCY_AND_PACKAGING_TYPE = "aar";
    @NonNls
    public static final String APK_LIB_ARTIFACT_SOURCE_ROOT = "src";
    @NonNls
    public static final String APK_LIB_ARTIFACT_RES_DIR = "res";
    public static final String APK_LIB_ARTIFACT_NATIVE_LIBS_DIR = "libs";
    public static final String APK_LIB_ARTIFACT_MANIFEST_FILE = "AndroidManifest.xml";
    @NonNls
    private static final String APKLIB_MODULE_PREFIX = "~apklib-";
    @NonNls
    private static final String GEN_EXTERNAL_APKLIBS_DIRNAME = "gen-external-apklibs";

    private AndroidMavenUtil() {
    }

    @Nullable
    public static String computePathForGenExternalApklibsDir(@NotNull MavenId mavenId, @NotNull MavenProject project, @NotNull Collection<MavenProject> allProjects) {
        if (mavenId == null) {
            AndroidMavenUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AndroidMavenUtil.$$$reportNull$$$0(1);
        }
        if (allProjects == null) {
            AndroidMavenUtil.$$$reportNull$$$0(2);
        }
        Object path2 = null;
        boolean resultUnderApp = false;
        for (MavenProject p : allProjects) {
            List dependencies2 = p.findDependencies(mavenId);
            if (dependencies2.isEmpty()) {
                dependencies2 = p.findDependencies(mavenId.getGroupId(), mavenId.getArtifactId());
            }
            if (dependencies2.isEmpty() || !AndroidMavenUtil.containsCompileDependency(dependencies2)) continue;
            VirtualFile projectDir = p.getDirectoryFile();
            boolean app = APK_PACKAGING_TYPE.equals(p.getPackaging());
            if (path2 != null && (resultUnderApp || !app)) continue;
            path2 = projectDir.getPath() + "/gen-external-apklibs";
            resultUnderApp = app;
        }
        if (path2 == null) {
            path2 = AndroidMavenUtil.getGenExternalApklibDirInProject(project);
        }
        return path2;
    }

    @NotNull
    public static String getGenExternalApklibDirInProject(@NotNull MavenProject project) {
        if (project == null) {
            AndroidMavenUtil.$$$reportNull$$$0(3);
        }
        String string = project.getDirectoryFile().getPath() + "/gen-external-apklibs";
        if (string == null) {
            AndroidMavenUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static boolean containsCompileDependency(Collection<MavenArtifact> dependencies2) {
        for (MavenArtifact dependency : dependencies2) {
            if (!"compile".equals(dependency.getScope())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getModuleNameForExtApklibArtifact(MavenId mavenId) {
        String string = APKLIB_MODULE_PREFIX + AndroidMavenUtil.getMavenIdStringForFileName(mavenId);
        if (string == null) {
            AndroidMavenUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static String getMavenIdStringByExtApklibModule(@NotNull Module module) {
        String moduleName2;
        if (module == null) {
            AndroidMavenUtil.$$$reportNull$$$0(6);
        }
        if (!(moduleName2 = module.getName()).startsWith(APKLIB_MODULE_PREFIX)) {
            return null;
        }
        return moduleName2.substring(APKLIB_MODULE_PREFIX.length());
    }

    public static boolean isExtApklibModule(@NotNull Module module) {
        if (module == null) {
            AndroidMavenUtil.$$$reportNull$$$0(7);
        }
        return module.getName().startsWith(APKLIB_MODULE_PREFIX);
    }

    @NotNull
    public static String getMavenIdStringForFileName(@NotNull MavenId mavenId) {
        String artifactId;
        if (mavenId == null) {
            AndroidMavenUtil.$$$reportNull$$$0(8);
        }
        return (artifactId = mavenId.getKey().replace(':', '_')) != null ? artifactId : "null";
    }

    public static boolean isMavenizedModule(@NotNull Module module) {
        AndroidMavenProvider mavenProxy;
        if (module == null) {
            AndroidMavenUtil.$$$reportNull$$$0(9);
        }
        return (mavenProxy = AndroidMavenUtil.getMavenProvider()) != null && mavenProxy.isMavenizedModule(module);
    }

    public static boolean isMavenAarDependency(@NotNull Module module, @NotNull OrderEntry entry) {
        if (module == null) {
            AndroidMavenUtil.$$$reportNull$$$0(10);
        }
        if (entry == null) {
            AndroidMavenUtil.$$$reportNull$$$0(11);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && entry.getPresentableName().equals("maven_aar_dependency")) {
            return true;
        }
        if (!(entry instanceof LibraryOrderEntry) || !AndroidMavenUtil.isMavenizedModule(module)) {
            return false;
        }
        Library library = ((LibraryOrderEntry)entry).getLibrary();
        if (library == null) {
            return false;
        }
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)module.getProject()).findProject(module);
        if (mavenProject == null) {
            return false;
        }
        MavenArtifact artifact = MavenRootModelAdapter.findArtifact((MavenProject)mavenProject, (Library)library);
        return artifact != null && AAR_DEPENDENCY_AND_PACKAGING_TYPE.equals(artifact.getType());
    }

    @Nullable
    public static AndroidMavenProvider getMavenProvider() {
        return (AndroidMavenProvider)ArrayUtil.getFirstElement((Object[])((AndroidMavenProvider[])AndroidMavenProvider.EP_NAME.getExtensions()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenId";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allProjects";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/maven/AndroidMavenUtil";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/maven/AndroidMavenUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenExternalApklibDirInProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNameForExtApklibArtifact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computePathForGenExternalApklibsDir";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGenExternalApklibDirInProject";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMavenIdStringByExtApklibModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isExtApklibModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMavenIdStringForFileName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMavenizedModule";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMavenAarDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

