/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidExtractStyleAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFindStyleApplicationsProcessor
extends BaseRefactoringProcessor {
    private final Module myModule;
    private final Map<AndroidAttributeInfo, String> myAttrMap;
    private final String myStyleName;
    private final XmlTag myStyleTag;
    private final XmlAttributeValue myStyleNameAttrValue;
    private final PsiElement myParentStyleNameAttrValue;
    private final PsiFile myContext;
    private boolean mySearchOnlyInCurrentModule;
    private VirtualFile myFileToScan;

    protected AndroidFindStyleApplicationsProcessor(@NotNull Module module, @NotNull Map<AndroidAttributeInfo, String> attrMap, @NotNull String styleName, @NotNull XmlTag styleTag, @NotNull XmlAttributeValue styleNameAttrValue, @Nullable PsiElement parentStyleNameAttrValue, @Nullable PsiFile context) {
        if (module == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(0);
        }
        if (attrMap == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(1);
        }
        if (styleName == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(2);
        }
        if (styleTag == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(3);
        }
        if (styleNameAttrValue == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(4);
        }
        super(module.getProject());
        this.myModule = module;
        this.myAttrMap = attrMap;
        this.myStyleName = styleName;
        this.myStyleTag = styleTag;
        this.myParentStyleNameAttrValue = parentStyleNameAttrValue;
        this.myStyleNameAttrValue = styleNameAttrValue;
        this.myContext = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(5);
        }
        return new UsageViewDescriptor(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{AndroidFindStyleApplicationsProcessor.this.myStyleTag};
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return "Style to use";
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "Tags the reference to the style will be added to " + UsageViewBundle.getOccurencesString((int)usagesCount, (int)filesCount);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor$1", "getElements"));
            }
        };
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        List<UsageInfo> usages = this.findAllStyleApplications();
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(6);
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(7);
        }
        super.preprocessUsages(refUsages);
        if (((UsageInfo[])refUsages.get()).length == 0) {
            Messages.showInfoMessage((Project)this.myProject, (String)("IDEA has not found any possible applications of style '" + this.myStyleName + "'"), (String)AndroidBundle.message("android.find.style.applications.title", new Object[0]));
            return false;
        }
        return true;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(8);
        }
        HashSet<Pair> attrsInStyle = new HashSet<Pair>();
        for (AndroidAttributeInfo info : this.myAttrMap.keySet()) {
            attrsInStyle.add(Pair.create((Object)info.getNamespace(), (Object)info.getName()));
        }
        for (UsageInfo usage : usages) {
            DomElement domElement;
            PsiElement element = usage.getElement();
            DomElement domElement2 = domElement = element instanceof XmlTag ? DomManager.getDomManager((Project)this.myProject).getDomElement((XmlTag)element) : null;
            if (!(domElement instanceof LayoutViewElement)) continue;
            final ArrayList<XmlAttribute> attributesToDelete = new ArrayList<XmlAttribute>();
            for (XmlAttribute attribute : ((XmlTag)element).getAttributes()) {
                if (!attrsInStyle.contains(Pair.create((Object)attribute.getNamespace(), (Object)attribute.getLocalName()))) continue;
                attributesToDelete.add(attribute);
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (XmlAttribute attribute : attributesToDelete) {
                        attribute.delete();
                    }
                    ((LayoutViewElement)domElement).getStyle().setStringValue("@style/" + AndroidFindStyleApplicationsProcessor.this.myStyleName);
                }
            });
        }
        PsiFile file = this.myStyleTag.getContainingFile();
        if (file != null) {
            UndoUtil.markPsiFileForUndo((PsiFile)file);
        }
        if (this.myContext != null) {
            UndoUtil.markPsiFileForUndo((PsiFile)this.myContext);
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = "Use Style '" + this.myStyleName + "' Where Possible";
        if (string == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    static List<Module> getAllModulesToScan(@NotNull Module module) {
        if (module == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(10);
        }
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (Module m : ModuleManager.getInstance((Project)module.getProject()).getModules()) {
            if (!m.equals(module) && !ModuleRootManager.getInstance((Module)m).isDependsOn(module)) continue;
            result2.add(module);
        }
        ArrayList<Module> arrayList = result2;
        if (arrayList == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public Collection<PsiFile> collectFilesToProcess() {
        Project project = this.myModule.getProject();
        ArrayList<VirtualFile> resDirs = new ArrayList<VirtualFile>();
        if (this.mySearchOnlyInCurrentModule) {
            AndroidFindStyleApplicationsProcessor.collectResDir(this.myModule, this.myStyleName, resDirs);
        } else {
            for (Module m : AndroidFindStyleApplicationsProcessor.getAllModulesToScan(this.myModule)) {
                AndroidFindStyleApplicationsProcessor.collectResDir(m, this.myStyleName, resDirs);
            }
        }
        List<VirtualFile> subdirs = AndroidResourceUtil.getResourceSubdirs(ResourceFolderType.LAYOUT, resDirs);
        ArrayList<VirtualFile> filesToProcess = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : subdirs) {
            for (VirtualFile child : virtualFile.getChildren()) {
                if (!FileTypeRegistry.getInstance().isFileOfType(child, (FileType)XmlFileType.INSTANCE) || this.myFileToScan != null && !this.myFileToScan.equals(child)) continue;
                filesToProcess.add(child);
            }
        }
        if (filesToProcess.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<PsiFile> psiFilesToProcess = new HashSet<PsiFile>();
        for (VirtualFile file : filesToProcess) {
            PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile2 == null) continue;
            psiFilesToProcess.add(psiFile2);
        }
        CacheManager cacheManager = CacheManager.getInstance((Project)project);
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)project);
        for (Map.Entry<AndroidAttributeInfo, String> entry : this.myAttrMap.entrySet()) {
            AndroidFindStyleApplicationsProcessor.filterFilesToScan(cacheManager, entry.getKey().getName(), psiFilesToProcess, projectScope);
            AndroidFindStyleApplicationsProcessor.filterFilesToScan(cacheManager, entry.getValue(), psiFilesToProcess, projectScope);
        }
        return psiFilesToProcess;
    }

    @NotNull
    private List<UsageInfo> findAllStyleApplications() {
        Collection<PsiFile> psiFilesToProcess = this.collectFilesToProcess();
        if (psiFilesToProcess.isEmpty()) {
            List<UsageInfo> list = Collections.emptyList();
            if (list == null) {
                AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(12);
            }
            return list;
        }
        int n = psiFilesToProcess.size();
        boolean i2 = false;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText("Searching for style applications");
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (PsiFile psiFile2 : psiFilesToProcess) {
            ProgressManager.checkCanceled();
            VirtualFile vFile = psiFile2.getVirtualFile();
            if (vFile == null) continue;
            if (indicator != null) {
                indicator.setFraction((double)i2 / (double)n);
                indicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)vFile, (Project)this.myProject));
            }
            this.findAllStyleApplications(vFile, usages);
        }
        ArrayList<UsageInfo> arrayList = usages;
        if (arrayList == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static void collectResDir(Module module, String styleName, List<VirtualFile> resDirs) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        if (facet2 == null) {
            return;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(facet2);
        LocalResourceRepository repository = repositoryManager.getAppResources();
        List<ResourceItem> styles2 = repository.getResources(ResourceNamespace.TODO(), ResourceType.STYLE, styleName);
        if (styles2.size() == 1) {
            resDirs.addAll(repositoryManager.getAllResourceDirs());
        }
    }

    private static void filterFilesToScan(CacheManager cacheManager, String s, Set<PsiFile> result2, GlobalSearchScope scope) {
        for (String word : StringUtil.getWordsInStringLongestFirst((String)s)) {
            PsiFile[] files2 = cacheManager.getFilesWithWord(word, (short)255, scope, true);
            result2.retainAll(Arrays.asList(files2));
        }
    }

    private void findAllStyleApplications(final VirtualFile layoutVFile, final List<UsageInfo> usages) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile layoutFile = PsiManager.getInstance((Project)AndroidFindStyleApplicationsProcessor.this.myProject).findFile(layoutVFile);
                if (!(layoutFile instanceof XmlFile)) {
                    return;
                }
                if (!(DomManager.getDomManager((Project)AndroidFindStyleApplicationsProcessor.this.myProject).getDomFileDescription((XmlFile)layoutFile) instanceof LayoutDomFileDescription)) {
                    return;
                }
                AndroidFindStyleApplicationsProcessor.this.collectPossibleStyleApplications(layoutFile, usages);
                PsiManager.getInstance((Project)AndroidFindStyleApplicationsProcessor.this.myProject).dropResolveCaches();
                InjectedLanguageManager.getInstance((Project)AndroidFindStyleApplicationsProcessor.this.myProject).dropFileCaches(layoutFile);
            }
        });
    }

    public void collectPossibleStyleApplications(PsiFile layoutFile, final List<UsageInfo> usages) {
        layoutFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                if (AndroidFindStyleApplicationsProcessor.this.isPossibleApplicationOfStyle(tag)) {
                    usages.add(new UsageInfo((PsiElement)tag));
                }
            }
        });
    }

    @Nullable
    private static PsiElement getStyleNameAttrValueForTag(@NotNull LayoutViewElement element) {
        PsiElement[] styleElements;
        AndroidResourceReferenceBase styleRef;
        if (element == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(14);
        }
        if ((styleRef = AndroidDomUtil.getAndroidResourceReference(element.getStyle(), false)) != null && (styleElements = styleRef.computeTargetElements()).length == 1) {
            return styleElements[0];
        }
        return null;
    }

    private boolean isPossibleApplicationOfStyle(XmlTag candidate) {
        DomElement domCandidate = DomManager.getDomManager((Project)this.myProject).getDomElement(candidate);
        if (!(domCandidate instanceof LayoutViewElement)) {
            return false;
        }
        LayoutViewElement candidateView = (LayoutViewElement)domCandidate;
        HashMap<Pair, String> attrsInCandidateMap = new HashMap<Pair, String>();
        List<XmlAttribute> attrsInCandidate = AndroidExtractStyleAction.getExtractableAttributes(candidate);
        if (attrsInCandidate.size() < this.myAttrMap.size()) {
            return false;
        }
        for (XmlAttribute xmlAttribute : attrsInCandidate) {
            String attrValue = xmlAttribute.getValue();
            if (attrValue == null) continue;
            attrsInCandidateMap.put(Pair.create((Object)xmlAttribute.getNamespace(), (Object)xmlAttribute.getLocalName()), attrValue);
        }
        for (Map.Entry entry : this.myAttrMap.entrySet()) {
            String ns = ((AndroidAttributeInfo)entry.getKey()).getNamespace();
            String name = ((AndroidAttributeInfo)entry.getKey()).getName();
            String value2 = (String)entry.getValue();
            String valueInCandidate = (String)attrsInCandidateMap.get(Pair.create((Object)ns, (Object)name));
            if (valueInCandidate != null && valueInCandidate.equals(value2)) continue;
            return false;
        }
        if (candidateView.getStyle().getStringValue() != null) {
            if (this.myParentStyleNameAttrValue == null) {
                return false;
            }
            PsiElement styleNameAttrValueForTag = AndroidFindStyleApplicationsProcessor.getStyleNameAttrValueForTag(candidateView);
            if (!this.myParentStyleNameAttrValue.equals(styleNameAttrValueForTag)) {
                return false;
            }
        } else if (this.myParentStyleNameAttrValue != null) {
            return false;
        }
        return true;
    }

    public void setSearchOnlyInCurrentModule(boolean searchOnlyInCurrentModule) {
        this.mySearchOnlyInCurrentModule = searchOnlyInCurrentModule;
    }

    public void setFileToScan(VirtualFile fileToScan) {
        this.myFileToScan = fileToScan;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(15);
        }
        return module;
    }

    @NotNull
    public String getStyleName() {
        String string = this.myStyleName;
        if (string == null) {
            AndroidFindStyleApplicationsProcessor.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void configureScope(MyScope scope, @Nullable VirtualFile context) {
        if (scope == MyScope.MODULE) {
            this.setSearchOnlyInCurrentModule(true);
        } else if (scope == MyScope.FILE) {
            this.setSearchOnlyInCurrentModule(true);
            this.setFileToScan(context);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleTag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleNameAttrValue";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModulesToScan";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllStyleApplications";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllModulesToScan";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStyleNameAttrValueForTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum MyScope {
        PROJECT,
        MODULE,
        FILE;

    }
}

