/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Map;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ViewStyleUsageData
implements StyleUsageData {
    private final XmlTag myTag;
    private final GenericAttributeValue<ResourceValue> myStyleAttribute;
    private final AndroidResourceReferenceBase myReference;

    ViewStyleUsageData(@NotNull XmlTag tag, @NotNull GenericAttributeValue<ResourceValue> styleAttribute, @NotNull AndroidResourceReferenceBase reference2) {
        if (tag == null) {
            ViewStyleUsageData.$$$reportNull$$$0(0);
        }
        if (styleAttribute == null) {
            ViewStyleUsageData.$$$reportNull$$$0(1);
        }
        if (reference2 == null) {
            ViewStyleUsageData.$$$reportNull$$$0(2);
        }
        this.myTag = tag;
        this.myStyleAttribute = styleAttribute;
        this.myReference = reference2;
    }

    @Override
    @Nullable
    public PsiFile getFile() {
        return this.myTag.getContainingFile();
    }

    @Override
    public void inline(@NotNull Map<AndroidAttributeInfo, String> attributeValues, @Nullable StyleRefData parentStyleRef) {
        if (attributeValues == null) {
            ViewStyleUsageData.$$$reportNull$$$0(3);
        }
        for (Map.Entry<AndroidAttributeInfo, String> entry : attributeValues.entrySet()) {
            String namespace;
            AndroidAttributeInfo info = entry.getKey();
            String localName = info.getName();
            if (this.myTag.getAttribute(localName, namespace = info.getNamespace()) != null) continue;
            this.myTag.setAttribute(localName, namespace, entry.getValue());
        }
        this.myStyleAttribute.setValue(parentStyleRef != null ? ResourceValue.referenceTo('@', parentStyleRef.getStylePackage(), ResourceType.STYLE.getName(), parentStyleRef.getStyleName()) : null);
    }

    @Override
    @NotNull
    public AndroidResourceReferenceBase getReference() {
        AndroidResourceReferenceBase androidResourceReferenceBase = this.myReference;
        if (androidResourceReferenceBase == null) {
            ViewStyleUsageData.$$$reportNull$$$0(4);
        }
        return androidResourceReferenceBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleAttribute";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValues";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/ViewStyleUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/ViewStyleUsageData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inline";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

