/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.renaming;

import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.android.tools.idea.res.psi.ResourceRepositoryToPsiResolver;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J-\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\tH\u0096\u0002J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/android/refactoring/renaming/ResourceRenameHandler;", "Lcom/intellij/refactoring/rename/RenameHandler;", "Lcom/intellij/ide/TitledHandler;", "()V", "getActionTitle", "", "getWritableResourceReferenceElement", "Lcom/android/tools/idea/res/psi/ResourceReferencePsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isAvailableInFile", "", "isAvailableOnDataContext", "isRenaming", "ResourceRenameDialog", "intellij.android.core"})
public class ResourceRenameHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue()) {
            return false;
        }
        PsiFile psiFile2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"CommonDataKeys.PSI_FILE.\u2026aContext) ?: return false");
        PsiFile file = psiFile2;
        return this.isAvailableInFile(file) && this.getWritableResourceReferenceElement(dataContext) != null;
    }

    public boolean isAvailableInFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getLanguage(), (Object)KotlinLanguage.INSTANCE) ^ true;
    }

    private final ResourceReferencePsiElement getWritableResourceReferenceElement(DataContext dataContext) {
        ResourceReferencePsiElement resourceReferenceElement;
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"CommonDataKeys.PSI_ELEME\u2026taContext) ?: return null");
        PsiElement element = psiElement;
        ResourceReferencePsiElement resourceReferencePsiElement = ResourceReferencePsiElement.Companion.create(element);
        ResourceReferencePsiElement resourceReferencePsiElement2 = resourceReferenceElement = resourceReferencePsiElement != null ? resourceReferencePsiElement.toWritableResourceReferencePsiElement() : null;
        if (resourceReferenceElement != null) {
            return resourceReferenceElement;
        }
        Caret caret = (Caret)CommonDataKeys.CARET.getData(dataContext);
        if (caret == null) {
            return null;
        }
        int offset = caret.getOffset();
        PsiFile psiFile2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"CommonDataKeys.PSI_FILE.\u2026taContext) ?: return null");
        PsiFile file = psiFile2;
        PsiElement psiElement2 = file.findElementAt(offset);
        if (psiElement2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"file.findElementAt(offset) ?: return null");
        PsiElement elementInFile = psiElement2;
        ResourceReferencePsiElement resourceReferencePsiElement3 = AndroidResourceUtil.getResourceElementFromSurroundingValuesTag(elementInFile);
        return resourceReferencePsiElement3 != null ? resourceReferencePsiElement3.toWritableResourceReferencePsiElement() : null;
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        ResourceReferencePsiElement resourceReferencePsiElement = this.getWritableResourceReferenceElement(dataContext);
        if (resourceReferencePsiElement == null) {
            return;
        }
        ResourceReferencePsiElement referencePsiElement = resourceReferencePsiElement;
        if (file == null) {
            return;
        }
        referencePsiElement.putCopyableUserData(ResourceReferencePsiElement.RESOURCE_CONTEXT_ELEMENT, file);
        referencePsiElement.putCopyableUserData(ResourceReferencePsiElement.RESOURCE_CONTEXT_SCOPE, ResourceRepositoryToPsiResolver.getResourceSearchScope(referencePsiElement.getResourceReference(), (PsiElement)file));
        ResourceRenameDialog renameDialog = new ResourceRenameDialog(project, referencePsiElement, null, editor2);
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)renameDialog);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        this.invoke(project, editor2, file, dataContext);
    }

    @NotNull
    public String getActionTitle() {
        return "Rename Android Resource";
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/android/refactoring/renaming/ResourceRenameHandler$ResourceRenameDialog;", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "resourceReferenceElement", "Lcom/android/tools/idea/res/psi/ResourceReferencePsiElement;", "nameSuggestionContext", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/res/psi/ResourceReferencePsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "canRun", "", "intellij.android.core"})
    private static final class ResourceRenameDialog
    extends RenameDialog {
        protected void canRun() {
            String string = this.getNewName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newName");
            String name = string;
            String errorText = ValueResourceNameValidator.getErrorText((String)name, null);
            if (errorText != null) {
                throw (Throwable)new ConfigurationException(errorText);
            }
        }

        public ResourceRenameDialog(@NotNull Project project, @NotNull ResourceReferencePsiElement resourceReferenceElement, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)resourceReferenceElement), (String)"resourceReferenceElement");
            super(project, (PsiElement)resourceReferenceElement, nameSuggestionContext, editor2);
        }
    }
}

