/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.ConvertContext;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkResourceManager
extends ResourceManager {
    @NotNull
    private final Module myModule;
    private final boolean myPublicOnly;

    public FrameworkResourceManager(@NotNull Module module, boolean publicOnly) {
        if (module == null) {
            FrameworkResourceManager.$$$reportNull$$$0(0);
        }
        super(module.getProject());
        this.myModule = module;
        this.myPublicOnly = publicOnly;
    }

    @Override
    public boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        AndroidPlatform platform;
        if (type == null) {
            FrameworkResourceManager.$$$reportNull$$$0(1);
        }
        if (name == null) {
            FrameworkResourceManager.$$$reportNull$$$0(2);
        }
        if ((platform = this.getPlatform()) == null) {
            return false;
        }
        return !this.myPublicOnly || platform.getSdkData().getTargetData(platform.getTarget()).isResourcePublic(type, name);
    }

    @Nullable
    private VirtualFile getResourceDir() {
        AndroidPlatform platform = this.getPlatform();
        if (platform == null) {
            return null;
        }
        String resPath = platform.getTarget().getPath(11);
        resPath = FileUtil.toSystemIndependentName((String)resPath);
        return LocalFileSystem.getInstance().findFileByPath(resPath);
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            FrameworkResourceManager.$$$reportNull$$$0(3);
        }
        return dir.equals(this.getResourceDir());
    }

    @Nullable
    public static FrameworkResourceManager getInstance(@NotNull ConvertContext context) {
        AndroidFacet facet2;
        if (context == null) {
            FrameworkResourceManager.$$$reportNull$$$0(4);
        }
        return (facet2 = AndroidFacet.getInstance((ConvertContext)context)) != null ? ModuleResourceManagers.getInstance(facet2).getFrameworkResourceManager() : null;
    }

    @Override
    @Nullable
    public AttributeDefinitions getAttributeDefinitions() {
        AndroidPlatform platform = this.getPlatform();
        if (platform == null) {
            return null;
        }
        return platform.getSdkData().getTargetData(platform.getTarget()).getPublicAttrDefs(this.myProject);
    }

    @Override
    @NotNull
    protected Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        ResourceRepository repository = this.getResourceRepository();
        Object object = repository == null ? ImmutableList.of() : repository.getLeafResourceRepositories();
        if (object == null) {
            FrameworkResourceManager.$$$reportNull$$$0(5);
        }
        return object;
    }

    @Override
    @NotNull
    protected List<ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resName) {
        ResourceRepository repository;
        if (namespace == null) {
            FrameworkResourceManager.$$$reportNull$$$0(6);
        }
        if (resourceType == null) {
            FrameworkResourceManager.$$$reportNull$$$0(7);
        }
        if (resName == null) {
            FrameworkResourceManager.$$$reportNull$$$0(8);
        }
        Object object = (repository = this.getResourceRepository()) == null ? ImmutableList.of() : repository.getResources(namespace, resourceType, resName);
        if (object == null) {
            FrameworkResourceManager.$$$reportNull$$$0(9);
        }
        return object;
    }

    @Nullable
    private ResourceRepository getResourceRepository() {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(this.myModule);
        return repositoryManager == null ? null : repositoryManager.getFrameworkResources((Set<String>)ImmutableSet.of());
    }

    @Nullable
    private AndroidPlatform getPlatform() {
        return AndroidPlatform.getInstance(this.myModule);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/FrameworkResourceManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/FrameworkResourceManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafResourceRepositories";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isResourcePublic";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResourceDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

