/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.CountryCodeQualifier;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.KeyboardStateQualifier;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NavigationMethodQualifier;
import com.android.ide.common.resources.configuration.NavigationStateQualifier;
import com.android.ide.common.resources.configuration.NetworkCodeQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenDimensionQualifier;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.ide.common.resources.configuration.TextInputMethodQualifier;
import com.android.ide.common.resources.configuration.TouchScreenQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.LayoutDirection;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.NightMode;
import com.android.resources.ResourceEnum;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.resources.UiMode;
import com.android.tools.idea.rendering.FlagManager;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.uipreview.InvalidOptionValueException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeviceConfiguratorPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.DeviceConfiguratorPanel");
    private JBList<ResourceQualifier> myAvailableQualifiersList;
    private JButton myAddQualifierButton;
    private JButton myRemoveQualifierButton;
    private JPanel myQualifierOptionsPanel;
    private final Map<String, MyQualifierEditor> myEditors = new HashMap<String, MyQualifierEditor>();
    private final FolderConfiguration myAvailableQualifiersConfig = FolderConfiguration.createDefault();
    private final FolderConfiguration myChosenQualifiersConfig = new FolderConfiguration();
    private FolderConfiguration myActualQualifiersConfig = new FolderConfiguration();
    private JBList<ResourceQualifier> myChosenQualifiersList;
    private final DocumentListener myUpdatingDocumentListener = new DocumentAdapter(){

        protected void textChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
            DeviceConfiguratorPanel.this.applyEditors();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$1", "textChanged"));
        }
    };
    public final ListSelectionListener myUpdatingListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DeviceConfiguratorPanel.this.applyEditors();
        }
    };
    private static final Map<String, Icon> ourIcons = Maps.newHashMapWithExpectedSize((int)25);

    public DeviceConfiguratorPanel() {
        super(new BorderLayout());
        this.createUIComponents();
        this.myChosenQualifiersConfig.reset();
        for (ResourceQualifier qualifier : this.myAvailableQualifiersConfig.getQualifiers()) {
            String name = qualifier.getShortName();
            if (qualifier instanceof CountryCodeQualifier) {
                this.myEditors.put(name, new MyCountryCodeEditor());
                continue;
            }
            if (qualifier instanceof NetworkCodeQualifier) {
                this.myEditors.put(name, new MyNetworkCodeEditor());
                continue;
            }
            if (qualifier instanceof KeyboardStateQualifier) {
                this.myEditors.put(name, new MyKeyboardStateEditor());
                continue;
            }
            if (qualifier instanceof NavigationMethodQualifier) {
                this.myEditors.put(name, new MyNavigationMethodEditor());
                continue;
            }
            if (qualifier instanceof NavigationStateQualifier) {
                this.myEditors.put(name, new MyNavigationStateEditor());
                continue;
            }
            if (qualifier instanceof DensityQualifier) {
                this.myEditors.put(name, new MyDensityEditor());
                continue;
            }
            if (qualifier instanceof ScreenDimensionQualifier) {
                this.myEditors.put(name, new MyScreenDimensionEditor());
                continue;
            }
            if (qualifier instanceof ScreenOrientationQualifier) {
                this.myEditors.put(name, new MyScreenOrientationEditor());
                continue;
            }
            if (qualifier instanceof ScreenRatioQualifier) {
                this.myEditors.put(name, new MyScreenRatioEditor());
                continue;
            }
            if (qualifier instanceof ScreenSizeQualifier) {
                this.myEditors.put(name, new MyScreenSizeEditor());
                continue;
            }
            if (qualifier instanceof TextInputMethodQualifier) {
                this.myEditors.put(name, new MyTextInputMethodEditor());
                continue;
            }
            if (qualifier instanceof TouchScreenQualifier) {
                this.myEditors.put(name, new MyTouchScreenEditor());
                continue;
            }
            if (qualifier instanceof VersionQualifier) {
                this.myEditors.put(name, new MyVersionEditor());
                continue;
            }
            if (qualifier instanceof NightModeQualifier) {
                this.myEditors.put(name, new MyNightModeEditor());
                continue;
            }
            if (qualifier instanceof UiModeQualifier) {
                this.myEditors.put(name, new MyUiModeEditor());
                continue;
            }
            if (qualifier instanceof LocaleQualifier) {
                this.myEditors.put(name, new MyLocaleEditor());
                continue;
            }
            if (qualifier instanceof SmallestScreenWidthQualifier) {
                this.myEditors.put(name, new MySmallestScreenWidthEditor());
                continue;
            }
            if (qualifier instanceof ScreenWidthQualifier) {
                this.myEditors.put(name, new MyScreenWidthEditor());
                continue;
            }
            if (qualifier instanceof ScreenHeightQualifier) {
                this.myEditors.put(name, new MyScreenHeightEditor());
                continue;
            }
            if (qualifier instanceof LayoutDirectionQualifier) {
                this.myEditors.put(name, new MyLayoutDirectionEditor());
                continue;
            }
            LOG.info("Missing editor for qualifier " + qualifier);
        }
        for (String name : this.myEditors.keySet()) {
            MyQualifierEditor editor2 = this.myEditors.get(name);
            this.myQualifierOptionsPanel.add((Component)editor2.getComponent(), name);
        }
        this.myAvailableQualifiersList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value2, index) -> {
            if (value2 == null) {
                return;
            }
            label.setText(value2.getShortName());
            label.setIcon(DeviceConfiguratorPanel.getResourceIcon(value2));
        }));
        this.myChosenQualifiersList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value2, index) -> {
            if (value2 == null) {
                return;
            }
            ResourceQualifier qualifier = this.getActualQualifier((ResourceQualifier)value2);
            String shortDisplayValue = qualifier.getShortDisplayValue();
            label.setText((String)(shortDisplayValue != null && !shortDisplayValue.isEmpty() ? shortDisplayValue : qualifier.getShortName() + " (?)"));
            label.setIcon(DeviceConfiguratorPanel.getResourceIcon(qualifier));
        }));
        this.myAddQualifierButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceQualifier selectedQualifier = (ResourceQualifier)DeviceConfiguratorPanel.this.myAvailableQualifiersList.getSelectedValue();
                if (selectedQualifier != null) {
                    int index = DeviceConfiguratorPanel.this.myAvailableQualifiersList.getSelectedIndex();
                    DeviceConfiguratorPanel.this.myAvailableQualifiersConfig.removeQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.myChosenQualifiersConfig.addQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.updateLists();
                    DeviceConfiguratorPanel.this.applyEditors();
                    if (index >= 0) {
                        DeviceConfiguratorPanel.this.myAvailableQualifiersList.setSelectedIndex(Math.min(index, DeviceConfiguratorPanel.this.myAvailableQualifiersList.getItemsCount() - 1));
                    }
                    DeviceConfiguratorPanel.this.myChosenQualifiersList.setSelectedValue((Object)selectedQualifier, true);
                }
            }
        });
        this.myRemoveQualifierButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceQualifier selectedQualifier = (ResourceQualifier)DeviceConfiguratorPanel.this.myChosenQualifiersList.getSelectedValue();
                if (selectedQualifier != null) {
                    int index = DeviceConfiguratorPanel.this.myChosenQualifiersList.getSelectedIndex();
                    DeviceConfiguratorPanel.this.myChosenQualifiersConfig.removeQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.myAvailableQualifiersConfig.addQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.updateLists();
                    DeviceConfiguratorPanel.this.applyEditors();
                    if (index >= 0) {
                        DeviceConfiguratorPanel.this.myChosenQualifiersList.setSelectedIndex(Math.min(index, DeviceConfiguratorPanel.this.myChosenQualifiersList.getItemsCount() - 1));
                    }
                }
            }
        });
        this.myAvailableQualifiersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeviceConfiguratorPanel.this.updateButtons();
            }
        });
        this.myChosenQualifiersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeviceConfiguratorPanel.this.updateButtons();
                DeviceConfiguratorPanel.this.updateQualifierEditor();
            }
        });
    }

    @Nullable
    public static Icon getResourceIcon(ResourceQualifier qualifier) {
        return ourIcons.get(qualifier.getName());
    }

    public void init(@NotNull FolderConfiguration config) {
        if (config == null) {
            DeviceConfiguratorPanel.$$$reportNull$$$0(0);
        }
        this.myChosenQualifiersConfig.set(config);
        this.myAvailableQualifiersConfig.substract(config);
        for (ResourceQualifier qualifier : config.getQualifiers()) {
            MyQualifierEditor editor2 = this.myEditors.get(qualifier.getShortName());
            if (editor2 == null) continue;
            editor2.reset(qualifier);
        }
    }

    public abstract void applyEditors();

    public void updateAll() {
        this.updateLists();
        this.updateButtons();
        this.updateQualifierEditor();
        this.applyEditors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doApplyEditors() throws InvalidOptionValueException {
        try {
            FolderConfiguration newConfig = new FolderConfiguration();
            for (ResourceQualifier qualifier : this.myChosenQualifiersConfig.getQualifiers()) {
                MyQualifierEditor editor2 = this.myEditors.get(qualifier.getShortName());
                if (editor2 == null) continue;
                newConfig.addQualifier(editor2.apply());
            }
            this.myActualQualifiersConfig = newConfig;
        }
        finally {
            this.myAvailableQualifiersList.repaint();
            this.myChosenQualifiersList.repaint();
        }
    }

    public DocumentListener getUpdatingDocumentListener() {
        return this.myUpdatingDocumentListener;
    }

    private ResourceQualifier getActualQualifier(ResourceQualifier qualifier) {
        for (ResourceQualifier qualifier1 : this.myActualQualifiersConfig.getQualifiers()) {
            if (!Objects.equals(qualifier1.getShortName(), qualifier.getShortName())) continue;
            return qualifier1;
        }
        return qualifier;
    }

    private void updateQualifierEditor() {
        ResourceQualifier selectedQualifier = (ResourceQualifier)this.myChosenQualifiersList.getSelectedValue();
        if (selectedQualifier != null && this.myEditors.containsKey(selectedQualifier.getShortName())) {
            CardLayout layout2 = (CardLayout)this.myQualifierOptionsPanel.getLayout();
            layout2.show(this.myQualifierOptionsPanel, selectedQualifier.getShortName());
            this.myQualifierOptionsPanel.setVisible(true);
        } else {
            this.myQualifierOptionsPanel.setVisible(false);
        }
    }

    private void updateButtons() {
        this.myAddQualifierButton.setEnabled(this.myAvailableQualifiersList.getSelectedIndex() >= 0);
        this.myRemoveQualifierButton.setEnabled(this.myChosenQualifiersList.getSelectedIndex() >= 0);
    }

    private void updateLists() {
        Object qualifier = this.myAvailableQualifiersList.getSelectedValue();
        Object[] availableQualifiers = this.filterUnsupportedQualifiers(this.myAvailableQualifiersConfig.getQualifiers());
        this.myAvailableQualifiersList.setModel((ListModel)new CollectionListModel(availableQualifiers));
        this.myAvailableQualifiersList.setSelectedValue(qualifier, true);
        if (this.myAvailableQualifiersList.getSelectedValue() == null && this.myAvailableQualifiersList.getItemsCount() > 0) {
            this.myAvailableQualifiersList.setSelectedIndex(0);
        }
        qualifier = this.myChosenQualifiersList.getSelectedValue();
        Object[] chosenQualifiers = this.filterUnsupportedQualifiers(this.myChosenQualifiersConfig.getQualifiers());
        this.myChosenQualifiersList.setModel((ListModel)new CollectionListModel(chosenQualifiers));
        this.myChosenQualifiersList.setSelectedValue(qualifier, true);
        if (this.myChosenQualifiersList.getSelectedValue() == null && this.myChosenQualifiersList.getItemsCount() > 0) {
            this.myChosenQualifiersList.setSelectedIndex(0);
        }
    }

    private ResourceQualifier[] filterUnsupportedQualifiers(ResourceQualifier[] qualifiers) {
        ArrayList<ResourceQualifier> result2 = new ArrayList<ResourceQualifier>();
        for (ResourceQualifier qualifier : qualifiers) {
            if (!this.myEditors.containsKey(qualifier.getShortName())) continue;
            result2.add(qualifier);
        }
        return result2.toArray(new ResourceQualifier[0]);
    }

    public FolderConfiguration getConfiguration() {
        return this.myActualQualifiersConfig;
    }

    private void createUIComponents() {
        this.myQualifierOptionsPanel = new JPanel(new CardLayout());
        final JPanel leftPanel = new JPanel(new BorderLayout(JBUIScale.scale((int)5), JBUIScale.scale((int)5)));
        this.myAvailableQualifiersList = new JBList();
        this.myAvailableQualifiersList.setMinimumSize((Dimension)JBUI.size((int)10, (int)10));
        JBLabel label = new JBLabel(AndroidBundle.message("android.layout.preview.edit.configuration.available.qualifiers.label", new Object[0]));
        label.setLabelFor(this.myAvailableQualifiersList);
        leftPanel.add((Component)label, "North");
        leftPanel.add((Component)new JBScrollPane(this.myAvailableQualifiersList, 20, 31), "Center");
        final JPanel rightPanel = new JPanel(new BorderLayout(JBUIScale.scale((int)5), JBUIScale.scale((int)5)));
        this.myChosenQualifiersList = new JBList();
        this.myChosenQualifiersList.setMinimumSize((Dimension)JBUI.size((int)10, (int)10));
        label = new JBLabel(AndroidBundle.message("android.layout.preview.edit.configuration.choosen.qualifiers.label", new Object[0]));
        label.setLabelFor(this.myChosenQualifiersList);
        rightPanel.add((Component)label, "North");
        rightPanel.add((Component)new JBScrollPane(this.myChosenQualifiersList, 20, 31), "Center");
        final JPanel buttonsPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1, 0, 0, true, false));
        this.myAddQualifierButton = new JButton(">>");
        buttonsPanel.add(this.myAddQualifierButton);
        this.myRemoveQualifierButton = new JButton("<<");
        buttonsPanel.add(this.myRemoveQualifierButton);
        int gap = 5;
        JPanel listsPanel = new JPanel((LayoutManager)new AbstractLayoutManager(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Dimension preferredLayoutSize(Container target) {
                Object object = target.getTreeLock();
                synchronized (object) {
                    Dimension leftPref = leftPanel.getPreferredSize();
                    Dimension rightPref = rightPanel.getPreferredSize();
                    Dimension middlePref = buttonsPanel.getPreferredSize();
                    Insets insets = target.getInsets();
                    int width = leftPref.width + middlePref.width + rightPref.width + insets.left + insets.right + 10;
                    int height = Math.max(leftPref.height, Math.max(rightPref.height, middlePref.height)) + insets.top + insets.bottom;
                    return new Dimension(width, height);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void layoutContainer(Container target) {
                Object object = target.getTreeLock();
                synchronized (object) {
                    Insets insets = target.getInsets();
                    int top = insets.top;
                    int bottom2 = target.getHeight() - insets.bottom;
                    int left2 = insets.left;
                    int right2 = target.getWidth() - insets.right;
                    int middleWidth = buttonsPanel.getPreferredSize().width + 10;
                    int listWidth = (right2 - left2 - middleWidth) / 2;
                    int height = bottom2 - top;
                    leftPanel.setSize(listWidth, height);
                    rightPanel.setSize(listWidth, height);
                    buttonsPanel.setSize(middleWidth, height);
                    leftPanel.setBounds(left2, top, listWidth, height);
                    rightPanel.setBounds(right2 - listWidth, top, listWidth, height);
                    buttonsPanel.setBounds(left2 + listWidth + 5, top, middleWidth - 10, height);
                }
            }
        });
        listsPanel.add(leftPanel);
        listsPanel.add(buttonsPanel);
        listsPanel.add(rightPanel);
        this.add((Component)listsPanel, "Center");
        this.add((Component)this.myQualifierOptionsPanel, "East");
    }

    public JBList getAvailableQualifiersList() {
        return this.myAvailableQualifiersList;
    }

    static {
        ourIcons.put("UI Mode", StudioIcons.DeviceConfiguration.UI_MODE);
        ourIcons.put("Night Mode", StudioIcons.DeviceConfiguration.NIGHT_MODE);
        ourIcons.put("Screen Dimension", StudioIcons.DeviceConfiguration.DIMENSION);
        ourIcons.put("Density", StudioIcons.DeviceConfiguration.DENSITY);
        ourIcons.put("Screen Height", StudioIcons.DeviceConfiguration.SCREEN_HEIGHT);
        ourIcons.put("Keyboard State", StudioIcons.DeviceConfiguration.KEYBOARD);
        ourIcons.put("Locale", StudioIcons.DeviceConfiguration.LOCALE);
        ourIcons.put("Mobile Country Code", StudioIcons.DeviceConfiguration.COUNTRY_CODE);
        ourIcons.put("Mobile Network Code", StudioIcons.DeviceConfiguration.NETWORK_CODE);
        ourIcons.put("Navigation State", StudioIcons.DeviceConfiguration.NAVIGATION_STATE);
        ourIcons.put("Navigation Method", StudioIcons.DeviceConfiguration.NAVIGATION_METHOD);
        ourIcons.put("Screen Orientation", StudioIcons.DeviceConfiguration.ORIENTATION);
        ourIcons.put("Screen Ratio", StudioIcons.DeviceConfiguration.SCREEN_RATIO);
        ourIcons.put("Screen Size", StudioIcons.DeviceConfiguration.SCREEN_SIZE);
        ourIcons.put("Smallest Screen Width", StudioIcons.DeviceConfiguration.SMALLEST_SCREEN_SIZE);
        ourIcons.put("Screen Width", StudioIcons.DeviceConfiguration.SCREEN_WIDTH);
        ourIcons.put("Text Input Method", StudioIcons.DeviceConfiguration.TEXT_INPUT);
        ourIcons.put("Touch Screen", StudioIcons.DeviceConfiguration.TOUCH_SCREEN);
        ourIcons.put("Layout Direction", StudioIcons.DeviceConfiguration.LAYOUT_DIRECTION);
        ourIcons.put("Platform Version", StudioIcons.DeviceConfiguration.VERSION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel", "init"));
    }

    private final class MyScreenHeightEditor
    extends MySizeEditorBase<ScreenHeightQualifier> {
        private MyScreenHeightEditor() {
            super("Screen height:");
        }

        @Override
        protected int getValue(@NotNull ScreenHeightQualifier qualifier) {
            if (qualifier == null) {
                MyScreenHeightEditor.$$$reportNull$$$0(0);
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected ScreenHeightQualifier createQualifier(int value2) {
            return new ScreenHeightQualifier(value2);
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect screen height";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenHeightEditor", "getValue"));
        }
    }

    private final class MyScreenWidthEditor
    extends MySizeEditorBase<ScreenWidthQualifier> {
        private MyScreenWidthEditor() {
            super("Screen width:");
        }

        @Override
        protected int getValue(@NotNull ScreenWidthQualifier qualifier) {
            if (qualifier == null) {
                MyScreenWidthEditor.$$$reportNull$$$0(0);
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected ScreenWidthQualifier createQualifier(int value2) {
            return new ScreenWidthQualifier(value2);
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect screen width";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenWidthEditor", "getValue"));
        }
    }

    private final class MySmallestScreenWidthEditor
    extends MySizeEditorBase<SmallestScreenWidthQualifier> {
        private MySmallestScreenWidthEditor() {
            super("Smallest screen width:");
        }

        @Override
        protected int getValue(@NotNull SmallestScreenWidthQualifier qualifier) {
            if (qualifier == null) {
                MySmallestScreenWidthEditor.$$$reportNull$$$0(0);
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected SmallestScreenWidthQualifier createQualifier(int value2) {
            return new SmallestScreenWidthQualifier(value2);
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect smallest screen width";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MySmallestScreenWidthEditor", "getValue"));
        }
    }

    private abstract class MySizeEditorBase<T extends ResourceQualifier>
    extends MyQualifierEditor<T> {
        private final JTextField myTextField = new JTextField(3);
        private String myLabelText;

        protected MySizeEditorBase(String labelText) {
            this.myLabelText = labelText;
        }

        @Override
        JComponent getComponent() {
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel(this.myLabelText);
            panel2.add((Component)label);
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel2.add(this.myTextField);
            return panel2;
        }

        @Override
        void reset(@NotNull T qualifier) {
            if (qualifier == null) {
                MySizeEditorBase.$$$reportNull$$$0(0);
            }
            this.myTextField.setText(Integer.toString(this.getValue(qualifier)));
        }

        protected abstract int getValue(@NotNull T var1);

        @NotNull
        protected abstract T createQualifier(int var1);

        protected abstract String getErrorMessage();

        @Override
        @NotNull
        T apply() throws InvalidOptionValueException {
            T t;
            try {
                int value2 = Integer.parseInt(this.myTextField.getText().trim());
                if (value2 < 0) {
                    throw new InvalidOptionValueException(this.getErrorMessage());
                }
                t = this.createQualifier(value2);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException(this.getErrorMessage());
            }
            if (t == null) {
                MySizeEditorBase.$$$reportNull$$$0(1);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MySizeEditorBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MySizeEditorBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyLocaleEditor
    extends MyQualifierEditor<LocaleQualifier> {
        private final JBList<String> myLanguageList = new JBList();
        private final JBList<String> myRegionList = new JBList();
        private JBCheckBox myShowAllRegions;
        private JBLabel myWarningsLabel;

        private MyLocaleEditor() {
        }

        @Override
        JComponent getComponent() {
            JPanel pane = new JPanel(new GridBagLayout());
            pane.setBorder((Border)JBUI.Borders.empty((int)0, (int)20, (int)0, (int)0));
            this.myShowAllRegions = new JBCheckBox("Show All Regions", false);
            this.myWarningsLabel = new JBLabel("BCP 47 tags (3-letter languages or regions) will only match on API 21");
            this.myWarningsLabel.setIcon(AllIcons.General.BalloonWarning);
            this.myWarningsLabel.setVisible(false);
            JBLabel languageLabel = new JBLabel("Language:");
            JBLabel languageTip = new JBLabel("Tip: Type in list to filter");
            JBLabel regionLabel = new JBLabel("Specific Region Only:");
            SortedListModel languageModel = new SortedListModel((Comparator)new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    int delta = s1.length() - s2.length();
                    if (delta != 0) {
                        return delta;
                    }
                    return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
                }
            });
            languageModel.addAll((Collection)LocaleManager.getLanguageCodes((boolean)true));
            this.myLanguageList.setModel((ListModel)languageModel);
            this.myLanguageList.setSelectionMode(0);
            this.myLanguageList.setCellRenderer(FlagManager.get().getLanguageCodeCellRenderer());
            JBScrollPane scroll = new JBScrollPane(this.myLanguageList);
            JComponent languagePane = ListWithFilter.wrap(this.myLanguageList, (JScrollPane)scroll, FlagManager.getLanguageNameMapper());
            languageLabel.setLabelFor(this.myLanguageList);
            languageTip.setFont((Font)JBUI.Fonts.miniFont());
            this.myRegionList.setSelectionMode(0);
            this.myRegionList.setCellRenderer(FlagManager.get().getRegionCodeCellRenderer());
            this.updateRegionList(null);
            JBScrollPane regionPane = new JBScrollPane(this.myRegionList);
            Insets insets = new Insets(0, 20, 0, 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            pane.add((Component)languageLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = insets;
            pane.add((Component)regionLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            pane.add((Component)languagePane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = insets;
            pane.add((Component)regionPane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            pane.add((Component)languageTip, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = insets;
            pane.add((Component)this.myShowAllRegions, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 21;
            pane.add((Component)this.myWarningsLabel, gridBagConstraints);
            this.myLanguageList.addListSelectionListener(DeviceConfiguratorPanel.this.myUpdatingListListener);
            this.myRegionList.addListSelectionListener(DeviceConfiguratorPanel.this.myUpdatingListListener);
            this.myLanguageList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    MyLocaleEditor.this.updateRegionList((String)MyLocaleEditor.this.myLanguageList.getSelectedValue());
                }
            });
            this.myShowAllRegions.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    MyLocaleEditor.this.updateRegionList((String)MyLocaleEditor.this.myLanguageList.getSelectedValue());
                }
            });
            return pane;
        }

        private void updateRegionList(@Nullable String languageCode) {
            final Ref preferred = new Ref(null);
            SortedListModel regionModel = new SortedListModel((Comparator)new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    if (s1.equals("__")) {
                        return -1;
                    }
                    if (s2.equals("__")) {
                        return 1;
                    }
                    if (s1.equals(preferred.get())) {
                        return -1;
                    }
                    if (s2.equals(preferred.get())) {
                        return 1;
                    }
                    int delta = s1.length() - s2.length();
                    if (delta != 0) {
                        return delta;
                    }
                    return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
                }
            });
            regionModel.add((Object)"__");
            if (!this.myShowAllRegions.isSelected() && languageCode != null) {
                preferred.set((Object)LocaleManager.getLanguageRegion((String)languageCode));
                List relevant = LocaleManager.getRelevantRegions((String)languageCode);
                for (String code : relevant) {
                    regionModel.add((Object)code);
                }
            } else {
                for (String code : LocaleManager.getRegionCodes((boolean)true)) {
                    regionModel.add((Object)code);
                }
            }
            this.myRegionList.setModel((ListModel)regionModel);
            if (languageCode != null && regionModel.getSize() > 0) {
                this.myRegionList.setSelectedIndex(0);
            }
        }

        @Override
        void reset(@NotNull LocaleQualifier qualifier) {
            if (qualifier == null) {
                MyLocaleEditor.$$$reportNull$$$0(0);
            }
            if (qualifier.isValid() && !qualifier.hasFakeValue()) {
                String language = qualifier.getLanguage();
                String region = qualifier.getRegion();
                ListModel languageModel = this.myLanguageList.getModel();
                ListModel regionModel = this.myRegionList.getModel();
                if (language != null) {
                    int n = languageModel.getSize();
                    for (int i2 = 0; i2 < n; ++i2) {
                        if (!language.equals(languageModel.getElementAt(i2))) continue;
                        this.myLanguageList.setSelectedIndex(i2);
                        break;
                    }
                }
                if (region != null) {
                    int i3;
                    boolean found = false;
                    int n = regionModel.getSize();
                    for (i3 = 0; i3 < n; ++i3) {
                        if (!region.equals(regionModel.getElementAt(i3))) continue;
                        this.myRegionList.setSelectedIndex(i3);
                        found = true;
                        break;
                    }
                    if (!found && !this.myShowAllRegions.isSelected()) {
                        this.myShowAllRegions.setSelected(true);
                        n = regionModel.getSize();
                        for (i3 = 0; i3 < n; ++i3) {
                            if (!region.equals(regionModel.getElementAt(i3))) continue;
                            this.myRegionList.setSelectedIndex(i3);
                            break;
                        }
                    }
                } else {
                    this.myRegionList.setSelectedIndex(-1);
                }
            } else {
                this.myLanguageList.setSelectedIndex(-1);
                this.myRegionList.setSelectedIndex(-1);
            }
        }

        @Override
        @NotNull
        LocaleQualifier apply() throws InvalidOptionValueException {
            String selectedLanguage = (String)this.myLanguageList.getSelectedValue();
            if (selectedLanguage == null) {
                throw new InvalidOptionValueException("Select a language tag");
            }
            String selectedRegion = (String)this.myRegionList.getSelectedValue();
            if ("__".equals(selectedRegion)) {
                selectedRegion = null;
            }
            this.myWarningsLabel.setVisible(selectedLanguage.length() > 2 || selectedRegion != null && selectedRegion.length() > 2);
            return new LocaleQualifier(null, selectedLanguage, selectedRegion, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLocaleEditor", "reset"));
        }
    }

    private final class MyUiModeEditor
    extends MyEnumBasedEditor<UiModeQualifier, UiMode> {
        private MyUiModeEditor() {
            super(UiMode.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "UI mode:";
        }

        @Override
        protected UiMode getValue(@NotNull UiModeQualifier qualifier) {
            if (qualifier == null) {
                MyUiModeEditor.$$$reportNull$$$0(0);
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected UiModeQualifier getQualifier(@NotNull UiMode value2) {
            if (value2 == null) {
                MyUiModeEditor.$$$reportNull$$$0(1);
            }
            return new UiModeQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify UI mode";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyUiModeEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getQualifier";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyNightModeEditor
    extends MyEnumBasedEditor<NightModeQualifier, NightMode> {
        protected MyNightModeEditor() {
            super(NightMode.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Night mode:";
        }

        @Override
        protected NightMode getValue(@NotNull NightModeQualifier qualifier) {
            if (qualifier == null) {
                MyNightModeEditor.$$$reportNull$$$0(0);
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected NightModeQualifier getQualifier(@NotNull NightMode value2) {
            if (value2 == null) {
                MyNightModeEditor.$$$reportNull$$$0(1);
            }
            return new NightModeQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify night mode";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNightModeEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getQualifier";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyVersionEditor
    extends MyQualifierEditor<VersionQualifier> {
        private final JTextField myTextField = new JTextField(3);

        private MyVersionEditor() {
        }

        @Override
        JComponent getComponent() {
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("Platform API level:");
            panel2.add((Component)label);
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel2.add(this.myTextField);
            return panel2;
        }

        @Override
        void reset(@NotNull VersionQualifier qualifier) {
            if (qualifier == null) {
                MyVersionEditor.$$$reportNull$$$0(0);
            }
            this.myTextField.setText(Integer.toString(qualifier.getVersion()));
        }

        @Override
        @NotNull
        VersionQualifier apply() throws InvalidOptionValueException {
            try {
                int apiLevel = Integer.parseInt(this.myTextField.getText().trim());
                if (apiLevel < 0) {
                    throw new InvalidOptionValueException("Incorrect API level");
                }
                return new VersionQualifier(apiLevel);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException("Incorrect API level");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyVersionEditor", "reset"));
        }
    }

    private class MyScreenDimensionEditor
    extends MyQualifierEditor<ScreenDimensionQualifier> {
        private final JTextField mySizeField1 = new JTextField();
        private final JTextField mySizeField2 = new JTextField();

        private MyScreenDimensionEditor() {
        }

        @Override
        JComponent getComponent() {
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("Screen dimension in dp:");
            label.setLabelFor((Component)this.mySizeField1);
            panel2.add((Component)label);
            panel2.add(this.mySizeField1);
            panel2.add(this.mySizeField2);
            this.mySizeField1.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            this.mySizeField2.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            return panel2;
        }

        @Override
        void reset(@NotNull ScreenDimensionQualifier qualifier) {
            int value2;
            int value1;
            if (qualifier == null) {
                MyScreenDimensionEditor.$$$reportNull$$$0(0);
            }
            if ((value1 = qualifier.getValue1()) >= 0) {
                this.mySizeField1.setText(Integer.toString(value1));
            }
            if ((value2 = qualifier.getValue2()) >= 0) {
                this.mySizeField2.setText(Integer.toString(value2));
            }
        }

        @Override
        @NotNull
        ScreenDimensionQualifier apply() throws InvalidOptionValueException {
            try {
                int size1 = Integer.parseInt(this.mySizeField1.getText());
                int size2 = Integer.parseInt(this.mySizeField2.getText());
                if (size1 <= 0 || size2 <= 0) {
                    throw new InvalidOptionValueException("Incorrect screen dimension");
                }
                return new ScreenDimensionQualifier(size1, size2);
            }
            catch (NumberFormatException e) {
                LOG.debug((Throwable)e);
                throw new InvalidOptionValueException("Incorrect screen dimension");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenDimensionEditor", "reset"));
        }
    }

    private final class MyLayoutDirectionEditor
    extends MyEnumBasedEditor<LayoutDirectionQualifier, LayoutDirection> {
        private MyLayoutDirectionEditor() {
            super(LayoutDirection.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Layout direction:";
        }

        @Override
        @NotNull
        protected LayoutDirection getValue(@NotNull LayoutDirectionQualifier qualifier) {
            if (qualifier == null) {
                MyLayoutDirectionEditor.$$$reportNull$$$0(0);
            }
            LayoutDirection layoutDirection = qualifier.getValue();
            if (layoutDirection == null) {
                MyLayoutDirectionEditor.$$$reportNull$$$0(1);
            }
            return layoutDirection;
        }

        @Override
        @NotNull
        protected LayoutDirectionQualifier getQualifier(@NotNull LayoutDirection value2) {
            if (value2 == null) {
                MyLayoutDirectionEditor.$$$reportNull$$$0(2);
            }
            return new LayoutDirectionQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify layout direction";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLayoutDirectionEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLayoutDirectionEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyNavigationMethodEditor
    extends MyEnumBasedEditor<NavigationMethodQualifier, Navigation> {
        private MyNavigationMethodEditor() {
            super(Navigation.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Navigation method:";
        }

        @Override
        @NotNull
        protected Navigation getValue(@NotNull NavigationMethodQualifier qualifier) {
            if (qualifier == null) {
                MyNavigationMethodEditor.$$$reportNull$$$0(0);
            }
            Navigation navigation = qualifier.getValue();
            if (navigation == null) {
                MyNavigationMethodEditor.$$$reportNull$$$0(1);
            }
            return navigation;
        }

        @Override
        @NotNull
        protected NavigationMethodQualifier getQualifier(@NotNull Navigation value2) {
            if (value2 == null) {
                MyNavigationMethodEditor.$$$reportNull$$$0(2);
            }
            return new NavigationMethodQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify navigation method";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationMethodEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationMethodEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyNavigationStateEditor
    extends MyEnumBasedEditor<NavigationStateQualifier, NavigationState> {
        private MyNavigationStateEditor() {
            super(NavigationState.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Navigation state:";
        }

        @Override
        @NotNull
        protected NavigationState getValue(@NotNull NavigationStateQualifier qualifier) {
            if (qualifier == null) {
                MyNavigationStateEditor.$$$reportNull$$$0(0);
            }
            NavigationState navigationState = qualifier.getValue();
            if (navigationState == null) {
                MyNavigationStateEditor.$$$reportNull$$$0(1);
            }
            return navigationState;
        }

        @Override
        @NotNull
        protected NavigationStateQualifier getQualifier(@NotNull NavigationState value2) {
            if (value2 == null) {
                MyNavigationStateEditor.$$$reportNull$$$0(2);
            }
            return new NavigationStateQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify navigation state";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationStateEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationStateEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyTextInputMethodEditor
    extends MyEnumBasedEditor<TextInputMethodQualifier, Keyboard> {
        private MyTextInputMethodEditor() {
            super(Keyboard.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Text input method:";
        }

        @Override
        @NotNull
        protected Keyboard getValue(@NotNull TextInputMethodQualifier qualifier) {
            if (qualifier == null) {
                MyTextInputMethodEditor.$$$reportNull$$$0(0);
            }
            Keyboard keyboard = qualifier.getValue();
            if (keyboard == null) {
                MyTextInputMethodEditor.$$$reportNull$$$0(1);
            }
            return keyboard;
        }

        @Override
        @NotNull
        protected TextInputMethodQualifier getQualifier(@NotNull Keyboard value2) {
            if (value2 == null) {
                MyTextInputMethodEditor.$$$reportNull$$$0(2);
            }
            return new TextInputMethodQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify text input method";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTextInputMethodEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTextInputMethodEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyKeyboardStateEditor
    extends MyEnumBasedEditor<KeyboardStateQualifier, KeyboardState> {
        private MyKeyboardStateEditor() {
            super(KeyboardState.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Keyboard state:";
        }

        @Override
        @NotNull
        protected KeyboardState getValue(@NotNull KeyboardStateQualifier qualifier) {
            if (qualifier == null) {
                MyKeyboardStateEditor.$$$reportNull$$$0(0);
            }
            KeyboardState keyboardState = qualifier.getValue();
            if (keyboardState == null) {
                MyKeyboardStateEditor.$$$reportNull$$$0(1);
            }
            return keyboardState;
        }

        @Override
        @NotNull
        protected KeyboardStateQualifier getQualifier(@NotNull KeyboardState value2) {
            if (value2 == null) {
                MyKeyboardStateEditor.$$$reportNull$$$0(2);
            }
            return new KeyboardStateQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify keyboard state";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyKeyboardStateEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyKeyboardStateEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyTouchScreenEditor
    extends MyEnumBasedEditor<TouchScreenQualifier, TouchScreen> {
        private MyTouchScreenEditor() {
            super(TouchScreen.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Touch screen:";
        }

        @Override
        @NotNull
        protected TouchScreen getValue(@NotNull TouchScreenQualifier qualifier) {
            if (qualifier == null) {
                MyTouchScreenEditor.$$$reportNull$$$0(0);
            }
            TouchScreen touchScreen = qualifier.getValue();
            if (touchScreen == null) {
                MyTouchScreenEditor.$$$reportNull$$$0(1);
            }
            return touchScreen;
        }

        @Override
        @NotNull
        protected TouchScreenQualifier getQualifier(@NotNull TouchScreen value2) {
            if (value2 == null) {
                MyTouchScreenEditor.$$$reportNull$$$0(2);
            }
            return new TouchScreenQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify touch screen";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTouchScreenEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTouchScreenEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyDensityEditor
    extends MyEnumBasedEditor<DensityQualifier, Density> {
        private MyDensityEditor() {
            super(Density.class);
        }

        @Override
        protected ComboBoxModel<Density> createModel() {
            return new DensityComboBoxModel();
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Density:";
        }

        @Override
        @NotNull
        protected Density getValue(@NotNull DensityQualifier qualifier) {
            if (qualifier == null) {
                MyDensityEditor.$$$reportNull$$$0(0);
            }
            Density density = qualifier.getValue();
            if (density == null) {
                MyDensityEditor.$$$reportNull$$$0(1);
            }
            return density;
        }

        @Override
        @NotNull
        protected DensityQualifier getQualifier(@NotNull Density value2) {
            if (value2 == null) {
                MyDensityEditor.$$$reportNull$$$0(2);
            }
            return new DensityQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify density";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyDensityEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyDensityEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DensityComboBoxModel
    extends AbstractListModel<Density>
    implements ComboBoxModel<Density> {
        private final List<Density> myList = new ArrayList<Density>();
        private Density mySelected = null;

        public DensityComboBoxModel() {
            for (Density density : Density.values()) {
                if (!density.isRecommended()) continue;
                this.myList.add(density);
            }
            this.mySelected = this.myList.get(0);
        }

        @Override
        public int getSize() {
            return this.myList.size();
        }

        @Override
        public Density getElementAt(int index) {
            return this.myList.get(index);
        }

        @Override
        public void setSelectedItem(Object item) {
            Density e = (Density)item;
            this.setSelectedItem(e);
        }

        public void setSelectedItem(Density item) {
            this.mySelected = item;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public Density getSelectedItem() {
            return this.mySelected;
        }
    }

    private final class MyScreenRatioEditor
    extends MyEnumBasedEditor<ScreenRatioQualifier, ScreenRatio> {
        private MyScreenRatioEditor() {
            super(ScreenRatio.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Screen ratio:";
        }

        @Override
        @NotNull
        protected ScreenRatio getValue(@NotNull ScreenRatioQualifier qualifier) {
            if (qualifier == null) {
                MyScreenRatioEditor.$$$reportNull$$$0(0);
            }
            ScreenRatio screenRatio = qualifier.getValue();
            if (screenRatio == null) {
                MyScreenRatioEditor.$$$reportNull$$$0(1);
            }
            return screenRatio;
        }

        @Override
        @NotNull
        protected ScreenRatioQualifier getQualifier(@NotNull ScreenRatio value2) {
            if (value2 == null) {
                MyScreenRatioEditor.$$$reportNull$$$0(2);
            }
            return new ScreenRatioQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify screen ratio";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenRatioEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenRatioEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyScreenOrientationEditor
    extends MyEnumBasedEditor<ScreenOrientationQualifier, ScreenOrientation> {
        private MyScreenOrientationEditor() {
            super(ScreenOrientation.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Screen orientation:";
        }

        @Override
        @NotNull
        protected ScreenOrientation getValue(@NotNull ScreenOrientationQualifier qualifier) {
            if (qualifier == null) {
                MyScreenOrientationEditor.$$$reportNull$$$0(0);
            }
            ScreenOrientation screenOrientation = qualifier.getValue();
            if (screenOrientation == null) {
                MyScreenOrientationEditor.$$$reportNull$$$0(1);
            }
            return screenOrientation;
        }

        @Override
        @NotNull
        protected ScreenOrientationQualifier getQualifier(@NotNull ScreenOrientation value2) {
            if (value2 == null) {
                MyScreenOrientationEditor.$$$reportNull$$$0(2);
            }
            return new ScreenOrientationQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify screen orientation";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenOrientationEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenOrientationEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyScreenSizeEditor
    extends MyEnumBasedEditor<ScreenSizeQualifier, ScreenSize> {
        private MyScreenSizeEditor() {
            super(ScreenSize.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Screen size:";
        }

        @Override
        @NotNull
        protected ScreenSize getValue(@NotNull ScreenSizeQualifier qualifier) {
            if (qualifier == null) {
                MyScreenSizeEditor.$$$reportNull$$$0(0);
            }
            ScreenSize screenSize = qualifier.getValue();
            if (screenSize == null) {
                MyScreenSizeEditor.$$$reportNull$$$0(1);
            }
            return screenSize;
        }

        @Override
        @NotNull
        protected ScreenSizeQualifier getQualifier(@NotNull ScreenSize value2) {
            if (value2 == null) {
                MyScreenSizeEditor.$$$reportNull$$$0(2);
            }
            return new ScreenSizeQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify screen size";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenSizeEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenSizeEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private abstract class MyEnumBasedEditor<T extends ResourceQualifier, U extends Enum<U>>
    extends MyQualifierEditor<T> {
        private final JComboBox<U> myComboBox;
        private final Class<U> myEnumClass;

        protected MyEnumBasedEditor(Class<U> enumClass) {
            if (enumClass == null) {
                MyEnumBasedEditor.$$$reportNull$$$0(0);
            }
            this.myComboBox = new ComboBox();
            this.myEnumClass = enumClass;
        }

        @Override
        JComponent getComponent() {
            this.myComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceConfiguratorPanel.this.applyEditors();
                }
            });
            this.myComboBox.setRenderer((ListCellRenderer<U>)SimpleListCellRenderer.create((label, value2, index) -> {
                if (value2 instanceof ResourceEnum) {
                    label.setText(((ResourceEnum)value2).getShortDisplayValue());
                }
            }));
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label2 = new JBLabel(this.getCaption());
            label2.setLabelFor(this.myComboBox);
            this.myComboBox.setModel(this.createModel());
            panel2.add((Component)label2);
            panel2.add(this.myComboBox);
            return panel2;
        }

        protected ComboBoxModel<U> createModel() {
            return new EnumComboBoxModel(this.myEnumClass);
        }

        @NotNull
        protected abstract String getCaption();

        @Override
        void reset(@NotNull T qualifier) {
            U value2;
            if (qualifier == null) {
                MyEnumBasedEditor.$$$reportNull$$$0(1);
            }
            if ((value2 = this.getValue(qualifier)) != null) {
                this.myComboBox.setSelectedItem(value2);
            } else if (this.myComboBox.getItemCount() > 0) {
                this.myComboBox.setSelectedIndex(0);
            }
        }

        protected abstract U getValue(@NotNull T var1);

        @NotNull
        protected abstract T getQualifier(@NotNull U var1);

        @NotNull
        protected abstract String getErrorMessage();

        @Override
        @NotNull
        T apply() throws InvalidOptionValueException {
            Enum selectedItem = (Enum)this.myComboBox.getSelectedItem();
            if (selectedItem == null) {
                throw new InvalidOptionValueException(this.getErrorMessage());
            }
            T t = this.getQualifier(selectedItem);
            if (t == null) {
                MyEnumBasedEditor.$$$reportNull$$$0(2);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyEnumBasedEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyEnumBasedEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyNetworkCodeEditor
    extends MyQualifierEditor<NetworkCodeQualifier> {
        private final JTextField myTextField = new JTextField(3);

        private MyNetworkCodeEditor() {
        }

        @Override
        JComponent getComponent() {
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("<html><body>Mobile network code<br>(1-3 digits):</body></html>");
            panel2.add((Component)label);
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel2.add(this.myTextField);
            return panel2;
        }

        @Override
        void reset(@NotNull NetworkCodeQualifier qualifier) {
            if (qualifier == null) {
                MyNetworkCodeEditor.$$$reportNull$$$0(0);
            }
            this.myTextField.setText(Integer.toString(qualifier.getCode()));
        }

        @Override
        @NotNull
        NetworkCodeQualifier apply() throws InvalidOptionValueException {
            try {
                int code = Integer.parseInt(this.myTextField.getText());
                if (code <= 0 || code >= 1000) {
                    throw new InvalidOptionValueException("Incorrect network code");
                }
                return new NetworkCodeQualifier(code);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException("Network code must be a number");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNetworkCodeEditor", "reset"));
        }
    }

    private class MyCountryCodeEditor
    extends MyQualifierEditor<CountryCodeQualifier> {
        private final JTextField myTextField = new JTextField(3);

        private MyCountryCodeEditor() {
        }

        @Override
        JComponent getComponent() {
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("<html><body>Mobile country code<br>(3 digits):</body></html>");
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.setColumns(3);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel2.add((Component)label);
            panel2.add(this.myTextField);
            return panel2;
        }

        @Override
        void reset(@NotNull CountryCodeQualifier qualifier) {
            if (qualifier == null) {
                MyCountryCodeEditor.$$$reportNull$$$0(0);
            }
            this.myTextField.setText(Integer.toString(qualifier.getCode()));
        }

        @Override
        @NotNull
        CountryCodeQualifier apply() throws InvalidOptionValueException {
            if (this.myTextField.getText().length() != 3) {
                throw new InvalidOptionValueException("Country code must contain 3 digits");
            }
            try {
                int code = Integer.parseInt(this.myTextField.getText());
                if (code < 100 || code > 999) {
                    throw new InvalidOptionValueException("Incorrect country code");
                }
                return new CountryCodeQualifier(code);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException("Country code must be a number");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyCountryCodeEditor", "reset"));
        }
    }

    private static abstract class MyQualifierEditor<T extends ResourceQualifier> {
        private MyQualifierEditor() {
        }

        abstract JComponent getComponent();

        abstract void reset(@NotNull T var1);

        @NotNull
        abstract T apply() throws InvalidOptionValueException;
    }
}

