/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.SdkConstants;
import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AndroidManifestPackageNameUtils;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalLibrary;
import com.android.projectmodel.Library;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.classloading.RenderClassLoader;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.idea.util.VirtualFileSystemOpener;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ClassLoadingUtilsKt;
import org.jetbrains.android.uipreview.RecyclerViewHelper;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleClassLoader
extends RenderClassLoader {
    private static final Logger LOG = Logger.getInstance(ModuleClassLoader.class);
    private final WeakReference<Module> myModuleReference;
    private Map<String, VirtualFile> myClassFiles;
    private Map<String, ClassModificationTimestamp> myClassFilesLastModified;
    private static final Pattern RESOURCE_CLASS_NAME = Pattern.compile(".+\\.R(\\$[^.]+)?$");

    ModuleClassLoader(@Nullable ClassLoader parent, @NotNull Module module) {
        if (module == null) {
            ModuleClassLoader.$$$reportNull$$$0(0);
        }
        super(parent);
        this.myModuleReference = new WeakReference<Module>(module);
        ModuleClassLoader.registerResources(module);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        block13: {
            block12: {
                if (ModuleClassLoader.LOG.isDebugEnabled()) {
                    ModuleClassLoader.LOG.debug(String.format("findClass(%s)", new Object[]{name}));
                }
                module = (Module)this.myModuleReference.get();
                try {
                    if (this.myInsideJarClassLoader || module == null || !ModuleClassLoader.isResourceClassName(name)) ** GOTO lbl35
                    facet = AndroidFacet.getInstance((Module)module);
                    if (facet == null) ** GOTO lbl34
                    repositoryManager = ResourceRepositoryManager.getInstance(facet);
                    data = ResourceClassRegistry.get(module.getProject()).findClassDefinition(name, repositoryManager);
                    if (data == null) break block12;
                    ModuleClassLoader.LOG.debug("  Defining class from AAR registry");
                    v0 = this.loadClass(name, data);
                }
                catch (ClassNotFoundException e) {
                    clazz = null;
                    if ("com.android.layoutlib.bridge.android.support.Adapter".equals(name)) {
                        clazz = RecyclerViewHelper.getAdapterClass(DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_V7), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER));
                    }
                    if ("com.android.layoutlib.bridge.android.support.Adapter$ViewHolder".equals(name)) {
                        clazz = RecyclerViewHelper.getViewHolder(DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_V7), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER));
                    }
                    if (clazz != null) {
                        if (ModuleClassLoader.LOG.isDebugEnabled()) {
                            ModuleClassLoader.LOG.debug("  Defining RecyclerView helper class");
                        }
                        v1 = this.defineClassAndPackage(name, clazz, 0, clazz.length);
                        if (v1 == null) {
                            ModuleClassLoader.$$$reportNull$$$0(3);
                        }
                        return v1;
                    }
                    ModuleClassLoader.LOG.debug((Throwable)e);
                    throw e;
                }
                if (v0 == null) {
                    ModuleClassLoader.$$$reportNull$$$0(1);
                }
                return v0;
            }
            break block13;
lbl34:
            // 1 sources

            ModuleClassLoader.LOG.debug("  LocalResourceRepositoryInstance not found");
        }
        if (ModuleClassLoader.LOG.isDebugEnabled()) {
            ModuleClassLoader.LOG.debug(String.format("  super.findClass(%s)", new Object[]{LogAnonymizerUtil.anonymizeClassName((String)name)}));
        }
        v2 = super.findClass(name);
        if (v2 == null) {
            ModuleClassLoader.$$$reportNull$$$0(2);
        }
        return v2;
    }

    @Override
    @NotNull
    protected Class<?> load(@NotNull String name) throws ClassNotFoundException {
        Module module;
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(4);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("load(%s)", LogAnonymizerUtil.anonymizeClassName((String)name)));
        }
        if ((module = (Module)this.myModuleReference.get()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  ClassNotFoundException(%s)", name));
            }
            throw new ClassNotFoundException(name);
        }
        Class<?> aClass = this.loadClassFromModuleOrDependency(module, name);
        if (aClass != null) {
            Class<?> clazz = aClass;
            if (clazz == null) {
                ModuleClassLoader.$$$reportNull$$$0(5);
            }
            return clazz;
        }
        Class<?> clazz = this.loadClassFromNonProjectDependency(name);
        if (clazz == null) {
            ModuleClassLoader.$$$reportNull$$$0(6);
        }
        return clazz;
    }

    @Override
    @NotNull
    public Class<?> loadClass(@NotNull String name) throws ClassNotFoundException {
        boolean loadFromProject;
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(7);
        }
        if (loadFromProject = name.startsWith("android.support.constraint.solver")) {
            Class<?> clazz;
            block8: {
                Class<?> loadedClass = this.findLoadedClass(name);
                if (loadedClass == null) break block8;
                Class<?> clazz2 = loadedClass;
                if (clazz2 == null) {
                    ModuleClassLoader.$$$reportNull$$$0(8);
                }
                return clazz2;
            }
            try {
                clazz = this.load(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clazz == null) {
                ModuleClassLoader.$$$reportNull$$$0(9);
            }
            return clazz;
        }
        Class<?> clazz = super.loadClass(name);
        if (clazz == null) {
            ModuleClassLoader.$$$reportNull$$$0(10);
        }
        return clazz;
    }

    @Nullable
    private Class<?> loadClassFromModuleOrDependency(@NotNull Module module, @NotNull String name) {
        if (module == null) {
            ModuleClassLoader.$$$reportNull$$$0(11);
        }
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(12);
        }
        if (module.isDisposed()) {
            return null;
        }
        VirtualFile classFile = ProjectSystemUtil.getModuleSystem(module).findClassFile(name);
        if (classFile == null) {
            return null;
        }
        return this.loadClassFile(name, classFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSourceModified(@NotNull String name, @Nullable Object myCredential) {
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(13);
        }
        if (ModuleClassLoader.isResourceClassName(name)) {
            return false;
        }
        Module module = (Module)this.myModuleReference.get();
        if (module == null) {
            return false;
        }
        VirtualFile classFile = this.getClassFile(name);
        if (classFile == null) {
            return false;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        if (facet2 == null || AndroidModel.get(facet2) == null) {
            return false;
        }
        boolean token = RenderSecurityManager.enterSafeRegion(myCredential);
        try {
            boolean bl = AndroidModel.get(facet2).isClassFileOutOfDate(module, name, classFile);
            return bl;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private static boolean isResourceClassName(@NotNull String className) {
        if (className == null) {
            ModuleClassLoader.$$$reportNull$$$0(14);
        }
        return RESOURCE_CLASS_NAME.matcher(className).matches();
    }

    @Override
    @Nullable
    protected Class<?> loadClassFile(@NotNull String name, @NotNull VirtualFile classFile) {
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(15);
        }
        if (classFile == null) {
            ModuleClassLoader.$$$reportNull$$$0(16);
        }
        if (this.myClassFiles == null) {
            this.myClassFiles = new ConcurrentHashMap<String, VirtualFile>();
            this.myClassFilesLastModified = new ConcurrentHashMap<String, ClassModificationTimestamp>();
        }
        this.myClassFiles.put(name, classFile);
        this.myClassFilesLastModified.put(name, new ClassModificationTimestamp(classFile.getTimeStamp(), classFile.getLength()));
        return super.loadClassFile(name, classFile);
    }

    private static void registerResources(@NotNull Module module) {
        AndroidFacet androidFacet;
        if (module == null) {
            ModuleClassLoader.$$$reportNull$$$0(17);
        }
        if ((androidFacet = AndroidFacet.getInstance((Module)module)) == null) {
            return;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(androidFacet);
        ResourceIdManager idManager = ResourceIdManager.get(module);
        ResourceClassRegistry classRegistry = ResourceClassRegistry.get(module.getProject());
        if (!idManager.finalIdsUsed()) {
            classRegistry.addLibrary((ResourceRepository)repositoryManager.getAppResources(), idManager, (String)ReadAction.compute(() -> AndroidManifestUtils.getPackageName(androidFacet)), repositoryManager.getNamespace());
        }
        for (AndroidFacet dependency : AndroidUtils.getAllAndroidDependencies(module, false)) {
            classRegistry.addLibrary((ResourceRepository)repositoryManager.getAppResources(), idManager, (String)ReadAction.compute(() -> AndroidManifestUtils.getPackageName(dependency)), repositoryManager.getNamespace());
        }
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module);
        for (Library library : moduleSystem.getResolvedDependentLibraries()) {
            if (!(library instanceof ExternalLibrary) || !((ExternalLibrary)library).hasResources()) continue;
            ModuleClassLoader.registerLibraryResources((ExternalLibrary)library, repositoryManager, classRegistry, idManager);
        }
    }

    private static void registerLibraryResources(@NotNull ExternalLibrary library, @NotNull ResourceRepositoryManager repositoryManager, @NotNull ResourceClassRegistry classRegistry, @NotNull ResourceIdManager idManager) {
        ResourceNamespace resourcesNamespace;
        Object rClassContents;
        String packageName;
        if (library == null) {
            ModuleClassLoader.$$$reportNull$$$0(18);
        }
        if (repositoryManager == null) {
            ModuleClassLoader.$$$reportNull$$$0(19);
        }
        if (classRegistry == null) {
            ModuleClassLoader.$$$reportNull$$$0(20);
        }
        if (idManager == null) {
            ModuleClassLoader.$$$reportNull$$$0(21);
        }
        LocalResourceRepository appResources = repositoryManager.getAppResources();
        if (repositoryManager.getNamespacing() == AaptOptions.Namespacing.DISABLED) {
            packageName = ModuleClassLoader.getPackageName(library);
            if (packageName == null) {
                return;
            }
            rClassContents = appResources;
            resourcesNamespace = ResourceNamespace.RES_AUTO;
        } else {
            AarResourceRepository aarResources = repositoryManager.findLibraryResources(library);
            if (aarResources == null) {
                return;
            }
            rClassContents = aarResources;
            resourcesNamespace = aarResources.getNamespace();
            packageName = aarResources.getPackageName();
        }
        classRegistry.addLibrary((ResourceRepository)rClassContents, idManager, packageName, resourcesNamespace);
    }

    @Nullable
    private static String getPackageName(@NotNull ExternalLibrary library) {
        block7: {
            if (library == null) {
                ModuleClassLoader.$$$reportNull$$$0(22);
            }
            if (library.getPackageName() != null) {
                return library.getPackageName();
            }
            PathString manifestFile = library.getManifestFile();
            if (manifestFile != null) {
                try {
                    return AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)manifestFile);
                }
                catch (IOException ignore) {
                    if (!VirtualFileSystemOpener.INSTANCE.recognizes(manifestFile)) break block7;
                    FileExtensions.toVirtualFile(manifestFile, true);
                    try {
                        return AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)manifestFile);
                    }
                    catch (IOException ignore2) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected List<URL> getExternalJars() {
        List<URL> list = ClassLoadingUtilsKt.getLibraryDependenciesJars((Module)this.myModuleReference.get());
        if (list == null) {
            ModuleClassLoader.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Nullable
    private VirtualFile getClassFile(@NotNull String className) {
        if (className == null) {
            ModuleClassLoader.$$$reportNull$$$0(24);
        }
        if (this.myClassFiles == null) {
            return null;
        }
        VirtualFile file = this.myClassFiles.get(className);
        if (file == null) {
            return null;
        }
        return file.isValid() ? file : null;
    }

    boolean isUpToDate() {
        if (this.myClassFiles != null) {
            for (Map.Entry<String, VirtualFile> entry : this.myClassFiles.entrySet()) {
                String className = entry.getKey();
                VirtualFile classFile = entry.getValue();
                if (!classFile.isValid()) {
                    return false;
                }
                ClassModificationTimestamp lastModifiedStamp = this.myClassFilesLastModified.get(className);
                if (lastModifiedStamp == null) continue;
                long loadedModifiedTime = lastModifiedStamp.timestamp;
                long loadedModifiedLength = lastModifiedStamp.length;
                long classFileModifiedTime = classFile.getTimeStamp();
                long classFileModifiedLength = classFile.getLength();
                if ((classFileModifiedTime <= 0L || loadedModifiedTime <= 0L || loadedModifiedTime >= classFileModifiedTime) && loadedModifiedLength == classFileModifiedLength) continue;
                return false;
            }
        }
        return this.areDependenciesUpToDate();
    }

    public boolean isClassLoaded(@NotNull String className) {
        if (className == null) {
            ModuleClassLoader.$$$reportNull$$$0(25);
        }
        return this.findLoadedClass(className) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/uipreview/ModuleClassLoader";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRegistry";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/uipreview/ModuleClassLoader";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadClass";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalJars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFromModuleOrDependency";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSourceModified";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isResourceClassName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerResources";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerLibraryResources";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getClassFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isClassLoaded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassModificationTimestamp {
        public final long timestamp;
        public final long length;

        ClassModificationTimestamp(long timestamp, long length) {
            this.timestamp = timestamp;
            this.length = length;
        }
    }
}

