/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import org.jetbrains.android.compiler.artifact.ApkSigningSettingsForm;
import org.jetbrains.android.compiler.artifact.ChooseKeyDialog;
import org.jetbrains.android.compiler.artifact.NewKeyStoreDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidUiUtil {
    private static final Logger LOG = Logger.getInstance(AndroidUiUtil.class);

    private AndroidUiUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static List<String> loadExistingKeys(@NotNull ApkSigningSettingsForm form) {
        if (form == null) {
            AndroidUiUtil.$$$reportNull$$$0(0);
        }
        String errorPrefix = "Cannot load key store: ";
        InputStream is = null;
        try {
            is = new FileInputStream(new File(form.getKeyStorePathField().getText().trim()));
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, form.getKeyStorePasswordField().getPassword());
            List list = ContainerUtil.toList(keyStore.aliases());
            return list;
        }
        catch (KeyStoreException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (FileNotFoundException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (CertificateException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (NoSuchAlgorithmException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (IOException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }

    public static void initSigningSettingsForm(final @NotNull Project project, final @NotNull ApkSigningSettingsForm form) {
        if (project == null) {
            AndroidUiUtil.$$$reportNull$$$0(1);
        }
        if (form == null) {
            AndroidUiUtil.$$$reportNull$$$0(2);
        }
        form.getLoadKeyStoreButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String defaultPath = form.getKeyStorePathField().getText().trim();
                VirtualFile defaultFile = LocalFileSystem.getInstance().findFileByPath(defaultPath);
                FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Component)form.getPanel(), (Project)project, (VirtualFile)defaultFile);
                if (file != null) {
                    form.getKeyStorePathField().setText(FileUtil.toSystemDependentName((String)file.getPath()));
                }
            }
        });
        form.getCreateKeyStoreButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewKeyStoreDialog dialog2 = new NewKeyStoreDialog(project, form.getKeyStorePathField().getText());
                dialog2.show();
                if (dialog2.getExitCode() == 0) {
                    form.getKeyStorePathField().setText(dialog2.getKeyStorePath());
                    form.getKeyStorePasswordField().setText(String.valueOf(dialog2.getKeyStorePassword()));
                    form.getKeyAliasField().setText(dialog2.getKeyAlias());
                    form.getKeyPasswordField().setText(String.valueOf(dialog2.getKeyPassword()));
                }
            }
        });
        form.getKeyAliasField().getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> keys = AndroidUiUtil.loadExistingKeys(form);
                if (keys == null) {
                    return;
                }
                ChooseKeyDialog dialog2 = new ChooseKeyDialog(project, form.getKeyStorePathField().getText().trim(), form.getKeyStorePasswordField().getPassword(), keys, form.getKeyAliasField().getText().trim());
                dialog2.show();
                if (dialog2.getExitCode() == 0) {
                    char[] password;
                    String chosenKey = dialog2.getChosenKey();
                    if (chosenKey != null) {
                        form.getKeyAliasField().setText(chosenKey);
                    }
                    if ((password = dialog2.getChosenKeyPassword()) != null) {
                        form.getKeyPasswordField().setText(String.valueOf(password));
                    }
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "form";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/util/AndroidUiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadExistingKeys";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initSigningSettingsForm";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

