/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.GradleUtil;
import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.parser.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.GradleDslConverterFactory;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleDslWriter;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.plugins.PluginsDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslFile
extends GradlePropertiesDslElement {
    private static final Logger LOG = Logger.getInstance(GradleDslFile.class);
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<GradleDslFile> myChildModuleDslFiles;
    @NotNull
    private final GradleDslWriter myGradleDslWriter;
    @NotNull
    private final GradleDslParser myGradleDslParser;
    @Nullable
    private GradleDslFile myParentModuleDslFile;
    @Nullable
    private GradleDslFile mySiblingDslFile;
    @Nullable
    private ApplyDslElement myApplyDslElement;
    @NotNull
    private final BuildModelContext myBuildModelContext;
    public static final ImmutableMap<String, PropertiesElementDescription> CHILD_PROPERTIES_ELEMENTS_MAP = (ImmutableMap)Stream.of({"android", AndroidDslElement.ANDROID}, {"buildscript", BuildScriptDslElement.BUILDSCRIPT}, {"configurations", ConfigurationsDslElement.CONFIGURATIONS}, {"dependencies", DependenciesDslElement.DEPENDENCIES}, {"ext", ExtDslElement.EXT}, {"java", JavaDslElement.JAVA}, {"repositories", RepositoriesDslElement.REPOSITORIES}, {"subprojects", SubProjectsDslElement.SUBPROJECTS}, {"plugins", PluginsDslElement.PLUGINS}).collect(ImmutableMap.toImmutableMap(data -> (String)data[0], data -> (PropertiesElementDescription)data[1]));

    @Override
    @NotNull
    protected ImmutableMap<String, PropertiesElementDescription> getChildPropertiesElementsDescriptionMap() {
        ImmutableMap<String, PropertiesElementDescription> immutableMap = CHILD_PROPERTIES_ELEMENTS_MAP;
        if (immutableMap == null) {
            GradleDslFile.$$$reportNull$$$0(0);
        }
        return immutableMap;
    }

    protected GradleDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName, @NotNull BuildModelContext context) {
        if (file == null) {
            GradleDslFile.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GradleDslFile.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            GradleDslFile.$$$reportNull$$$0(3);
        }
        if (context == null) {
            GradleDslFile.$$$reportNull$$$0(4);
        }
        super(null, null, GradleNameElement.fake(moduleName));
        this.myChildModuleDslFiles = new HashSet<GradleDslFile>();
        this.myFile = file;
        this.myProject = project;
        this.myBuildModelContext = context;
        Application application = ApplicationManager.getApplication();
        PsiFile psiFile = (PsiFile)application.runReadAction(() -> PsiManager.getInstance((Project)this.myProject).findFile(this.myFile));
        List extensionList = GradleDslConverterFactory.EXTENSION_POINT_NAME.getExtensionList();
        GradleDslParser parser = null;
        GradleDslWriter writer = null;
        for (GradleDslConverterFactory factory : extensionList) {
            if (!factory.canConvert(psiFile)) continue;
            parser = factory.createParser(psiFile, this);
            writer = factory.createWriter();
            this.setPsiElement((PsiElement)psiFile);
            break;
        }
        if (parser != null) {
            this.myGradleDslParser = parser;
            this.myGradleDslWriter = writer;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("cannot find converter factory for " + psiFile.getName() + "(" + psiFile.getClass().getCanonicalName() + ")");
            }
            this.myGradleDslParser = new GradleDslParser.Adapter();
            this.myGradleDslWriter = new GradleDslWriter.Adapter();
        }
    }

    public void reparse() {
        this.clear();
        this.parse();
    }

    public void parse() {
        this.myGradleDslParser.parse();
        this.getContext().getDependencyManager().resolveAllIn(this, true);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GradleDslFile.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            GradleDslFile.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @NotNull
    public File getDirectoryPath() {
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)this.getFile().getParent());
        if (file == null) {
            GradleDslFile.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    public List<GradleDslFile> getApplyDslElement() {
        Object object = this.myApplyDslElement == null ? ImmutableList.of() : this.myApplyDslElement.getAppliedDslFiles();
        if (object == null) {
            GradleDslFile.$$$reportNull$$$0(8);
        }
        return object;
    }

    public void setParentModuleDslFile(@NotNull GradleDslFile parentModuleDslFile) {
        if (parentModuleDslFile == null) {
            GradleDslFile.$$$reportNull$$$0(9);
        }
        this.myParentModuleDslFile = parentModuleDslFile;
        this.myParentModuleDslFile.myChildModuleDslFiles.add(this);
    }

    @Nullable
    public GradleDslFile getParentModuleDslFile() {
        return this.myParentModuleDslFile;
    }

    @NotNull
    public Collection<GradleDslFile> getChildModuleDslFiles() {
        Set<GradleDslFile> set = this.myChildModuleDslFiles;
        if (set == null) {
            GradleDslFile.$$$reportNull$$$0(10);
        }
        return set;
    }

    public void setSiblingDslFile(@NotNull GradleDslFile siblingDslFile) {
        if (siblingDslFile == null) {
            GradleDslFile.$$$reportNull$$$0(11);
        }
        this.mySiblingDslFile = siblingDslFile;
    }

    @Nullable
    public GradleDslFile getSiblingDslFile() {
        return this.mySiblingDslFile;
    }

    @NotNull
    public GradleDslWriter getWriter() {
        GradleDslWriter gradleDslWriter = this.myGradleDslWriter;
        if (gradleDslWriter == null) {
            GradleDslFile.$$$reportNull$$$0(12);
        }
        return gradleDslWriter;
    }

    @NotNull
    public GradleDslParser getParser() {
        GradleDslParser gradleDslParser = this.myGradleDslParser;
        if (gradleDslParser == null) {
            GradleDslFile.$$$reportNull$$$0(13);
        }
        return gradleDslParser;
    }

    @NotNull
    public BuildModelContext getContext() {
        BuildModelContext buildModelContext = this.myBuildModelContext;
        if (buildModelContext == null) {
            GradleDslFile.$$$reportNull$$$0(14);
        }
        return buildModelContext;
    }

    @Override
    protected void apply() {
        if (this.myApplyDslElement != null) {
            for (GradleDslFile file : this.myApplyDslElement.getAppliedDslFiles()) {
                file.apply();
            }
        }
        super.apply();
    }

    public void registerApplyElement(@NotNull ApplyDslElement applyElement) {
        if (applyElement == null) {
            GradleDslFile.$$$reportNull$$$0(15);
        }
        this.myApplyDslElement = applyElement;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications() {
        List<BuildModelNotification> list = this.myBuildModelContext.getPublicNotifications(this);
        if (list == null) {
            GradleDslFile.$$$reportNull$$$0(16);
        }
        return list;
    }

    public void saveAllChanges() {
        PsiElement element = this.getPsiElement();
        if (element == null) {
            return;
        }
        assert (element instanceof PsiFile);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document document = psiDocumentManager.getDocument((PsiFile)element);
        if (document == null) {
            return;
        }
        if (psiDocumentManager.isDocumentBlockedByPsi(document)) {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        }
        FileDocumentManager.getInstance().saveDocument(document);
        if (!psiDocumentManager.isCommitted(document)) {
            psiDocumentManager.commitDocument(document);
        }
    }

    @Nullable
    public VirtualFile tryToFindSettingsFile() {
        if (this instanceof GradleSettingsFile) {
            return this.getFile();
        }
        for (VirtualFile buildFileParent = this.getFile().getParent(); buildFileParent != null; buildFileParent = buildFileParent.getParent()) {
            VirtualFile maybeSettingsFile = GradleUtil.getGradleSettingsFile(VfsUtilCore.virtualToIoFile((VirtualFile)buildFileParent));
            if (maybeSettingsFile == null) continue;
            return maybeSettingsFile;
        }
        return null;
    }

    public boolean isKotlin() {
        return this.myGradleDslParser.isKotlin();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/files/GradleDslFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentModuleDslFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siblingDslFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPropertiesElementsDescriptionMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/files/GradleDslFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplyDslElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildModuleDslFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getWriter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getParser";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setParentModuleDslFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSiblingDslFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerApplyElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

