/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;

public class UsageEvents
implements Parcelable {
    public static final String INSTANT_APP_PACKAGE_NAME = "android.instant_app";
    public static final String INSTANT_APP_CLASS_NAME = "android.instant_class";
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private List<Event> mEventsToWrite = null;
    @UnsupportedAppUsage
    private Parcel mParcel = null;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final int mEventCount;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mIndex = 0;
    private final boolean mIncludeTaskRoots;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private String[] mStringPool;
    public static final Parcelable.Creator<UsageEvents> CREATOR = new Parcelable.Creator<UsageEvents>(){

        @Override
        public UsageEvents createFromParcel(Parcel source) {
            return new UsageEvents(source);
        }

        public UsageEvents[] newArray(int size) {
            return new UsageEvents[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public UsageEvents(Parcel in) {
        byte[] bytes = in.readBlob();
        Parcel data = Parcel.obtain();
        data.unmarshall(bytes, 0, bytes.length);
        data.setDataPosition(0);
        this.mEventCount = data.readInt();
        this.mIndex = data.readInt();
        if (this.mEventCount > 0) {
            this.mStringPool = data.createStringArray();
            int listByteLength = data.readInt();
            int positionInParcel = data.readInt();
            this.mParcel = Parcel.obtain();
            this.mParcel.setDataPosition(0);
            this.mParcel.appendFrom(data, data.dataPosition(), listByteLength);
            this.mParcel.setDataSize(this.mParcel.dataPosition());
            this.mParcel.setDataPosition(positionInParcel);
        }
        this.mIncludeTaskRoots = true;
    }

    UsageEvents() {
        this.mEventCount = 0;
        this.mIncludeTaskRoots = true;
    }

    public UsageEvents(List<Event> events, String[] stringPool) {
        this(events, stringPool, false);
    }

    public UsageEvents(List<Event> events, String[] stringPool, boolean includeTaskRoots) {
        this.mStringPool = stringPool;
        this.mEventCount = events.size();
        this.mEventsToWrite = events;
        this.mIncludeTaskRoots = includeTaskRoots;
    }

    public boolean hasNextEvent() {
        return this.mIndex < this.mEventCount;
    }

    public boolean getNextEvent(Event eventOut) {
        if (this.mIndex >= this.mEventCount) {
            return false;
        }
        this.readEventFromParcel(this.mParcel, eventOut);
        ++this.mIndex;
        if (this.mIndex >= this.mEventCount) {
            this.mParcel.recycle();
            this.mParcel = null;
        }
        return true;
    }

    public void resetToStart() {
        this.mIndex = 0;
        if (this.mParcel != null) {
            this.mParcel.setDataPosition(0);
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int findStringIndex(String str) {
        int index = Arrays.binarySearch(this.mStringPool, str);
        if (index < 0) {
            throw new IllegalStateException("String '" + str + "' is not in the string pool");
        }
        return index;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private void writeEventToParcel(Event event, Parcel p, int flags) {
        int packageIndex = event.mPackage != null ? this.findStringIndex(event.mPackage) : -1;
        int classIndex = event.mClass != null ? this.findStringIndex(event.mClass) : -1;
        int taskRootPackageIndex = this.mIncludeTaskRoots && event.mTaskRootPackage != null ? this.findStringIndex(event.mTaskRootPackage) : -1;
        int taskRootClassIndex = this.mIncludeTaskRoots && event.mTaskRootClass != null ? this.findStringIndex(event.mTaskRootClass) : -1;
        p.writeInt(packageIndex);
        p.writeInt(classIndex);
        p.writeInt(event.mInstanceId);
        p.writeInt(taskRootPackageIndex);
        p.writeInt(taskRootClassIndex);
        p.writeInt(event.mEventType);
        p.writeLong(event.mTimeStamp);
        switch (event.mEventType) {
            case 5: {
                event.mConfiguration.writeToParcel(p, flags);
                break;
            }
            case 8: {
                p.writeString(event.mShortcutId);
                break;
            }
            case 9: {
                p.writeString(event.mAction);
                p.writeString(event.mContentType);
                p.writeStringArray(event.mContentAnnotations);
                break;
            }
            case 11: {
                p.writeInt(event.mBucketAndReason);
                break;
            }
            case 12: {
                p.writeString(event.mNotificationChannelId);
            }
        }
        p.writeInt(event.mFlags);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private void readEventFromParcel(Parcel p, Event eventOut) {
        int packageIndex = p.readInt();
        eventOut.mPackage = packageIndex >= 0 ? this.mStringPool[packageIndex] : null;
        int classIndex = p.readInt();
        eventOut.mClass = classIndex >= 0 ? this.mStringPool[classIndex] : null;
        eventOut.mInstanceId = p.readInt();
        int taskRootPackageIndex = p.readInt();
        eventOut.mTaskRootPackage = taskRootPackageIndex >= 0 ? this.mStringPool[taskRootPackageIndex] : null;
        int taskRootClassIndex = p.readInt();
        eventOut.mTaskRootClass = taskRootClassIndex >= 0 ? this.mStringPool[taskRootClassIndex] : null;
        eventOut.mEventType = p.readInt();
        eventOut.mTimeStamp = p.readLong();
        eventOut.mConfiguration = null;
        eventOut.mShortcutId = null;
        eventOut.mAction = null;
        eventOut.mContentType = null;
        eventOut.mContentAnnotations = null;
        eventOut.mNotificationChannelId = null;
        switch (eventOut.mEventType) {
            case 5: {
                eventOut.mConfiguration = Configuration.CREATOR.createFromParcel(p);
                break;
            }
            case 8: {
                eventOut.mShortcutId = p.readString();
                break;
            }
            case 9: {
                eventOut.mAction = p.readString();
                eventOut.mContentType = p.readString();
                eventOut.mContentAnnotations = p.createStringArray();
                break;
            }
            case 11: {
                eventOut.mBucketAndReason = p.readInt();
                break;
            }
            case 12: {
                eventOut.mNotificationChannelId = p.readString();
            }
        }
        eventOut.mFlags = p.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Parcel data = Parcel.obtain();
        data.writeInt(this.mEventCount);
        data.writeInt(this.mIndex);
        if (this.mEventCount > 0) {
            data.writeStringArray(this.mStringPool);
            if (this.mEventsToWrite != null) {
                Parcel p = Parcel.obtain();
                try {
                    p.setDataPosition(0);
                    for (int i = 0; i < this.mEventCount; ++i) {
                        Event event = this.mEventsToWrite.get(i);
                        this.writeEventToParcel(event, p, flags);
                    }
                    int listByteLength = p.dataPosition();
                    data.writeInt(listByteLength);
                    data.writeInt(0);
                    data.appendFrom(p, 0, listByteLength);
                }
                finally {
                    p.recycle();
                }
            } else if (this.mParcel != null) {
                data.writeInt(this.mParcel.dataSize());
                data.writeInt(this.mParcel.dataPosition());
                data.appendFrom(this.mParcel, 0, this.mParcel.dataSize());
            } else {
                throw new IllegalStateException("Either mParcel or mEventsToWrite must not be null");
            }
        }
        dest.writeBlob(data.marshall());
    }

    public static class Event {
        public static final int NONE = 0;
        public static final String DEVICE_EVENT_PACKAGE_NAME = "android";
        @Deprecated
        public static final int MOVE_TO_FOREGROUND = 1;
        public static final int ACTIVITY_RESUMED = 1;
        @Deprecated
        public static final int MOVE_TO_BACKGROUND = 2;
        public static final int ACTIVITY_PAUSED = 2;
        public static final int END_OF_DAY = 3;
        public static final int CONTINUE_PREVIOUS_DAY = 4;
        public static final int CONFIGURATION_CHANGE = 5;
        @SystemApi
        public static final int SYSTEM_INTERACTION = 6;
        public static final int USER_INTERACTION = 7;
        public static final int SHORTCUT_INVOCATION = 8;
        public static final int CHOOSER_ACTION = 9;
        @SystemApi
        public static final int NOTIFICATION_SEEN = 10;
        public static final int STANDBY_BUCKET_CHANGED = 11;
        @SystemApi
        public static final int NOTIFICATION_INTERRUPTION = 12;
        @SystemApi
        public static final int SLICE_PINNED_PRIV = 13;
        @SystemApi
        public static final int SLICE_PINNED = 14;
        public static final int SCREEN_INTERACTIVE = 15;
        public static final int SCREEN_NON_INTERACTIVE = 16;
        public static final int KEYGUARD_SHOWN = 17;
        public static final int KEYGUARD_HIDDEN = 18;
        public static final int FOREGROUND_SERVICE_START = 19;
        public static final int FOREGROUND_SERVICE_STOP = 20;
        public static final int CONTINUING_FOREGROUND_SERVICE = 21;
        public static final int ROLLOVER_FOREGROUND_SERVICE = 22;
        public static final int ACTIVITY_STOPPED = 23;
        public static final int ACTIVITY_DESTROYED = 24;
        public static final int FLUSH_TO_DISK = 25;
        public static final int DEVICE_SHUTDOWN = 26;
        public static final int DEVICE_STARTUP = 27;
        public static final int MAX_EVENT_TYPE = 27;
        public static final int FLAG_IS_PACKAGE_INSTANT_APP = 1;
        public static final int VALID_FLAG_BITS = 1;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        public String mPackage;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        public String mClass;
        public int mInstanceId;
        public String mTaskRootPackage;
        public String mTaskRootClass;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        public long mTimeStamp;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        public int mEventType;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        public Configuration mConfiguration;
        public String mShortcutId;
        public String mAction;
        public String mContentType;
        public String[] mContentAnnotations;
        public int mBucketAndReason;
        public String mNotificationChannelId;
        public int mFlags;

        public Event() {
        }

        public Event(int type, long timeStamp) {
            this.mEventType = type;
            this.mTimeStamp = timeStamp;
        }

        public Event(Event orig) {
            this.mPackage = orig.mPackage;
            this.mClass = orig.mClass;
            this.mInstanceId = orig.mInstanceId;
            this.mTaskRootPackage = orig.mTaskRootPackage;
            this.mTaskRootClass = orig.mTaskRootClass;
            this.mTimeStamp = orig.mTimeStamp;
            this.mEventType = orig.mEventType;
            this.mConfiguration = orig.mConfiguration;
            this.mShortcutId = orig.mShortcutId;
            this.mAction = orig.mAction;
            this.mContentType = orig.mContentType;
            this.mContentAnnotations = orig.mContentAnnotations;
            this.mFlags = orig.mFlags;
            this.mBucketAndReason = orig.mBucketAndReason;
            this.mNotificationChannelId = orig.mNotificationChannelId;
        }

        public String getPackageName() {
            return this.mPackage;
        }

        @SystemApi
        public boolean isInstantApp() {
            return (this.mFlags & 1) == 1;
        }

        public String getClassName() {
            return this.mClass;
        }

        @SystemApi
        public int getInstanceId() {
            return this.mInstanceId;
        }

        @SystemApi
        public String getTaskRootPackageName() {
            return this.mTaskRootPackage;
        }

        @SystemApi
        public String getTaskRootClassName() {
            return this.mTaskRootClass;
        }

        public long getTimeStamp() {
            return this.mTimeStamp;
        }

        public int getEventType() {
            return this.mEventType;
        }

        public Configuration getConfiguration() {
            return this.mConfiguration;
        }

        public String getShortcutId() {
            return this.mShortcutId;
        }

        public int getStandbyBucket() {
            return (this.mBucketAndReason & 0xFFFF0000) >>> 16;
        }

        public int getAppStandbyBucket() {
            return (this.mBucketAndReason & 0xFFFF0000) >>> 16;
        }

        public int getStandbyReason() {
            return this.mBucketAndReason & 0xFFFF;
        }

        @SystemApi
        public String getNotificationChannelId() {
            return this.mNotificationChannelId;
        }

        public Event getObfuscatedIfInstantApp() {
            if (!this.isInstantApp()) {
                return this;
            }
            Event ret = new Event(this);
            ret.mPackage = UsageEvents.INSTANT_APP_PACKAGE_NAME;
            ret.mClass = UsageEvents.INSTANT_APP_CLASS_NAME;
            return ret;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface EventFlags {
        }
    }
}

