/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ChangedPackages;
import android.content.pm.IDexModuleRegisterCallback;
import android.content.pm.IOnPermissionsChangeListener;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageDeleteObserver2;
import android.content.pm.IPackageInstaller;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.KeySet;
import android.content.pm.ModuleInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.SuspendDialogInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.content.pm.VersionedPackage;
import android.content.pm.dex.IArtManager;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public interface IPackageManager
extends IInterface {
    public void checkPackageStartable(String var1, int var2) throws RemoteException;

    @UnsupportedAppUsage
    public boolean isPackageAvailable(String var1, int var2) throws RemoteException;

    @UnsupportedAppUsage
    public PackageInfo getPackageInfo(String var1, int var2, int var3) throws RemoteException;

    public PackageInfo getPackageInfoVersioned(VersionedPackage var1, int var2, int var3) throws RemoteException;

    @UnsupportedAppUsage
    public int getPackageUid(String var1, int var2, int var3) throws RemoteException;

    public int[] getPackageGids(String var1, int var2, int var3) throws RemoteException;

    @UnsupportedAppUsage
    public String[] currentToCanonicalPackageNames(String[] var1) throws RemoteException;

    @UnsupportedAppUsage
    public String[] canonicalToCurrentPackageNames(String[] var1) throws RemoteException;

    public PermissionInfo getPermissionInfo(String var1, String var2, int var3) throws RemoteException;

    public ParceledListSlice queryPermissionsByGroup(String var1, int var2) throws RemoteException;

    @UnsupportedAppUsage
    public PermissionGroupInfo getPermissionGroupInfo(String var1, int var2) throws RemoteException;

    public ParceledListSlice getAllPermissionGroups(int var1) throws RemoteException;

    @UnsupportedAppUsage
    public ApplicationInfo getApplicationInfo(String var1, int var2, int var3) throws RemoteException;

    @UnsupportedAppUsage
    public ActivityInfo getActivityInfo(ComponentName var1, int var2, int var3) throws RemoteException;

    public boolean activitySupportsIntent(ComponentName var1, Intent var2, String var3) throws RemoteException;

    @UnsupportedAppUsage
    public ActivityInfo getReceiverInfo(ComponentName var1, int var2, int var3) throws RemoteException;

    @UnsupportedAppUsage
    public ServiceInfo getServiceInfo(ComponentName var1, int var2, int var3) throws RemoteException;

    @UnsupportedAppUsage
    public ProviderInfo getProviderInfo(ComponentName var1, int var2, int var3) throws RemoteException;

    @UnsupportedAppUsage
    public int checkPermission(String var1, String var2, int var3) throws RemoteException;

    public int checkUidPermission(String var1, int var2) throws RemoteException;

    @UnsupportedAppUsage
    public boolean addPermission(PermissionInfo var1) throws RemoteException;

    @UnsupportedAppUsage
    public void removePermission(String var1) throws RemoteException;

    @UnsupportedAppUsage
    public void grantRuntimePermission(String var1, String var2, int var3) throws RemoteException;

    public void revokeRuntimePermission(String var1, String var2, int var3) throws RemoteException;

    public void resetRuntimePermissions() throws RemoteException;

    public int getPermissionFlags(String var1, String var2, int var3) throws RemoteException;

    public void updatePermissionFlags(String var1, String var2, int var3, int var4, boolean var5, int var6) throws RemoteException;

    public void updatePermissionFlagsForAllApps(int var1, int var2, int var3) throws RemoteException;

    public List<String> getWhitelistedRestrictedPermissions(String var1, int var2, int var3) throws RemoteException;

    public boolean addWhitelistedRestrictedPermission(String var1, String var2, int var3, int var4) throws RemoteException;

    public boolean removeWhitelistedRestrictedPermission(String var1, String var2, int var3, int var4) throws RemoteException;

    public boolean shouldShowRequestPermissionRationale(String var1, String var2, int var3) throws RemoteException;

    public boolean isProtectedBroadcast(String var1) throws RemoteException;

    @UnsupportedAppUsage
    public int checkSignatures(String var1, String var2) throws RemoteException;

    @UnsupportedAppUsage
    public int checkUidSignatures(int var1, int var2) throws RemoteException;

    public List<String> getAllPackages() throws RemoteException;

    @UnsupportedAppUsage
    public String[] getPackagesForUid(int var1) throws RemoteException;

    @UnsupportedAppUsage
    public String getNameForUid(int var1) throws RemoteException;

    public String[] getNamesForUids(int[] var1) throws RemoteException;

    @UnsupportedAppUsage
    public int getUidForSharedUser(String var1) throws RemoteException;

    @UnsupportedAppUsage
    public int getFlagsForUid(int var1) throws RemoteException;

    public int getPrivateFlagsForUid(int var1) throws RemoteException;

    @UnsupportedAppUsage
    public boolean isUidPrivileged(int var1) throws RemoteException;

    @UnsupportedAppUsage
    public String[] getAppOpPermissionPackages(String var1) throws RemoteException;

    @UnsupportedAppUsage
    public ResolveInfo resolveIntent(Intent var1, String var2, int var3, int var4) throws RemoteException;

    public ResolveInfo findPersistentPreferredActivity(Intent var1, int var2) throws RemoteException;

    public boolean canForwardTo(Intent var1, String var2, int var3, int var4) throws RemoteException;

    @UnsupportedAppUsage
    public ParceledListSlice queryIntentActivities(Intent var1, String var2, int var3, int var4) throws RemoteException;

    public ParceledListSlice queryIntentActivityOptions(ComponentName var1, Intent[] var2, String[] var3, Intent var4, String var5, int var6, int var7) throws RemoteException;

    public ParceledListSlice queryIntentReceivers(Intent var1, String var2, int var3, int var4) throws RemoteException;

    public ResolveInfo resolveService(Intent var1, String var2, int var3, int var4) throws RemoteException;

    public ParceledListSlice queryIntentServices(Intent var1, String var2, int var3, int var4) throws RemoteException;

    public ParceledListSlice queryIntentContentProviders(Intent var1, String var2, int var3, int var4) throws RemoteException;

    @UnsupportedAppUsage
    public ParceledListSlice getInstalledPackages(int var1, int var2) throws RemoteException;

    public ParceledListSlice getPackagesHoldingPermissions(String[] var1, int var2, int var3) throws RemoteException;

    @UnsupportedAppUsage
    public ParceledListSlice getInstalledApplications(int var1, int var2) throws RemoteException;

    public ParceledListSlice getPersistentApplications(int var1) throws RemoteException;

    public ProviderInfo resolveContentProvider(String var1, int var2, int var3) throws RemoteException;

    @UnsupportedAppUsage
    public void querySyncProviders(List<String> var1, List<ProviderInfo> var2) throws RemoteException;

    public ParceledListSlice queryContentProviders(String var1, int var2, int var3, String var4) throws RemoteException;

    @UnsupportedAppUsage
    public InstrumentationInfo getInstrumentationInfo(ComponentName var1, int var2) throws RemoteException;

    @UnsupportedAppUsage
    public ParceledListSlice queryInstrumentation(String var1, int var2) throws RemoteException;

    public void finishPackageInstall(int var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage
    public void setInstallerPackageName(String var1, String var2) throws RemoteException;

    public void setApplicationCategoryHint(String var1, int var2, String var3) throws RemoteException;

    public void deletePackageAsUser(String var1, int var2, IPackageDeleteObserver var3, int var4, int var5) throws RemoteException;

    public void deletePackageVersioned(VersionedPackage var1, IPackageDeleteObserver2 var2, int var3, int var4) throws RemoteException;

    @UnsupportedAppUsage
    public String getInstallerPackageName(String var1) throws RemoteException;

    public void resetApplicationPreferences(int var1) throws RemoteException;

    @UnsupportedAppUsage
    public ResolveInfo getLastChosenActivity(Intent var1, String var2, int var3) throws RemoteException;

    @UnsupportedAppUsage
    public void setLastChosenActivity(Intent var1, String var2, int var3, IntentFilter var4, int var5, ComponentName var6) throws RemoteException;

    public void addPreferredActivity(IntentFilter var1, int var2, ComponentName[] var3, ComponentName var4, int var5) throws RemoteException;

    @UnsupportedAppUsage
    public void replacePreferredActivity(IntentFilter var1, int var2, ComponentName[] var3, ComponentName var4, int var5) throws RemoteException;

    @UnsupportedAppUsage
    public void clearPackagePreferredActivities(String var1) throws RemoteException;

    @UnsupportedAppUsage
    public int getPreferredActivities(List<IntentFilter> var1, List<ComponentName> var2, String var3) throws RemoteException;

    public void addPersistentPreferredActivity(IntentFilter var1, ComponentName var2, int var3) throws RemoteException;

    public void clearPackagePersistentPreferredActivities(String var1, int var2) throws RemoteException;

    public void addCrossProfileIntentFilter(IntentFilter var1, String var2, int var3, int var4, int var5) throws RemoteException;

    public void clearCrossProfileIntentFilters(int var1, String var2) throws RemoteException;

    public String[] setDistractingPackageRestrictionsAsUser(String[] var1, int var2, int var3) throws RemoteException;

    public String[] setPackagesSuspendedAsUser(String[] var1, boolean var2, PersistableBundle var3, PersistableBundle var4, SuspendDialogInfo var5, String var6, int var7) throws RemoteException;

    public String[] getUnsuspendablePackagesForUser(String[] var1, int var2) throws RemoteException;

    public boolean isPackageSuspendedForUser(String var1, int var2) throws RemoteException;

    public PersistableBundle getSuspendedPackageAppExtras(String var1, int var2) throws RemoteException;

    public byte[] getPreferredActivityBackup(int var1) throws RemoteException;

    public void restorePreferredActivities(byte[] var1, int var2) throws RemoteException;

    public byte[] getDefaultAppsBackup(int var1) throws RemoteException;

    public void restoreDefaultApps(byte[] var1, int var2) throws RemoteException;

    public byte[] getIntentFilterVerificationBackup(int var1) throws RemoteException;

    public void restoreIntentFilterVerification(byte[] var1, int var2) throws RemoteException;

    @UnsupportedAppUsage
    public ComponentName getHomeActivities(List<ResolveInfo> var1) throws RemoteException;

    public void setHomeActivity(ComponentName var1, int var2) throws RemoteException;

    @UnsupportedAppUsage
    public void setComponentEnabledSetting(ComponentName var1, int var2, int var3, int var4) throws RemoteException;

    @UnsupportedAppUsage
    public int getComponentEnabledSetting(ComponentName var1, int var2) throws RemoteException;

    @UnsupportedAppUsage
    public void setApplicationEnabledSetting(String var1, int var2, int var3, int var4, String var5) throws RemoteException;

    @UnsupportedAppUsage
    public int getApplicationEnabledSetting(String var1, int var2) throws RemoteException;

    public void logAppProcessStartIfNeeded(String var1, int var2, String var3, String var4, int var5) throws RemoteException;

    public void flushPackageRestrictionsAsUser(int var1) throws RemoteException;

    @UnsupportedAppUsage
    public void setPackageStoppedState(String var1, boolean var2, int var3) throws RemoteException;

    public void freeStorageAndNotify(String var1, long var2, int var4, IPackageDataObserver var5) throws RemoteException;

    public void freeStorage(String var1, long var2, int var4, IntentSender var5) throws RemoteException;

    @UnsupportedAppUsage
    public void deleteApplicationCacheFiles(String var1, IPackageDataObserver var2) throws RemoteException;

    public void deleteApplicationCacheFilesAsUser(String var1, int var2, IPackageDataObserver var3) throws RemoteException;

    public void clearApplicationUserData(String var1, IPackageDataObserver var2, int var3) throws RemoteException;

    public void clearApplicationProfileData(String var1) throws RemoteException;

    public void getPackageSizeInfo(String var1, int var2, IPackageStatsObserver var3) throws RemoteException;

    @UnsupportedAppUsage
    public String[] getSystemSharedLibraryNames() throws RemoteException;

    public ParceledListSlice getSystemAvailableFeatures() throws RemoteException;

    public boolean hasSystemFeature(String var1, int var2) throws RemoteException;

    public void enterSafeMode() throws RemoteException;

    @UnsupportedAppUsage
    public boolean isSafeMode() throws RemoteException;

    public void systemReady() throws RemoteException;

    @UnsupportedAppUsage
    public boolean hasSystemUidErrors() throws RemoteException;

    public void performFstrimIfNeeded() throws RemoteException;

    public void updatePackagesIfNeeded() throws RemoteException;

    public void notifyPackageUse(String var1, int var2) throws RemoteException;

    public void notifyDexLoad(String var1, List<String> var2, List<String> var3, String var4) throws RemoteException;

    public void registerDexModule(String var1, String var2, boolean var3, IDexModuleRegisterCallback var4) throws RemoteException;

    public boolean performDexOptMode(String var1, boolean var2, String var3, boolean var4, boolean var5, String var6) throws RemoteException;

    public boolean performDexOptSecondary(String var1, String var2, boolean var3) throws RemoteException;

    public boolean compileLayouts(String var1) throws RemoteException;

    public void dumpProfiles(String var1) throws RemoteException;

    public void forceDexOpt(String var1) throws RemoteException;

    public boolean runBackgroundDexoptJob(List<String> var1) throws RemoteException;

    public void reconcileSecondaryDexFiles(String var1) throws RemoteException;

    public int getMoveStatus(int var1) throws RemoteException;

    public void registerMoveCallback(IPackageMoveObserver var1) throws RemoteException;

    public void unregisterMoveCallback(IPackageMoveObserver var1) throws RemoteException;

    public int movePackage(String var1, String var2) throws RemoteException;

    public int movePrimaryStorage(String var1) throws RemoteException;

    @UnsupportedAppUsage
    public boolean addPermissionAsync(PermissionInfo var1) throws RemoteException;

    public boolean setInstallLocation(int var1) throws RemoteException;

    @UnsupportedAppUsage
    public int getInstallLocation() throws RemoteException;

    public int installExistingPackageAsUser(String var1, int var2, int var3, int var4, List<String> var5) throws RemoteException;

    public void verifyPendingInstall(int var1, int var2) throws RemoteException;

    public void extendVerificationTimeout(int var1, int var2, long var3) throws RemoteException;

    public void verifyIntentFilter(int var1, int var2, List<String> var3) throws RemoteException;

    public int getIntentVerificationStatus(String var1, int var2) throws RemoteException;

    public boolean updateIntentVerificationStatus(String var1, int var2, int var3) throws RemoteException;

    public ParceledListSlice getIntentFilterVerifications(String var1) throws RemoteException;

    public ParceledListSlice getAllIntentFilters(String var1) throws RemoteException;

    public boolean setDefaultBrowserPackageName(String var1, int var2) throws RemoteException;

    public String getDefaultBrowserPackageName(int var1) throws RemoteException;

    public VerifierDeviceIdentity getVerifierDeviceIdentity() throws RemoteException;

    public boolean isFirstBoot() throws RemoteException;

    public boolean isOnlyCoreApps() throws RemoteException;

    public boolean isDeviceUpgrading() throws RemoteException;

    public void setPermissionEnforced(String var1, boolean var2) throws RemoteException;

    public boolean isPermissionEnforced(String var1) throws RemoteException;

    @UnsupportedAppUsage
    public boolean isStorageLow() throws RemoteException;

    @UnsupportedAppUsage
    public boolean setApplicationHiddenSettingAsUser(String var1, boolean var2, int var3) throws RemoteException;

    public boolean getApplicationHiddenSettingAsUser(String var1, int var2) throws RemoteException;

    public void setSystemAppHiddenUntilInstalled(String var1, boolean var2) throws RemoteException;

    public boolean setSystemAppInstallState(String var1, boolean var2, int var3) throws RemoteException;

    @UnsupportedAppUsage
    public IPackageInstaller getPackageInstaller() throws RemoteException;

    public boolean setBlockUninstallForUser(String var1, boolean var2, int var3) throws RemoteException;

    @UnsupportedAppUsage
    public boolean getBlockUninstallForUser(String var1, int var2) throws RemoteException;

    public KeySet getKeySetByAlias(String var1, String var2) throws RemoteException;

    public KeySet getSigningKeySet(String var1) throws RemoteException;

    public boolean isPackageSignedByKeySet(String var1, KeySet var2) throws RemoteException;

    public boolean isPackageSignedByKeySetExactly(String var1, KeySet var2) throws RemoteException;

    public void addOnPermissionsChangeListener(IOnPermissionsChangeListener var1) throws RemoteException;

    public void removeOnPermissionsChangeListener(IOnPermissionsChangeListener var1) throws RemoteException;

    public void grantDefaultPermissionsToEnabledCarrierApps(String[] var1, int var2) throws RemoteException;

    public void grantDefaultPermissionsToEnabledImsServices(String[] var1, int var2) throws RemoteException;

    public void grantDefaultPermissionsToEnabledTelephonyDataServices(String[] var1, int var2) throws RemoteException;

    public void revokeDefaultPermissionsFromDisabledTelephonyDataServices(String[] var1, int var2) throws RemoteException;

    public void grantDefaultPermissionsToActiveLuiApp(String var1, int var2) throws RemoteException;

    public void revokeDefaultPermissionsFromLuiApps(String[] var1, int var2) throws RemoteException;

    public boolean isPermissionRevokedByPolicy(String var1, String var2, int var3) throws RemoteException;

    @UnsupportedAppUsage
    public String getPermissionControllerPackageName() throws RemoteException;

    public ParceledListSlice getInstantApps(int var1) throws RemoteException;

    public byte[] getInstantAppCookie(String var1, int var2) throws RemoteException;

    public boolean setInstantAppCookie(String var1, byte[] var2, int var3) throws RemoteException;

    public Bitmap getInstantAppIcon(String var1, int var2) throws RemoteException;

    public boolean isInstantApp(String var1, int var2) throws RemoteException;

    public boolean setRequiredForSystemUser(String var1, boolean var2) throws RemoteException;

    public void setUpdateAvailable(String var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage
    public String getServicesSystemSharedLibraryPackageName() throws RemoteException;

    @UnsupportedAppUsage
    public String getSharedSystemSharedLibraryPackageName() throws RemoteException;

    public ChangedPackages getChangedPackages(int var1, int var2) throws RemoteException;

    public boolean isPackageDeviceAdminOnAnyUser(String var1) throws RemoteException;

    public int getInstallReason(String var1, int var2) throws RemoteException;

    public ParceledListSlice getSharedLibraries(String var1, int var2, int var3) throws RemoteException;

    public ParceledListSlice getDeclaredSharedLibraries(String var1, int var2, int var3) throws RemoteException;

    public boolean canRequestPackageInstalls(String var1, int var2) throws RemoteException;

    public void deletePreloadsFileCache() throws RemoteException;

    public ComponentName getInstantAppResolverComponent() throws RemoteException;

    public ComponentName getInstantAppResolverSettingsComponent() throws RemoteException;

    public ComponentName getInstantAppInstallerComponent() throws RemoteException;

    public String getInstantAppAndroidId(String var1, int var2) throws RemoteException;

    public IArtManager getArtManager() throws RemoteException;

    public void setHarmfulAppWarning(String var1, CharSequence var2, int var3) throws RemoteException;

    public CharSequence getHarmfulAppWarning(String var1, int var2) throws RemoteException;

    public boolean hasSigningCertificate(String var1, byte[] var2, int var3) throws RemoteException;

    public boolean hasUidSigningCertificate(int var1, byte[] var2, int var3) throws RemoteException;

    public String getSystemTextClassifierPackageName() throws RemoteException;

    public String getAttentionServicePackageName() throws RemoteException;

    public String getWellbeingPackageName() throws RemoteException;

    public String getAppPredictionServicePackageName() throws RemoteException;

    public String getSystemCaptionsServicePackageName() throws RemoteException;

    public String getIncidentReportApproverPackageName() throws RemoteException;

    public boolean isPackageStateProtected(String var1, int var2) throws RemoteException;

    public void sendDeviceCustomizationReadyBroadcast() throws RemoteException;

    public List<ModuleInfo> getInstalledModules(int var1) throws RemoteException;

    public ModuleInfo getModuleInfo(String var1, int var2) throws RemoteException;

    public int getRuntimePermissionsVersion(int var1) throws RemoteException;

    public void setRuntimePermissionsVersion(int var1, int var2) throws RemoteException;

    public void notifyPackagesReplacedReceived(String[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPackageManager {
        private static final String DESCRIPTOR = "android.content.pm.IPackageManager";
        static final int TRANSACTION_checkPackageStartable = 1;
        static final int TRANSACTION_isPackageAvailable = 2;
        static final int TRANSACTION_getPackageInfo = 3;
        static final int TRANSACTION_getPackageInfoVersioned = 4;
        static final int TRANSACTION_getPackageUid = 5;
        static final int TRANSACTION_getPackageGids = 6;
        static final int TRANSACTION_currentToCanonicalPackageNames = 7;
        static final int TRANSACTION_canonicalToCurrentPackageNames = 8;
        static final int TRANSACTION_getPermissionInfo = 9;
        static final int TRANSACTION_queryPermissionsByGroup = 10;
        static final int TRANSACTION_getPermissionGroupInfo = 11;
        static final int TRANSACTION_getAllPermissionGroups = 12;
        static final int TRANSACTION_getApplicationInfo = 13;
        static final int TRANSACTION_getActivityInfo = 14;
        static final int TRANSACTION_activitySupportsIntent = 15;
        static final int TRANSACTION_getReceiverInfo = 16;
        static final int TRANSACTION_getServiceInfo = 17;
        static final int TRANSACTION_getProviderInfo = 18;
        static final int TRANSACTION_checkPermission = 19;
        static final int TRANSACTION_checkUidPermission = 20;
        static final int TRANSACTION_addPermission = 21;
        static final int TRANSACTION_removePermission = 22;
        static final int TRANSACTION_grantRuntimePermission = 23;
        static final int TRANSACTION_revokeRuntimePermission = 24;
        static final int TRANSACTION_resetRuntimePermissions = 25;
        static final int TRANSACTION_getPermissionFlags = 26;
        static final int TRANSACTION_updatePermissionFlags = 27;
        static final int TRANSACTION_updatePermissionFlagsForAllApps = 28;
        static final int TRANSACTION_getWhitelistedRestrictedPermissions = 29;
        static final int TRANSACTION_addWhitelistedRestrictedPermission = 30;
        static final int TRANSACTION_removeWhitelistedRestrictedPermission = 31;
        static final int TRANSACTION_shouldShowRequestPermissionRationale = 32;
        static final int TRANSACTION_isProtectedBroadcast = 33;
        static final int TRANSACTION_checkSignatures = 34;
        static final int TRANSACTION_checkUidSignatures = 35;
        static final int TRANSACTION_getAllPackages = 36;
        static final int TRANSACTION_getPackagesForUid = 37;
        static final int TRANSACTION_getNameForUid = 38;
        static final int TRANSACTION_getNamesForUids = 39;
        static final int TRANSACTION_getUidForSharedUser = 40;
        static final int TRANSACTION_getFlagsForUid = 41;
        static final int TRANSACTION_getPrivateFlagsForUid = 42;
        static final int TRANSACTION_isUidPrivileged = 43;
        static final int TRANSACTION_getAppOpPermissionPackages = 44;
        static final int TRANSACTION_resolveIntent = 45;
        static final int TRANSACTION_findPersistentPreferredActivity = 46;
        static final int TRANSACTION_canForwardTo = 47;
        static final int TRANSACTION_queryIntentActivities = 48;
        static final int TRANSACTION_queryIntentActivityOptions = 49;
        static final int TRANSACTION_queryIntentReceivers = 50;
        static final int TRANSACTION_resolveService = 51;
        static final int TRANSACTION_queryIntentServices = 52;
        static final int TRANSACTION_queryIntentContentProviders = 53;
        static final int TRANSACTION_getInstalledPackages = 54;
        static final int TRANSACTION_getPackagesHoldingPermissions = 55;
        static final int TRANSACTION_getInstalledApplications = 56;
        static final int TRANSACTION_getPersistentApplications = 57;
        static final int TRANSACTION_resolveContentProvider = 58;
        static final int TRANSACTION_querySyncProviders = 59;
        static final int TRANSACTION_queryContentProviders = 60;
        static final int TRANSACTION_getInstrumentationInfo = 61;
        static final int TRANSACTION_queryInstrumentation = 62;
        static final int TRANSACTION_finishPackageInstall = 63;
        static final int TRANSACTION_setInstallerPackageName = 64;
        static final int TRANSACTION_setApplicationCategoryHint = 65;
        static final int TRANSACTION_deletePackageAsUser = 66;
        static final int TRANSACTION_deletePackageVersioned = 67;
        static final int TRANSACTION_getInstallerPackageName = 68;
        static final int TRANSACTION_resetApplicationPreferences = 69;
        static final int TRANSACTION_getLastChosenActivity = 70;
        static final int TRANSACTION_setLastChosenActivity = 71;
        static final int TRANSACTION_addPreferredActivity = 72;
        static final int TRANSACTION_replacePreferredActivity = 73;
        static final int TRANSACTION_clearPackagePreferredActivities = 74;
        static final int TRANSACTION_getPreferredActivities = 75;
        static final int TRANSACTION_addPersistentPreferredActivity = 76;
        static final int TRANSACTION_clearPackagePersistentPreferredActivities = 77;
        static final int TRANSACTION_addCrossProfileIntentFilter = 78;
        static final int TRANSACTION_clearCrossProfileIntentFilters = 79;
        static final int TRANSACTION_setDistractingPackageRestrictionsAsUser = 80;
        static final int TRANSACTION_setPackagesSuspendedAsUser = 81;
        static final int TRANSACTION_getUnsuspendablePackagesForUser = 82;
        static final int TRANSACTION_isPackageSuspendedForUser = 83;
        static final int TRANSACTION_getSuspendedPackageAppExtras = 84;
        static final int TRANSACTION_getPreferredActivityBackup = 85;
        static final int TRANSACTION_restorePreferredActivities = 86;
        static final int TRANSACTION_getDefaultAppsBackup = 87;
        static final int TRANSACTION_restoreDefaultApps = 88;
        static final int TRANSACTION_getIntentFilterVerificationBackup = 89;
        static final int TRANSACTION_restoreIntentFilterVerification = 90;
        static final int TRANSACTION_getHomeActivities = 91;
        static final int TRANSACTION_setHomeActivity = 92;
        static final int TRANSACTION_setComponentEnabledSetting = 93;
        static final int TRANSACTION_getComponentEnabledSetting = 94;
        static final int TRANSACTION_setApplicationEnabledSetting = 95;
        static final int TRANSACTION_getApplicationEnabledSetting = 96;
        static final int TRANSACTION_logAppProcessStartIfNeeded = 97;
        static final int TRANSACTION_flushPackageRestrictionsAsUser = 98;
        static final int TRANSACTION_setPackageStoppedState = 99;
        static final int TRANSACTION_freeStorageAndNotify = 100;
        static final int TRANSACTION_freeStorage = 101;
        static final int TRANSACTION_deleteApplicationCacheFiles = 102;
        static final int TRANSACTION_deleteApplicationCacheFilesAsUser = 103;
        static final int TRANSACTION_clearApplicationUserData = 104;
        static final int TRANSACTION_clearApplicationProfileData = 105;
        static final int TRANSACTION_getPackageSizeInfo = 106;
        static final int TRANSACTION_getSystemSharedLibraryNames = 107;
        static final int TRANSACTION_getSystemAvailableFeatures = 108;
        static final int TRANSACTION_hasSystemFeature = 109;
        static final int TRANSACTION_enterSafeMode = 110;
        static final int TRANSACTION_isSafeMode = 111;
        static final int TRANSACTION_systemReady = 112;
        static final int TRANSACTION_hasSystemUidErrors = 113;
        static final int TRANSACTION_performFstrimIfNeeded = 114;
        static final int TRANSACTION_updatePackagesIfNeeded = 115;
        static final int TRANSACTION_notifyPackageUse = 116;
        static final int TRANSACTION_notifyDexLoad = 117;
        static final int TRANSACTION_registerDexModule = 118;
        static final int TRANSACTION_performDexOptMode = 119;
        static final int TRANSACTION_performDexOptSecondary = 120;
        static final int TRANSACTION_compileLayouts = 121;
        static final int TRANSACTION_dumpProfiles = 122;
        static final int TRANSACTION_forceDexOpt = 123;
        static final int TRANSACTION_runBackgroundDexoptJob = 124;
        static final int TRANSACTION_reconcileSecondaryDexFiles = 125;
        static final int TRANSACTION_getMoveStatus = 126;
        static final int TRANSACTION_registerMoveCallback = 127;
        static final int TRANSACTION_unregisterMoveCallback = 128;
        static final int TRANSACTION_movePackage = 129;
        static final int TRANSACTION_movePrimaryStorage = 130;
        static final int TRANSACTION_addPermissionAsync = 131;
        static final int TRANSACTION_setInstallLocation = 132;
        static final int TRANSACTION_getInstallLocation = 133;
        static final int TRANSACTION_installExistingPackageAsUser = 134;
        static final int TRANSACTION_verifyPendingInstall = 135;
        static final int TRANSACTION_extendVerificationTimeout = 136;
        static final int TRANSACTION_verifyIntentFilter = 137;
        static final int TRANSACTION_getIntentVerificationStatus = 138;
        static final int TRANSACTION_updateIntentVerificationStatus = 139;
        static final int TRANSACTION_getIntentFilterVerifications = 140;
        static final int TRANSACTION_getAllIntentFilters = 141;
        static final int TRANSACTION_setDefaultBrowserPackageName = 142;
        static final int TRANSACTION_getDefaultBrowserPackageName = 143;
        static final int TRANSACTION_getVerifierDeviceIdentity = 144;
        static final int TRANSACTION_isFirstBoot = 145;
        static final int TRANSACTION_isOnlyCoreApps = 146;
        static final int TRANSACTION_isDeviceUpgrading = 147;
        static final int TRANSACTION_setPermissionEnforced = 148;
        static final int TRANSACTION_isPermissionEnforced = 149;
        static final int TRANSACTION_isStorageLow = 150;
        static final int TRANSACTION_setApplicationHiddenSettingAsUser = 151;
        static final int TRANSACTION_getApplicationHiddenSettingAsUser = 152;
        static final int TRANSACTION_setSystemAppHiddenUntilInstalled = 153;
        static final int TRANSACTION_setSystemAppInstallState = 154;
        static final int TRANSACTION_getPackageInstaller = 155;
        static final int TRANSACTION_setBlockUninstallForUser = 156;
        static final int TRANSACTION_getBlockUninstallForUser = 157;
        static final int TRANSACTION_getKeySetByAlias = 158;
        static final int TRANSACTION_getSigningKeySet = 159;
        static final int TRANSACTION_isPackageSignedByKeySet = 160;
        static final int TRANSACTION_isPackageSignedByKeySetExactly = 161;
        static final int TRANSACTION_addOnPermissionsChangeListener = 162;
        static final int TRANSACTION_removeOnPermissionsChangeListener = 163;
        static final int TRANSACTION_grantDefaultPermissionsToEnabledCarrierApps = 164;
        static final int TRANSACTION_grantDefaultPermissionsToEnabledImsServices = 165;
        static final int TRANSACTION_grantDefaultPermissionsToEnabledTelephonyDataServices = 166;
        static final int TRANSACTION_revokeDefaultPermissionsFromDisabledTelephonyDataServices = 167;
        static final int TRANSACTION_grantDefaultPermissionsToActiveLuiApp = 168;
        static final int TRANSACTION_revokeDefaultPermissionsFromLuiApps = 169;
        static final int TRANSACTION_isPermissionRevokedByPolicy = 170;
        static final int TRANSACTION_getPermissionControllerPackageName = 171;
        static final int TRANSACTION_getInstantApps = 172;
        static final int TRANSACTION_getInstantAppCookie = 173;
        static final int TRANSACTION_setInstantAppCookie = 174;
        static final int TRANSACTION_getInstantAppIcon = 175;
        static final int TRANSACTION_isInstantApp = 176;
        static final int TRANSACTION_setRequiredForSystemUser = 177;
        static final int TRANSACTION_setUpdateAvailable = 178;
        static final int TRANSACTION_getServicesSystemSharedLibraryPackageName = 179;
        static final int TRANSACTION_getSharedSystemSharedLibraryPackageName = 180;
        static final int TRANSACTION_getChangedPackages = 181;
        static final int TRANSACTION_isPackageDeviceAdminOnAnyUser = 182;
        static final int TRANSACTION_getInstallReason = 183;
        static final int TRANSACTION_getSharedLibraries = 184;
        static final int TRANSACTION_getDeclaredSharedLibraries = 185;
        static final int TRANSACTION_canRequestPackageInstalls = 186;
        static final int TRANSACTION_deletePreloadsFileCache = 187;
        static final int TRANSACTION_getInstantAppResolverComponent = 188;
        static final int TRANSACTION_getInstantAppResolverSettingsComponent = 189;
        static final int TRANSACTION_getInstantAppInstallerComponent = 190;
        static final int TRANSACTION_getInstantAppAndroidId = 191;
        static final int TRANSACTION_getArtManager = 192;
        static final int TRANSACTION_setHarmfulAppWarning = 193;
        static final int TRANSACTION_getHarmfulAppWarning = 194;
        static final int TRANSACTION_hasSigningCertificate = 195;
        static final int TRANSACTION_hasUidSigningCertificate = 196;
        static final int TRANSACTION_getSystemTextClassifierPackageName = 197;
        static final int TRANSACTION_getAttentionServicePackageName = 198;
        static final int TRANSACTION_getWellbeingPackageName = 199;
        static final int TRANSACTION_getAppPredictionServicePackageName = 200;
        static final int TRANSACTION_getSystemCaptionsServicePackageName = 201;
        static final int TRANSACTION_getIncidentReportApproverPackageName = 202;
        static final int TRANSACTION_isPackageStateProtected = 203;
        static final int TRANSACTION_sendDeviceCustomizationReadyBroadcast = 204;
        static final int TRANSACTION_getInstalledModules = 205;
        static final int TRANSACTION_getModuleInfo = 206;
        static final int TRANSACTION_getRuntimePermissionsVersion = 207;
        static final int TRANSACTION_setRuntimePermissionsVersion = 208;
        static final int TRANSACTION_notifyPackagesReplacedReceived = 209;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPackageManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPackageManager) {
                return (IPackageManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "checkPackageStartable";
                }
                case 2: {
                    return "isPackageAvailable";
                }
                case 3: {
                    return "getPackageInfo";
                }
                case 4: {
                    return "getPackageInfoVersioned";
                }
                case 5: {
                    return "getPackageUid";
                }
                case 6: {
                    return "getPackageGids";
                }
                case 7: {
                    return "currentToCanonicalPackageNames";
                }
                case 8: {
                    return "canonicalToCurrentPackageNames";
                }
                case 9: {
                    return "getPermissionInfo";
                }
                case 10: {
                    return "queryPermissionsByGroup";
                }
                case 11: {
                    return "getPermissionGroupInfo";
                }
                case 12: {
                    return "getAllPermissionGroups";
                }
                case 13: {
                    return "getApplicationInfo";
                }
                case 14: {
                    return "getActivityInfo";
                }
                case 15: {
                    return "activitySupportsIntent";
                }
                case 16: {
                    return "getReceiverInfo";
                }
                case 17: {
                    return "getServiceInfo";
                }
                case 18: {
                    return "getProviderInfo";
                }
                case 19: {
                    return "checkPermission";
                }
                case 20: {
                    return "checkUidPermission";
                }
                case 21: {
                    return "addPermission";
                }
                case 22: {
                    return "removePermission";
                }
                case 23: {
                    return "grantRuntimePermission";
                }
                case 24: {
                    return "revokeRuntimePermission";
                }
                case 25: {
                    return "resetRuntimePermissions";
                }
                case 26: {
                    return "getPermissionFlags";
                }
                case 27: {
                    return "updatePermissionFlags";
                }
                case 28: {
                    return "updatePermissionFlagsForAllApps";
                }
                case 29: {
                    return "getWhitelistedRestrictedPermissions";
                }
                case 30: {
                    return "addWhitelistedRestrictedPermission";
                }
                case 31: {
                    return "removeWhitelistedRestrictedPermission";
                }
                case 32: {
                    return "shouldShowRequestPermissionRationale";
                }
                case 33: {
                    return "isProtectedBroadcast";
                }
                case 34: {
                    return "checkSignatures";
                }
                case 35: {
                    return "checkUidSignatures";
                }
                case 36: {
                    return "getAllPackages";
                }
                case 37: {
                    return "getPackagesForUid";
                }
                case 38: {
                    return "getNameForUid";
                }
                case 39: {
                    return "getNamesForUids";
                }
                case 40: {
                    return "getUidForSharedUser";
                }
                case 41: {
                    return "getFlagsForUid";
                }
                case 42: {
                    return "getPrivateFlagsForUid";
                }
                case 43: {
                    return "isUidPrivileged";
                }
                case 44: {
                    return "getAppOpPermissionPackages";
                }
                case 45: {
                    return "resolveIntent";
                }
                case 46: {
                    return "findPersistentPreferredActivity";
                }
                case 47: {
                    return "canForwardTo";
                }
                case 48: {
                    return "queryIntentActivities";
                }
                case 49: {
                    return "queryIntentActivityOptions";
                }
                case 50: {
                    return "queryIntentReceivers";
                }
                case 51: {
                    return "resolveService";
                }
                case 52: {
                    return "queryIntentServices";
                }
                case 53: {
                    return "queryIntentContentProviders";
                }
                case 54: {
                    return "getInstalledPackages";
                }
                case 55: {
                    return "getPackagesHoldingPermissions";
                }
                case 56: {
                    return "getInstalledApplications";
                }
                case 57: {
                    return "getPersistentApplications";
                }
                case 58: {
                    return "resolveContentProvider";
                }
                case 59: {
                    return "querySyncProviders";
                }
                case 60: {
                    return "queryContentProviders";
                }
                case 61: {
                    return "getInstrumentationInfo";
                }
                case 62: {
                    return "queryInstrumentation";
                }
                case 63: {
                    return "finishPackageInstall";
                }
                case 64: {
                    return "setInstallerPackageName";
                }
                case 65: {
                    return "setApplicationCategoryHint";
                }
                case 66: {
                    return "deletePackageAsUser";
                }
                case 67: {
                    return "deletePackageVersioned";
                }
                case 68: {
                    return "getInstallerPackageName";
                }
                case 69: {
                    return "resetApplicationPreferences";
                }
                case 70: {
                    return "getLastChosenActivity";
                }
                case 71: {
                    return "setLastChosenActivity";
                }
                case 72: {
                    return "addPreferredActivity";
                }
                case 73: {
                    return "replacePreferredActivity";
                }
                case 74: {
                    return "clearPackagePreferredActivities";
                }
                case 75: {
                    return "getPreferredActivities";
                }
                case 76: {
                    return "addPersistentPreferredActivity";
                }
                case 77: {
                    return "clearPackagePersistentPreferredActivities";
                }
                case 78: {
                    return "addCrossProfileIntentFilter";
                }
                case 79: {
                    return "clearCrossProfileIntentFilters";
                }
                case 80: {
                    return "setDistractingPackageRestrictionsAsUser";
                }
                case 81: {
                    return "setPackagesSuspendedAsUser";
                }
                case 82: {
                    return "getUnsuspendablePackagesForUser";
                }
                case 83: {
                    return "isPackageSuspendedForUser";
                }
                case 84: {
                    return "getSuspendedPackageAppExtras";
                }
                case 85: {
                    return "getPreferredActivityBackup";
                }
                case 86: {
                    return "restorePreferredActivities";
                }
                case 87: {
                    return "getDefaultAppsBackup";
                }
                case 88: {
                    return "restoreDefaultApps";
                }
                case 89: {
                    return "getIntentFilterVerificationBackup";
                }
                case 90: {
                    return "restoreIntentFilterVerification";
                }
                case 91: {
                    return "getHomeActivities";
                }
                case 92: {
                    return "setHomeActivity";
                }
                case 93: {
                    return "setComponentEnabledSetting";
                }
                case 94: {
                    return "getComponentEnabledSetting";
                }
                case 95: {
                    return "setApplicationEnabledSetting";
                }
                case 96: {
                    return "getApplicationEnabledSetting";
                }
                case 97: {
                    return "logAppProcessStartIfNeeded";
                }
                case 98: {
                    return "flushPackageRestrictionsAsUser";
                }
                case 99: {
                    return "setPackageStoppedState";
                }
                case 100: {
                    return "freeStorageAndNotify";
                }
                case 101: {
                    return "freeStorage";
                }
                case 102: {
                    return "deleteApplicationCacheFiles";
                }
                case 103: {
                    return "deleteApplicationCacheFilesAsUser";
                }
                case 104: {
                    return "clearApplicationUserData";
                }
                case 105: {
                    return "clearApplicationProfileData";
                }
                case 106: {
                    return "getPackageSizeInfo";
                }
                case 107: {
                    return "getSystemSharedLibraryNames";
                }
                case 108: {
                    return "getSystemAvailableFeatures";
                }
                case 109: {
                    return "hasSystemFeature";
                }
                case 110: {
                    return "enterSafeMode";
                }
                case 111: {
                    return "isSafeMode";
                }
                case 112: {
                    return "systemReady";
                }
                case 113: {
                    return "hasSystemUidErrors";
                }
                case 114: {
                    return "performFstrimIfNeeded";
                }
                case 115: {
                    return "updatePackagesIfNeeded";
                }
                case 116: {
                    return "notifyPackageUse";
                }
                case 117: {
                    return "notifyDexLoad";
                }
                case 118: {
                    return "registerDexModule";
                }
                case 119: {
                    return "performDexOptMode";
                }
                case 120: {
                    return "performDexOptSecondary";
                }
                case 121: {
                    return "compileLayouts";
                }
                case 122: {
                    return "dumpProfiles";
                }
                case 123: {
                    return "forceDexOpt";
                }
                case 124: {
                    return "runBackgroundDexoptJob";
                }
                case 125: {
                    return "reconcileSecondaryDexFiles";
                }
                case 126: {
                    return "getMoveStatus";
                }
                case 127: {
                    return "registerMoveCallback";
                }
                case 128: {
                    return "unregisterMoveCallback";
                }
                case 129: {
                    return "movePackage";
                }
                case 130: {
                    return "movePrimaryStorage";
                }
                case 131: {
                    return "addPermissionAsync";
                }
                case 132: {
                    return "setInstallLocation";
                }
                case 133: {
                    return "getInstallLocation";
                }
                case 134: {
                    return "installExistingPackageAsUser";
                }
                case 135: {
                    return "verifyPendingInstall";
                }
                case 136: {
                    return "extendVerificationTimeout";
                }
                case 137: {
                    return "verifyIntentFilter";
                }
                case 138: {
                    return "getIntentVerificationStatus";
                }
                case 139: {
                    return "updateIntentVerificationStatus";
                }
                case 140: {
                    return "getIntentFilterVerifications";
                }
                case 141: {
                    return "getAllIntentFilters";
                }
                case 142: {
                    return "setDefaultBrowserPackageName";
                }
                case 143: {
                    return "getDefaultBrowserPackageName";
                }
                case 144: {
                    return "getVerifierDeviceIdentity";
                }
                case 145: {
                    return "isFirstBoot";
                }
                case 146: {
                    return "isOnlyCoreApps";
                }
                case 147: {
                    return "isDeviceUpgrading";
                }
                case 148: {
                    return "setPermissionEnforced";
                }
                case 149: {
                    return "isPermissionEnforced";
                }
                case 150: {
                    return "isStorageLow";
                }
                case 151: {
                    return "setApplicationHiddenSettingAsUser";
                }
                case 152: {
                    return "getApplicationHiddenSettingAsUser";
                }
                case 153: {
                    return "setSystemAppHiddenUntilInstalled";
                }
                case 154: {
                    return "setSystemAppInstallState";
                }
                case 155: {
                    return "getPackageInstaller";
                }
                case 156: {
                    return "setBlockUninstallForUser";
                }
                case 157: {
                    return "getBlockUninstallForUser";
                }
                case 158: {
                    return "getKeySetByAlias";
                }
                case 159: {
                    return "getSigningKeySet";
                }
                case 160: {
                    return "isPackageSignedByKeySet";
                }
                case 161: {
                    return "isPackageSignedByKeySetExactly";
                }
                case 162: {
                    return "addOnPermissionsChangeListener";
                }
                case 163: {
                    return "removeOnPermissionsChangeListener";
                }
                case 164: {
                    return "grantDefaultPermissionsToEnabledCarrierApps";
                }
                case 165: {
                    return "grantDefaultPermissionsToEnabledImsServices";
                }
                case 166: {
                    return "grantDefaultPermissionsToEnabledTelephonyDataServices";
                }
                case 167: {
                    return "revokeDefaultPermissionsFromDisabledTelephonyDataServices";
                }
                case 168: {
                    return "grantDefaultPermissionsToActiveLuiApp";
                }
                case 169: {
                    return "revokeDefaultPermissionsFromLuiApps";
                }
                case 170: {
                    return "isPermissionRevokedByPolicy";
                }
                case 171: {
                    return "getPermissionControllerPackageName";
                }
                case 172: {
                    return "getInstantApps";
                }
                case 173: {
                    return "getInstantAppCookie";
                }
                case 174: {
                    return "setInstantAppCookie";
                }
                case 175: {
                    return "getInstantAppIcon";
                }
                case 176: {
                    return "isInstantApp";
                }
                case 177: {
                    return "setRequiredForSystemUser";
                }
                case 178: {
                    return "setUpdateAvailable";
                }
                case 179: {
                    return "getServicesSystemSharedLibraryPackageName";
                }
                case 180: {
                    return "getSharedSystemSharedLibraryPackageName";
                }
                case 181: {
                    return "getChangedPackages";
                }
                case 182: {
                    return "isPackageDeviceAdminOnAnyUser";
                }
                case 183: {
                    return "getInstallReason";
                }
                case 184: {
                    return "getSharedLibraries";
                }
                case 185: {
                    return "getDeclaredSharedLibraries";
                }
                case 186: {
                    return "canRequestPackageInstalls";
                }
                case 187: {
                    return "deletePreloadsFileCache";
                }
                case 188: {
                    return "getInstantAppResolverComponent";
                }
                case 189: {
                    return "getInstantAppResolverSettingsComponent";
                }
                case 190: {
                    return "getInstantAppInstallerComponent";
                }
                case 191: {
                    return "getInstantAppAndroidId";
                }
                case 192: {
                    return "getArtManager";
                }
                case 193: {
                    return "setHarmfulAppWarning";
                }
                case 194: {
                    return "getHarmfulAppWarning";
                }
                case 195: {
                    return "hasSigningCertificate";
                }
                case 196: {
                    return "hasUidSigningCertificate";
                }
                case 197: {
                    return "getSystemTextClassifierPackageName";
                }
                case 198: {
                    return "getAttentionServicePackageName";
                }
                case 199: {
                    return "getWellbeingPackageName";
                }
                case 200: {
                    return "getAppPredictionServicePackageName";
                }
                case 201: {
                    return "getSystemCaptionsServicePackageName";
                }
                case 202: {
                    return "getIncidentReportApproverPackageName";
                }
                case 203: {
                    return "isPackageStateProtected";
                }
                case 204: {
                    return "sendDeviceCustomizationReadyBroadcast";
                }
                case 205: {
                    return "getInstalledModules";
                }
                case 206: {
                    return "getModuleInfo";
                }
                case 207: {
                    return "getRuntimePermissionsVersion";
                }
                case 208: {
                    return "setRuntimePermissionsVersion";
                }
                case 209: {
                    return "notifyPackagesReplacedReceived";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.checkPackageStartable(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.isPackageAvailable(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    PackageInfo _result = this.getPackageInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    VersionedPackage _arg0 = 0 != data.readInt() ? VersionedPackage.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    PackageInfo _result = this.getPackageInfoVersioned(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _result = this.getPackageUid(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int[] _result = this.getPackageGids(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    String[] _result = this.currentToCanonicalPackageNames(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    String[] _result = this.canonicalToCurrentPackageNames(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    PermissionInfo _result = this.getPermissionInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    ParceledListSlice _result = this.queryPermissionsByGroup(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    PermissionGroupInfo _result = this.getPermissionGroupInfo(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ParceledListSlice _result = this.getAllPermissionGroups(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ApplicationInfo _result = this.getApplicationInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ActivityInfo _result = this.getActivityInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    Intent _arg1 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    boolean _result = this.activitySupportsIntent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ActivityInfo _result = this.getReceiverInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ServiceInfo _result = this.getServiceInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ProviderInfo _result = this.getProviderInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _result = this.checkPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _result = this.checkUidPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    PermissionInfo _arg0 = 0 != data.readInt() ? PermissionInfo.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.addPermission(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.removePermission(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.grantRuntimePermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.revokeRuntimePermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    this.resetRuntimePermissions();
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _result = this.getPermissionFlags(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    boolean _arg4 = 0 != data.readInt();
                    int _arg5 = data.readInt();
                    this.updatePermissionFlags(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.updatePermissionFlagsForAllApps(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    List<String> _result = this.getWhitelistedRestrictedPermissions(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    boolean _result = this.addWhitelistedRestrictedPermission(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    boolean _result = this.removeWhitelistedRestrictedPermission(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _result = this.shouldShowRequestPermissionRationale(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isProtectedBroadcast(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _result = this.checkSignatures(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _result = this.checkUidSignatures(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    List<String> _result = this.getAllPackages();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String[] _result = this.getPackagesForUid(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _result = this.getNameForUid(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    String[] _result = this.getNamesForUids(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.getUidForSharedUser(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getFlagsForUid(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getPrivateFlagsForUid(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.isUidPrivileged(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String[] _result = this.getAppOpPermissionPackages(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    Intent _arg0 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ResolveInfo _result = this.resolveIntent(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    Intent _arg0 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    ResolveInfo _result = this.findPersistentPreferredActivity(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    Intent _arg0 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    boolean _result = this.canForwardTo(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    Intent _arg0 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ParceledListSlice _result = this.queryIntentActivities(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    Intent[] _arg1 = data.createTypedArray(Intent.CREATOR);
                    String[] _arg2 = data.createStringArray();
                    Intent _arg3 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg4 = data.readString();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    ParceledListSlice _result = this.queryIntentActivityOptions(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    Intent _arg0 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ParceledListSlice _result = this.queryIntentReceivers(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    Intent _arg0 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ResolveInfo _result = this.resolveService(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    Intent _arg0 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ParceledListSlice _result = this.queryIntentServices(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    Intent _arg0 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ParceledListSlice _result = this.queryIntentContentProviders(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ParceledListSlice _result = this.getInstalledPackages(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ParceledListSlice _result = this.getPackagesHoldingPermissions(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 56: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ParceledListSlice _result = this.getInstalledApplications(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 57: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ParceledListSlice _result = this.getPersistentApplications(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 58: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ProviderInfo _result = this.resolveContentProvider(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 59: {
                    data.enforceInterface(descriptor);
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    ArrayList<ProviderInfo> _arg1 = data.createTypedArrayList(ProviderInfo.CREATOR);
                    this.querySyncProviders(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_arg0);
                    reply.writeTypedList(_arg1);
                    return true;
                }
                case 60: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    ParceledListSlice _result = this.queryContentProviders(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 61: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    InstrumentationInfo _result = this.getInstrumentationInfo(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 62: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    ParceledListSlice _result = this.queryInstrumentation(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 63: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.finishPackageInstall(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 64: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.setInstallerPackageName(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 65: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    this.setApplicationCategoryHint(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 66: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    IPackageDeleteObserver _arg2 = IPackageDeleteObserver.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    this.deletePackageAsUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 67: {
                    data.enforceInterface(descriptor);
                    VersionedPackage _arg0 = 0 != data.readInt() ? VersionedPackage.CREATOR.createFromParcel(data) : null;
                    IPackageDeleteObserver2 _arg1 = IPackageDeleteObserver2.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.deletePackageVersioned(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 68: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _result = this.getInstallerPackageName(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 69: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.resetApplicationPreferences(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 70: {
                    data.enforceInterface(descriptor);
                    Intent _arg0 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    ResolveInfo _result = this.getLastChosenActivity(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 71: {
                    data.enforceInterface(descriptor);
                    Intent _arg0 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    IntentFilter _arg3 = 0 != data.readInt() ? IntentFilter.CREATOR.createFromParcel(data) : null;
                    int _arg4 = data.readInt();
                    ComponentName _arg5 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    this.setLastChosenActivity(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 72: {
                    data.enforceInterface(descriptor);
                    IntentFilter _arg0 = 0 != data.readInt() ? IntentFilter.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    ComponentName[] _arg2 = data.createTypedArray(ComponentName.CREATOR);
                    ComponentName _arg3 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg4 = data.readInt();
                    this.addPreferredActivity(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 73: {
                    data.enforceInterface(descriptor);
                    IntentFilter _arg0 = 0 != data.readInt() ? IntentFilter.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    ComponentName[] _arg2 = data.createTypedArray(ComponentName.CREATOR);
                    ComponentName _arg3 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg4 = data.readInt();
                    this.replacePreferredActivity(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 74: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.clearPackagePreferredActivities(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 75: {
                    data.enforceInterface(descriptor);
                    ArrayList<IntentFilter> _arg0 = new ArrayList<IntentFilter>();
                    ArrayList<ComponentName> _arg1 = new ArrayList<ComponentName>();
                    String _arg2 = data.readString();
                    int _result = this.getPreferredActivities(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    reply.writeTypedList(_arg0);
                    reply.writeTypedList(_arg1);
                    return true;
                }
                case 76: {
                    data.enforceInterface(descriptor);
                    IntentFilter _arg0 = 0 != data.readInt() ? IntentFilter.CREATOR.createFromParcel(data) : null;
                    ComponentName _arg1 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.addPersistentPreferredActivity(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 77: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.clearPackagePersistentPreferredActivities(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 78: {
                    data.enforceInterface(descriptor);
                    IntentFilter _arg0 = 0 != data.readInt() ? IntentFilter.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    this.addCrossProfileIntentFilter(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 79: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.clearCrossProfileIntentFilters(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 80: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String[] _result = this.setDistractingPackageRestrictionsAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 81: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    boolean _arg1 = 0 != data.readInt();
                    PersistableBundle _arg2 = 0 != data.readInt() ? PersistableBundle.CREATOR.createFromParcel(data) : null;
                    PersistableBundle _arg3 = 0 != data.readInt() ? PersistableBundle.CREATOR.createFromParcel(data) : null;
                    SuspendDialogInfo _arg4 = 0 != data.readInt() ? SuspendDialogInfo.CREATOR.createFromParcel(data) : null;
                    String _arg5 = data.readString();
                    int _arg6 = data.readInt();
                    String[] _result = this.setPackagesSuspendedAsUser(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 82: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    String[] _result = this.getUnsuspendablePackagesForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 83: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.isPackageSuspendedForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 84: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    PersistableBundle _result = this.getSuspendedPackageAppExtras(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 85: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    byte[] _result = this.getPreferredActivityBackup(_arg0);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 86: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    int _arg1 = data.readInt();
                    this.restorePreferredActivities(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 87: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    byte[] _result = this.getDefaultAppsBackup(_arg0);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 88: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    int _arg1 = data.readInt();
                    this.restoreDefaultApps(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 89: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    byte[] _result = this.getIntentFilterVerificationBackup(_arg0);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 90: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    int _arg1 = data.readInt();
                    this.restoreIntentFilterVerification(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 91: {
                    data.enforceInterface(descriptor);
                    ArrayList<ResolveInfo> _arg0 = new ArrayList<ResolveInfo>();
                    ComponentName _result = this.getHomeActivities(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    reply.writeTypedList(_arg0);
                    return true;
                }
                case 92: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.setHomeActivity(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 93: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.setComponentEnabledSetting(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 94: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _result = this.getComponentEnabledSetting(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 95: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    String _arg4 = data.readString();
                    this.setApplicationEnabledSetting(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 96: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _result = this.getApplicationEnabledSetting(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 97: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    this.logAppProcessStartIfNeeded(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 98: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.flushPackageRestrictionsAsUser(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 99: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    int _arg2 = data.readInt();
                    this.setPackageStoppedState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 100: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    IPackageDataObserver _arg3 = IPackageDataObserver.Stub.asInterface(data.readStrongBinder());
                    this.freeStorageAndNotify(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 101: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    IntentSender _arg3 = 0 != data.readInt() ? IntentSender.CREATOR.createFromParcel(data) : null;
                    this.freeStorage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 102: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IPackageDataObserver _arg1 = IPackageDataObserver.Stub.asInterface(data.readStrongBinder());
                    this.deleteApplicationCacheFiles(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 103: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    IPackageDataObserver _arg2 = IPackageDataObserver.Stub.asInterface(data.readStrongBinder());
                    this.deleteApplicationCacheFilesAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 104: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IPackageDataObserver _arg1 = IPackageDataObserver.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    this.clearApplicationUserData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 105: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.clearApplicationProfileData(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 106: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    IPackageStatsObserver _arg2 = IPackageStatsObserver.Stub.asInterface(data.readStrongBinder());
                    this.getPackageSizeInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 107: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getSystemSharedLibraryNames();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 108: {
                    data.enforceInterface(descriptor);
                    ParceledListSlice _result = this.getSystemAvailableFeatures();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 109: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.hasSystemFeature(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 110: {
                    data.enforceInterface(descriptor);
                    this.enterSafeMode();
                    reply.writeNoException();
                    return true;
                }
                case 111: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isSafeMode();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 112: {
                    data.enforceInterface(descriptor);
                    this.systemReady();
                    reply.writeNoException();
                    return true;
                }
                case 113: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.hasSystemUidErrors();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 114: {
                    data.enforceInterface(descriptor);
                    this.performFstrimIfNeeded();
                    reply.writeNoException();
                    return true;
                }
                case 115: {
                    data.enforceInterface(descriptor);
                    this.updatePackagesIfNeeded();
                    reply.writeNoException();
                    return true;
                }
                case 116: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.notifyPackageUse(_arg0, _arg1);
                    return true;
                }
                case 117: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    ArrayList<String> _arg2 = data.createStringArrayList();
                    String _arg3 = data.readString();
                    this.notifyDexLoad(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 118: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    IDexModuleRegisterCallback _arg3 = IDexModuleRegisterCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerDexModule(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 119: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    String _arg2 = data.readString();
                    boolean _arg3 = 0 != data.readInt();
                    boolean _arg4 = 0 != data.readInt();
                    String _arg5 = data.readString();
                    boolean _result = this.performDexOptMode(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 120: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    boolean _result = this.performDexOptSecondary(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 121: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.compileLayouts(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 122: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.dumpProfiles(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 123: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.forceDexOpt(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 124: {
                    data.enforceInterface(descriptor);
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    boolean _result = this.runBackgroundDexoptJob(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 125: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.reconcileSecondaryDexFiles(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 126: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getMoveStatus(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 127: {
                    data.enforceInterface(descriptor);
                    IPackageMoveObserver _arg0 = IPackageMoveObserver.Stub.asInterface(data.readStrongBinder());
                    this.registerMoveCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 128: {
                    data.enforceInterface(descriptor);
                    IPackageMoveObserver _arg0 = IPackageMoveObserver.Stub.asInterface(data.readStrongBinder());
                    this.unregisterMoveCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 129: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _result = this.movePackage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 130: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.movePrimaryStorage(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 131: {
                    data.enforceInterface(descriptor);
                    PermissionInfo _arg0 = 0 != data.readInt() ? PermissionInfo.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.addPermissionAsync(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 132: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.setInstallLocation(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 133: {
                    data.enforceInterface(descriptor);
                    int _result = this.getInstallLocation();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 134: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ArrayList<String> _arg4 = data.createStringArrayList();
                    int _result = this.installExistingPackageAsUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 135: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.verifyPendingInstall(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 136: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    this.extendVerificationTimeout(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 137: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ArrayList<String> _arg2 = data.createStringArrayList();
                    this.verifyIntentFilter(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 138: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _result = this.getIntentVerificationStatus(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 139: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _result = this.updateIntentVerificationStatus(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 140: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ParceledListSlice _result = this.getIntentFilterVerifications(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 141: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ParceledListSlice _result = this.getAllIntentFilters(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 142: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.setDefaultBrowserPackageName(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 143: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _result = this.getDefaultBrowserPackageName(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 144: {
                    data.enforceInterface(descriptor);
                    VerifierDeviceIdentity _result = this.getVerifierDeviceIdentity();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 145: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isFirstBoot();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 146: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isOnlyCoreApps();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 147: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isDeviceUpgrading();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 148: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.setPermissionEnforced(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 149: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isPermissionEnforced(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 150: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isStorageLow();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 151: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    int _arg2 = data.readInt();
                    boolean _result = this.setApplicationHiddenSettingAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 152: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.getApplicationHiddenSettingAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 153: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.setSystemAppHiddenUntilInstalled(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 154: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    int _arg2 = data.readInt();
                    boolean _result = this.setSystemAppInstallState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 155: {
                    data.enforceInterface(descriptor);
                    IPackageInstaller _result = this.getPackageInstaller();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 156: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    int _arg2 = data.readInt();
                    boolean _result = this.setBlockUninstallForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 157: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.getBlockUninstallForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 158: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    KeySet _result = this.getKeySetByAlias(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 159: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    KeySet _result = this.getSigningKeySet(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 160: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    KeySet _arg1 = 0 != data.readInt() ? KeySet.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.isPackageSignedByKeySet(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 161: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    KeySet _arg1 = 0 != data.readInt() ? KeySet.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.isPackageSignedByKeySetExactly(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 162: {
                    data.enforceInterface(descriptor);
                    IOnPermissionsChangeListener _arg0 = IOnPermissionsChangeListener.Stub.asInterface(data.readStrongBinder());
                    this.addOnPermissionsChangeListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 163: {
                    data.enforceInterface(descriptor);
                    IOnPermissionsChangeListener _arg0 = IOnPermissionsChangeListener.Stub.asInterface(data.readStrongBinder());
                    this.removeOnPermissionsChangeListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 164: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    this.grantDefaultPermissionsToEnabledCarrierApps(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 165: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    this.grantDefaultPermissionsToEnabledImsServices(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 166: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    this.grantDefaultPermissionsToEnabledTelephonyDataServices(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 167: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    this.revokeDefaultPermissionsFromDisabledTelephonyDataServices(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 168: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.grantDefaultPermissionsToActiveLuiApp(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 169: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    this.revokeDefaultPermissionsFromLuiApps(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 170: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _result = this.isPermissionRevokedByPolicy(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 171: {
                    data.enforceInterface(descriptor);
                    String _result = this.getPermissionControllerPackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 172: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ParceledListSlice _result = this.getInstantApps(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 173: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    byte[] _result = this.getInstantAppCookie(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 174: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    int _arg2 = data.readInt();
                    boolean _result = this.setInstantAppCookie(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 175: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    Bitmap _result = this.getInstantAppIcon(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 176: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.isInstantApp(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 177: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.setRequiredForSystemUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 178: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.setUpdateAvailable(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 179: {
                    data.enforceInterface(descriptor);
                    String _result = this.getServicesSystemSharedLibraryPackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 180: {
                    data.enforceInterface(descriptor);
                    String _result = this.getSharedSystemSharedLibraryPackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 181: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ChangedPackages _result = this.getChangedPackages(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 182: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isPackageDeviceAdminOnAnyUser(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 183: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _result = this.getInstallReason(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 184: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ParceledListSlice _result = this.getSharedLibraries(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 185: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ParceledListSlice _result = this.getDeclaredSharedLibraries(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 186: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.canRequestPackageInstalls(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 187: {
                    data.enforceInterface(descriptor);
                    this.deletePreloadsFileCache();
                    reply.writeNoException();
                    return true;
                }
                case 188: {
                    data.enforceInterface(descriptor);
                    ComponentName _result = this.getInstantAppResolverComponent();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 189: {
                    data.enforceInterface(descriptor);
                    ComponentName _result = this.getInstantAppResolverSettingsComponent();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 190: {
                    data.enforceInterface(descriptor);
                    ComponentName _result = this.getInstantAppInstallerComponent();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 191: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _result = this.getInstantAppAndroidId(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 192: {
                    data.enforceInterface(descriptor);
                    IArtManager _result = this.getArtManager();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 193: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    CharSequence _arg1 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.setHarmfulAppWarning(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 194: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    CharSequence _result = this.getHarmfulAppWarning(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        TextUtils.writeToParcel(_result, reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 195: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    int _arg2 = data.readInt();
                    boolean _result = this.hasSigningCertificate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 196: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    int _arg2 = data.readInt();
                    boolean _result = this.hasUidSigningCertificate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 197: {
                    data.enforceInterface(descriptor);
                    String _result = this.getSystemTextClassifierPackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 198: {
                    data.enforceInterface(descriptor);
                    String _result = this.getAttentionServicePackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 199: {
                    data.enforceInterface(descriptor);
                    String _result = this.getWellbeingPackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 200: {
                    data.enforceInterface(descriptor);
                    String _result = this.getAppPredictionServicePackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 201: {
                    data.enforceInterface(descriptor);
                    String _result = this.getSystemCaptionsServicePackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 202: {
                    data.enforceInterface(descriptor);
                    String _result = this.getIncidentReportApproverPackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 203: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.isPackageStateProtected(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 204: {
                    data.enforceInterface(descriptor);
                    this.sendDeviceCustomizationReadyBroadcast();
                    reply.writeNoException();
                    return true;
                }
                case 205: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    List<ModuleInfo> _result = this.getInstalledModules(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 206: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    ModuleInfo _result = this.getModuleInfo(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 207: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getRuntimePermissionsVersion(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 208: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.setRuntimePermissionsVersion(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 209: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    this.notifyPackagesReplacedReceived(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IPackageManager impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IPackageManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IPackageManager {
            private IBinder mRemote;
            public static IPackageManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void checkPackageStartable(String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().checkPackageStartable(packageName, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPackageAvailable(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isPackageAvailable(packageName, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PackageInfo getPackageInfo(String packageName, int flags, int userId) throws RemoteException {
                PackageInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        PackageInfo packageInfo = Stub.getDefaultImpl().getPackageInfo(packageName, flags, userId);
                        return packageInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? PackageInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PackageInfo getPackageInfoVersioned(VersionedPackage versionedPackage, int flags, int userId) throws RemoteException {
                PackageInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (versionedPackage != null) {
                        _data.writeInt(1);
                        versionedPackage.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        PackageInfo packageInfo = Stub.getDefaultImpl().getPackageInfoVersioned(versionedPackage, flags, userId);
                        return packageInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? PackageInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPackageUid(String packageName, int flags, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getPackageUid(packageName, flags, userId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getPackageGids(String packageName, int flags, int userId) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int[] nArray = Stub.getDefaultImpl().getPackageGids(packageName, flags, userId);
                        return nArray;
                    }
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] currentToCanonicalPackageNames(String[] names) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(names);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().currentToCanonicalPackageNames(names);
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] canonicalToCurrentPackageNames(String[] names) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(names);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().canonicalToCurrentPackageNames(names);
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PermissionInfo getPermissionInfo(String name, String packageName, int flags) throws RemoteException {
                PermissionInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        PermissionInfo permissionInfo = Stub.getDefaultImpl().getPermissionInfo(name, packageName, flags);
                        return permissionInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? PermissionInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice queryPermissionsByGroup(String group, int flags) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(group);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().queryPermissionsByGroup(group, flags);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PermissionGroupInfo getPermissionGroupInfo(String name, int flags) throws RemoteException {
                PermissionGroupInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        PermissionGroupInfo permissionGroupInfo = Stub.getDefaultImpl().getPermissionGroupInfo(name, flags);
                        return permissionGroupInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? PermissionGroupInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getAllPermissionGroups(int flags) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getAllPermissionGroups(flags);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ApplicationInfo getApplicationInfo(String packageName, int flags, int userId) throws RemoteException {
                ApplicationInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ApplicationInfo applicationInfo = Stub.getDefaultImpl().getApplicationInfo(packageName, flags, userId);
                        return applicationInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ApplicationInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ActivityInfo getActivityInfo(ComponentName className, int flags, int userId) throws RemoteException {
                ActivityInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (className != null) {
                        _data.writeInt(1);
                        className.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ActivityInfo activityInfo = Stub.getDefaultImpl().getActivityInfo(className, flags, userId);
                        return activityInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ActivityInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean activitySupportsIntent(ComponentName className, Intent intent, String resolvedType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (className != null) {
                        _data.writeInt(1);
                        className.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(resolvedType);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().activitySupportsIntent(className, intent, resolvedType);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ActivityInfo getReceiverInfo(ComponentName className, int flags, int userId) throws RemoteException {
                ActivityInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (className != null) {
                        _data.writeInt(1);
                        className.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ActivityInfo activityInfo = Stub.getDefaultImpl().getReceiverInfo(className, flags, userId);
                        return activityInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ActivityInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ServiceInfo getServiceInfo(ComponentName className, int flags, int userId) throws RemoteException {
                ServiceInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (className != null) {
                        _data.writeInt(1);
                        className.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ServiceInfo serviceInfo = Stub.getDefaultImpl().getServiceInfo(className, flags, userId);
                        return serviceInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ServiceInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ProviderInfo getProviderInfo(ComponentName className, int flags, int userId) throws RemoteException {
                ProviderInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (className != null) {
                        _data.writeInt(1);
                        className.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ProviderInfo providerInfo = Stub.getDefaultImpl().getProviderInfo(className, flags, userId);
                        return providerInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ProviderInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkPermission(String permName, String pkgName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(permName);
                    _data.writeString(pkgName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().checkPermission(permName, pkgName, userId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkUidPermission(String permName, int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(permName);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().checkUidPermission(permName, uid);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addPermission(PermissionInfo info) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (info != null) {
                        _data.writeInt(1);
                        info.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().addPermission(info);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePermission(String name) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removePermission(name);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantRuntimePermission(String packageName, String permissionName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(permissionName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().grantRuntimePermission(packageName, permissionName, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeRuntimePermission(String packageName, String permissionName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(permissionName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().revokeRuntimePermission(packageName, permissionName, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetRuntimePermissions() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().resetRuntimePermissions();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPermissionFlags(String permissionName, String packageName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(permissionName);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getPermissionFlags(permissionName, packageName, userId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePermissionFlags(String permissionName, String packageName, int flagMask, int flagValues, boolean checkAdjustPolicyFlagPermission, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(permissionName);
                    _data.writeString(packageName);
                    _data.writeInt(flagMask);
                    _data.writeInt(flagValues);
                    _data.writeInt(checkAdjustPolicyFlagPermission ? 1 : 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updatePermissionFlags(permissionName, packageName, flagMask, flagValues, checkAdjustPolicyFlagPermission, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePermissionFlagsForAllApps(int flagMask, int flagValues, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flagMask);
                    _data.writeInt(flagValues);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updatePermissionFlagsForAllApps(flagMask, flagValues, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getWhitelistedRestrictedPermissions(String packageName, int flags, int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<String> list = Stub.getDefaultImpl().getWhitelistedRestrictedPermissions(packageName, flags, userId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addWhitelistedRestrictedPermission(String packageName, String permission2, int whitelistFlags, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(permission2);
                    _data.writeInt(whitelistFlags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().addWhitelistedRestrictedPermission(packageName, permission2, whitelistFlags, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeWhitelistedRestrictedPermission(String packageName, String permission2, int whitelistFlags, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(permission2);
                    _data.writeInt(whitelistFlags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().removeWhitelistedRestrictedPermission(packageName, permission2, whitelistFlags, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldShowRequestPermissionRationale(String permissionName, String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(permissionName);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().shouldShowRequestPermissionRationale(permissionName, packageName, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isProtectedBroadcast(String actionName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(actionName);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isProtectedBroadcast(actionName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkSignatures(String pkg1, String pkg2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg1);
                    _data.writeString(pkg2);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().checkSignatures(pkg1, pkg2);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkUidSignatures(int uid1, int uid2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid1);
                    _data.writeInt(uid2);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().checkUidSignatures(uid1, uid2);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getAllPackages() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<String> list = Stub.getDefaultImpl().getAllPackages();
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getPackagesForUid(int uid) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getPackagesForUid(uid);
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getNameForUid(int uid) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getNameForUid(uid);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getNamesForUids(int[] uids) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(uids);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getNamesForUids(uids);
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getUidForSharedUser(String sharedUserName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(sharedUserName);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getUidForSharedUser(sharedUserName);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFlagsForUid(int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getFlagsForUid(uid);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPrivateFlagsForUid(int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getPrivateFlagsForUid(uid);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUidPrivileged(int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isUidPrivileged(uid);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getAppOpPermissionPackages(String permissionName) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(permissionName);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getAppOpPermissionPackages(permissionName);
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResolveInfo resolveIntent(Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
                ResolveInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(resolvedType);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ResolveInfo resolveInfo = Stub.getDefaultImpl().resolveIntent(intent, resolvedType, flags, userId);
                        return resolveInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ResolveInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResolveInfo findPersistentPreferredActivity(Intent intent, int userId) throws RemoteException {
                ResolveInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ResolveInfo resolveInfo = Stub.getDefaultImpl().findPersistentPreferredActivity(intent, userId);
                        return resolveInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ResolveInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canForwardTo(Intent intent, String resolvedType, int sourceUserId, int targetUserId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(resolvedType);
                    _data.writeInt(sourceUserId);
                    _data.writeInt(targetUserId);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().canForwardTo(intent, resolvedType, sourceUserId, targetUserId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice queryIntentActivities(Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(resolvedType);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().queryIntentActivities(intent, resolvedType, flags, userId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice queryIntentActivityOptions(ComponentName caller, Intent[] specifics, String[] specificTypes, Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (caller != null) {
                        _data.writeInt(1);
                        caller.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedArray(specifics, 0);
                    _data.writeStringArray(specificTypes);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(resolvedType);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().queryIntentActivityOptions(caller, specifics, specificTypes, intent, resolvedType, flags, userId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice queryIntentReceivers(Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(resolvedType);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().queryIntentReceivers(intent, resolvedType, flags, userId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResolveInfo resolveService(Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
                ResolveInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(resolvedType);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ResolveInfo resolveInfo = Stub.getDefaultImpl().resolveService(intent, resolvedType, flags, userId);
                        return resolveInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ResolveInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice queryIntentServices(Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(resolvedType);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().queryIntentServices(intent, resolvedType, flags, userId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice queryIntentContentProviders(Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(resolvedType);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().queryIntentContentProviders(intent, resolvedType, flags, userId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getInstalledPackages(int flags, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getInstalledPackages(flags, userId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getPackagesHoldingPermissions(String[] permissions, int flags, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(permissions);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getPackagesHoldingPermissions(permissions, flags, userId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getInstalledApplications(int flags, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getInstalledApplications(flags, userId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getPersistentApplications(int flags) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getPersistentApplications(flags);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ProviderInfo resolveContentProvider(String name, int flags, int userId) throws RemoteException {
                ProviderInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ProviderInfo providerInfo = Stub.getDefaultImpl().resolveContentProvider(name, flags, userId);
                        return providerInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ProviderInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void querySyncProviders(List<String> outNames, List<ProviderInfo> outInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(outNames);
                    _data.writeTypedList(outInfo);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().querySyncProviders(outNames, outInfo);
                        return;
                    }
                    _reply.readException();
                    _reply.readStringList(outNames);
                    _reply.readTypedList(outInfo, ProviderInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice queryContentProviders(String processName, int uid, int flags, String metaDataKey) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(processName);
                    _data.writeInt(uid);
                    _data.writeInt(flags);
                    _data.writeString(metaDataKey);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().queryContentProviders(processName, uid, flags, metaDataKey);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InstrumentationInfo getInstrumentationInfo(ComponentName className, int flags) throws RemoteException {
                InstrumentationInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (className != null) {
                        _data.writeInt(1);
                        className.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        InstrumentationInfo instrumentationInfo = Stub.getDefaultImpl().getInstrumentationInfo(className, flags);
                        return instrumentationInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? InstrumentationInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice queryInstrumentation(String targetPackage, int flags) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(targetPackage);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().queryInstrumentation(targetPackage, flags);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishPackageInstall(int token, boolean didLaunch) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(token);
                    _data.writeInt(didLaunch ? 1 : 0);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().finishPackageInstall(token, didLaunch);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInstallerPackageName(String targetPackage, String installerPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(targetPackage);
                    _data.writeString(installerPackageName);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setInstallerPackageName(targetPackage, installerPackageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setApplicationCategoryHint(String packageName, int categoryHint, String callerPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(categoryHint);
                    _data.writeString(callerPackageName);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setApplicationCategoryHint(packageName, categoryHint, callerPackageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deletePackageAsUser(String packageName, int versionCode, IPackageDeleteObserver observer, int userId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(versionCode);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deletePackageAsUser(packageName, versionCode, observer, userId, flags);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deletePackageVersioned(VersionedPackage versionedPackage, IPackageDeleteObserver2 observer, int userId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (versionedPackage != null) {
                        _data.writeInt(1);
                        versionedPackage.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deletePackageVersioned(versionedPackage, observer, userId, flags);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getInstallerPackageName(String packageName) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getInstallerPackageName(packageName);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetApplicationPreferences(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().resetApplicationPreferences(userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResolveInfo getLastChosenActivity(Intent intent, String resolvedType, int flags) throws RemoteException {
                ResolveInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(resolvedType);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ResolveInfo resolveInfo = Stub.getDefaultImpl().getLastChosenActivity(intent, resolvedType, flags);
                        return resolveInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ResolveInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLastChosenActivity(Intent intent, String resolvedType, int flags, IntentFilter filter, int match, ComponentName activity) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(resolvedType);
                    _data.writeInt(flags);
                    if (filter != null) {
                        _data.writeInt(1);
                        filter.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(match);
                    if (activity != null) {
                        _data.writeInt(1);
                        activity.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setLastChosenActivity(intent, resolvedType, flags, filter, match, activity);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (filter != null) {
                        _data.writeInt(1);
                        filter.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(match);
                    _data.writeTypedArray(set, 0);
                    if (activity != null) {
                        _data.writeInt(1);
                        activity.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addPreferredActivity(filter, match, set, activity, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (filter != null) {
                        _data.writeInt(1);
                        filter.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(match);
                    _data.writeTypedArray(set, 0);
                    if (activity != null) {
                        _data.writeInt(1);
                        activity.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().replacePreferredActivity(filter, match, set, activity, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearPackagePreferredActivities(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearPackagePreferredActivities(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getPreferredActivities(outFilters, outActivities, packageName);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                    _reply.readTypedList(outFilters, IntentFilter.CREATOR);
                    _reply.readTypedList(outActivities, ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addPersistentPreferredActivity(IntentFilter filter, ComponentName activity, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (filter != null) {
                        _data.writeInt(1);
                        filter.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (activity != null) {
                        _data.writeInt(1);
                        activity.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addPersistentPreferredActivity(filter, activity, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearPackagePersistentPreferredActivities(String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearPackagePersistentPreferredActivities(packageName, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCrossProfileIntentFilter(IntentFilter intentFilter, String ownerPackage, int sourceUserId, int targetUserId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intentFilter != null) {
                        _data.writeInt(1);
                        intentFilter.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(ownerPackage);
                    _data.writeInt(sourceUserId);
                    _data.writeInt(targetUserId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addCrossProfileIntentFilter(intentFilter, ownerPackage, sourceUserId, targetUserId, flags);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearCrossProfileIntentFilters(int sourceUserId, String ownerPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sourceUserId);
                    _data.writeString(ownerPackage);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearCrossProfileIntentFilters(sourceUserId, ownerPackage);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] setDistractingPackageRestrictionsAsUser(String[] packageNames, int restrictionFlags, int userId) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(restrictionFlags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().setDistractingPackageRestrictionsAsUser(packageNames, restrictionFlags, userId);
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] setPackagesSuspendedAsUser(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, SuspendDialogInfo dialogInfo, String callingPackage, int userId) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(suspended ? 1 : 0);
                    if (appExtras != null) {
                        _data.writeInt(1);
                        appExtras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (launcherExtras != null) {
                        _data.writeInt(1);
                        launcherExtras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (dialogInfo != null) {
                        _data.writeInt(1);
                        dialogInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().setPackagesSuspendedAsUser(packageNames, suspended, appExtras, launcherExtras, dialogInfo, callingPackage, userId);
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getUnsuspendablePackagesForUser(String[] packageNames, int userId) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getUnsuspendablePackagesForUser(packageNames, userId);
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPackageSuspendedForUser(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isPackageSuspendedForUser(packageName, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getSuspendedPackageAppExtras(String packageName, int userId) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        PersistableBundle persistableBundle = Stub.getDefaultImpl().getSuspendedPackageAppExtras(packageName, userId);
                        return persistableBundle;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? PersistableBundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getPreferredActivityBackup(int userId) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getPreferredActivityBackup(userId);
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restorePreferredActivities(byte[] backup, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(backup);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().restorePreferredActivities(backup, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getDefaultAppsBackup(int userId) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getDefaultAppsBackup(userId);
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreDefaultApps(byte[] backup, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(backup);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().restoreDefaultApps(backup, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getIntentFilterVerificationBackup(int userId) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getIntentFilterVerificationBackup(userId);
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreIntentFilterVerification(byte[] backup, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(backup);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().restoreIntentFilterVerification(backup, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getHomeActivities(List<ResolveInfo> outHomeCandidates) throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(91, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ComponentName componentName = Stub.getDefaultImpl().getHomeActivities(outHomeCandidates);
                        return componentName;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ComponentName.CREATOR.createFromParcel(_reply) : null;
                    _reply.readTypedList(outHomeCandidates, ResolveInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHomeActivity(ComponentName className, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (className != null) {
                        _data.writeInt(1);
                        className.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setHomeActivity(className, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        _data.writeInt(1);
                        componentName.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(newState);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setComponentEnabledSetting(componentName, newState, flags, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getComponentEnabledSetting(ComponentName componentName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        _data.writeInt(1);
                        componentName.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getComponentEnabledSetting(componentName, userId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setApplicationEnabledSetting(String packageName, int newState, int flags, int userId, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(newState);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setApplicationEnabledSetting(packageName, newState, flags, userId, callingPackage);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getApplicationEnabledSetting(String packageName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getApplicationEnabledSetting(packageName, userId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void logAppProcessStartIfNeeded(String processName, int uid, String seinfo, String apkFile, int pid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(processName);
                    _data.writeInt(uid);
                    _data.writeString(seinfo);
                    _data.writeString(apkFile);
                    _data.writeInt(pid);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().logAppProcessStartIfNeeded(processName, uid, seinfo, apkFile, pid);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flushPackageRestrictionsAsUser(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().flushPackageRestrictionsAsUser(userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPackageStoppedState(String packageName, boolean stopped, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(stopped ? 1 : 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPackageStoppedState(packageName, stopped, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void freeStorageAndNotify(String volumeUuid, long freeStorageSize, int storageFlags, IPackageDataObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    _data.writeLong(freeStorageSize);
                    _data.writeInt(storageFlags);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    boolean _status = this.mRemote.transact(100, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().freeStorageAndNotify(volumeUuid, freeStorageSize, storageFlags, observer);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void freeStorage(String volumeUuid, long freeStorageSize, int storageFlags, IntentSender pi) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    _data.writeLong(freeStorageSize);
                    _data.writeInt(storageFlags);
                    if (pi != null) {
                        _data.writeInt(1);
                        pi.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(101, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().freeStorage(volumeUuid, freeStorageSize, storageFlags, pi);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    boolean _status = this.mRemote.transact(102, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deleteApplicationCacheFiles(packageName, observer);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteApplicationCacheFilesAsUser(String packageName, int userId, IPackageDataObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deleteApplicationCacheFilesAsUser(packageName, userId, observer);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearApplicationUserData(String packageName, IPackageDataObserver observer, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(104, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearApplicationUserData(packageName, observer, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearApplicationProfileData(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(105, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearApplicationProfileData(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPackageSizeInfo(String packageName, int userHandle, IPackageStatsObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userHandle);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    boolean _status = this.mRemote.transact(106, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getPackageSizeInfo(packageName, userHandle, observer);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getSystemSharedLibraryNames() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(107, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getSystemSharedLibraryNames();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getSystemAvailableFeatures() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(108, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getSystemAvailableFeatures();
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasSystemFeature(String name, int version) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeInt(version);
                    boolean _status = this.mRemote.transact(109, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().hasSystemFeature(name, version);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enterSafeMode() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(110, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().enterSafeMode();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSafeMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(111, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isSafeMode();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void systemReady() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(112, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().systemReady();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasSystemUidErrors() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(113, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().hasSystemUidErrors();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performFstrimIfNeeded() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(114, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().performFstrimIfNeeded();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePackagesIfNeeded() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(115, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updatePackagesIfNeeded();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPackageUse(String packageName, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(116, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyPackageUse(packageName, reason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDexLoad(String loadingPackageName, List<String> classLoadersNames, List<String> classPaths, String loaderIsa) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(loadingPackageName);
                    _data.writeStringList(classLoadersNames);
                    _data.writeStringList(classPaths);
                    _data.writeString(loaderIsa);
                    boolean _status = this.mRemote.transact(117, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyDexLoad(loadingPackageName, classLoadersNames, classPaths, loaderIsa);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDexModule(String packageName, String dexModulePath, boolean isSharedModule, IDexModuleRegisterCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(dexModulePath);
                    _data.writeInt(isSharedModule ? 1 : 0);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(118, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerDexModule(packageName, dexModulePath, isSharedModule, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean performDexOptMode(String packageName, boolean checkProfiles, String targetCompilerFilter, boolean force, boolean bootComplete, String splitName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(checkProfiles ? 1 : 0);
                    _data.writeString(targetCompilerFilter);
                    _data.writeInt(force ? 1 : 0);
                    _data.writeInt(bootComplete ? 1 : 0);
                    _data.writeString(splitName);
                    boolean _status = this.mRemote.transact(119, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().performDexOptMode(packageName, checkProfiles, targetCompilerFilter, force, bootComplete, splitName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean performDexOptSecondary(String packageName, String targetCompilerFilter, boolean force) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(targetCompilerFilter);
                    _data.writeInt(force ? 1 : 0);
                    boolean _status = this.mRemote.transact(120, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().performDexOptSecondary(packageName, targetCompilerFilter, force);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean compileLayouts(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(121, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().compileLayouts(packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dumpProfiles(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(122, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dumpProfiles(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceDexOpt(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(123, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().forceDexOpt(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean runBackgroundDexoptJob(List<String> packageNames) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(packageNames);
                    boolean _status = this.mRemote.transact(124, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().runBackgroundDexoptJob(packageNames);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reconcileSecondaryDexFiles(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(125, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reconcileSecondaryDexFiles(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMoveStatus(int moveId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(moveId);
                    boolean _status = this.mRemote.transact(126, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getMoveStatus(moveId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerMoveCallback(IPackageMoveObserver callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(127, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerMoveCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterMoveCallback(IPackageMoveObserver callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(128, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterMoveCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int movePackage(String packageName, String volumeUuid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(volumeUuid);
                    boolean _status = this.mRemote.transact(129, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().movePackage(packageName, volumeUuid);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int movePrimaryStorage(String volumeUuid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    boolean _status = this.mRemote.transact(130, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().movePrimaryStorage(volumeUuid);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addPermissionAsync(PermissionInfo info) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (info != null) {
                        _data.writeInt(1);
                        info.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(131, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().addPermissionAsync(info);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setInstallLocation(int loc) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(loc);
                    boolean _status = this.mRemote.transact(132, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setInstallLocation(loc);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInstallLocation() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(133, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getInstallLocation();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int installExistingPackageAsUser(String packageName, int userId, int installFlags, int installReason, List<String> whiteListedPermissions) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(installFlags);
                    _data.writeInt(installReason);
                    _data.writeStringList(whiteListedPermissions);
                    boolean _status = this.mRemote.transact(134, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().installExistingPackageAsUser(packageName, userId, installFlags, installReason, whiteListedPermissions);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void verifyPendingInstall(int id2, int verificationCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(id2);
                    _data.writeInt(verificationCode);
                    boolean _status = this.mRemote.transact(135, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().verifyPendingInstall(id2, verificationCode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(id2);
                    _data.writeInt(verificationCodeAtTimeout);
                    _data.writeLong(millisecondsToDelay);
                    boolean _status = this.mRemote.transact(136, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().extendVerificationTimeout(id2, verificationCodeAtTimeout, millisecondsToDelay);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void verifyIntentFilter(int id2, int verificationCode, List<String> failedDomains) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(id2);
                    _data.writeInt(verificationCode);
                    _data.writeStringList(failedDomains);
                    boolean _status = this.mRemote.transact(137, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().verifyIntentFilter(id2, verificationCode, failedDomains);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getIntentVerificationStatus(String packageName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(138, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getIntentVerificationStatus(packageName, userId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean updateIntentVerificationStatus(String packageName, int status, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(status);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(139, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().updateIntentVerificationStatus(packageName, status, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getIntentFilterVerifications(String packageName) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(140, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getIntentFilterVerifications(packageName);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getAllIntentFilters(String packageName) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(141, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getAllIntentFilters(packageName);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setDefaultBrowserPackageName(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(142, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setDefaultBrowserPackageName(packageName, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDefaultBrowserPackageName(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(143, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getDefaultBrowserPackageName(userId);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VerifierDeviceIdentity getVerifierDeviceIdentity() throws RemoteException {
                VerifierDeviceIdentity _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(144, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        VerifierDeviceIdentity verifierDeviceIdentity = Stub.getDefaultImpl().getVerifierDeviceIdentity();
                        return verifierDeviceIdentity;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? VerifierDeviceIdentity.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isFirstBoot() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(145, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isFirstBoot();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOnlyCoreApps() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(146, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isOnlyCoreApps();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceUpgrading() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(147, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isDeviceUpgrading();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPermissionEnforced(String permission2, boolean enforced) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(permission2);
                    _data.writeInt(enforced ? 1 : 0);
                    boolean _status = this.mRemote.transact(148, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPermissionEnforced(permission2, enforced);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPermissionEnforced(String permission2) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(permission2);
                    boolean _status = this.mRemote.transact(149, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isPermissionEnforced(permission2);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStorageLow() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(150, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isStorageLow();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setApplicationHiddenSettingAsUser(String packageName, boolean hidden, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(hidden ? 1 : 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(151, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setApplicationHiddenSettingAsUser(packageName, hidden, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getApplicationHiddenSettingAsUser(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(152, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().getApplicationHiddenSettingAsUser(packageName, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemAppHiddenUntilInstalled(String packageName, boolean hidden) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(hidden ? 1 : 0);
                    boolean _status = this.mRemote.transact(153, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSystemAppHiddenUntilInstalled(packageName, hidden);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSystemAppInstallState(String packageName, boolean installed, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(installed ? 1 : 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(154, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setSystemAppInstallState(packageName, installed, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IPackageInstaller getPackageInstaller() throws RemoteException {
                IPackageInstaller _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(155, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IPackageInstaller iPackageInstaller = Stub.getDefaultImpl().getPackageInstaller();
                        return iPackageInstaller;
                    }
                    _reply.readException();
                    _result = IPackageInstaller.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setBlockUninstallForUser(String packageName, boolean blockUninstall, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(blockUninstall ? 1 : 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(156, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setBlockUninstallForUser(packageName, blockUninstall, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getBlockUninstallForUser(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(157, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().getBlockUninstallForUser(packageName, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeySet getKeySetByAlias(String packageName, String alias) throws RemoteException {
                KeySet _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(158, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        KeySet keySet = Stub.getDefaultImpl().getKeySetByAlias(packageName, alias);
                        return keySet;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? KeySet.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeySet getSigningKeySet(String packageName) throws RemoteException {
                KeySet _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(159, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        KeySet keySet = Stub.getDefaultImpl().getSigningKeySet(packageName);
                        return keySet;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? KeySet.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPackageSignedByKeySet(String packageName, KeySet ks) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    if (ks != null) {
                        _data.writeInt(1);
                        ks.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(160, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isPackageSignedByKeySet(packageName, ks);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPackageSignedByKeySetExactly(String packageName, KeySet ks) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    if (ks != null) {
                        _data.writeInt(1);
                        ks.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(161, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isPackageSignedByKeySetExactly(packageName, ks);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnPermissionsChangeListener(IOnPermissionsChangeListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(162, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addOnPermissionsChangeListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnPermissionsChangeListener(IOnPermissionsChangeListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(163, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeOnPermissionsChangeListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantDefaultPermissionsToEnabledCarrierApps(String[] packageNames, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(164, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().grantDefaultPermissionsToEnabledCarrierApps(packageNames, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantDefaultPermissionsToEnabledImsServices(String[] packageNames, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(165, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().grantDefaultPermissionsToEnabledImsServices(packageNames, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantDefaultPermissionsToEnabledTelephonyDataServices(String[] packageNames, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(166, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().grantDefaultPermissionsToEnabledTelephonyDataServices(packageNames, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeDefaultPermissionsFromDisabledTelephonyDataServices(String[] packageNames, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(167, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().revokeDefaultPermissionsFromDisabledTelephonyDataServices(packageNames, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantDefaultPermissionsToActiveLuiApp(String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(168, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().grantDefaultPermissionsToActiveLuiApp(packageName, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeDefaultPermissionsFromLuiApps(String[] packageNames, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(169, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().revokeDefaultPermissionsFromLuiApps(packageNames, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPermissionRevokedByPolicy(String permission2, String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(permission2);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(170, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isPermissionRevokedByPolicy(permission2, packageName, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPermissionControllerPackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(171, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getPermissionControllerPackageName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getInstantApps(int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(172, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getInstantApps(userId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getInstantAppCookie(String packageName, int userId) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(173, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getInstantAppCookie(packageName, userId);
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setInstantAppCookie(String packageName, byte[] cookie, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeByteArray(cookie);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(174, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setInstantAppCookie(packageName, cookie, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bitmap getInstantAppIcon(String packageName, int userId) throws RemoteException {
                Bitmap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(175, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Bitmap bitmap = Stub.getDefaultImpl().getInstantAppIcon(packageName, userId);
                        return bitmap;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Bitmap.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInstantApp(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(176, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isInstantApp(packageName, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setRequiredForSystemUser(String packageName, boolean systemUserApp) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(systemUserApp ? 1 : 0);
                    boolean _status = this.mRemote.transact(177, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setRequiredForSystemUser(packageName, systemUserApp);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUpdateAvailable(String packageName, boolean updateAvaialble) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(updateAvaialble ? 1 : 0);
                    boolean _status = this.mRemote.transact(178, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setUpdateAvailable(packageName, updateAvaialble);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getServicesSystemSharedLibraryPackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(179, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getServicesSystemSharedLibraryPackageName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSharedSystemSharedLibraryPackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(180, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getSharedSystemSharedLibraryPackageName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChangedPackages getChangedPackages(int sequenceNumber, int userId) throws RemoteException {
                ChangedPackages _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sequenceNumber);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(181, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ChangedPackages changedPackages = Stub.getDefaultImpl().getChangedPackages(sequenceNumber, userId);
                        return changedPackages;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ChangedPackages.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPackageDeviceAdminOnAnyUser(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(182, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isPackageDeviceAdminOnAnyUser(packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInstallReason(String packageName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(183, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getInstallReason(packageName, userId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getSharedLibraries(String packageName, int flags, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(184, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getSharedLibraries(packageName, flags, userId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getDeclaredSharedLibraries(String packageName, int flags, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(185, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getDeclaredSharedLibraries(packageName, flags, userId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canRequestPackageInstalls(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(186, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().canRequestPackageInstalls(packageName, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deletePreloadsFileCache() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(187, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deletePreloadsFileCache();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getInstantAppResolverComponent() throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(188, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ComponentName componentName = Stub.getDefaultImpl().getInstantAppResolverComponent();
                        return componentName;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ComponentName.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getInstantAppResolverSettingsComponent() throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(189, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ComponentName componentName = Stub.getDefaultImpl().getInstantAppResolverSettingsComponent();
                        return componentName;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ComponentName.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getInstantAppInstallerComponent() throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(190, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ComponentName componentName = Stub.getDefaultImpl().getInstantAppInstallerComponent();
                        return componentName;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ComponentName.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getInstantAppAndroidId(String packageName, int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(191, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getInstantAppAndroidId(packageName, userId);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IArtManager getArtManager() throws RemoteException {
                IArtManager _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(192, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IArtManager iArtManager = Stub.getDefaultImpl().getArtManager();
                        return iArtManager;
                    }
                    _reply.readException();
                    _result = IArtManager.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHarmfulAppWarning(String packageName, CharSequence warning, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    if (warning != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(warning, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(193, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setHarmfulAppWarning(packageName, warning, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CharSequence getHarmfulAppWarning(String packageName, int userId) throws RemoteException {
                CharSequence _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(194, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CharSequence charSequence = Stub.getDefaultImpl().getHarmfulAppWarning(packageName, userId);
                        return charSequence;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasSigningCertificate(String packageName, byte[] signingCertificate, int flags) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeByteArray(signingCertificate);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(195, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().hasSigningCertificate(packageName, signingCertificate, flags);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasUidSigningCertificate(int uid, byte[] signingCertificate, int flags) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeByteArray(signingCertificate);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(196, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().hasUidSigningCertificate(uid, signingCertificate, flags);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSystemTextClassifierPackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(197, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getSystemTextClassifierPackageName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getAttentionServicePackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(198, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getAttentionServicePackageName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getWellbeingPackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(199, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getWellbeingPackageName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getAppPredictionServicePackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(200, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getAppPredictionServicePackageName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSystemCaptionsServicePackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(201, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getSystemCaptionsServicePackageName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getIncidentReportApproverPackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(202, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getIncidentReportApproverPackageName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPackageStateProtected(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(203, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isPackageStateProtected(packageName, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendDeviceCustomizationReadyBroadcast() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(204, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendDeviceCustomizationReadyBroadcast();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ModuleInfo> getInstalledModules(int flags) throws RemoteException {
                ArrayList<ModuleInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(205, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<ModuleInfo> list = Stub.getDefaultImpl().getInstalledModules(flags);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ModuleInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ModuleInfo getModuleInfo(String packageName, int flags) throws RemoteException {
                ModuleInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(206, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ModuleInfo moduleInfo = Stub.getDefaultImpl().getModuleInfo(packageName, flags);
                        return moduleInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ModuleInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRuntimePermissionsVersion(int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(207, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getRuntimePermissionsVersion(userId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRuntimePermissionsVersion(int version, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(version);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(208, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setRuntimePermissionsVersion(version, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPackagesReplacedReceived(String[] packages) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(packages);
                    boolean _status = this.mRemote.transact(209, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyPackagesReplacedReceived(packages);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPackageManager {
        @Override
        public void checkPackageStartable(String packageName, int userId) throws RemoteException {
        }

        @Override
        public boolean isPackageAvailable(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public PackageInfo getPackageInfo(String packageName, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public PackageInfo getPackageInfoVersioned(VersionedPackage versionedPackage, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public int getPackageUid(String packageName, int flags, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public int[] getPackageGids(String packageName, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public String[] currentToCanonicalPackageNames(String[] names) throws RemoteException {
            return null;
        }

        @Override
        public String[] canonicalToCurrentPackageNames(String[] names) throws RemoteException {
            return null;
        }

        @Override
        public PermissionInfo getPermissionInfo(String name, String packageName, int flags) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice queryPermissionsByGroup(String group, int flags) throws RemoteException {
            return null;
        }

        @Override
        public PermissionGroupInfo getPermissionGroupInfo(String name, int flags) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getAllPermissionGroups(int flags) throws RemoteException {
            return null;
        }

        @Override
        public ApplicationInfo getApplicationInfo(String packageName, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ActivityInfo getActivityInfo(ComponentName className, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean activitySupportsIntent(ComponentName className, Intent intent, String resolvedType) throws RemoteException {
            return false;
        }

        @Override
        public ActivityInfo getReceiverInfo(ComponentName className, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ServiceInfo getServiceInfo(ComponentName className, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ProviderInfo getProviderInfo(ComponentName className, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public int checkPermission(String permName, String pkgName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public int checkUidPermission(String permName, int uid) throws RemoteException {
            return 0;
        }

        @Override
        public boolean addPermission(PermissionInfo info) throws RemoteException {
            return false;
        }

        @Override
        public void removePermission(String name) throws RemoteException {
        }

        @Override
        public void grantRuntimePermission(String packageName, String permissionName, int userId) throws RemoteException {
        }

        @Override
        public void revokeRuntimePermission(String packageName, String permissionName, int userId) throws RemoteException {
        }

        @Override
        public void resetRuntimePermissions() throws RemoteException {
        }

        @Override
        public int getPermissionFlags(String permissionName, String packageName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void updatePermissionFlags(String permissionName, String packageName, int flagMask, int flagValues, boolean checkAdjustPolicyFlagPermission, int userId) throws RemoteException {
        }

        @Override
        public void updatePermissionFlagsForAllApps(int flagMask, int flagValues, int userId) throws RemoteException {
        }

        @Override
        public List<String> getWhitelistedRestrictedPermissions(String packageName, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean addWhitelistedRestrictedPermission(String packageName, String permission2, int whitelistFlags, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeWhitelistedRestrictedPermission(String packageName, String permission2, int whitelistFlags, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean shouldShowRequestPermissionRationale(String permissionName, String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isProtectedBroadcast(String actionName) throws RemoteException {
            return false;
        }

        @Override
        public int checkSignatures(String pkg1, String pkg2) throws RemoteException {
            return 0;
        }

        @Override
        public int checkUidSignatures(int uid1, int uid2) throws RemoteException {
            return 0;
        }

        @Override
        public List<String> getAllPackages() throws RemoteException {
            return null;
        }

        @Override
        public String[] getPackagesForUid(int uid) throws RemoteException {
            return null;
        }

        @Override
        public String getNameForUid(int uid) throws RemoteException {
            return null;
        }

        @Override
        public String[] getNamesForUids(int[] uids) throws RemoteException {
            return null;
        }

        @Override
        public int getUidForSharedUser(String sharedUserName) throws RemoteException {
            return 0;
        }

        @Override
        public int getFlagsForUid(int uid) throws RemoteException {
            return 0;
        }

        @Override
        public int getPrivateFlagsForUid(int uid) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isUidPrivileged(int uid) throws RemoteException {
            return false;
        }

        @Override
        public String[] getAppOpPermissionPackages(String permissionName) throws RemoteException {
            return null;
        }

        @Override
        public ResolveInfo resolveIntent(Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ResolveInfo findPersistentPreferredActivity(Intent intent, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean canForwardTo(Intent intent, String resolvedType, int sourceUserId, int targetUserId) throws RemoteException {
            return false;
        }

        @Override
        public ParceledListSlice queryIntentActivities(Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice queryIntentActivityOptions(ComponentName caller, Intent[] specifics, String[] specificTypes, Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice queryIntentReceivers(Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ResolveInfo resolveService(Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice queryIntentServices(Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice queryIntentContentProviders(Intent intent, String resolvedType, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getInstalledPackages(int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getPackagesHoldingPermissions(String[] permissions, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getInstalledApplications(int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getPersistentApplications(int flags) throws RemoteException {
            return null;
        }

        @Override
        public ProviderInfo resolveContentProvider(String name, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void querySyncProviders(List<String> outNames, List<ProviderInfo> outInfo) throws RemoteException {
        }

        @Override
        public ParceledListSlice queryContentProviders(String processName, int uid, int flags, String metaDataKey) throws RemoteException {
            return null;
        }

        @Override
        public InstrumentationInfo getInstrumentationInfo(ComponentName className, int flags) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice queryInstrumentation(String targetPackage, int flags) throws RemoteException {
            return null;
        }

        @Override
        public void finishPackageInstall(int token, boolean didLaunch) throws RemoteException {
        }

        @Override
        public void setInstallerPackageName(String targetPackage, String installerPackageName) throws RemoteException {
        }

        @Override
        public void setApplicationCategoryHint(String packageName, int categoryHint, String callerPackageName) throws RemoteException {
        }

        @Override
        public void deletePackageAsUser(String packageName, int versionCode, IPackageDeleteObserver observer, int userId, int flags) throws RemoteException {
        }

        @Override
        public void deletePackageVersioned(VersionedPackage versionedPackage, IPackageDeleteObserver2 observer, int userId, int flags) throws RemoteException {
        }

        @Override
        public String getInstallerPackageName(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void resetApplicationPreferences(int userId) throws RemoteException {
        }

        @Override
        public ResolveInfo getLastChosenActivity(Intent intent, String resolvedType, int flags) throws RemoteException {
            return null;
        }

        @Override
        public void setLastChosenActivity(Intent intent, String resolvedType, int flags, IntentFilter filter, int match, ComponentName activity) throws RemoteException {
        }

        @Override
        public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) throws RemoteException {
        }

        @Override
        public void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) throws RemoteException {
        }

        @Override
        public void clearPackagePreferredActivities(String packageName) throws RemoteException {
        }

        @Override
        public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public void addPersistentPreferredActivity(IntentFilter filter, ComponentName activity, int userId) throws RemoteException {
        }

        @Override
        public void clearPackagePersistentPreferredActivities(String packageName, int userId) throws RemoteException {
        }

        @Override
        public void addCrossProfileIntentFilter(IntentFilter intentFilter, String ownerPackage, int sourceUserId, int targetUserId, int flags) throws RemoteException {
        }

        @Override
        public void clearCrossProfileIntentFilters(int sourceUserId, String ownerPackage) throws RemoteException {
        }

        @Override
        public String[] setDistractingPackageRestrictionsAsUser(String[] packageNames, int restrictionFlags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public String[] setPackagesSuspendedAsUser(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, SuspendDialogInfo dialogInfo, String callingPackage, int userId) throws RemoteException {
            return null;
        }

        @Override
        public String[] getUnsuspendablePackagesForUser(String[] packageNames, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isPackageSuspendedForUser(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public PersistableBundle getSuspendedPackageAppExtras(String packageName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public byte[] getPreferredActivityBackup(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void restorePreferredActivities(byte[] backup, int userId) throws RemoteException {
        }

        @Override
        public byte[] getDefaultAppsBackup(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void restoreDefaultApps(byte[] backup, int userId) throws RemoteException {
        }

        @Override
        public byte[] getIntentFilterVerificationBackup(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void restoreIntentFilterVerification(byte[] backup, int userId) throws RemoteException {
        }

        @Override
        public ComponentName getHomeActivities(List<ResolveInfo> outHomeCandidates) throws RemoteException {
            return null;
        }

        @Override
        public void setHomeActivity(ComponentName className, int userId) throws RemoteException {
        }

        @Override
        public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags, int userId) throws RemoteException {
        }

        @Override
        public int getComponentEnabledSetting(ComponentName componentName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void setApplicationEnabledSetting(String packageName, int newState, int flags, int userId, String callingPackage) throws RemoteException {
        }

        @Override
        public int getApplicationEnabledSetting(String packageName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void logAppProcessStartIfNeeded(String processName, int uid, String seinfo, String apkFile, int pid) throws RemoteException {
        }

        @Override
        public void flushPackageRestrictionsAsUser(int userId) throws RemoteException {
        }

        @Override
        public void setPackageStoppedState(String packageName, boolean stopped, int userId) throws RemoteException {
        }

        @Override
        public void freeStorageAndNotify(String volumeUuid, long freeStorageSize, int storageFlags, IPackageDataObserver observer) throws RemoteException {
        }

        @Override
        public void freeStorage(String volumeUuid, long freeStorageSize, int storageFlags, IntentSender pi) throws RemoteException {
        }

        @Override
        public void deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) throws RemoteException {
        }

        @Override
        public void deleteApplicationCacheFilesAsUser(String packageName, int userId, IPackageDataObserver observer) throws RemoteException {
        }

        @Override
        public void clearApplicationUserData(String packageName, IPackageDataObserver observer, int userId) throws RemoteException {
        }

        @Override
        public void clearApplicationProfileData(String packageName) throws RemoteException {
        }

        @Override
        public void getPackageSizeInfo(String packageName, int userHandle, IPackageStatsObserver observer) throws RemoteException {
        }

        @Override
        public String[] getSystemSharedLibraryNames() throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getSystemAvailableFeatures() throws RemoteException {
            return null;
        }

        @Override
        public boolean hasSystemFeature(String name, int version) throws RemoteException {
            return false;
        }

        @Override
        public void enterSafeMode() throws RemoteException {
        }

        @Override
        public boolean isSafeMode() throws RemoteException {
            return false;
        }

        @Override
        public void systemReady() throws RemoteException {
        }

        @Override
        public boolean hasSystemUidErrors() throws RemoteException {
            return false;
        }

        @Override
        public void performFstrimIfNeeded() throws RemoteException {
        }

        @Override
        public void updatePackagesIfNeeded() throws RemoteException {
        }

        @Override
        public void notifyPackageUse(String packageName, int reason) throws RemoteException {
        }

        @Override
        public void notifyDexLoad(String loadingPackageName, List<String> classLoadersNames, List<String> classPaths, String loaderIsa) throws RemoteException {
        }

        @Override
        public void registerDexModule(String packageName, String dexModulePath, boolean isSharedModule, IDexModuleRegisterCallback callback) throws RemoteException {
        }

        @Override
        public boolean performDexOptMode(String packageName, boolean checkProfiles, String targetCompilerFilter, boolean force, boolean bootComplete, String splitName) throws RemoteException {
            return false;
        }

        @Override
        public boolean performDexOptSecondary(String packageName, String targetCompilerFilter, boolean force) throws RemoteException {
            return false;
        }

        @Override
        public boolean compileLayouts(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void dumpProfiles(String packageName) throws RemoteException {
        }

        @Override
        public void forceDexOpt(String packageName) throws RemoteException {
        }

        @Override
        public boolean runBackgroundDexoptJob(List<String> packageNames) throws RemoteException {
            return false;
        }

        @Override
        public void reconcileSecondaryDexFiles(String packageName) throws RemoteException {
        }

        @Override
        public int getMoveStatus(int moveId) throws RemoteException {
            return 0;
        }

        @Override
        public void registerMoveCallback(IPackageMoveObserver callback) throws RemoteException {
        }

        @Override
        public void unregisterMoveCallback(IPackageMoveObserver callback) throws RemoteException {
        }

        @Override
        public int movePackage(String packageName, String volumeUuid) throws RemoteException {
            return 0;
        }

        @Override
        public int movePrimaryStorage(String volumeUuid) throws RemoteException {
            return 0;
        }

        @Override
        public boolean addPermissionAsync(PermissionInfo info) throws RemoteException {
            return false;
        }

        @Override
        public boolean setInstallLocation(int loc) throws RemoteException {
            return false;
        }

        @Override
        public int getInstallLocation() throws RemoteException {
            return 0;
        }

        @Override
        public int installExistingPackageAsUser(String packageName, int userId, int installFlags, int installReason, List<String> whiteListedPermissions) throws RemoteException {
            return 0;
        }

        @Override
        public void verifyPendingInstall(int id2, int verificationCode) throws RemoteException {
        }

        @Override
        public void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) throws RemoteException {
        }

        @Override
        public void verifyIntentFilter(int id2, int verificationCode, List<String> failedDomains) throws RemoteException {
        }

        @Override
        public int getIntentVerificationStatus(String packageName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public boolean updateIntentVerificationStatus(String packageName, int status, int userId) throws RemoteException {
            return false;
        }

        @Override
        public ParceledListSlice getIntentFilterVerifications(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getAllIntentFilters(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public boolean setDefaultBrowserPackageName(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public String getDefaultBrowserPackageName(int userId) throws RemoteException {
            return null;
        }

        @Override
        public VerifierDeviceIdentity getVerifierDeviceIdentity() throws RemoteException {
            return null;
        }

        @Override
        public boolean isFirstBoot() throws RemoteException {
            return false;
        }

        @Override
        public boolean isOnlyCoreApps() throws RemoteException {
            return false;
        }

        @Override
        public boolean isDeviceUpgrading() throws RemoteException {
            return false;
        }

        @Override
        public void setPermissionEnforced(String permission2, boolean enforced) throws RemoteException {
        }

        @Override
        public boolean isPermissionEnforced(String permission2) throws RemoteException {
            return false;
        }

        @Override
        public boolean isStorageLow() throws RemoteException {
            return false;
        }

        @Override
        public boolean setApplicationHiddenSettingAsUser(String packageName, boolean hidden, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean getApplicationHiddenSettingAsUser(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setSystemAppHiddenUntilInstalled(String packageName, boolean hidden) throws RemoteException {
        }

        @Override
        public boolean setSystemAppInstallState(String packageName, boolean installed, int userId) throws RemoteException {
            return false;
        }

        @Override
        public IPackageInstaller getPackageInstaller() throws RemoteException {
            return null;
        }

        @Override
        public boolean setBlockUninstallForUser(String packageName, boolean blockUninstall, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean getBlockUninstallForUser(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public KeySet getKeySetByAlias(String packageName, String alias) throws RemoteException {
            return null;
        }

        @Override
        public KeySet getSigningKeySet(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public boolean isPackageSignedByKeySet(String packageName, KeySet ks) throws RemoteException {
            return false;
        }

        @Override
        public boolean isPackageSignedByKeySetExactly(String packageName, KeySet ks) throws RemoteException {
            return false;
        }

        @Override
        public void addOnPermissionsChangeListener(IOnPermissionsChangeListener listener) throws RemoteException {
        }

        @Override
        public void removeOnPermissionsChangeListener(IOnPermissionsChangeListener listener) throws RemoteException {
        }

        @Override
        public void grantDefaultPermissionsToEnabledCarrierApps(String[] packageNames, int userId) throws RemoteException {
        }

        @Override
        public void grantDefaultPermissionsToEnabledImsServices(String[] packageNames, int userId) throws RemoteException {
        }

        @Override
        public void grantDefaultPermissionsToEnabledTelephonyDataServices(String[] packageNames, int userId) throws RemoteException {
        }

        @Override
        public void revokeDefaultPermissionsFromDisabledTelephonyDataServices(String[] packageNames, int userId) throws RemoteException {
        }

        @Override
        public void grantDefaultPermissionsToActiveLuiApp(String packageName, int userId) throws RemoteException {
        }

        @Override
        public void revokeDefaultPermissionsFromLuiApps(String[] packageNames, int userId) throws RemoteException {
        }

        @Override
        public boolean isPermissionRevokedByPolicy(String permission2, String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public String getPermissionControllerPackageName() throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getInstantApps(int userId) throws RemoteException {
            return null;
        }

        @Override
        public byte[] getInstantAppCookie(String packageName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean setInstantAppCookie(String packageName, byte[] cookie, int userId) throws RemoteException {
            return false;
        }

        @Override
        public Bitmap getInstantAppIcon(String packageName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isInstantApp(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean setRequiredForSystemUser(String packageName, boolean systemUserApp) throws RemoteException {
            return false;
        }

        @Override
        public void setUpdateAvailable(String packageName, boolean updateAvaialble) throws RemoteException {
        }

        @Override
        public String getServicesSystemSharedLibraryPackageName() throws RemoteException {
            return null;
        }

        @Override
        public String getSharedSystemSharedLibraryPackageName() throws RemoteException {
            return null;
        }

        @Override
        public ChangedPackages getChangedPackages(int sequenceNumber, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isPackageDeviceAdminOnAnyUser(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public int getInstallReason(String packageName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public ParceledListSlice getSharedLibraries(String packageName, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getDeclaredSharedLibraries(String packageName, int flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean canRequestPackageInstalls(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void deletePreloadsFileCache() throws RemoteException {
        }

        @Override
        public ComponentName getInstantAppResolverComponent() throws RemoteException {
            return null;
        }

        @Override
        public ComponentName getInstantAppResolverSettingsComponent() throws RemoteException {
            return null;
        }

        @Override
        public ComponentName getInstantAppInstallerComponent() throws RemoteException {
            return null;
        }

        @Override
        public String getInstantAppAndroidId(String packageName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public IArtManager getArtManager() throws RemoteException {
            return null;
        }

        @Override
        public void setHarmfulAppWarning(String packageName, CharSequence warning, int userId) throws RemoteException {
        }

        @Override
        public CharSequence getHarmfulAppWarning(String packageName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean hasSigningCertificate(String packageName, byte[] signingCertificate, int flags) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasUidSigningCertificate(int uid, byte[] signingCertificate, int flags) throws RemoteException {
            return false;
        }

        @Override
        public String getSystemTextClassifierPackageName() throws RemoteException {
            return null;
        }

        @Override
        public String getAttentionServicePackageName() throws RemoteException {
            return null;
        }

        @Override
        public String getWellbeingPackageName() throws RemoteException {
            return null;
        }

        @Override
        public String getAppPredictionServicePackageName() throws RemoteException {
            return null;
        }

        @Override
        public String getSystemCaptionsServicePackageName() throws RemoteException {
            return null;
        }

        @Override
        public String getIncidentReportApproverPackageName() throws RemoteException {
            return null;
        }

        @Override
        public boolean isPackageStateProtected(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void sendDeviceCustomizationReadyBroadcast() throws RemoteException {
        }

        @Override
        public List<ModuleInfo> getInstalledModules(int flags) throws RemoteException {
            return null;
        }

        @Override
        public ModuleInfo getModuleInfo(String packageName, int flags) throws RemoteException {
            return null;
        }

        @Override
        public int getRuntimePermissionsVersion(int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void setRuntimePermissionsVersion(int version, int userId) throws RemoteException {
        }

        @Override
        public void notifyPackagesReplacedReceived(String[] packages) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

