/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.FontResourcesParser;
import android.graphics.FontFamily_Delegate;
import android.graphics.Typeface;
import android.graphics.fonts.FontFamily_Builder_Delegate;
import android.graphics.fonts.FontVariationAxis;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Font;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import libcore.util.NativeAllocationRegistry_Delegate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class Typeface_Delegate {
    public static final String SYSTEM_FONTS = "/system/fonts/";
    public static final Map<String, FontFamily_Delegate[]> sGenericNativeFamilies = new HashMap<String, FontFamily_Delegate[]>();
    private static final DelegateManager<Typeface_Delegate> sManager = new DelegateManager<Typeface_Delegate>(Typeface_Delegate.class);
    private static long sFinalizer = -1L;
    private static long sDefaultTypeface;
    private final FontFamily_Delegate[] mFontFamilies;
    private final FontFamily_Builder_Delegate[] mFontFamilyBuilders;
    private final int mStyle;
    private final int mWeight;

    private Typeface_Delegate(FontFamily_Delegate[] fontFamilies, FontFamily_Builder_Delegate[] fontFamilyBuilders, int style2, int weight) {
        this.mFontFamilies = fontFamilies;
        this.mFontFamilyBuilders = fontFamilyBuilders;
        this.mStyle = style2;
        this.mWeight = weight;
    }

    public static Typeface_Delegate getDelegate(long nativeTypeface) {
        return sManager.getDelegate(nativeTypeface);
    }

    @LayoutlibDelegate
    static synchronized long nativeCreateFromTypeface(long native_instance, int style2) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            delegate = sManager.getDelegate(sDefaultTypeface);
        }
        if (delegate == null) {
            return 0L;
        }
        return sManager.addNewDelegate(new Typeface_Delegate(delegate.mFontFamilies, delegate.mFontFamilyBuilders, style2, delegate.mWeight));
    }

    @LayoutlibDelegate
    static long nativeCreateFromTypefaceWithExactStyle(long native_instance, int weight, boolean italic) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            delegate = sManager.getDelegate(sDefaultTypeface);
        }
        if (delegate == null) {
            return 0L;
        }
        int style2 = weight >= 600 ? (italic ? 3 : 1) : (italic ? 2 : 0);
        return sManager.addNewDelegate(new Typeface_Delegate(delegate.mFontFamilies, delegate.mFontFamilyBuilders, style2, weight));
    }

    @LayoutlibDelegate
    static synchronized long nativeCreateFromTypefaceWithVariation(long native_instance, List<FontVariationAxis> axes) {
        long newInstance = Typeface_Delegate.nativeCreateFromTypeface(native_instance, 0);
        if (newInstance != 0L) {
            Bridge.getLog().fidelityWarning("unsupported", "nativeCreateFromTypefaceWithVariation is not supported", null, null);
        }
        return newInstance;
    }

    @LayoutlibDelegate
    static synchronized int[] nativeGetSupportedAxes(long native_instance) {
        return null;
    }

    @LayoutlibDelegate
    static long nativeCreateWeightAlias(long native_instance, int weight) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            delegate = sManager.getDelegate(sDefaultTypeface);
        }
        if (delegate == null) {
            return 0L;
        }
        Typeface_Delegate weightAlias = new Typeface_Delegate(delegate.mFontFamilies, delegate.mFontFamilyBuilders, delegate.mStyle, weight);
        return sManager.addNewDelegate(weightAlias);
    }

    @LayoutlibDelegate
    static synchronized long nativeCreateFromArray(long[] familyArray, int weight, int italic) {
        ArrayList<FontFamily_Delegate> fontFamilies = new ArrayList<FontFamily_Delegate>();
        ArrayList<FontFamily_Builder_Delegate> fontFamilyBuilders = new ArrayList<FontFamily_Builder_Delegate>();
        for (long aFamilyArray : familyArray) {
            try {
                fontFamilies.add(FontFamily_Delegate.getDelegate(aFamilyArray));
            }
            catch (ClassCastException e) {
                fontFamilyBuilders.add(FontFamily_Builder_Delegate.getDelegate(aFamilyArray));
            }
        }
        if (weight == -1) {
            weight = 400;
        }
        if (italic == -1) {
            italic = 0;
        }
        int style2 = weight >= 600 ? (italic == 1 ? 3 : 1) : (italic == 1 ? 2 : 0);
        Typeface_Delegate delegate = new Typeface_Delegate(fontFamilies.toArray(new FontFamily_Delegate[0]), fontFamilyBuilders.toArray(new FontFamily_Builder_Delegate[0]), style2, weight);
        return sManager.addNewDelegate(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nativeGetReleaseFunc() {
        Class<Typeface_Delegate> clazz = Typeface_Delegate.class;
        synchronized (Typeface_Delegate.class) {
            if (sFinalizer == -1L) {
                sFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFinalizer;
        }
    }

    @LayoutlibDelegate
    static int nativeGetStyle(long native_instance) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            return 0;
        }
        return delegate.mStyle;
    }

    @LayoutlibDelegate
    static void nativeSetDefault(long native_instance) {
        sDefaultTypeface = native_instance;
    }

    @LayoutlibDelegate
    static int nativeGetWeight(long native_instance) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            return 0;
        }
        return delegate.mWeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromDisk(BridgeContext context, String path, boolean isFramework) {
        Typeface typeface = Typeface.findFromCache(context.getAssets(), path);
        if (typeface != null) {
            return typeface;
        }
        String lowerCaseValue = path.toLowerCase();
        if (lowerCaseValue.endsWith(".xml")) {
            Boolean psiParserSupport = (Boolean)context.getLayoutlibCallback().getFlag(RenderParamsFlags.FLAG_KEY_XML_FILE_PARSER_SUPPORT);
            XmlPullParser parser = psiParserSupport != null && psiParserSupport != false ? context.getLayoutlibCallback().createXmlParserForPsiFile(path) : context.getLayoutlibCallback().createXmlParserForFile(path);
            if (parser != null) {
                BridgeXmlBlockParser blockParser = new BridgeXmlBlockParser(parser, context, ResourceNamespace.fromBoolean((boolean)isFramework));
                try {
                    FontResourcesParser.FamilyResourceEntry entry = FontResourcesParser.parse(blockParser, context.getResources());
                    typeface = Typeface.createFromResources(entry, context.getAssets(), path);
                }
                catch (IOException | XmlPullParserException e) {
                    Bridge.getLog().error(null, "Failed to parse file " + path, e, null);
                }
                finally {
                    blockParser.ensurePopped();
                }
            } else {
                Bridge.getLog().error("broken", String.format("File %s does not exist (or is not a file)", path), null);
            }
        } else {
            typeface = new Typeface.Builder(context.getAssets(), path).build();
        }
        return typeface;
    }

    @LayoutlibDelegate
    static Typeface create(String familyName, int style2) {
        if (familyName != null && Files.exists(Paths.get(familyName, new String[0]), new LinkOption[0])) {
            return Typeface_Delegate.createFromDisk(RenderAction.getCurrentContext(), familyName, false);
        }
        return Typeface.create_Original(familyName, style2);
    }

    @LayoutlibDelegate
    static Typeface create(Typeface family, int style2) {
        return Typeface.create_Original(family, style2);
    }

    @LayoutlibDelegate
    static Typeface create(Typeface family, int style2, boolean isItalic) {
        return Typeface.create_Original(family, style2, isItalic);
    }

    @LayoutlibDelegate
    static void nativeRegisterGenericFamily(String str, long nativePtr) {
        Typeface_Delegate delegate = sManager.getDelegate(nativePtr);
        if (delegate == null) {
            return;
        }
        sGenericNativeFamilies.put(str, delegate.mFontFamilies);
    }

    public Iterable<Font> getFonts(FontFamily_Delegate.FontVariant variant) {
        assert (variant != FontFamily_Delegate.FontVariant.NONE);
        return new FontsIterator(this.mFontFamilies, this.mFontFamilyBuilders, variant, this.mWeight, this.mStyle);
    }

    private static class FontsIterator
    implements Iterator<Font>,
    Iterable<Font> {
        private final FontFamily_Delegate[] fontFamilies;
        private final FontFamily_Builder_Delegate[] fontFamilyBuilders;
        private final int weight;
        private final boolean isItalic;
        private final FontFamily_Delegate.FontVariant variant;
        private int index = 0;

        private FontsIterator(FontFamily_Delegate[] fontFamilies, FontFamily_Builder_Delegate[] fontFamilyBuilders, FontFamily_Delegate.FontVariant variant, int weight, int style2) {
            int boldExtraWeight = (style2 & 1) == 0 ? 0 : 300;
            this.weight = Math.min(Math.max(100, weight + 50 + boldExtraWeight), 1000);
            this.isItalic = (style2 & 2) != 0;
            this.fontFamilies = fontFamilies;
            this.fontFamilyBuilders = fontFamilyBuilders;
            this.variant = variant;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.fontFamilies.length + this.fontFamilyBuilders.length;
        }

        @Override
        public Font next() {
            Object ffd2;
            FontFamily_Delegate.FontVariant ffdVariant;
            Font font;
            Object ffd;
            if (this.index < this.fontFamilies.length) {
                if ((ffd = this.fontFamilies[this.index++]) == null || !((FontFamily_Delegate)ffd).isValid()) {
                    return null;
                }
                font = ((FontFamily_Delegate)ffd).getFont(this.weight, this.isItalic);
                ffdVariant = ((FontFamily_Delegate)ffd).getVariant();
            } else {
                if ((ffd = this.fontFamilyBuilders[this.index++ - this.fontFamilies.length]) == null) {
                    return null;
                }
                font = ((FontFamily_Builder_Delegate)ffd).getFont(this.weight, this.isItalic);
                ffdVariant = ((FontFamily_Builder_Delegate)ffd).getVariant();
            }
            if (font == null) {
                return null;
            }
            if (ffdVariant == FontFamily_Delegate.FontVariant.NONE || ffdVariant == this.variant) {
                return font;
            }
            if (this.index < this.fontFamilies.length) {
                assert (this.index < this.fontFamilies.length - 1);
                ffd2 = this.fontFamilies[this.index++];
                assert (ffd2 != null);
                return ((FontFamily_Delegate)ffd2).getFont(this.weight, this.isItalic);
            }
            assert (this.index < this.fontFamilies.length + this.fontFamilyBuilders.length - 1);
            ffd2 = this.fontFamilyBuilders[this.index++ - this.fontFamilies.length];
            assert (ffd2 != null);
            return ((FontFamily_Builder_Delegate)ffd2).getFont(this.weight, this.isItalic);
        }

        @Override
        public Iterator<Font> iterator() {
            return this;
        }

        @Override
        public Spliterator<Font> spliterator() {
            return Spliterators.spliterator(this.iterator(), (long)(this.fontFamilies.length + this.fontFamilyBuilders.length), 1088);
        }
    }
}

