/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.fonts.Font;
import android.graphics.fonts.FontFamily_Builder_Delegate;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import java.util.ArrayList;
import java.util.HashSet;
import libcore.util.NativeAllocationRegistry;

public class FontFamily {
    private static final String TAG = "FontFamily";
    private final ArrayList<Font> mFonts;
    private final long mNativePtr;

    private FontFamily(ArrayList<Font> fonts, long ptr) {
        this.mFonts = fonts;
        this.mNativePtr = ptr;
    }

    public Font getFont(int index) {
        return this.mFonts.get(index);
    }

    public int getSize() {
        return this.mFonts.size();
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    public static class Builder {
        private static final NativeAllocationRegistry sFamilyRegistory = NativeAllocationRegistry.createMalloced(FontFamily.class.getClassLoader(), Builder.nGetReleaseNativeFamily());
        private final ArrayList<Font> mFonts = new ArrayList();
        private final HashSet<Integer> mStyleHashSet = new HashSet();

        public Builder(Font font) {
            Preconditions.checkNotNull(font, "font can not be null");
            this.mStyleHashSet.add(Builder.makeStyleIdentifier(font));
            this.mFonts.add(font);
        }

        public Builder addFont(Font font) {
            Preconditions.checkNotNull(font, "font can not be null");
            if (!this.mStyleHashSet.add(Builder.makeStyleIdentifier(font))) {
                throw new IllegalArgumentException(font + " has already been added");
            }
            this.mFonts.add(font);
            return this;
        }

        public FontFamily build() {
            return this.build("", 0, true);
        }

        public FontFamily build(String langTags, int variant, boolean isCustomFallback) {
            long builderPtr = Builder.nInitBuilder();
            for (int i = 0; i < this.mFonts.size(); ++i) {
                Builder.nAddFont(builderPtr, this.mFonts.get(i).getNativePtr());
            }
            long ptr = Builder.nBuild(builderPtr, langTags, variant, isCustomFallback);
            FontFamily family = new FontFamily(this.mFonts, ptr);
            sFamilyRegistory.registerNativeAllocation(family, ptr);
            return family;
        }

        private static int makeStyleIdentifier(Font font) {
            return font.getStyle().getWeight() | font.getStyle().getSlant() << 16;
        }

        @LayoutlibDelegate
        private static long nInitBuilder() {
            return FontFamily_Builder_Delegate.nInitBuilder();
        }

        @LayoutlibDelegate
        @CriticalNative
        private static void nAddFont(long l, long l2) {
            FontFamily_Builder_Delegate.nAddFont(l, l2);
        }

        @LayoutlibDelegate
        private static long nBuild(long l, String string2, int n, boolean bl) {
            return FontFamily_Builder_Delegate.nBuild(l, string2, n, bl);
        }

        @LayoutlibDelegate
        @CriticalNative
        private static long nGetReleaseNativeFamily() {
            return FontFamily_Builder_Delegate.nGetReleaseNativeFamily();
        }
    }
}

