/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.FontFamily_Delegate;
import android.graphics.fonts.Font_Builder_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import libcore.util.NativeAllocationRegistry_Delegate;

public class FontFamily_Builder_Delegate {
    private static final DelegateManager<FontFamily_Builder_Delegate> sBuilderManager = new DelegateManager<FontFamily_Builder_Delegate>(FontFamily_Builder_Delegate.class);
    private static long sFontFamilyFinalizer = -1L;
    private Map<FontFamily_Delegate.FontInfo, Font> mFonts = new LinkedHashMap<FontFamily_Delegate.FontInfo, Font>();
    private FontFamily_Delegate.FontVariant mVariant;
    private boolean mIsCustomFallback;

    @LayoutlibDelegate
    static long nInitBuilder() {
        return sBuilderManager.addNewDelegate(new FontFamily_Builder_Delegate());
    }

    @LayoutlibDelegate
    static void nAddFont(long builderPtr, long fontPtr) {
        FontFamily_Builder_Delegate familyBuilder = sBuilderManager.getDelegate(builderPtr);
        Font_Builder_Delegate fontBuilder = Font_Builder_Delegate.sBuilderManager.getDelegate(fontPtr);
        if (familyBuilder == null || fontBuilder == null) {
            return;
        }
        Font font = fontBuilder.filePath.equals("") ? FontFamily_Builder_Delegate.loadFontBuffer(fontBuilder.mBuffer) : FontFamily_Builder_Delegate.loadFontPath(fontBuilder.filePath);
        if (font != null) {
            familyBuilder.addFont(font, fontBuilder.mWeight, fontBuilder.mItalic);
        }
    }

    @LayoutlibDelegate
    static long nBuild(long builderPtr, String langTags, int variant, boolean isCustomFallback) {
        FontFamily_Builder_Delegate builder = sBuilderManager.getDelegate(builderPtr);
        if (builder != null) {
            assert (variant < 3);
            builder.mVariant = FontFamily_Delegate.FontVariant.values()[variant];
            builder.mIsCustomFallback = isCustomFallback;
        }
        return builderPtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nGetReleaseNativeFamily() {
        Class<Font_Builder_Delegate> clazz = Font_Builder_Delegate.class;
        synchronized (Font_Builder_Delegate.class) {
            if (sFontFamilyFinalizer == -1L) {
                sFontFamilyFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sBuilderManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFontFamilyFinalizer;
        }
    }

    public static FontFamily_Builder_Delegate getDelegate(long nativeFontFamily) {
        return sBuilderManager.getDelegate(nativeFontFamily);
    }

    public Font getFont(int desiredWeight, boolean isItalic) {
        FontFamily_Delegate.FontInfo desiredStyle = new FontFamily_Delegate.FontInfo();
        desiredStyle.mWeight = desiredWeight;
        desiredStyle.mIsItalic = isItalic;
        Font cachedFont = this.mFonts.get(desiredStyle);
        if (cachedFont != null) {
            return cachedFont;
        }
        FontFamily_Delegate.FontInfo bestFont = null;
        if (this.mFonts.size() == 1) {
            bestFont = this.mFonts.keySet().iterator().next();
        } else {
            int bestMatch = Integer.MAX_VALUE;
            for (FontFamily_Delegate.FontInfo font : this.mFonts.keySet()) {
                int match = FontFamily_Delegate.computeMatch(font, desiredStyle);
                if (match >= bestMatch) continue;
                bestMatch = match;
                bestFont = font;
                if (bestMatch != 0) continue;
                break;
            }
        }
        if (bestFont == null) {
            return null;
        }
        FontFamily_Delegate.deriveFont(bestFont, desiredStyle);
        this.addFont(desiredStyle);
        return desiredStyle.mFont;
    }

    public FontFamily_Delegate.FontVariant getVariant() {
        return this.mVariant;
    }

    private void addFont(Font font, int weight, boolean italic) {
        FontFamily_Delegate.FontInfo fontInfo = new FontFamily_Delegate.FontInfo();
        fontInfo.mFont = font;
        fontInfo.mWeight = weight;
        fontInfo.mIsItalic = italic;
        this.addFont(fontInfo);
    }

    private void addFont(FontFamily_Delegate.FontInfo fontInfo) {
        this.mFonts.putIfAbsent(fontInfo, fontInfo.mFont);
    }

    private static Font loadFontBuffer(ByteBuffer buffer) {
        try {
            byte[] byteArray = new byte[buffer.limit()];
            buffer.get(byteArray);
            buffer.rewind();
            return Font.createFont(0, new ByteArrayInputStream(byteArray));
        }
        catch (Exception e) {
            Bridge.getLog().fidelityWarning("broken", "Unable to load font", (Throwable)e, null);
            return null;
        }
    }

    private static Font loadFontPath(String path) {
        try {
            File file = new File(path);
            return Font.createFont(0, file);
        }
        catch (Exception e) {
            Bridge.getLog().fidelityWarning("broken", "Unable to load font", (Throwable)e, null);
            return null;
        }
    }
}

