/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.text.MeasuredText_Builder_Delegate;
import android.graphics.text.MeasuredText_Delegate;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import libcore.util.NativeAllocationRegistry;

public class MeasuredText {
    private long mNativePtr;
    private boolean mComputeHyphenation;
    private boolean mComputeLayout;
    private char[] mChars;

    private MeasuredText(long ptr, char[] chars, boolean computeHyphenation, boolean computeLayout) {
        this.mNativePtr = ptr;
        this.mChars = chars;
        this.mComputeHyphenation = computeHyphenation;
        this.mComputeLayout = computeLayout;
    }

    public char[] getChars() {
        return this.mChars;
    }

    public float getWidth(int start, int end) {
        Preconditions.checkArgument(0 <= start && start <= this.mChars.length, "start(" + start + ") must be 0 <= start <= " + this.mChars.length);
        Preconditions.checkArgument(0 <= end && end <= this.mChars.length, "end(" + end + ") must be 0 <= end <= " + this.mChars.length);
        Preconditions.checkArgument(start <= end, "start(" + start + ") is larger than end(" + end + ")");
        return MeasuredText.nGetWidth(this.mNativePtr, start, end);
    }

    public int getMemoryUsage() {
        return MeasuredText.nGetMemoryUsage(this.mNativePtr);
    }

    public void getBounds(int start, int end, Rect rect) {
        Preconditions.checkArgument(0 <= start && start <= this.mChars.length, "start(" + start + ") must be 0 <= start <= " + this.mChars.length);
        Preconditions.checkArgument(0 <= end && end <= this.mChars.length, "end(" + end + ") must be 0 <= end <= " + this.mChars.length);
        Preconditions.checkArgument(start <= end, "start(" + start + ") is larger than end(" + end + ")");
        Preconditions.checkNotNull(rect);
        MeasuredText.nGetBounds(this.mNativePtr, this.mChars, start, end, rect);
    }

    public float getCharWidthAt(int offset) {
        Preconditions.checkArgument(0 <= offset && offset < this.mChars.length, "offset(" + offset + ") is larger than text length: " + this.mChars.length);
        return MeasuredText.nGetCharWidthAt(this.mNativePtr, offset);
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetWidth(long l, int n, int n2) {
        return MeasuredText_Delegate.nGetWidth(l, n, n2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static long nGetReleaseFunc() {
        return MeasuredText_Delegate.nGetReleaseFunc();
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetMemoryUsage(long l) {
        return MeasuredText_Delegate.nGetMemoryUsage(l);
    }

    @LayoutlibDelegate
    private static void nGetBounds(long l, char[] cArray, int n, int n2, Rect rect) {
        MeasuredText_Delegate.nGetBounds(l, cArray, n, n2, rect);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetCharWidthAt(long l, int n) {
        return MeasuredText_Delegate.nGetCharWidthAt(l, n);
    }

    static /* synthetic */ long access$000() {
        return MeasuredText.nGetReleaseFunc();
    }

    public static class Builder {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(MeasuredText.class.getClassLoader(), MeasuredText.access$000());
        private long mNativePtr;
        private final char[] mText;
        private boolean mComputeHyphenation = false;
        private boolean mComputeLayout = true;
        private int mCurrentOffset = 0;
        private MeasuredText mHintMt = null;

        public Builder(char[] text) {
            Preconditions.checkNotNull(text);
            this.mText = text;
            this.mNativePtr = Builder.nInitBuilder();
        }

        public Builder(MeasuredText text) {
            Preconditions.checkNotNull(text);
            this.mText = text.mChars;
            this.mNativePtr = Builder.nInitBuilder();
            if (!text.mComputeLayout) {
                throw new IllegalArgumentException("The input MeasuredText must not be created with setComputeLayout(false).");
            }
            this.mComputeHyphenation = text.mComputeHyphenation;
            this.mComputeLayout = text.mComputeLayout;
            this.mHintMt = text;
        }

        public Builder appendStyleRun(Paint paint, int length, boolean isRtl) {
            Preconditions.checkNotNull(paint);
            Preconditions.checkArgument(length > 0, "length can not be negative");
            int end = this.mCurrentOffset + length;
            Preconditions.checkArgument(end <= this.mText.length, "Style exceeds the text length");
            Builder.nAddStyleRun(this.mNativePtr, paint.getNativeInstance(), this.mCurrentOffset, end, isRtl);
            this.mCurrentOffset = end;
            return this;
        }

        public Builder appendReplacementRun(Paint paint, int length, float width) {
            Preconditions.checkArgument(length > 0, "length can not be negative");
            int end = this.mCurrentOffset + length;
            Preconditions.checkArgument(end <= this.mText.length, "Replacement exceeds the text length");
            Builder.nAddReplacementRun(this.mNativePtr, paint.getNativeInstance(), this.mCurrentOffset, end, width);
            this.mCurrentOffset = end;
            return this;
        }

        public Builder setComputeHyphenation(boolean computeHyphenation) {
            this.mComputeHyphenation = computeHyphenation;
            return this;
        }

        public Builder setComputeLayout(boolean computeLayout) {
            this.mComputeLayout = computeLayout;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MeasuredText build() {
            this.ensureNativePtrNoReuse();
            if (this.mCurrentOffset != this.mText.length) {
                throw new IllegalStateException("Style info has not been provided for all text.");
            }
            if (this.mHintMt != null && this.mHintMt.mComputeHyphenation != this.mComputeHyphenation) {
                throw new IllegalArgumentException("The hyphenation configuration is different from given hint MeasuredText");
            }
            try {
                long hintPtr = this.mHintMt == null ? 0L : this.mHintMt.getNativePtr();
                long ptr = Builder.nBuildMeasuredText(this.mNativePtr, hintPtr, this.mText, this.mComputeHyphenation, this.mComputeLayout);
                MeasuredText res = new MeasuredText(ptr, this.mText, this.mComputeHyphenation, this.mComputeLayout);
                sRegistry.registerNativeAllocation(res, ptr);
                MeasuredText measuredText = res;
                return measuredText;
            }
            finally {
                Builder.nFreeBuilder(this.mNativePtr);
                this.mNativePtr = 0L;
            }
        }

        private void ensureNativePtrNoReuse() {
            if (this.mNativePtr == 0L) {
                throw new IllegalStateException("Builder can not be reused.");
            }
        }

        @LayoutlibDelegate
        private static long nInitBuilder() {
            return MeasuredText_Builder_Delegate.nInitBuilder();
        }

        @LayoutlibDelegate
        private static void nAddStyleRun(long l, long l2, int n, int n2, boolean bl) {
            MeasuredText_Builder_Delegate.nAddStyleRun(l, l2, n, n2, bl);
        }

        @LayoutlibDelegate
        private static void nAddReplacementRun(long l, long l2, int n, int n2, float f) {
            MeasuredText_Builder_Delegate.nAddReplacementRun(l, l2, n, n2, f);
        }

        @LayoutlibDelegate
        private static long nBuildMeasuredText(long l, long l2, char[] cArray, boolean bl, boolean bl2) {
            return MeasuredText_Builder_Delegate.nBuildMeasuredText(l, l2, cArray, bl, bl2);
        }

        @LayoutlibDelegate
        private static void nFreeBuilder(long l) {
            MeasuredText_Builder_Delegate.nFreeBuilder(l);
        }
    }
}

