/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;
import android.location.GnssSingleSatCorrection;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SystemApi
public class GnssMeasurementCorrections
implements Parcelable {
    private final double mLatitudeDegrees;
    private final double mLongitudeDegrees;
    private final double mAltitudeMeters;
    private final double mHorizontalPositionUncertaintyMeters;
    private final double mVerticalPositionUncertaintyMeters;
    private final long mToaGpsNanosecondsOfWeek;
    private final List<GnssSingleSatCorrection> mSingleSatCorrectionList;
    public static final Parcelable.Creator<GnssMeasurementCorrections> CREATOR = new Parcelable.Creator<GnssMeasurementCorrections>(){

        @Override
        public GnssMeasurementCorrections createFromParcel(Parcel parcel) {
            Builder gnssMeasurementCorrectons = new Builder().setLatitudeDegrees(parcel.readDouble()).setLongitudeDegrees(parcel.readDouble()).setAltitudeMeters(parcel.readDouble()).setHorizontalPositionUncertaintyMeters(parcel.readDouble()).setVerticalPositionUncertaintyMeters(parcel.readDouble()).setToaGpsNanosecondsOfWeek(parcel.readLong());
            ArrayList<GnssSingleSatCorrection> singleSatCorrectionList = new ArrayList<GnssSingleSatCorrection>();
            parcel.readTypedList(singleSatCorrectionList, GnssSingleSatCorrection.CREATOR);
            gnssMeasurementCorrectons.setSingleSatelliteCorrectionList(singleSatCorrectionList);
            return gnssMeasurementCorrectons.build();
        }

        public GnssMeasurementCorrections[] newArray(int i) {
            return new GnssMeasurementCorrections[i];
        }
    };

    private GnssMeasurementCorrections(Builder builder) {
        this.mLatitudeDegrees = builder.mLatitudeDegrees;
        this.mLongitudeDegrees = builder.mLongitudeDegrees;
        this.mAltitudeMeters = builder.mAltitudeMeters;
        this.mHorizontalPositionUncertaintyMeters = builder.mHorizontalPositionUncertaintyMeters;
        this.mVerticalPositionUncertaintyMeters = builder.mVerticalPositionUncertaintyMeters;
        this.mToaGpsNanosecondsOfWeek = builder.mToaGpsNanosecondsOfWeek;
        List singleSatCorrList = builder.mSingleSatCorrectionList;
        Preconditions.checkArgument(singleSatCorrList != null && !singleSatCorrList.isEmpty());
        this.mSingleSatCorrectionList = Collections.unmodifiableList(new ArrayList(singleSatCorrList));
    }

    public double getLatitudeDegrees() {
        return this.mLatitudeDegrees;
    }

    public double getLongitudeDegrees() {
        return this.mLongitudeDegrees;
    }

    public double getAltitudeMeters() {
        return this.mAltitudeMeters;
    }

    public double getHorizontalPositionUncertaintyMeters() {
        return this.mHorizontalPositionUncertaintyMeters;
    }

    public double getVerticalPositionUncertaintyMeters() {
        return this.mVerticalPositionUncertaintyMeters;
    }

    public long getToaGpsNanosecondsOfWeek() {
        return this.mToaGpsNanosecondsOfWeek;
    }

    public List<GnssSingleSatCorrection> getSingleSatelliteCorrectionList() {
        return this.mSingleSatCorrectionList;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String format = "   %-29s = %s\n";
        StringBuilder builder = new StringBuilder("GnssMeasurementCorrections:\n");
        builder.append(String.format("   %-29s = %s\n", "LatitudeDegrees = ", this.mLatitudeDegrees));
        builder.append(String.format("   %-29s = %s\n", "LongitudeDegrees = ", this.mLongitudeDegrees));
        builder.append(String.format("   %-29s = %s\n", "AltitudeMeters = ", this.mAltitudeMeters));
        builder.append(String.format("   %-29s = %s\n", "HorizontalPositionUncertaintyMeters = ", this.mHorizontalPositionUncertaintyMeters));
        builder.append(String.format("   %-29s = %s\n", "VerticalPositionUncertaintyMeters = ", this.mVerticalPositionUncertaintyMeters));
        builder.append(String.format("   %-29s = %s\n", "ToaGpsNanosecondsOfWeek = ", this.mToaGpsNanosecondsOfWeek));
        builder.append(String.format("   %-29s = %s\n", "mSingleSatCorrectionList = ", this.mSingleSatCorrectionList));
        return builder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeDouble(this.mLatitudeDegrees);
        parcel.writeDouble(this.mLongitudeDegrees);
        parcel.writeDouble(this.mAltitudeMeters);
        parcel.writeDouble(this.mHorizontalPositionUncertaintyMeters);
        parcel.writeDouble(this.mVerticalPositionUncertaintyMeters);
        parcel.writeLong(this.mToaGpsNanosecondsOfWeek);
        parcel.writeTypedList(this.mSingleSatCorrectionList);
    }

    public static class Builder {
        private double mLatitudeDegrees;
        private double mLongitudeDegrees;
        private double mAltitudeMeters;
        private double mHorizontalPositionUncertaintyMeters;
        private double mVerticalPositionUncertaintyMeters;
        private long mToaGpsNanosecondsOfWeek;
        private List<GnssSingleSatCorrection> mSingleSatCorrectionList;

        public Builder setLatitudeDegrees(double latitudeDegrees) {
            this.mLatitudeDegrees = latitudeDegrees;
            return this;
        }

        public Builder setLongitudeDegrees(double longitudeDegrees) {
            this.mLongitudeDegrees = longitudeDegrees;
            return this;
        }

        public Builder setAltitudeMeters(double altitudeMeters) {
            this.mAltitudeMeters = altitudeMeters;
            return this;
        }

        public Builder setHorizontalPositionUncertaintyMeters(double horizontalPositionUncertaintyMeters) {
            this.mHorizontalPositionUncertaintyMeters = horizontalPositionUncertaintyMeters;
            return this;
        }

        public Builder setVerticalPositionUncertaintyMeters(double verticalPositionUncertaintyMeters) {
            this.mVerticalPositionUncertaintyMeters = verticalPositionUncertaintyMeters;
            return this;
        }

        public Builder setToaGpsNanosecondsOfWeek(long toaGpsNanosecondsOfWeek) {
            this.mToaGpsNanosecondsOfWeek = toaGpsNanosecondsOfWeek;
            return this;
        }

        public Builder setSingleSatelliteCorrectionList(List<GnssSingleSatCorrection> singleSatCorrectionList) {
            this.mSingleSatCorrectionList = singleSatCorrectionList;
            return this;
        }

        public GnssMeasurementCorrections build() {
            return new GnssMeasurementCorrections(this);
        }
    }
}

