/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.ImageFormat;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;
import android.hardware.camera2.utils.SurfaceUtils;
import android.media.Image;
import android.media.ImageReader;
import android.media.ImageUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Size;
import android.view.Surface;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.NioUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ImageWriter
implements AutoCloseable {
    private final Object mListenerLock = new Object();
    private OnImageReleasedListener mListener;
    private ListenerHandler mListenerHandler;
    private long mNativeContext;
    private int mWriterFormat;
    private final int mMaxImages;
    private List<Image> mDequeuedImages = new CopyOnWriteArrayList<Image>();
    private int mEstimatedNativeAllocBytes;

    public static ImageWriter newInstance(Surface surface, int maxImages) {
        return new ImageWriter(surface, maxImages, 0);
    }

    public static ImageWriter newInstance(Surface surface, int maxImages, int format) {
        if (!ImageFormat.isPublicFormat(format) && !PixelFormat.isPublicFormat(format)) {
            throw new IllegalArgumentException("Invalid format is specified: " + format);
        }
        return new ImageWriter(surface, maxImages, format);
    }

    protected ImageWriter(Surface surface, int maxImages, int format) {
        if (surface == null || maxImages < 1) {
            throw new IllegalArgumentException("Illegal input argument: surface " + surface + ", maxImages: " + maxImages);
        }
        this.mMaxImages = maxImages;
        if (format == 0) {
            format = SurfaceUtils.getSurfaceFormat(surface);
        }
        this.mNativeContext = this.nativeInit(new WeakReference<ImageWriter>(this), surface, maxImages, format);
        Size surfSize = SurfaceUtils.getSurfaceSize(surface);
        this.mEstimatedNativeAllocBytes = ImageUtils.getEstimatedNativeAllocBytes(surfSize.getWidth(), surfSize.getHeight(), format, 1);
        VMRuntime.getRuntime().registerNativeAllocation(this.mEstimatedNativeAllocBytes);
    }

    public int getMaxImages() {
        return this.mMaxImages;
    }

    public Image dequeueInputImage() {
        if (this.mDequeuedImages.size() >= this.mMaxImages) {
            throw new IllegalStateException("Already dequeued max number of Images " + this.mMaxImages);
        }
        WriterSurfaceImage newImage = new WriterSurfaceImage(this);
        this.nativeDequeueInputImage(this.mNativeContext, newImage);
        this.mDequeuedImages.add(newImage);
        newImage.mIsImageValid = true;
        return newImage;
    }

    public void queueInputImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image shouldn't be null");
        }
        boolean ownedByMe = this.isImageOwnedByMe(image);
        if (ownedByMe && !((WriterSurfaceImage)image).mIsImageValid) {
            throw new IllegalStateException("Image from ImageWriter is invalid");
        }
        if (!ownedByMe) {
            if (!(image.getOwner() instanceof ImageReader)) {
                throw new IllegalArgumentException("Only images from ImageReader can be queued to ImageWriter, other image source is not supported yet!");
            }
            ImageReader prevOwner = (ImageReader)image.getOwner();
            prevOwner.detachImage(image);
            this.attachAndQueueInputImage(image);
            image.close();
            return;
        }
        Rect crop = image.getCropRect();
        this.nativeQueueInputImage(this.mNativeContext, image, image.getTimestamp(), crop.left, crop.top, crop.right, crop.bottom, image.getTransform(), image.getScalingMode());
        if (ownedByMe) {
            this.mDequeuedImages.remove(image);
            WriterSurfaceImage wi = (WriterSurfaceImage)image;
            wi.clearSurfacePlanes();
            wi.mIsImageValid = false;
        }
    }

    public int getFormat() {
        return this.mWriterFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnImageReleasedListener(OnImageReleasedListener listener, Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            if (listener != null) {
                Looper looper;
                Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
                if (looper == null) {
                    throw new IllegalArgumentException("handler is null but the current thread is not a looper");
                }
                if (this.mListenerHandler == null || this.mListenerHandler.getLooper() != looper) {
                    this.mListenerHandler = new ListenerHandler(looper);
                }
                this.mListener = listener;
            } else {
                this.mListener = null;
                this.mListenerHandler = null;
            }
        }
    }

    @Override
    public void close() {
        this.setOnImageReleasedListener(null, null);
        for (Image image : this.mDequeuedImages) {
            image.close();
        }
        this.mDequeuedImages.clear();
        this.nativeClose(this.mNativeContext);
        this.mNativeContext = 0L;
        if (this.mEstimatedNativeAllocBytes > 0) {
            VMRuntime.getRuntime().registerNativeFree(this.mEstimatedNativeAllocBytes);
            this.mEstimatedNativeAllocBytes = 0;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void attachAndQueueInputImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image shouldn't be null");
        }
        if (this.isImageOwnedByMe(image)) {
            throw new IllegalArgumentException("Can not attach an image that is owned ImageWriter already");
        }
        if (!image.isAttachable()) {
            throw new IllegalStateException("Image was not detached from last owner, or image  is not detachable");
        }
        Rect crop = image.getCropRect();
        this.nativeAttachAndQueueImage(this.mNativeContext, image.getNativeContext(), image.getFormat(), image.getTimestamp(), crop.left, crop.top, crop.right, crop.bottom, image.getTransform(), image.getScalingMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postEventFromNative(Object selfRef) {
        ListenerHandler handler;
        WeakReference weakSelf = (WeakReference)selfRef;
        ImageWriter iw = (ImageWriter)weakSelf.get();
        if (iw == null) {
            return;
        }
        Object object = iw.mListenerLock;
        synchronized (object) {
            handler = iw.mListenerHandler;
        }
        if (handler != null) {
            handler.sendEmptyMessage(0);
        }
    }

    private void abortImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image shouldn't be null");
        }
        if (!this.mDequeuedImages.contains(image)) {
            throw new IllegalStateException("It is illegal to abort some image that is not dequeued yet");
        }
        WriterSurfaceImage wi = (WriterSurfaceImage)image;
        if (!wi.mIsImageValid) {
            return;
        }
        this.cancelImage(this.mNativeContext, image);
        this.mDequeuedImages.remove(image);
        wi.clearSurfacePlanes();
        wi.mIsImageValid = false;
    }

    private boolean isImageOwnedByMe(Image image) {
        if (!(image instanceof WriterSurfaceImage)) {
            return false;
        }
        WriterSurfaceImage wi = (WriterSurfaceImage)image;
        return wi.getOwner() == this;
    }

    private synchronized long nativeInit(Object object, Surface surface, int n, int n2) {
        return OverrideMethod.invokeL("android.media.ImageWriter#nativeInit(Ljava/lang/Object;Landroid/view/Surface;II)J", true, this);
    }

    private synchronized void nativeClose(long l) {
        OverrideMethod.invokeV("android.media.ImageWriter#nativeClose(J)V", true, this);
    }

    private synchronized void nativeDequeueInputImage(long l, Image image) {
        OverrideMethod.invokeV("android.media.ImageWriter#nativeDequeueInputImage(JLandroid/media/Image;)V", true, this);
    }

    private synchronized void nativeQueueInputImage(long l, Image image, long l2, int n, int n2, int n3, int n4, int n5, int n6) {
        OverrideMethod.invokeV("android.media.ImageWriter#nativeQueueInputImage(JLandroid/media/Image;JIIIIII)V", true, this);
    }

    private synchronized int nativeAttachAndQueueImage(long l, long l2, int n, long l3, int n2, int n3, int n4, int n5, int n6, int n7) {
        return OverrideMethod.invokeI("android.media.ImageWriter#nativeAttachAndQueueImage(JJIJIIIIII)I", true, this);
    }

    private synchronized void cancelImage(long l, Image image) {
        OverrideMethod.invokeV("android.media.ImageWriter#cancelImage(JLandroid/media/Image;)V", true, this);
    }

    private static void nativeClassInit() {
        OverrideMethod.invokeV("android.media.ImageWriter#nativeClassInit()V", true, null);
    }

    static {
        System.loadLibrary("media_jni");
        ImageWriter.nativeClassInit();
    }

    private static class WriterSurfaceImage
    extends Image {
        private ImageWriter mOwner;
        private long mNativeBuffer;
        private int mNativeFenceFd = -1;
        private SurfacePlane[] mPlanes;
        private int mHeight = -1;
        private int mWidth = -1;
        private int mFormat = -1;
        private final long DEFAULT_TIMESTAMP = Long.MIN_VALUE;
        private long mTimestamp = Long.MIN_VALUE;
        private int mTransform = 0;
        private int mScalingMode = 0;

        public WriterSurfaceImage(ImageWriter writer) {
            this.mOwner = writer;
        }

        @Override
        public int getFormat() {
            this.throwISEIfImageIsInvalid();
            if (this.mFormat == -1) {
                this.mFormat = this.nativeGetFormat();
            }
            return this.mFormat;
        }

        @Override
        public int getWidth() {
            this.throwISEIfImageIsInvalid();
            if (this.mWidth == -1) {
                this.mWidth = this.nativeGetWidth();
            }
            return this.mWidth;
        }

        @Override
        public int getHeight() {
            this.throwISEIfImageIsInvalid();
            if (this.mHeight == -1) {
                this.mHeight = this.nativeGetHeight();
            }
            return this.mHeight;
        }

        @Override
        public int getTransform() {
            this.throwISEIfImageIsInvalid();
            return this.mTransform;
        }

        @Override
        public int getScalingMode() {
            this.throwISEIfImageIsInvalid();
            return this.mScalingMode;
        }

        @Override
        public long getTimestamp() {
            this.throwISEIfImageIsInvalid();
            return this.mTimestamp;
        }

        @Override
        public void setTimestamp(long timestamp) {
            this.throwISEIfImageIsInvalid();
            this.mTimestamp = timestamp;
        }

        @Override
        public HardwareBuffer getHardwareBuffer() {
            this.throwISEIfImageIsInvalid();
            return this.nativeGetHardwareBuffer();
        }

        @Override
        public Image.Plane[] getPlanes() {
            this.throwISEIfImageIsInvalid();
            if (this.mPlanes == null) {
                int numPlanes = ImageUtils.getNumPlanesForFormat(this.getFormat());
                this.mPlanes = this.nativeCreatePlanes(numPlanes, this.getOwner().getFormat());
            }
            return (Image.Plane[])this.mPlanes.clone();
        }

        @Override
        boolean isAttachable() {
            this.throwISEIfImageIsInvalid();
            return false;
        }

        @Override
        ImageWriter getOwner() {
            this.throwISEIfImageIsInvalid();
            return this.mOwner;
        }

        @Override
        long getNativeContext() {
            this.throwISEIfImageIsInvalid();
            return this.mNativeBuffer;
        }

        @Override
        public void close() {
            if (this.mIsImageValid) {
                this.getOwner().abortImage(this);
            }
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void clearSurfacePlanes() {
            if (this.mIsImageValid && this.mPlanes != null) {
                for (int i = 0; i < this.mPlanes.length; ++i) {
                    if (this.mPlanes[i] == null) continue;
                    this.mPlanes[i].clearBuffer();
                    this.mPlanes[i] = null;
                }
            }
        }

        private synchronized SurfacePlane[] nativeCreatePlanes(int n, int n2) {
            return (SurfacePlane[])OverrideMethod.invokeA("android.media.ImageWriter$WriterSurfaceImage#nativeCreatePlanes(II)[Landroid/media/ImageWriter$WriterSurfaceImage$SurfacePlane;", true, this);
        }

        private synchronized int nativeGetWidth() {
            return OverrideMethod.invokeI("android.media.ImageWriter$WriterSurfaceImage#nativeGetWidth()I", true, this);
        }

        private synchronized int nativeGetHeight() {
            return OverrideMethod.invokeI("android.media.ImageWriter$WriterSurfaceImage#nativeGetHeight()I", true, this);
        }

        private synchronized int nativeGetFormat() {
            return OverrideMethod.invokeI("android.media.ImageWriter$WriterSurfaceImage#nativeGetFormat()I", true, this);
        }

        private synchronized HardwareBuffer nativeGetHardwareBuffer() {
            return (HardwareBuffer)OverrideMethod.invokeA("android.media.ImageWriter$WriterSurfaceImage#nativeGetHardwareBuffer()Landroid/hardware/HardwareBuffer;", true, this);
        }

        private class SurfacePlane
        extends Image.Plane {
            private ByteBuffer mBuffer;
            private final int mPixelStride;
            private final int mRowStride;

            private SurfacePlane(int rowStride, int pixelStride, ByteBuffer buffer) {
                this.mRowStride = rowStride;
                this.mPixelStride = pixelStride;
                this.mBuffer = buffer;
                this.mBuffer.order(ByteOrder.nativeOrder());
            }

            @Override
            public int getRowStride() {
                WriterSurfaceImage.this.throwISEIfImageIsInvalid();
                return this.mRowStride;
            }

            @Override
            public int getPixelStride() {
                WriterSurfaceImage.this.throwISEIfImageIsInvalid();
                return this.mPixelStride;
            }

            @Override
            public ByteBuffer getBuffer() {
                WriterSurfaceImage.this.throwISEIfImageIsInvalid();
                return this.mBuffer;
            }

            private void clearBuffer() {
                if (this.mBuffer == null) {
                    return;
                }
                if (this.mBuffer.isDirect()) {
                    NioUtils.freeDirectBuffer((ByteBuffer)this.mBuffer);
                }
                this.mBuffer = null;
            }
        }
    }

    private class ListenerHandler
    extends Handler {
        public ListenerHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            OnImageReleasedListener listener;
            Object object = ImageWriter.this.mListenerLock;
            synchronized (object) {
                listener = ImageWriter.this.mListener;
            }
            if (listener != null) {
                listener.onImageReleased(ImageWriter.this);
            }
        }
    }

    public static interface OnImageReleasedListener {
        public void onImageReleased(ImageWriter var1);
    }
}

