/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;

public class WifiP2pServiceRequest
implements Parcelable {
    private int mProtocolType;
    private int mLength;
    private int mTransId;
    private String mQuery;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<WifiP2pServiceRequest> CREATOR = new Parcelable.Creator<WifiP2pServiceRequest>(){

        @Override
        public WifiP2pServiceRequest createFromParcel(Parcel in) {
            int servType = in.readInt();
            int length = in.readInt();
            int transId = in.readInt();
            String query = in.readString();
            return new WifiP2pServiceRequest(servType, length, transId, query);
        }

        public WifiP2pServiceRequest[] newArray(int size) {
            return new WifiP2pServiceRequest[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    protected WifiP2pServiceRequest(int protocolType, String query) {
        this.validateQuery(query);
        this.mProtocolType = protocolType;
        this.mQuery = query;
        this.mLength = query != null ? query.length() / 2 + 2 : 2;
    }

    private WifiP2pServiceRequest(int serviceType, int length, int transId, String query) {
        this.mProtocolType = serviceType;
        this.mLength = length;
        this.mTransId = transId;
        this.mQuery = query;
    }

    public int getTransactionId() {
        return this.mTransId;
    }

    public void setTransactionId(int id2) {
        this.mTransId = id2;
    }

    public String getSupplicantQuery() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format(Locale.US, "%02x", this.mLength & 0xFF));
        sb.append(String.format(Locale.US, "%02x", this.mLength >> 8 & 0xFF));
        sb.append(String.format(Locale.US, "%02x", this.mProtocolType));
        sb.append(String.format(Locale.US, "%02x", this.mTransId));
        if (this.mQuery != null) {
            sb.append(this.mQuery);
        }
        return sb.toString();
    }

    private void validateQuery(String query) {
        char[] chars;
        if (query == null) {
            return;
        }
        int UNSIGNED_SHORT_MAX = 65535;
        if (query.length() % 2 == 1) {
            throw new IllegalArgumentException("query size is invalid. query=" + query);
        }
        if (query.length() / 2 > UNSIGNED_SHORT_MAX) {
            throw new IllegalArgumentException("query size is too large. len=" + query.length());
        }
        query = query.toLowerCase(Locale.ROOT);
        for (char c : chars = query.toCharArray()) {
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') continue;
            throw new IllegalArgumentException("query should be hex string. query=" + query);
        }
    }

    public static WifiP2pServiceRequest newInstance(int protocolType, String queryData) {
        return new WifiP2pServiceRequest(protocolType, queryData);
    }

    public static WifiP2pServiceRequest newInstance(int protocolType) {
        return new WifiP2pServiceRequest(protocolType, null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WifiP2pServiceRequest)) {
            return false;
        }
        WifiP2pServiceRequest req = (WifiP2pServiceRequest)o;
        if (req.mProtocolType != this.mProtocolType || req.mLength != this.mLength) {
            return false;
        }
        if (req.mQuery == null && this.mQuery == null) {
            return true;
        }
        if (req.mQuery != null) {
            return req.mQuery.equals(this.mQuery);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.mProtocolType;
        result = 31 * result + this.mLength;
        result = 31 * result + (this.mQuery == null ? 0 : this.mQuery.hashCode());
        return result;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mProtocolType);
        dest.writeInt(this.mLength);
        dest.writeInt(this.mTransId);
        dest.writeString(this.mQuery);
    }
}

