/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.StatsDimensionsValue;
import android.os.StatsLogEventWrapper;

public interface IStatsCompanionService
extends IInterface {
    public void statsdReady() throws RemoteException;

    public void setAnomalyAlarm(long var1) throws RemoteException;

    public void cancelAnomalyAlarm() throws RemoteException;

    public void setPullingAlarm(long var1) throws RemoteException;

    public void cancelPullingAlarm() throws RemoteException;

    public void setAlarmForSubscriberTriggering(long var1) throws RemoteException;

    public void cancelAlarmForSubscriberTriggering() throws RemoteException;

    public StatsLogEventWrapper[] pullData(int var1) throws RemoteException;

    public void sendDataBroadcast(IBinder var1, long var2) throws RemoteException;

    public void sendActiveConfigsChangedBroadcast(IBinder var1, long[] var2) throws RemoteException;

    public void sendSubscriberBroadcast(IBinder var1, long var2, long var4, long var6, long var8, String[] var10, StatsDimensionsValue var11) throws RemoteException;

    public void triggerUidSnapshot() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatsCompanionService {
        private static final String DESCRIPTOR = "android.os.IStatsCompanionService";
        static final int TRANSACTION_statsdReady = 1;
        static final int TRANSACTION_setAnomalyAlarm = 2;
        static final int TRANSACTION_cancelAnomalyAlarm = 3;
        static final int TRANSACTION_setPullingAlarm = 4;
        static final int TRANSACTION_cancelPullingAlarm = 5;
        static final int TRANSACTION_setAlarmForSubscriberTriggering = 6;
        static final int TRANSACTION_cancelAlarmForSubscriberTriggering = 7;
        static final int TRANSACTION_pullData = 8;
        static final int TRANSACTION_sendDataBroadcast = 9;
        static final int TRANSACTION_sendActiveConfigsChangedBroadcast = 10;
        static final int TRANSACTION_sendSubscriberBroadcast = 11;
        static final int TRANSACTION_triggerUidSnapshot = 12;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IStatsCompanionService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IStatsCompanionService) {
                return (IStatsCompanionService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "statsdReady";
                }
                case 2: {
                    return "setAnomalyAlarm";
                }
                case 3: {
                    return "cancelAnomalyAlarm";
                }
                case 4: {
                    return "setPullingAlarm";
                }
                case 5: {
                    return "cancelPullingAlarm";
                }
                case 6: {
                    return "setAlarmForSubscriberTriggering";
                }
                case 7: {
                    return "cancelAlarmForSubscriberTriggering";
                }
                case 8: {
                    return "pullData";
                }
                case 9: {
                    return "sendDataBroadcast";
                }
                case 10: {
                    return "sendActiveConfigsChangedBroadcast";
                }
                case 11: {
                    return "sendSubscriberBroadcast";
                }
                case 12: {
                    return "triggerUidSnapshot";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    this.statsdReady();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.setAnomalyAlarm(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.cancelAnomalyAlarm();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.setPullingAlarm(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.cancelPullingAlarm();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.setAlarmForSubscriberTriggering(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    this.cancelAlarmForSubscriberTriggering();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Parcelable[] _result = this.pullData(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    long _arg1 = data.readLong();
                    this.sendDataBroadcast(_arg0, _arg1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    long[] _arg1 = data.createLongArray();
                    this.sendActiveConfigsChangedBroadcast(_arg0, _arg1);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    long _arg3 = data.readLong();
                    long _arg4 = data.readLong();
                    String[] _arg5 = data.createStringArray();
                    StatsDimensionsValue _arg6 = 0 != data.readInt() ? StatsDimensionsValue.CREATOR.createFromParcel(data) : null;
                    this.sendSubscriberBroadcast(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    this.triggerUidSnapshot();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IStatsCompanionService impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IStatsCompanionService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IStatsCompanionService {
            private IBinder mRemote;
            public static IStatsCompanionService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void statsdReady() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().statsdReady();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnomalyAlarm(long timestampMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timestampMs);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAnomalyAlarm(timestampMs);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelAnomalyAlarm() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().cancelAnomalyAlarm();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPullingAlarm(long nextPullTimeMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(nextPullTimeMs);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPullingAlarm(nextPullTimeMs);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelPullingAlarm() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().cancelPullingAlarm();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAlarmForSubscriberTriggering(long timestampMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timestampMs);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAlarmForSubscriberTriggering(timestampMs);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelAlarmForSubscriberTriggering() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().cancelAlarmForSubscriberTriggering();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StatsLogEventWrapper[] pullData(int pullCode) throws RemoteException {
                StatsLogEventWrapper[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(pullCode);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        StatsLogEventWrapper[] statsLogEventWrapperArray = Stub.getDefaultImpl().pullData(pullCode);
                        return statsLogEventWrapperArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(StatsLogEventWrapper.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendDataBroadcast(IBinder intentSender, long lastReportTimeNs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(intentSender);
                    _data.writeLong(lastReportTimeNs);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendDataBroadcast(intentSender, lastReportTimeNs);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendActiveConfigsChangedBroadcast(IBinder intentSender, long[] configIds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(intentSender);
                    _data.writeLongArray(configIds);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendActiveConfigsChangedBroadcast(intentSender, configIds);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSubscriberBroadcast(IBinder intentSender, long configUid, long configId, long subscriptionId, long subscriptionRuleId, String[] cookies, StatsDimensionsValue dimensionsValue) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(intentSender);
                    _data.writeLong(configUid);
                    _data.writeLong(configId);
                    _data.writeLong(subscriptionId);
                    _data.writeLong(subscriptionRuleId);
                    _data.writeStringArray(cookies);
                    if (dimensionsValue != null) {
                        _data.writeInt(1);
                        dimensionsValue.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendSubscriberBroadcast(intentSender, configUid, configId, subscriptionId, subscriptionRuleId, cookies, dimensionsValue);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void triggerUidSnapshot() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().triggerUidSnapshot();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStatsCompanionService {
        @Override
        public void statsdReady() throws RemoteException {
        }

        @Override
        public void setAnomalyAlarm(long timestampMs) throws RemoteException {
        }

        @Override
        public void cancelAnomalyAlarm() throws RemoteException {
        }

        @Override
        public void setPullingAlarm(long nextPullTimeMs) throws RemoteException {
        }

        @Override
        public void cancelPullingAlarm() throws RemoteException {
        }

        @Override
        public void setAlarmForSubscriberTriggering(long timestampMs) throws RemoteException {
        }

        @Override
        public void cancelAlarmForSubscriberTriggering() throws RemoteException {
        }

        @Override
        public StatsLogEventWrapper[] pullData(int pullCode) throws RemoteException {
            return null;
        }

        @Override
        public void sendDataBroadcast(IBinder intentSender, long lastReportTimeNs) throws RemoteException {
        }

        @Override
        public void sendActiveConfigsChangedBroadcast(IBinder intentSender, long[] configIds) throws RemoteException {
        }

        @Override
        public void sendSubscriberBroadcast(IBinder intentSender, long configUid, long configId, long subscriptionId, long subscriptionRuleId, String[] cookies, StatsDimensionsValue dimensionsValue) throws RemoteException {
        }

        @Override
        public void triggerUidSnapshot() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

