/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.euicc;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.carrier.CarrierIdentifier;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;

@SystemApi
public class EuiccRulesAuthTable
implements Parcelable {
    public static final int POLICY_RULE_FLAG_CONSENT_REQUIRED = 1;
    private final int[] mPolicyRules;
    private final CarrierIdentifier[][] mCarrierIds;
    private final int[] mPolicyRuleFlags;
    public static final Parcelable.Creator<EuiccRulesAuthTable> CREATOR = new Parcelable.Creator<EuiccRulesAuthTable>(){

        @Override
        public EuiccRulesAuthTable createFromParcel(Parcel source) {
            return new EuiccRulesAuthTable(source);
        }

        public EuiccRulesAuthTable[] newArray(int size) {
            return new EuiccRulesAuthTable[size];
        }
    };

    @VisibleForTesting
    public static boolean match(String mccRule, String mcc) {
        if (mccRule.length() < mcc.length()) {
            return false;
        }
        for (int i = 0; i < mccRule.length(); ++i) {
            if (mccRule.charAt(i) == 'E' || i < mcc.length() && mccRule.charAt(i) == mcc.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private EuiccRulesAuthTable(int[] policyRules, CarrierIdentifier[][] carrierIds, int[] policyRuleFlags) {
        this.mPolicyRules = policyRules;
        this.mCarrierIds = carrierIds;
        this.mPolicyRuleFlags = policyRuleFlags;
    }

    public int findIndex(int policy, CarrierIdentifier carrierId) {
        for (int i = 0; i < this.mPolicyRules.length; ++i) {
            CarrierIdentifier[] carrierIds;
            if ((this.mPolicyRules[i] & policy) == 0 || (carrierIds = this.mCarrierIds[i]) == null || carrierIds.length == 0) continue;
            for (int j = 0; j < carrierIds.length; ++j) {
                String gid;
                CarrierIdentifier ruleCarrierId = carrierIds[j];
                if (!EuiccRulesAuthTable.match(ruleCarrierId.getMcc(), carrierId.getMcc()) || !EuiccRulesAuthTable.match(ruleCarrierId.getMnc(), carrierId.getMnc()) || !TextUtils.isEmpty(gid = ruleCarrierId.getGid1()) && !gid.equals(carrierId.getGid1()) || !TextUtils.isEmpty(gid = ruleCarrierId.getGid2()) && !gid.equals(carrierId.getGid2())) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean hasPolicyRuleFlag(int index, int flag) {
        if (index < 0 || index >= this.mPolicyRules.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (this.mPolicyRuleFlags[index] & flag) != 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeIntArray(this.mPolicyRules);
        for (Parcelable[] parcelableArray : this.mCarrierIds) {
            dest.writeTypedArray(parcelableArray, flags);
        }
        dest.writeIntArray(this.mPolicyRuleFlags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EuiccRulesAuthTable that = (EuiccRulesAuthTable)obj;
        if (this.mCarrierIds.length != that.mCarrierIds.length) {
            return false;
        }
        for (int i = 0; i < this.mCarrierIds.length; ++i) {
            CarrierIdentifier[] carrierIds = this.mCarrierIds[i];
            CarrierIdentifier[] thatCarrierIds = that.mCarrierIds[i];
            if (carrierIds != null && thatCarrierIds != null) {
                if (carrierIds.length != thatCarrierIds.length) {
                    return false;
                }
                for (int j = 0; j < carrierIds.length; ++j) {
                    if (carrierIds[j].equals(thatCarrierIds[j])) continue;
                    return false;
                }
                continue;
            }
            if (carrierIds == null && thatCarrierIds == null) continue;
            return false;
        }
        return Arrays.equals(this.mPolicyRules, that.mPolicyRules) && Arrays.equals(this.mPolicyRuleFlags, that.mPolicyRuleFlags);
    }

    private EuiccRulesAuthTable(Parcel source) {
        this.mPolicyRules = source.createIntArray();
        int len = this.mPolicyRules.length;
        this.mCarrierIds = new CarrierIdentifier[len][];
        for (int i = 0; i < len; ++i) {
            this.mCarrierIds[i] = source.createTypedArray(CarrierIdentifier.CREATOR);
        }
        this.mPolicyRuleFlags = source.createIntArray();
    }

    public static class Builder {
        private int[] mPolicyRules;
        private CarrierIdentifier[][] mCarrierIds;
        private int[] mPolicyRuleFlags;
        private int mPosition;

        public Builder(int ruleNum) {
            this.mPolicyRules = new int[ruleNum];
            this.mCarrierIds = new CarrierIdentifier[ruleNum][];
            this.mPolicyRuleFlags = new int[ruleNum];
        }

        public EuiccRulesAuthTable build() {
            if (this.mPosition != this.mPolicyRules.length) {
                throw new IllegalStateException("Not enough rules are added, expected: " + this.mPolicyRules.length + ", added: " + this.mPosition);
            }
            return new EuiccRulesAuthTable(this.mPolicyRules, this.mCarrierIds, this.mPolicyRuleFlags);
        }

        public Builder add(int policyRules, List<CarrierIdentifier> carrierId, int policyRuleFlags) {
            if (this.mPosition >= this.mPolicyRules.length) {
                throw new ArrayIndexOutOfBoundsException(this.mPosition);
            }
            this.mPolicyRules[this.mPosition] = policyRules;
            if (carrierId != null && carrierId.size() > 0) {
                this.mCarrierIds[this.mPosition] = carrierId.toArray(new CarrierIdentifier[carrierId.size()]);
            }
            this.mPolicyRuleFlags[this.mPosition] = policyRuleFlags;
            ++this.mPosition;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PolicyRuleFlag {
    }
}

