/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.ims.RcsMessageStoreException;
import android.telephony.ims.aidl.IRcs;

class RcsControllerCall {
    private final Context mContext;

    RcsControllerCall(Context context) {
        this.mContext = context;
    }

    <R> R call(RcsServiceCall<R> serviceCall) throws RcsMessageStoreException {
        IRcs iRcs = IRcs.Stub.asInterface(ServiceManager.getService("ircs"));
        if (iRcs == null) {
            throw new RcsMessageStoreException("Could not connect to RCS storage service");
        }
        try {
            return serviceCall.methodOnIRcs(iRcs, this.mContext.getOpPackageName());
        }
        catch (RemoteException exception) {
            throw new RcsMessageStoreException(exception.getMessage());
        }
    }

    void callWithNoReturn(RcsServiceCallWithNoReturn serviceCall) throws RcsMessageStoreException {
        this.call((iRcs, callingPackage) -> {
            serviceCall.methodOnIRcs(iRcs, callingPackage);
            return null;
        });
    }

    static interface RcsServiceCallWithNoReturn {
        public void methodOnIRcs(IRcs var1, String var2) throws RemoteException;
    }

    static interface RcsServiceCall<R> {
        public R methodOnIRcs(IRcs var1, String var2) throws RemoteException;
    }
}

