/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.net.Uri;
import android.telephony.ims.RcsControllerCall;
import android.telephony.ims.RcsMessageStoreException;
import android.telephony.ims.RcsParticipant;
import android.telephony.ims.RcsParticipantQueryParams;
import android.telephony.ims.RcsParticipantQueryResult;
import android.telephony.ims.RcsThread;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class RcsGroupThread
extends RcsThread {
    public RcsGroupThread(RcsControllerCall rcsControllerCall, int threadId) {
        super(rcsControllerCall, threadId);
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    public String getGroupName() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getGroupThreadName(this.mThreadId, callingPackage));
    }

    public void setGroupName(String groupName) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setGroupThreadName(this.mThreadId, groupName, callingPackage));
    }

    public Uri getGroupIcon() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getGroupThreadIcon(this.mThreadId, callingPackage));
    }

    public void setGroupIcon(Uri groupIcon) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setGroupThreadIcon(this.mThreadId, groupIcon, callingPackage));
    }

    public RcsParticipant getOwner() throws RcsMessageStoreException {
        return new RcsParticipant(this.mRcsControllerCall, this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getGroupThreadOwner(this.mThreadId, callingPackage)));
    }

    public void setOwner(RcsParticipant participant) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setGroupThreadOwner(this.mThreadId, participant.getId(), callingPackage));
    }

    public void addParticipant(RcsParticipant participant) throws RcsMessageStoreException {
        if (participant == null) {
            return;
        }
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.addParticipantToGroupThread(this.mThreadId, participant.getId(), callingPackage));
    }

    public void removeParticipant(RcsParticipant participant) throws RcsMessageStoreException {
        if (participant == null) {
            return;
        }
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.removeParticipantFromGroupThread(this.mThreadId, participant.getId(), callingPackage));
    }

    public Set<RcsParticipant> getParticipants() throws RcsMessageStoreException {
        RcsParticipantQueryParams queryParameters = new RcsParticipantQueryParams.Builder().setThread(this).build();
        RcsParticipantQueryResult queryResult = new RcsParticipantQueryResult(this.mRcsControllerCall, this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getParticipants(queryParameters, callingPackage)));
        List<RcsParticipant> participantList = queryResult.getParticipants();
        LinkedHashSet<RcsParticipant> participantSet = new LinkedHashSet<RcsParticipant>(participantList);
        return Collections.unmodifiableSet(participantSet);
    }

    public Uri getConferenceUri() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getGroupThreadConferenceUri(this.mThreadId, callingPackage));
    }

    public void setConferenceUri(Uri conferenceUri) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setGroupThreadConferenceUri(this.mThreadId, conferenceUri, callingPackage));
    }
}

