/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.RemoteException;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.util.Property;
import android.util.SparseArray;
import android.view.DisplayCutout;
import android.view.ImeInsetsSourceConsumer;
import android.view.InsetsAnimationControlImpl;
import android.view.InsetsSourceConsumer;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.SyncRtSurfaceTransactionApplier;
import android.view.ViewRootImpl;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsAnimationController;
import android.view.WindowInsetsAnimationListener;
import android.view.WindowInsetsController;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.util.ArrayList;

public class InsetsController
implements WindowInsetsController {
    private static final int ANIMATION_DURATION_SHOW_MS = 275;
    private static final int ANIMATION_DURATION_HIDE_MS = 340;
    private static final Interpolator INTERPOLATOR = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
    private static final int DIRECTION_NONE = 0;
    private static final int DIRECTION_SHOW = 1;
    private static final int DIRECTION_HIDE = 2;
    private static TypeEvaluator<Insets> sEvaluator = (fraction2, startValue, endValue) -> Insets.of(0, (int)((float)startValue.top + fraction2 * (float)(endValue.top - startValue.top)), 0, (int)((float)startValue.bottom + fraction2 * (float)(endValue.bottom - startValue.bottom)));
    private final String TAG = "InsetsControllerImpl";
    private final InsetsState mState = new InsetsState();
    private final InsetsState mTmpState = new InsetsState();
    private final Rect mFrame = new Rect();
    private final SparseArray<InsetsSourceConsumer> mSourceConsumers = new SparseArray();
    private final ViewRootImpl mViewRoot;
    private final SparseArray<InsetsSourceControl> mTmpControlArray = new SparseArray();
    private final ArrayList<InsetsAnimationControlImpl> mAnimationControls = new ArrayList();
    private final ArrayList<InsetsAnimationControlImpl> mTmpFinishedControls = new ArrayList();
    private WindowInsets mLastInsets;
    private boolean mAnimCallbackScheduled;
    private final Runnable mAnimCallback;
    private final Rect mLastLegacyContentInsets = new Rect();
    private final Rect mLastLegacyStableInsets = new Rect();
    @AnimationDirection
    private int mAnimationDirection;
    private int mPendingTypesToShow;
    private int mLastLegacySoftInputMode;

    public InsetsController(ViewRootImpl viewRoot) {
        this.mViewRoot = viewRoot;
        this.mAnimCallback = () -> {
            this.mAnimCallbackScheduled = false;
            if (this.mAnimationControls.isEmpty()) {
                return;
            }
            this.mTmpFinishedControls.clear();
            InsetsState state = new InsetsState(this.mState, true);
            for (int i = this.mAnimationControls.size() - 1; i >= 0; --i) {
                InsetsAnimationControlImpl control = this.mAnimationControls.get(i);
                if (!this.mAnimationControls.get(i).applyChangeInsets(state)) continue;
                this.mTmpFinishedControls.add(control);
            }
            WindowInsets insets = state.calculateInsets(this.mFrame, this.mLastInsets.isRound(), this.mLastInsets.shouldAlwaysConsumeSystemBars(), this.mLastInsets.getDisplayCutout(), this.mLastLegacyContentInsets, this.mLastLegacyStableInsets, this.mLastLegacySoftInputMode, null);
            this.mViewRoot.mView.dispatchWindowInsetsAnimationProgress(insets);
            for (int i = this.mTmpFinishedControls.size() - 1; i >= 0; --i) {
                this.dispatchAnimationFinished(this.mTmpFinishedControls.get(i).getAnimation());
            }
        };
    }

    @VisibleForTesting
    public void onFrameChanged(Rect frame) {
        if (this.mFrame.equals(frame)) {
            return;
        }
        this.mViewRoot.notifyInsetsChanged();
        this.mFrame.set(frame);
    }

    public InsetsState getState() {
        return this.mState;
    }

    boolean onStateChanged(InsetsState state) {
        if (this.mState.equals(state)) {
            return false;
        }
        this.mState.set(state);
        this.mTmpState.set(state, true);
        this.applyLocalVisibilityOverride();
        this.mViewRoot.notifyInsetsChanged();
        if (!this.mState.equals(this.mTmpState)) {
            this.sendStateToWindowManager();
        }
        return true;
    }

    @VisibleForTesting
    public WindowInsets calculateInsets(boolean isScreenRound, boolean alwaysConsumeSystemBars, DisplayCutout cutout, Rect legacyContentInsets, Rect legacyStableInsets, int legacySoftInputMode) {
        this.mLastLegacyContentInsets.set(legacyContentInsets);
        this.mLastLegacyStableInsets.set(legacyStableInsets);
        this.mLastLegacySoftInputMode = legacySoftInputMode;
        this.mLastInsets = this.mState.calculateInsets(this.mFrame, isScreenRound, alwaysConsumeSystemBars, cutout, legacyContentInsets, legacyStableInsets, legacySoftInputMode, null);
        return this.mLastInsets;
    }

    public void onControlsChanged(InsetsSourceControl[] activeControls) {
        int i;
        if (activeControls != null) {
            for (InsetsSourceControl activeControl : activeControls) {
                if (activeControl == null) continue;
                this.mTmpControlArray.put(activeControl.getType(), activeControl);
            }
        }
        for (i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            InsetsSourceControl control = this.mTmpControlArray.get(consumer.getType());
            consumer.setControl(control);
        }
        for (i = this.mTmpControlArray.size() - 1; i >= 0; --i) {
            InsetsSourceControl control = this.mTmpControlArray.valueAt(i);
            this.getSourceConsumer(control.getType()).setControl(control);
        }
        this.mTmpControlArray.clear();
    }

    @Override
    public void show(int types) {
        this.show(types, false);
    }

    private void show(int types, boolean fromIme) {
        int typesReady = 0;
        ArraySet<Integer> internalTypes = InsetsState.toInternalType(types);
        for (int i = internalTypes.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.getSourceConsumer(internalTypes.valueAt(i));
            if (this.mAnimationDirection == 2) {
                this.cancelExistingAnimation();
            } else if (consumer.isVisible() && (this.mAnimationDirection == 0 || this.mAnimationDirection == 2)) continue;
            typesReady |= InsetsState.toPublicType(consumer.getType());
        }
        this.applyAnimation(typesReady, true, fromIme);
    }

    @Override
    public void hide(int types) {
        int typesReady = 0;
        ArraySet<Integer> internalTypes = InsetsState.toInternalType(types);
        for (int i = internalTypes.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.getSourceConsumer(internalTypes.valueAt(i));
            if (this.mAnimationDirection == 1) {
                this.cancelExistingAnimation();
            } else if (!consumer.isVisible() && (this.mAnimationDirection == 0 || this.mAnimationDirection == 2)) continue;
            typesReady |= InsetsState.toPublicType(consumer.getType());
        }
        this.applyAnimation(typesReady, false, false);
    }

    @Override
    public void controlWindowInsetsAnimation(int types, WindowInsetsAnimationControlListener listener) {
        this.controlWindowInsetsAnimation(types, listener, false);
    }

    private void controlWindowInsetsAnimation(int types, WindowInsetsAnimationControlListener listener, boolean fromIme) {
        if (!this.mState.getDisplayFrame().equals(this.mFrame)) {
            listener.onCancelled();
            return;
        }
        this.controlAnimationUnchecked(types, listener, this.mFrame, fromIme);
    }

    private void controlAnimationUnchecked(int types, WindowInsetsAnimationControlListener listener, Rect frame, boolean fromIme) {
        if (types == 0) {
            return;
        }
        this.cancelExistingControllers(types);
        ArraySet<Integer> internalTypes = InsetsState.toInternalType(types);
        SparseArray<InsetsSourceConsumer> consumers = new SparseArray<InsetsSourceConsumer>();
        Pair<Integer, Boolean> typesReadyPair = this.collectConsumers(fromIme, internalTypes, consumers);
        int typesReady = (Integer)typesReadyPair.first;
        boolean isReady = (Boolean)typesReadyPair.second;
        if (!isReady) {
            this.mPendingTypesToShow = typesReady;
            return;
        }
        if ((typesReady = this.collectPendingConsumers(typesReady, consumers)) == 0) {
            listener.onCancelled();
            return;
        }
        InsetsAnimationControlImpl controller = new InsetsAnimationControlImpl(consumers, frame, this.mState, listener, typesReady, () -> new SyncRtSurfaceTransactionApplier(this.mViewRoot.mView), this);
        this.mAnimationControls.add(controller);
    }

    private Pair<Integer, Boolean> collectConsumers(boolean fromIme, ArraySet<Integer> internalTypes, SparseArray<InsetsSourceConsumer> consumers) {
        int typesReady = 0;
        boolean isReady = true;
        for (int i = internalTypes.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.getSourceConsumer(internalTypes.valueAt(i));
            if (consumer.getControl() == null) continue;
            if (!consumer.isVisible()) {
                switch (consumer.requestShow(fromIme)) {
                    case 0: {
                        typesReady |= InsetsState.toPublicType(consumer.getType());
                        break;
                    }
                    case 1: {
                        isReady = false;
                        break;
                    }
                    case 2: {
                        if (this.mPendingTypesToShow == 0) break;
                        this.mPendingTypesToShow &= ~InsetsState.toPublicType(10);
                    }
                }
            } else {
                consumer.notifyHidden();
                typesReady |= InsetsState.toPublicType(consumer.getType());
            }
            consumers.put(consumer.getType(), consumer);
        }
        return new Pair<Integer, Boolean>(typesReady, isReady);
    }

    private int collectPendingConsumers(int typesReady, SparseArray<InsetsSourceConsumer> consumers) {
        if (this.mPendingTypesToShow != 0) {
            typesReady |= this.mPendingTypesToShow;
            ArraySet<Integer> internalTypes = InsetsState.toInternalType(this.mPendingTypesToShow);
            for (int i = internalTypes.size() - 1; i >= 0; --i) {
                InsetsSourceConsumer consumer = this.getSourceConsumer(internalTypes.valueAt(i));
                consumers.put(consumer.getType(), consumer);
            }
            this.mPendingTypesToShow = 0;
        }
        return typesReady;
    }

    private void cancelExistingControllers(int types) {
        for (int i = this.mAnimationControls.size() - 1; i >= 0; --i) {
            InsetsAnimationControlImpl control = this.mAnimationControls.get(i);
            if ((control.getTypes() & types) == 0) continue;
            this.cancelAnimation(control);
        }
    }

    @VisibleForTesting
    public void notifyFinished(InsetsAnimationControlImpl controller, int shownTypes) {
        this.mAnimationControls.remove(controller);
        this.hideDirectly(controller.getTypes() & ~shownTypes);
        this.showDirectly(controller.getTypes() & shownTypes);
    }

    void notifyControlRevoked(InsetsSourceConsumer consumer) {
        for (int i = this.mAnimationControls.size() - 1; i >= 0; --i) {
            InsetsAnimationControlImpl control = this.mAnimationControls.get(i);
            if ((control.getTypes() & InsetsState.toPublicType(consumer.getType())) == 0) continue;
            this.cancelAnimation(control);
        }
    }

    private void cancelAnimation(InsetsAnimationControlImpl control) {
        control.onCancelled();
        this.mAnimationControls.remove(control);
    }

    private void applyLocalVisibilityOverride() {
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer controller = this.mSourceConsumers.valueAt(i);
            controller.applyLocalVisibilityOverride();
        }
    }

    @VisibleForTesting
    public InsetsSourceConsumer getSourceConsumer(int type) {
        InsetsSourceConsumer controller = this.mSourceConsumers.get(type);
        if (controller != null) {
            return controller;
        }
        controller = this.createConsumerOfType(type);
        this.mSourceConsumers.put(type, controller);
        return controller;
    }

    @VisibleForTesting
    public void notifyVisibilityChanged() {
        this.mViewRoot.notifyInsetsChanged();
        this.sendStateToWindowManager();
    }

    public void onWindowFocusGained() {
        this.getSourceConsumer(10).onWindowFocusGained();
    }

    public void onWindowFocusLost() {
        this.getSourceConsumer(10).onWindowFocusLost();
    }

    ViewRootImpl getViewRoot() {
        return this.mViewRoot;
    }

    @VisibleForTesting
    public void applyImeVisibility(boolean setVisible) {
        if (setVisible) {
            this.show(2, true);
        } else {
            this.hide(2);
        }
    }

    private InsetsSourceConsumer createConsumerOfType(int type) {
        if (type == 10) {
            return new ImeInsetsSourceConsumer(this.mState, SurfaceControl.Transaction::new, this);
        }
        return new InsetsSourceConsumer(type, this.mState, SurfaceControl.Transaction::new, this);
    }

    private void sendStateToWindowManager() {
        InsetsState tmpState = new InsetsState();
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            if (consumer.getControl() == null) continue;
            tmpState.addSource(this.mState.getSource(consumer.getType()));
        }
        try {
            this.mViewRoot.mWindowSession.insetsModified(this.mViewRoot.mWindow, tmpState);
        }
        catch (RemoteException e) {
            Log.e("InsetsControllerImpl", "Failed to call insetsModified", e);
        }
    }

    private void applyAnimation(final int types, final boolean show, boolean fromIme) {
        if (types == 0) {
            return;
        }
        WindowInsetsAnimationControlListener listener = new WindowInsetsAnimationControlListener(){
            private WindowInsetsAnimationController mController;
            private ObjectAnimator mAnimator;

            @Override
            public void onReady(WindowInsetsAnimationController controller, int types2) {
                this.mController = controller;
                if (show) {
                    InsetsController.this.showDirectly(types2);
                } else {
                    InsetsController.this.hideDirectly(types2);
                }
                this.mAnimator = ObjectAnimator.ofObject(controller, new InsetsProperty(), sEvaluator, show ? controller.getHiddenStateInsets() : controller.getShownStateInsets(), show ? controller.getShownStateInsets() : controller.getHiddenStateInsets());
                this.mAnimator.setDuration(show ? 275L : 340L);
                this.mAnimator.setInterpolator(INTERPOLATOR);
                this.mAnimator.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        this.onAnimationFinish();
                    }
                });
                this.mAnimator.start();
            }

            @Override
            public void onCancelled() {
                this.mAnimator.cancel();
            }

            private void onAnimationFinish() {
                InsetsController.this.mAnimationDirection = 0;
                this.mController.finish(show ? types : 0);
            }
        };
        this.controlAnimationUnchecked(types, listener, this.mState.getDisplayFrame(), fromIme);
    }

    private void hideDirectly(int types) {
        ArraySet<Integer> internalTypes = InsetsState.toInternalType(types);
        for (int i = internalTypes.size() - 1; i >= 0; --i) {
            this.getSourceConsumer(internalTypes.valueAt(i)).hide();
        }
    }

    private void showDirectly(int types) {
        ArraySet<Integer> internalTypes = InsetsState.toInternalType(types);
        for (int i = internalTypes.size() - 1; i >= 0; --i) {
            this.getSourceConsumer(internalTypes.valueAt(i)).show();
        }
    }

    @VisibleForTesting
    public void cancelExistingAnimation() {
        this.cancelExistingControllers(WindowInsets.Type.all());
    }

    void dump(String prefix, PrintWriter pw) {
        pw.println(prefix);
        pw.println("InsetsController:");
        this.mState.dump(prefix + "  ", pw);
    }

    @VisibleForTesting
    public void dispatchAnimationStarted(WindowInsetsAnimationListener.InsetsAnimation animation) {
        this.mViewRoot.mView.dispatchWindowInsetsAnimationStarted(animation);
    }

    @VisibleForTesting
    public void dispatchAnimationFinished(WindowInsetsAnimationListener.InsetsAnimation animation) {
        this.mViewRoot.mView.dispatchWindowInsetsAnimationFinished(animation);
    }

    @VisibleForTesting
    public void scheduleApplyChangeInsets() {
        if (!this.mAnimCallbackScheduled) {
            this.mViewRoot.mChoreographer.postCallback(2, this.mAnimCallback, null);
            this.mAnimCallbackScheduled = true;
        }
    }

    private static class InsetsProperty
    extends Property<WindowInsetsAnimationController, Insets> {
        InsetsProperty() {
            super(Insets.class, "Insets");
        }

        @Override
        public Insets get(WindowInsetsAnimationController object) {
            return object.getCurrentInsets();
        }

        @Override
        public void set(WindowInsetsAnimationController object, Insets value) {
            object.changeInsets(value);
        }
    }

    private static @interface AnimationDirection {
    }
}

