/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.UnsupportedAppUsage;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.GraphicBuffer;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.display.DisplayedContentSample;
import android.hardware.display.DisplayedContentSamplingAttributes;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.InputWindowHandle;
import android.view.Surface;
import android.view.SurfaceControl_Delegate;
import android.view.SurfaceSession;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import libcore.util.NativeAllocationRegistry;

public class SurfaceControl
implements Parcelable {
    private static final String TAG = "SurfaceControl";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private String mName;
    long mNativeObject;
    private final Object mSizeLock = new Object();
    @GuardedBy(value={"mSizeLock"})
    private int mWidth;
    @GuardedBy(value={"mSizeLock"})
    private int mHeight;
    static Transaction sGlobalTransaction;
    static long sTransactionNestCount;
    @UnsupportedAppUsage
    public static final int HIDDEN = 4;
    public static final int SECURE = 128;
    public static final int NON_PREMULTIPLIED = 256;
    public static final int OPAQUE = 1024;
    public static final int PROTECTED_APP = 2048;
    public static final int CURSOR_WINDOW = 8192;
    public static final int FX_SURFACE_NORMAL = 0;
    public static final int FX_SURFACE_DIM = 131072;
    public static final int FX_SURFACE_CONTAINER = 524288;
    public static final int FX_SURFACE_MASK = 983040;
    private static final int SURFACE_HIDDEN = 1;
    private static final int SURFACE_OPAQUE = 2;
    public static final int POWER_MODE_OFF = 0;
    public static final int POWER_MODE_DOZE = 1;
    public static final int POWER_MODE_NORMAL = 2;
    public static final int POWER_MODE_DOZE_SUSPEND = 3;
    public static final int POWER_MODE_ON_SUSPEND = 4;
    public static final int WINDOW_TYPE_DONT_SCREENSHOT = 441731;
    private static final int INTERNAL_DATASPACE_SRGB = 0x8810000;
    private static final int INTERNAL_DATASPACE_DISPLAY_P3 = 0x88A0000;
    private static final int INTERNAL_DATASPACE_SCRGB = 0x18810000;
    public static final int METADATA_OWNER_UID = 1;
    public static final int METADATA_WINDOW_TYPE = 2;
    public static final int METADATA_TASK_ID = 3;
    public static final Parcelable.Creator<SurfaceControl> CREATOR;

    private static long nativeCreate(SurfaceSession surfaceSession, String string2, int n, int n2, int n3, int n4, long l, Parcel parcel) throws Surface.OutOfResourcesException {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeCreate(Landroid/view/SurfaceSession;Ljava/lang/String;IIIIJLandroid/os/Parcel;)J", true, null);
    }

    private static long nativeReadFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeReadFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    private static long nativeCopyFromSurfaceControl(long l) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeCopyFromSurfaceControl(J)J", true, null);
    }

    private static void nativeWriteToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeWriteToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static void nativeRelease(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeRelease(J)V", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDestroy(J)V", true, null);
    }

    private static void nativeDisconnect(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDisconnect(J)V", true, null);
    }

    private static ScreenshotGraphicBuffer nativeScreenshot(IBinder iBinder, Rect rect, int n, int n2, boolean bl, int n3, boolean bl2) {
        return (ScreenshotGraphicBuffer)OverrideMethod.invokeA("android.view.SurfaceControl#nativeScreenshot(Landroid/os/IBinder;Landroid/graphics/Rect;IIZIZ)Landroid/view/SurfaceControl$ScreenshotGraphicBuffer;", true, null);
    }

    private static ScreenshotGraphicBuffer nativeCaptureLayers(IBinder iBinder, IBinder iBinder2, Rect rect, float f, IBinder[] iBinderArray) {
        return (ScreenshotGraphicBuffer)OverrideMethod.invokeA("android.view.SurfaceControl#nativeCaptureLayers(Landroid/os/IBinder;Landroid/os/IBinder;Landroid/graphics/Rect;F[Landroid/os/IBinder;)Landroid/view/SurfaceControl$ScreenshotGraphicBuffer;", true, null);
    }

    @LayoutlibDelegate
    private static long nativeCreateTransaction() {
        return SurfaceControl_Delegate.nativeCreateTransaction();
    }

    @LayoutlibDelegate
    private static long nativeGetNativeTransactionFinalizer() {
        return SurfaceControl_Delegate.nativeGetNativeTransactionFinalizer();
    }

    private static void nativeApplyTransaction(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeApplyTransaction(JZ)V", true, null);
    }

    private static void nativeMergeTransaction(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeMergeTransaction(JJ)V", true, null);
    }

    private static void nativeSetAnimationTransaction(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAnimationTransaction(J)V", true, null);
    }

    private static void nativeSetEarlyWakeup(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetEarlyWakeup(J)V", true, null);
    }

    private static void nativeSetLayer(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLayer(JJI)V", true, null);
    }

    private static void nativeSetRelativeLayer(long l, long l2, IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetRelativeLayer(JJLandroid/os/IBinder;I)V", true, null);
    }

    private static void nativeSetPosition(long l, long l2, float f, float f2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetPosition(JJFF)V", true, null);
    }

    private static void nativeSetGeometryAppliesWithResize(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetGeometryAppliesWithResize(JJ)V", true, null);
    }

    private static void nativeSetSize(long l, long l2, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetSize(JJII)V", true, null);
    }

    private static void nativeSetTransparentRegionHint(long l, long l2, Region region) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetTransparentRegionHint(JJLandroid/graphics/Region;)V", true, null);
    }

    private static void nativeSetAlpha(long l, long l2, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAlpha(JJF)V", true, null);
    }

    private static void nativeSetMatrix(long l, long l2, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetMatrix(JJFFFF)V", true, null);
    }

    private static void nativeSetColorTransform(long l, long l2, float[] fArray, float[] fArray2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetColorTransform(JJ[F[F)V", true, null);
    }

    private static void nativeSetColorSpaceAgnostic(long l, long l2, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetColorSpaceAgnostic(JJZ)V", true, null);
    }

    private static void nativeSetGeometry(long l, long l2, Rect rect, Rect rect2, long l3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetGeometry(JJLandroid/graphics/Rect;Landroid/graphics/Rect;J)V", true, null);
    }

    private static void nativeSetColor(long l, long l2, float[] fArray) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetColor(JJ[F)V", true, null);
    }

    private static void nativeSetFlags(long l, long l2, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFlags(JJII)V", true, null);
    }

    private static void nativeSetWindowCrop(long l, long l2, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetWindowCrop(JJIIII)V", true, null);
    }

    private static void nativeSetCornerRadius(long l, long l2, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetCornerRadius(JJF)V", true, null);
    }

    private static void nativeSetLayerStack(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLayerStack(JJI)V", true, null);
    }

    private static boolean nativeClearContentFrameStats(long l) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeClearContentFrameStats(J)Z", true, null) != 0;
    }

    private static boolean nativeGetContentFrameStats(long l, WindowContentFrameStats windowContentFrameStats) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetContentFrameStats(JLandroid/view/WindowContentFrameStats;)Z", true, null) != 0;
    }

    private static boolean nativeClearAnimationFrameStats() {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeClearAnimationFrameStats()Z", true, null) != 0;
    }

    private static boolean nativeGetAnimationFrameStats(WindowAnimationFrameStats windowAnimationFrameStats) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetAnimationFrameStats(Landroid/view/WindowAnimationFrameStats;)Z", true, null) != 0;
    }

    private static long[] nativeGetPhysicalDisplayIds() {
        return (long[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetPhysicalDisplayIds()[J", true, null);
    }

    private static IBinder nativeGetPhysicalDisplayToken(long l) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetPhysicalDisplayToken(J)Landroid/os/IBinder;", true, null);
    }

    private static IBinder nativeCreateDisplay(String string2, boolean bl) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeCreateDisplay(Ljava/lang/String;Z)Landroid/os/IBinder;", true, null);
    }

    private static void nativeDestroyDisplay(IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDestroyDisplay(Landroid/os/IBinder;)V", true, null);
    }

    private static void nativeSetDisplaySurface(long l, IBinder iBinder, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplaySurface(JLandroid/os/IBinder;J)V", true, null);
    }

    private static void nativeSetDisplayLayerStack(long l, IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayLayerStack(JLandroid/os/IBinder;I)V", true, null);
    }

    private static void nativeSetDisplayProjection(long l, IBinder iBinder, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayProjection(JLandroid/os/IBinder;IIIIIIIII)V", true, null);
    }

    private static void nativeSetDisplaySize(long l, IBinder iBinder, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplaySize(JLandroid/os/IBinder;II)V", true, null);
    }

    private static PhysicalDisplayInfo[] nativeGetDisplayConfigs(IBinder iBinder) {
        return (PhysicalDisplayInfo[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayConfigs(Landroid/os/IBinder;)[Landroid/view/SurfaceControl$PhysicalDisplayInfo;", true, null);
    }

    private static DisplayedContentSamplingAttributes nativeGetDisplayedContentSamplingAttributes(IBinder iBinder) {
        return (DisplayedContentSamplingAttributes)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayedContentSamplingAttributes(Landroid/os/IBinder;)Landroid/hardware/display/DisplayedContentSamplingAttributes;", true, null);
    }

    private static boolean nativeSetDisplayedContentSamplingEnabled(IBinder iBinder, boolean bl, int n, int n2) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetDisplayedContentSamplingEnabled(Landroid/os/IBinder;ZII)Z", true, null) != 0;
    }

    private static DisplayedContentSample nativeGetDisplayedContentSample(IBinder iBinder, long l, long l2) {
        return (DisplayedContentSample)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayedContentSample(Landroid/os/IBinder;JJ)Landroid/hardware/display/DisplayedContentSample;", true, null);
    }

    private static int nativeGetActiveConfig(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetActiveConfig(Landroid/os/IBinder;)I", true, null);
    }

    private static boolean nativeSetActiveConfig(IBinder iBinder, int n) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetActiveConfig(Landroid/os/IBinder;I)Z", true, null) != 0;
    }

    private static boolean nativeSetAllowedDisplayConfigs(IBinder iBinder, int[] nArray) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetAllowedDisplayConfigs(Landroid/os/IBinder;[I)Z", true, null) != 0;
    }

    private static int[] nativeGetAllowedDisplayConfigs(IBinder iBinder) {
        return (int[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetAllowedDisplayConfigs(Landroid/os/IBinder;)[I", true, null);
    }

    private static int[] nativeGetDisplayColorModes(IBinder iBinder) {
        return (int[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayColorModes(Landroid/os/IBinder;)[I", true, null);
    }

    private static DisplayPrimaries nativeGetDisplayNativePrimaries(IBinder iBinder) {
        return (DisplayPrimaries)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayNativePrimaries(Landroid/os/IBinder;)Landroid/view/SurfaceControl$DisplayPrimaries;", true, null);
    }

    private static int[] nativeGetCompositionDataspaces() {
        return (int[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetCompositionDataspaces()[I", true, null);
    }

    private static int nativeGetActiveColorMode(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetActiveColorMode(Landroid/os/IBinder;)I", true, null);
    }

    private static boolean nativeSetActiveColorMode(IBinder iBinder, int n) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetActiveColorMode(Landroid/os/IBinder;I)Z", true, null) != 0;
    }

    private static void nativeSetDisplayPowerMode(IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayPowerMode(Landroid/os/IBinder;I)V", true, null);
    }

    private static void nativeDeferTransactionUntil(long l, long l2, IBinder iBinder, long l3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDeferTransactionUntil(JJLandroid/os/IBinder;J)V", true, null);
    }

    private static void nativeDeferTransactionUntilSurface(long l, long l2, long l3, long l4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDeferTransactionUntilSurface(JJJJ)V", true, null);
    }

    private static void nativeReparentChildren(long l, long l2, IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeReparentChildren(JJLandroid/os/IBinder;)V", true, null);
    }

    private static void nativeReparent(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeReparent(JJJ)V", true, null);
    }

    private static void nativeSeverChildren(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSeverChildren(JJ)V", true, null);
    }

    private static void nativeSetOverrideScalingMode(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetOverrideScalingMode(JJI)V", true, null);
    }

    private static IBinder nativeGetHandle(long l) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetHandle(J)Landroid/os/IBinder;", true, null);
    }

    private static boolean nativeGetTransformToDisplayInverse(long l) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetTransformToDisplayInverse(J)Z", true, null) != 0;
    }

    private static Display.HdrCapabilities nativeGetHdrCapabilities(IBinder iBinder) {
        return (Display.HdrCapabilities)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetHdrCapabilities(Landroid/os/IBinder;)Landroid/view/Display$HdrCapabilities;", true, null);
    }

    private static void nativeSetInputWindowInfo(long l, long l2, InputWindowHandle inputWindowHandle) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetInputWindowInfo(JJLandroid/view/InputWindowHandle;)V", true, null);
    }

    private static void nativeTransferTouchFocus(long l, IBinder iBinder, IBinder iBinder2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeTransferTouchFocus(JLandroid/os/IBinder;Landroid/os/IBinder;)V", true, null);
    }

    private static boolean nativeGetProtectedContentSupport() {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetProtectedContentSupport()Z", true, null) != 0;
    }

    private static void nativeSetMetadata(long l, long l2, int n, Parcel parcel) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetMetadata(JJILandroid/os/Parcel;)V", true, null);
    }

    private static void nativeSyncInputWindows(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSyncInputWindows(J)V", true, null);
    }

    private static boolean nativeGetDisplayBrightnessSupport(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetDisplayBrightnessSupport(Landroid/os/IBinder;)Z", true, null) != 0;
    }

    private static boolean nativeSetDisplayBrightness(IBinder iBinder, float f) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetDisplayBrightness(Landroid/os/IBinder;F)Z", true, null) != 0;
    }

    private void assignNativeObject(long nativeObject) {
        if (this.mNativeObject != 0L) {
            this.release();
        }
        this.mNativeObject = nativeObject;
    }

    public void copyFrom(SurfaceControl other) {
        this.mName = other.mName;
        this.mWidth = other.mWidth;
        this.mHeight = other.mHeight;
        this.assignNativeObject(SurfaceControl.nativeCopyFromSurfaceControl(other.mNativeObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SurfaceControl(SurfaceSession session, String name, int w, int h, int format, int flags, SurfaceControl parent, SparseIntArray metadata) throws Surface.OutOfResourcesException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if ((flags & 4) == 0) {
            Log.w(TAG, "Surfaces should always be created with the HIDDEN flag set to ensure that they are not made visible prematurely before all of the surface's properties have been configured.  Set the other properties and make the surface visible within a transaction.  New surface name: " + name, new Throwable());
        }
        this.mName = name;
        this.mWidth = w;
        this.mHeight = h;
        Parcel metaParcel = Parcel.obtain();
        try {
            if (metadata != null && metadata.size() > 0) {
                metaParcel.writeInt(metadata.size());
                for (int i = 0; i < metadata.size(); ++i) {
                    metaParcel.writeInt(metadata.keyAt(i));
                    metaParcel.writeByteArray(ByteBuffer.allocate(4).order(ByteOrder.nativeOrder()).putInt(metadata.valueAt(i)).array());
                }
                metaParcel.setDataPosition(0);
            }
            this.mNativeObject = SurfaceControl.nativeCreate(session, name, w, h, format, flags, parent != null ? parent.mNativeObject : 0L, metaParcel);
        }
        finally {
            metaParcel.recycle();
        }
        if (this.mNativeObject == 0L) {
            throw new Surface.OutOfResourcesException("Couldn't allocate SurfaceControl native object");
        }
        this.mCloseGuard.open("release");
    }

    public SurfaceControl(SurfaceControl other) {
        this.mName = other.mName;
        this.mWidth = other.mWidth;
        this.mHeight = other.mHeight;
        this.mNativeObject = other.mNativeObject;
        other.mCloseGuard.close();
        other.mNativeObject = 0L;
        this.mCloseGuard.open("release");
    }

    private SurfaceControl(Parcel in) {
        this.readFromParcel(in);
        this.mCloseGuard.open("release");
    }

    public SurfaceControl() {
        this.mCloseGuard.open("release");
    }

    public void readFromParcel(Parcel in) {
        if (in == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.mName = in.readString();
        this.mWidth = in.readInt();
        this.mHeight = in.readInt();
        long object = 0L;
        if (in.readInt() != 0) {
            object = SurfaceControl.nativeReadFromParcel(in);
        }
        this.assignNativeObject(object);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mHeight);
        if (this.mNativeObject == 0L) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
        }
        SurfaceControl.nativeWriteToParcel(this.mNativeObject, dest);
        if ((flags & 1) != 0) {
            this.release();
        }
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, System.identityHashCode(this));
        proto.write(1138166333442L, this.mName);
        proto.end(token);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (this.mNativeObject != 0L) {
                SurfaceControl.nativeRelease(this.mNativeObject);
            }
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeRelease(this.mNativeObject);
            this.mNativeObject = 0L;
        }
        this.mCloseGuard.close();
    }

    public void remove() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeDestroy(this.mNativeObject);
            this.mNativeObject = 0L;
        }
        this.mCloseGuard.close();
    }

    public void disconnect() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeDisconnect(this.mNativeObject);
        }
    }

    private void checkNotReleased() {
        if (this.mNativeObject == 0L) {
            throw new NullPointerException("mNativeObject is null. Have you called release() already?");
        }
    }

    public boolean isValid() {
        return this.mNativeObject != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void openTransaction() {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            if (sGlobalTransaction == null) {
                sGlobalTransaction = new Transaction();
            }
            Class<SurfaceControl> clazz2 = SurfaceControl.class;
            synchronized (SurfaceControl.class) {
                ++sTransactionNestCount;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void mergeToGlobalTransaction(Transaction t) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.merge(t);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void closeTransaction() {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            if (sTransactionNestCount == 0L) {
                Log.e(TAG, "Call to SurfaceControl.closeTransaction without matching openTransaction");
            } else if (--sTransactionNestCount > 0L) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            sGlobalTransaction.apply();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferTransactionUntil(IBinder handle, long frame) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.deferTransactionUntil(this, handle, frame);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferTransactionUntil(Surface barrier, long frame) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.deferTransactionUntilSurface(this, barrier, frame);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparentChildren(IBinder newParentHandle) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.reparentChildren(this, newParentHandle);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparent(SurfaceControl newParent) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.reparent(this, newParent);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachChildren() {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.detachChildren(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverrideScalingMode(int scalingMode) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setOverrideScalingMode(this, scalingMode);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public IBinder getHandle() {
        return SurfaceControl.nativeGetHandle(this.mNativeObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAnimationTransaction() {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setAnimationTransaction();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void setLayer(int zorder) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setLayer(this, zorder);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelativeLayer(SurfaceControl relativeTo, int zorder) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setRelativeLayer(this, relativeTo, zorder);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void setPosition(float x, float y) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setPosition(this, x, y);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeometryAppliesWithResize() {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setGeometryAppliesWithResize(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSize(int w, int h) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setBufferSize(this, w, h);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void hide() {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.hide(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void show() {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.show(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransparentRegionHint(Region region) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setTransparentRegionHint(this, region);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean clearContentFrameStats() {
        this.checkNotReleased();
        return SurfaceControl.nativeClearContentFrameStats(this.mNativeObject);
    }

    public boolean getContentFrameStats(WindowContentFrameStats outStats) {
        this.checkNotReleased();
        return SurfaceControl.nativeGetContentFrameStats(this.mNativeObject, outStats);
    }

    public static boolean clearAnimationFrameStats() {
        return SurfaceControl.nativeClearAnimationFrameStats();
    }

    public static boolean getAnimationFrameStats(WindowAnimationFrameStats outStats) {
        return SurfaceControl.nativeGetAnimationFrameStats(outStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlpha(float alpha) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setAlpha(this, alpha);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor(float[] color2) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setColor(this, color2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatrix(float dsdx, float dtdx, float dtdy, float dsdy) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setMatrix(this, dsdx, dtdx, dtdy, dsdy);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatrix(Matrix matrix, float[] float9) {
        this.checkNotReleased();
        matrix.getValues(float9);
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setMatrix(this, float9[0], float9[3], float9[1], float9[4]);
            sGlobalTransaction.setPosition(this, float9[2], float9[5]);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorTransform(float[] matrix, float[] translation) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setColorTransform(this, matrix, translation);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorSpaceAgnostic(boolean agnostic) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setColorSpaceAgnostic(this, agnostic);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowCrop(Rect crop) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setWindowCrop(this, crop);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowCrop(int width, int height) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setWindowCrop(this, width, height);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCornerRadius(float cornerRadius) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setCornerRadius(this, cornerRadius);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayerStack(int layerStack) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setLayerStack(this, layerStack);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpaque(boolean isOpaque) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setOpaque(this, isOpaque);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecure(boolean isSecure) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setSecure(this, isSecure);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.mSizeLock;
        synchronized (object) {
            return this.mWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.mSizeLock;
        synchronized (object) {
            return this.mHeight;
        }
    }

    public String toString() {
        return "Surface(name=" + this.mName + ")/@0x" + Integer.toHexString(System.identityHashCode(this));
    }

    public static void setDisplayPowerMode(IBinder displayToken, int mode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetDisplayPowerMode(displayToken, mode);
    }

    @UnsupportedAppUsage
    public static PhysicalDisplayInfo[] getDisplayConfigs(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayConfigs(displayToken);
    }

    public static int getActiveConfig(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetActiveConfig(displayToken);
    }

    public static DisplayedContentSamplingAttributes getDisplayedContentSamplingAttributes(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayedContentSamplingAttributes(displayToken);
    }

    public static boolean setDisplayedContentSamplingEnabled(IBinder displayToken, boolean enable, int componentMask, int maxFrames) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        int maxColorComponents = 4;
        if (componentMask >> 4 != 0) {
            throw new IllegalArgumentException("invalid componentMask when enabling sampling");
        }
        return SurfaceControl.nativeSetDisplayedContentSamplingEnabled(displayToken, enable, componentMask, maxFrames);
    }

    public static DisplayedContentSample getDisplayedContentSample(IBinder displayToken, long maxFrames, long timestamp) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayedContentSample(displayToken, maxFrames, timestamp);
    }

    public static boolean setActiveConfig(IBinder displayToken, int id2) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeSetActiveConfig(displayToken, id2);
    }

    public static boolean setAllowedDisplayConfigs(IBinder displayToken, int[] allowedConfigs) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (allowedConfigs == null) {
            throw new IllegalArgumentException("allowedConfigs must not be null");
        }
        return SurfaceControl.nativeSetAllowedDisplayConfigs(displayToken, allowedConfigs);
    }

    public static int[] getAllowedDisplayConfigs(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetAllowedDisplayConfigs(displayToken);
    }

    public static int[] getDisplayColorModes(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayColorModes(displayToken);
    }

    public static DisplayPrimaries getDisplayNativePrimaries(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayNativePrimaries(displayToken);
    }

    public static int getActiveColorMode(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetActiveColorMode(displayToken);
    }

    public static boolean setActiveColorMode(IBinder displayToken, int colorMode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeSetActiveColorMode(displayToken, colorMode);
    }

    public static ColorSpace[] getCompositionColorSpaces() {
        int[] dataspaces = SurfaceControl.nativeGetCompositionDataspaces();
        ColorSpace srgb = ColorSpace.get(ColorSpace.Named.SRGB);
        ColorSpace[] colorSpaces = new ColorSpace[]{srgb, srgb};
        if (dataspaces.length == 2) {
            block4: for (int i = 0; i < 2; ++i) {
                switch (dataspaces[i]) {
                    case 0x88A0000: {
                        colorSpaces[i] = ColorSpace.get(ColorSpace.Named.DISPLAY_P3);
                        continue block4;
                    }
                    case 0x18810000: {
                        colorSpaces[i] = ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB);
                        continue block4;
                    }
                }
            }
        }
        return colorSpaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void setDisplayProjection(IBinder displayToken, int orientation, Rect layerStackRect, Rect displayRect) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplayProjection(displayToken, orientation, layerStackRect, displayRect);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void setDisplayLayerStack(IBinder displayToken, int layerStack) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplayLayerStack(displayToken, layerStack);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void setDisplaySurface(IBinder displayToken, Surface surface) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplaySurface(displayToken, surface);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDisplaySize(IBinder displayToken, int width, int height) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplaySize(displayToken, width, height);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static Display.HdrCapabilities getHdrCapabilities(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetHdrCapabilities(displayToken);
    }

    @UnsupportedAppUsage
    public static IBinder createDisplay(String name, boolean secure) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return SurfaceControl.nativeCreateDisplay(name, secure);
    }

    @UnsupportedAppUsage
    public static void destroyDisplay(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeDestroyDisplay(displayToken);
    }

    public static long[] getPhysicalDisplayIds() {
        return SurfaceControl.nativeGetPhysicalDisplayIds();
    }

    public static IBinder getPhysicalDisplayToken(long physicalDisplayId) {
        return SurfaceControl.nativeGetPhysicalDisplayToken(physicalDisplayId);
    }

    public static IBinder getInternalDisplayToken() {
        long[] physicalDisplayIds = SurfaceControl.getPhysicalDisplayIds();
        if (physicalDisplayIds.length == 0) {
            return null;
        }
        return SurfaceControl.getPhysicalDisplayToken(physicalDisplayIds[0]);
    }

    public static void screenshot(IBinder display, Surface consumer) {
        SurfaceControl.screenshot(display, consumer, new Rect(), 0, 0, false, 0);
    }

    public static void screenshot(IBinder display, Surface consumer, Rect sourceCrop, int width, int height, boolean useIdentityTransform, int rotation) {
        if (consumer == null) {
            throw new IllegalArgumentException("consumer must not be null");
        }
        ScreenshotGraphicBuffer buffer = SurfaceControl.screenshotToBuffer(display, sourceCrop, width, height, useIdentityTransform, rotation);
        try {
            consumer.attachAndQueueBuffer(buffer.getGraphicBuffer());
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Failed to take screenshot - " + e.getMessage());
        }
    }

    @UnsupportedAppUsage
    public static Bitmap screenshot(Rect sourceCrop, int width, int height, int rotation) {
        return SurfaceControl.screenshot(sourceCrop, width, height, false, rotation);
    }

    @UnsupportedAppUsage
    public static Bitmap screenshot(Rect sourceCrop, int width, int height, boolean useIdentityTransform, int rotation) {
        IBinder displayToken = SurfaceControl.getInternalDisplayToken();
        if (displayToken == null) {
            Log.w(TAG, "Failed to take screenshot because internal display is disconnected");
            return null;
        }
        if (rotation == 1 || rotation == 3) {
            rotation = rotation == 1 ? 3 : 1;
        }
        SurfaceControl.rotateCropForSF(sourceCrop, rotation);
        ScreenshotGraphicBuffer buffer = SurfaceControl.screenshotToBuffer(displayToken, sourceCrop, width, height, useIdentityTransform, rotation);
        if (buffer == null) {
            Log.w(TAG, "Failed to take screenshot");
            return null;
        }
        return Bitmap.wrapHardwareBuffer(buffer.getGraphicBuffer(), buffer.getColorSpace());
    }

    public static ScreenshotGraphicBuffer screenshotToBuffer(IBinder display, Rect sourceCrop, int width, int height, boolean useIdentityTransform, int rotation) {
        if (display == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeScreenshot(display, sourceCrop, width, height, useIdentityTransform, rotation, false);
    }

    public static ScreenshotGraphicBuffer screenshotToBufferWithSecureLayersUnsafe(IBinder display, Rect sourceCrop, int width, int height, boolean useIdentityTransform, int rotation) {
        if (display == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeScreenshot(display, sourceCrop, width, height, useIdentityTransform, rotation, true);
    }

    private static void rotateCropForSF(Rect crop, int rot) {
        if (rot == 1 || rot == 3) {
            int tmp = crop.top;
            crop.top = crop.left;
            crop.left = tmp;
            tmp = crop.right;
            crop.right = crop.bottom;
            crop.bottom = tmp;
        }
    }

    public static ScreenshotGraphicBuffer captureLayers(IBinder layerHandleToken, Rect sourceCrop, float frameScale) {
        IBinder displayToken = SurfaceControl.getInternalDisplayToken();
        return SurfaceControl.nativeCaptureLayers(displayToken, layerHandleToken, sourceCrop, frameScale, null);
    }

    public static ScreenshotGraphicBuffer captureLayersExcluding(IBinder layerHandleToken, Rect sourceCrop, float frameScale, IBinder[] exclude) {
        IBinder displayToken = SurfaceControl.getInternalDisplayToken();
        return SurfaceControl.nativeCaptureLayers(displayToken, layerHandleToken, sourceCrop, frameScale, exclude);
    }

    public static boolean getProtectedContentSupport() {
        return SurfaceControl.nativeGetProtectedContentSupport();
    }

    public static boolean getDisplayBrightnessSupport(IBinder displayToken) {
        return SurfaceControl.nativeGetDisplayBrightnessSupport(displayToken);
    }

    public static boolean setDisplayBrightness(IBinder displayToken, float brightness) {
        Objects.requireNonNull(displayToken);
        if (Float.isNaN(brightness) || brightness > 1.0f || brightness < 0.0f && brightness != -1.0f) {
            throw new IllegalArgumentException("brightness must be a number between 0.0f and 1.0f, or -1 to turn the backlight off.");
        }
        return SurfaceControl.nativeSetDisplayBrightness(displayToken, brightness);
    }

    static /* synthetic */ long access$200() {
        return SurfaceControl.nativeGetNativeTransactionFinalizer();
    }

    static {
        sTransactionNestCount = 0L;
        CREATOR = new Parcelable.Creator<SurfaceControl>(){

            @Override
            public SurfaceControl createFromParcel(Parcel in) {
                return new SurfaceControl(in);
            }

            public SurfaceControl[] newArray(int size) {
                return new SurfaceControl[size];
            }
        };
    }

    public static class Transaction
    implements Closeable {
        public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(Transaction.class.getClassLoader(), SurfaceControl.access$200(), 512L);
        private long mNativeObject;
        private final ArrayMap<SurfaceControl, Point> mResizedSurfaces = new ArrayMap();
        Runnable mFreeNativeResources;

        public Transaction() {
            this.mNativeObject = SurfaceControl.nativeCreateTransaction();
            this.mFreeNativeResources = sRegistry.registerNativeAllocation(this, this.mNativeObject);
        }

        public void apply() {
            this.apply(false);
        }

        @Override
        public void close() {
            this.mFreeNativeResources.run();
            this.mNativeObject = 0L;
        }

        public void apply(boolean sync) {
            this.applyResizedSurfaces();
            SurfaceControl.nativeApplyTransaction(this.mNativeObject, sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyResizedSurfaces() {
            for (int i = this.mResizedSurfaces.size() - 1; i >= 0; --i) {
                Point size = this.mResizedSurfaces.valueAt(i);
                SurfaceControl surfaceControl = this.mResizedSurfaces.keyAt(i);
                Object object = surfaceControl.mSizeLock;
                synchronized (object) {
                    surfaceControl.mWidth = size.x;
                    surfaceControl.mHeight = size.y;
                    continue;
                }
            }
            this.mResizedSurfaces.clear();
        }

        public Transaction setVisibility(SurfaceControl sc, boolean visible) {
            sc.checkNotReleased();
            if (visible) {
                return this.show(sc);
            }
            return this.hide(sc);
        }

        @UnsupportedAppUsage
        public Transaction show(SurfaceControl sc) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 1);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction hide(SurfaceControl sc) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 1, 1);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setPosition(SurfaceControl sc, float x, float y) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetPosition(this.mNativeObject, sc.mNativeObject, x, y);
            return this;
        }

        public Transaction setBufferSize(SurfaceControl sc, int w, int h) {
            sc.checkNotReleased();
            this.mResizedSurfaces.put(sc, new Point(w, h));
            SurfaceControl.nativeSetSize(this.mNativeObject, sc.mNativeObject, w, h);
            return this;
        }

        public Transaction setLayer(SurfaceControl sc, int z) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetLayer(this.mNativeObject, sc.mNativeObject, z);
            return this;
        }

        public Transaction setRelativeLayer(SurfaceControl sc, SurfaceControl relativeTo, int z) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetRelativeLayer(this.mNativeObject, sc.mNativeObject, relativeTo.getHandle(), z);
            return this;
        }

        public Transaction setTransparentRegionHint(SurfaceControl sc, Region transparentRegion) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetTransparentRegionHint(this.mNativeObject, sc.mNativeObject, transparentRegion);
            return this;
        }

        public Transaction setAlpha(SurfaceControl sc, float alpha) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetAlpha(this.mNativeObject, sc.mNativeObject, alpha);
            return this;
        }

        public Transaction setInputWindowInfo(SurfaceControl sc, InputWindowHandle handle) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetInputWindowInfo(this.mNativeObject, sc.mNativeObject, handle);
            return this;
        }

        public Transaction transferTouchFocus(IBinder fromToken, IBinder toToken) {
            SurfaceControl.nativeTransferTouchFocus(this.mNativeObject, fromToken, toToken);
            return this;
        }

        public Transaction syncInputWindows() {
            SurfaceControl.nativeSyncInputWindows(this.mNativeObject);
            return this;
        }

        public Transaction setGeometry(SurfaceControl sc, Rect sourceCrop, Rect destFrame, int orientation) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetGeometry(this.mNativeObject, sc.mNativeObject, sourceCrop, destFrame, orientation);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setMatrix(SurfaceControl sc, float dsdx, float dtdx, float dtdy, float dsdy) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetMatrix(this.mNativeObject, sc.mNativeObject, dsdx, dtdx, dtdy, dsdy);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setMatrix(SurfaceControl sc, Matrix matrix, float[] float9) {
            matrix.getValues(float9);
            this.setMatrix(sc, float9[0], float9[3], float9[1], float9[4]);
            this.setPosition(sc, float9[2], float9[5]);
            return this;
        }

        public Transaction setColorTransform(SurfaceControl sc, float[] matrix, float[] translation) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetColorTransform(this.mNativeObject, sc.mNativeObject, matrix, translation);
            return this;
        }

        public Transaction setColorSpaceAgnostic(SurfaceControl sc, boolean agnostic) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetColorSpaceAgnostic(this.mNativeObject, sc.mNativeObject, agnostic);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setWindowCrop(SurfaceControl sc, Rect crop) {
            sc.checkNotReleased();
            if (crop != null) {
                SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, crop.left, crop.top, crop.right, crop.bottom);
            } else {
                SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, 0, 0, 0, 0);
            }
            return this;
        }

        public Transaction setWindowCrop(SurfaceControl sc, int width, int height) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, 0, 0, width, height);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setCornerRadius(SurfaceControl sc, float cornerRadius) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetCornerRadius(this.mNativeObject, sc.mNativeObject, cornerRadius);
            return this;
        }

        @UnsupportedAppUsage(maxTargetSdk=26)
        public Transaction setLayerStack(SurfaceControl sc, int layerStack) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetLayerStack(this.mNativeObject, sc.mNativeObject, layerStack);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction deferTransactionUntil(SurfaceControl sc, IBinder handle, long frameNumber) {
            if (frameNumber < 0L) {
                return this;
            }
            sc.checkNotReleased();
            SurfaceControl.nativeDeferTransactionUntil(this.mNativeObject, sc.mNativeObject, handle, frameNumber);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction deferTransactionUntilSurface(SurfaceControl sc, Surface barrierSurface, long frameNumber) {
            if (frameNumber < 0L) {
                return this;
            }
            sc.checkNotReleased();
            SurfaceControl.nativeDeferTransactionUntilSurface(this.mNativeObject, sc.mNativeObject, barrierSurface.mNativeObject, frameNumber);
            return this;
        }

        public Transaction reparentChildren(SurfaceControl sc, IBinder newParentHandle) {
            sc.checkNotReleased();
            SurfaceControl.nativeReparentChildren(this.mNativeObject, sc.mNativeObject, newParentHandle);
            return this;
        }

        public Transaction reparent(SurfaceControl sc, SurfaceControl newParent) {
            sc.checkNotReleased();
            long otherObject = 0L;
            if (newParent != null) {
                newParent.checkNotReleased();
                otherObject = newParent.mNativeObject;
            }
            SurfaceControl.nativeReparent(this.mNativeObject, sc.mNativeObject, otherObject);
            return this;
        }

        public Transaction detachChildren(SurfaceControl sc) {
            sc.checkNotReleased();
            SurfaceControl.nativeSeverChildren(this.mNativeObject, sc.mNativeObject);
            return this;
        }

        public Transaction setOverrideScalingMode(SurfaceControl sc, int overrideScalingMode) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetOverrideScalingMode(this.mNativeObject, sc.mNativeObject, overrideScalingMode);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setColor(SurfaceControl sc, float[] color2) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetColor(this.mNativeObject, sc.mNativeObject, color2);
            return this;
        }

        public Transaction setGeometryAppliesWithResize(SurfaceControl sc) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetGeometryAppliesWithResize(this.mNativeObject, sc.mNativeObject);
            return this;
        }

        public Transaction setSecure(SurfaceControl sc, boolean isSecure) {
            sc.checkNotReleased();
            if (isSecure) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 128, 128);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 128);
            }
            return this;
        }

        public Transaction setOpaque(SurfaceControl sc, boolean isOpaque) {
            sc.checkNotReleased();
            if (isOpaque) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 2, 2);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 2);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transaction setDisplaySurface(IBinder displayToken, Surface surface) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (surface != null) {
                Object object = surface.mLock;
                synchronized (object) {
                    SurfaceControl.nativeSetDisplaySurface(this.mNativeObject, displayToken, surface.mNativeObject);
                }
            } else {
                SurfaceControl.nativeSetDisplaySurface(this.mNativeObject, displayToken, 0L);
            }
            return this;
        }

        public Transaction setDisplayLayerStack(IBinder displayToken, int layerStack) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            SurfaceControl.nativeSetDisplayLayerStack(this.mNativeObject, displayToken, layerStack);
            return this;
        }

        public Transaction setDisplayProjection(IBinder displayToken, int orientation, Rect layerStackRect, Rect displayRect) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (layerStackRect == null) {
                throw new IllegalArgumentException("layerStackRect must not be null");
            }
            if (displayRect == null) {
                throw new IllegalArgumentException("displayRect must not be null");
            }
            SurfaceControl.nativeSetDisplayProjection(this.mNativeObject, displayToken, orientation, layerStackRect.left, layerStackRect.top, layerStackRect.right, layerStackRect.bottom, displayRect.left, displayRect.top, displayRect.right, displayRect.bottom);
            return this;
        }

        public Transaction setDisplaySize(IBinder displayToken, int width, int height) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException("width and height must be positive");
            }
            SurfaceControl.nativeSetDisplaySize(this.mNativeObject, displayToken, width, height);
            return this;
        }

        public Transaction setAnimationTransaction() {
            SurfaceControl.nativeSetAnimationTransaction(this.mNativeObject);
            return this;
        }

        public Transaction setEarlyWakeup() {
            SurfaceControl.nativeSetEarlyWakeup(this.mNativeObject);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transaction setMetadata(SurfaceControl sc, int key, int data) {
            Parcel parcel = Parcel.obtain();
            parcel.writeInt(data);
            try {
                this.setMetadata(sc, key, parcel);
            }
            finally {
                parcel.recycle();
            }
            return this;
        }

        public Transaction setMetadata(SurfaceControl sc, int key, Parcel data) {
            SurfaceControl.nativeSetMetadata(this.mNativeObject, sc.mNativeObject, key, data);
            return this;
        }

        public Transaction merge(Transaction other) {
            if (this == other) {
                return this;
            }
            this.mResizedSurfaces.putAll(other.mResizedSurfaces);
            other.mResizedSurfaces.clear();
            SurfaceControl.nativeMergeTransaction(this.mNativeObject, other.mNativeObject);
            return this;
        }

        public Transaction remove(SurfaceControl sc) {
            this.reparent(sc, null);
            sc.release();
            return this;
        }
    }

    public static class DisplayPrimaries {
        public CieXyz red;
        public CieXyz green;
        public CieXyz blue;
        public CieXyz white;
    }

    public static class CieXyz {
        public float X;
        public float Y;
        public float Z;
    }

    public static class PhysicalDisplayInfo {
        @UnsupportedAppUsage
        public int width;
        @UnsupportedAppUsage
        public int height;
        @UnsupportedAppUsage
        public float refreshRate;
        @UnsupportedAppUsage
        public float density;
        @UnsupportedAppUsage
        public float xDpi;
        @UnsupportedAppUsage
        public float yDpi;
        @UnsupportedAppUsage
        public boolean secure;
        @UnsupportedAppUsage
        public long appVsyncOffsetNanos;
        @UnsupportedAppUsage
        public long presentationDeadlineNanos;

        @UnsupportedAppUsage
        public PhysicalDisplayInfo() {
        }

        public PhysicalDisplayInfo(PhysicalDisplayInfo other) {
            this.copyFrom(other);
        }

        public boolean equals(Object o) {
            return o instanceof PhysicalDisplayInfo && this.equals((PhysicalDisplayInfo)o);
        }

        public boolean equals(PhysicalDisplayInfo other) {
            return other != null && this.width == other.width && this.height == other.height && this.refreshRate == other.refreshRate && this.density == other.density && this.xDpi == other.xDpi && this.yDpi == other.yDpi && this.secure == other.secure && this.appVsyncOffsetNanos == other.appVsyncOffsetNanos && this.presentationDeadlineNanos == other.presentationDeadlineNanos;
        }

        public int hashCode() {
            return 0;
        }

        public void copyFrom(PhysicalDisplayInfo other) {
            this.width = other.width;
            this.height = other.height;
            this.refreshRate = other.refreshRate;
            this.density = other.density;
            this.xDpi = other.xDpi;
            this.yDpi = other.yDpi;
            this.secure = other.secure;
            this.appVsyncOffsetNanos = other.appVsyncOffsetNanos;
            this.presentationDeadlineNanos = other.presentationDeadlineNanos;
        }

        public String toString() {
            return "PhysicalDisplayInfo{" + this.width + " x " + this.height + ", " + this.refreshRate + " fps, density " + this.density + ", " + this.xDpi + " x " + this.yDpi + " dpi, secure " + this.secure + ", appVsyncOffset " + this.appVsyncOffsetNanos + ", bufferDeadline " + this.presentationDeadlineNanos + "}";
        }
    }

    public static class Builder {
        private SurfaceSession mSession;
        private int mFlags = 4;
        private int mWidth;
        private int mHeight;
        private int mFormat = -1;
        private String mName;
        private SurfaceControl mParent;
        private SparseIntArray mMetadata;

        public Builder(SurfaceSession session) {
            this.mSession = session;
        }

        public Builder() {
        }

        public SurfaceControl build() {
            if (this.mWidth < 0 || this.mHeight < 0) {
                throw new IllegalStateException("width and height must be positive or unset");
            }
            if ((this.mWidth > 0 || this.mHeight > 0) && (this.isColorLayerSet() || this.isContainerLayerSet())) {
                throw new IllegalStateException("Only buffer layers can set a valid buffer size.");
            }
            return new SurfaceControl(this.mSession, this.mName, this.mWidth, this.mHeight, this.mFormat, this.mFlags, this.mParent, this.mMetadata);
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setBufferSize(int width, int height) {
            if (width < 0 || height < 0) {
                throw new IllegalArgumentException("width and height must be positive");
            }
            this.mWidth = width;
            this.mHeight = height;
            return this.setFlags(0, 983040);
        }

        private void unsetBufferSize() {
            this.mWidth = 0;
            this.mHeight = 0;
        }

        public Builder setFormat(int format) {
            this.mFormat = format;
            return this;
        }

        public Builder setProtected(boolean protectedContent) {
            this.mFlags = protectedContent ? (this.mFlags |= 0x800) : (this.mFlags &= 0xFFFFF7FF);
            return this;
        }

        public Builder setSecure(boolean secure) {
            this.mFlags = secure ? (this.mFlags |= 0x80) : (this.mFlags &= 0xFFFFFF7F);
            return this;
        }

        public Builder setOpaque(boolean opaque) {
            this.mFlags = opaque ? (this.mFlags |= 0x400) : (this.mFlags &= 0xFFFFFBFF);
            return this;
        }

        public Builder setParent(SurfaceControl parent) {
            this.mParent = parent;
            return this;
        }

        public Builder setMetadata(int key, int data) {
            if (this.mMetadata == null) {
                this.mMetadata = new SparseIntArray();
            }
            this.mMetadata.put(key, data);
            return this;
        }

        public Builder setColorLayer() {
            this.unsetBufferSize();
            return this.setFlags(131072, 983040);
        }

        private boolean isColorLayerSet() {
            return (this.mFlags & 0x20000) == 131072;
        }

        public Builder setContainerLayer() {
            this.unsetBufferSize();
            return this.setFlags(524288, 983040);
        }

        private boolean isContainerLayerSet() {
            return (this.mFlags & 0x80000) == 524288;
        }

        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        private Builder setFlags(int flags, int mask) {
            this.mFlags = this.mFlags & ~mask | flags;
            return this;
        }
    }

    public static class ScreenshotGraphicBuffer {
        private final GraphicBuffer mGraphicBuffer;
        private final ColorSpace mColorSpace;
        private final boolean mContainsSecureLayers;

        public ScreenshotGraphicBuffer(GraphicBuffer graphicBuffer, ColorSpace colorSpace, boolean containsSecureLayers) {
            this.mGraphicBuffer = graphicBuffer;
            this.mColorSpace = colorSpace;
            this.mContainsSecureLayers = containsSecureLayers;
        }

        private static ScreenshotGraphicBuffer createFromNative(int width, int height, int format, int usage, long unwrappedNativeObject, int namedColorSpace, boolean containsSecureLayers) {
            GraphicBuffer graphicBuffer = GraphicBuffer.createFromExisting(width, height, format, usage, unwrappedNativeObject);
            ColorSpace colorSpace = ColorSpace.get(ColorSpace.Named.values()[namedColorSpace]);
            return new ScreenshotGraphicBuffer(graphicBuffer, colorSpace, containsSecureLayers);
        }

        public ColorSpace getColorSpace() {
            return this.mColorSpace;
        }

        public GraphicBuffer getGraphicBuffer() {
            return this.mGraphicBuffer;
        }

        public boolean containsSecureLayers() {
            return this.mContainsSecureLayers;
        }
    }
}

