/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.UnsupportedAppUsage;
import android.graphics.Rect;
import android.graphics.Region;
import android.util.ArrayMap;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityNodeInfo;

public class TouchDelegate {
    private View mDelegateView;
    private Rect mBounds;
    private Rect mSlopBounds;
    @UnsupportedAppUsage
    private boolean mDelegateTargeted;
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    public static final int TO_LEFT = 4;
    public static final int TO_RIGHT = 8;
    private int mSlop;
    private AccessibilityNodeInfo.TouchDelegateInfo mTouchDelegateInfo;

    public TouchDelegate(Rect bounds, View delegateView) {
        this.mBounds = bounds;
        this.mSlop = ViewConfiguration.get(delegateView.getContext()).getScaledTouchSlop();
        this.mSlopBounds = new Rect(bounds);
        this.mSlopBounds.inset(-this.mSlop, -this.mSlop);
        this.mDelegateView = delegateView;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        boolean sendToDelegate = false;
        boolean hit = true;
        boolean handled = false;
        switch (event.getActionMasked()) {
            case 0: {
                sendToDelegate = this.mDelegateTargeted = this.mBounds.contains(x, y);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                Rect slopBounds;
                sendToDelegate = this.mDelegateTargeted;
                if (!sendToDelegate || (slopBounds = this.mSlopBounds).contains(x, y)) break;
                hit = false;
                break;
            }
            case 3: {
                sendToDelegate = this.mDelegateTargeted;
                this.mDelegateTargeted = false;
            }
        }
        if (sendToDelegate) {
            if (hit) {
                event.setLocation(this.mDelegateView.getWidth() / 2, this.mDelegateView.getHeight() / 2);
            } else {
                int slop = this.mSlop;
                event.setLocation(-(slop * 2), -(slop * 2));
            }
            handled = this.mDelegateView.dispatchTouchEvent(event);
        }
        return handled;
    }

    public boolean onTouchExplorationHoverEvent(MotionEvent event) {
        if (this.mBounds == null) {
            return false;
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        boolean hit = true;
        boolean handled = false;
        boolean isInbound = this.mBounds.contains(x, y);
        switch (event.getActionMasked()) {
            case 9: {
                this.mDelegateTargeted = isInbound;
                break;
            }
            case 7: {
                if (isInbound) {
                    this.mDelegateTargeted = true;
                    break;
                }
                if (!this.mDelegateTargeted || this.mSlopBounds.contains(x, y)) break;
                hit = false;
                break;
            }
            case 10: {
                this.mDelegateTargeted = true;
            }
        }
        if (this.mDelegateTargeted) {
            if (hit) {
                event.setLocation(this.mDelegateView.getWidth() / 2, this.mDelegateView.getHeight() / 2);
            } else {
                this.mDelegateTargeted = false;
            }
            handled = this.mDelegateView.dispatchHoverEvent(event);
        }
        return handled;
    }

    public AccessibilityNodeInfo.TouchDelegateInfo getTouchDelegateInfo() {
        if (this.mTouchDelegateInfo == null) {
            ArrayMap<Region, View> targetMap = new ArrayMap<Region, View>(1);
            Rect bounds = this.mBounds;
            if (bounds == null) {
                bounds = new Rect();
            }
            targetMap.put(new Region(bounds), this.mDelegateView);
            this.mTouchDelegateInfo = new AccessibilityNodeInfo.TouchDelegateInfo(targetMap);
        }
        return this.mTouchDelegateInfo;
    }
}

