/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier.intent;

import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.UserManager;
import android.provider.CalendarContract;
import android.view.textclassifier.Log;
import android.view.textclassifier.intent.ClassificationIntentFactory;
import android.view.textclassifier.intent.LabeledIntent;
import com.google.android.textclassifier.AnnotatorModel;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class LegacyClassificationIntentFactory
implements ClassificationIntentFactory {
    private static final String TAG = "LegacyClassificationIntentFactory";
    private static final long MIN_EVENT_FUTURE_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private static final long DEFAULT_EVENT_DURATION = TimeUnit.HOURS.toMillis(1L);

    @Override
    public List<LabeledIntent> create(Context context, String text, boolean foreignText, Instant referenceTime, AnnotatorModel.ClassificationResult classification) {
        List<LabeledIntent> actions;
        String type = classification != null ? classification.getCollection().trim().toLowerCase(Locale.ENGLISH) : "";
        text = text.trim();
        switch (type) {
            case "email": {
                actions = LegacyClassificationIntentFactory.createForEmail(context, text);
                break;
            }
            case "phone": {
                actions = LegacyClassificationIntentFactory.createForPhone(context, text);
                break;
            }
            case "address": {
                actions = LegacyClassificationIntentFactory.createForAddress(context, text);
                break;
            }
            case "url": {
                actions = LegacyClassificationIntentFactory.createForUrl(context, text);
                break;
            }
            case "date": 
            case "datetime": {
                if (classification.getDatetimeResult() != null) {
                    Instant parsedTime = Instant.ofEpochMilli(classification.getDatetimeResult().getTimeMsUtc());
                    actions = LegacyClassificationIntentFactory.createForDatetime(context, type, referenceTime, parsedTime);
                    break;
                }
                actions = new ArrayList<LabeledIntent>();
                break;
            }
            case "flight": {
                actions = LegacyClassificationIntentFactory.createForFlight(context, text);
                break;
            }
            case "dictionary": {
                actions = LegacyClassificationIntentFactory.createForDictionary(context, text);
                break;
            }
            default: {
                actions = new ArrayList<LabeledIntent>();
            }
        }
        if (foreignText) {
            ClassificationIntentFactory.insertTranslateAction(actions, context, text);
        }
        return actions;
    }

    private static List<LabeledIntent> createForEmail(Context context, String text) {
        ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
        actions.add(new LabeledIntent(context.getString(17039888), null, context.getString(17039894), null, new Intent("android.intent.action.SENDTO").setData(Uri.parse(String.format("mailto:%s", text))), 0));
        actions.add(new LabeledIntent(context.getString(17039468), null, context.getString(17039469), null, new Intent("android.intent.action.INSERT_OR_EDIT").setType("vnd.android.cursor.item/contact").putExtra("email", text), text.hashCode()));
        return actions;
    }

    private static List<LabeledIntent> createForPhone(Context context, String text) {
        Bundle userRestrictions;
        ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
        UserManager userManager = context.getSystemService(UserManager.class);
        Bundle bundle = userRestrictions = userManager != null ? userManager.getUserRestrictions() : new Bundle();
        if (!userRestrictions.getBoolean("no_outgoing_calls", false)) {
            actions.add(new LabeledIntent(context.getString(17039861), null, context.getString(17039862), null, new Intent("android.intent.action.DIAL").setData(Uri.parse(String.format("tel:%s", text))), 0));
        }
        actions.add(new LabeledIntent(context.getString(17039468), null, context.getString(17039469), null, new Intent("android.intent.action.INSERT_OR_EDIT").setType("vnd.android.cursor.item/contact").putExtra("phone", text), text.hashCode()));
        if (!userRestrictions.getBoolean("no_sms", false)) {
            actions.add(new LabeledIntent(context.getString(17041040), null, context.getString(17041045), null, new Intent("android.intent.action.SENDTO").setData(Uri.parse(String.format("smsto:%s", text))), 0));
        }
        return actions;
    }

    private static List<LabeledIntent> createForAddress(Context context, String text) {
        ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
        try {
            String encText = URLEncoder.encode(text, "UTF-8");
            actions.add(new LabeledIntent(context.getString(17040303), null, context.getString(17040304), null, new Intent("android.intent.action.VIEW").setData(Uri.parse(String.format("geo:0,0?q=%s", encText))), 0));
        }
        catch (UnsupportedEncodingException e) {
            Log.e(TAG, "Could not encode address", e);
        }
        return actions;
    }

    private static List<LabeledIntent> createForUrl(Context context, String text) {
        if (Uri.parse(text).getScheme() == null) {
            text = "http://" + text;
        }
        ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
        actions.add(new LabeledIntent(context.getString(0x1040100), null, context.getString(0x1040101), null, new Intent("android.intent.action.VIEW").setDataAndNormalize(Uri.parse(text)).putExtra("com.android.browser.application_id", context.getPackageName()), 0));
        return actions;
    }

    private static List<LabeledIntent> createForDatetime(Context context, String type, Instant referenceTime, Instant parsedTime) {
        if (referenceTime == null) {
            referenceTime = Instant.now();
        }
        ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
        actions.add(LegacyClassificationIntentFactory.createCalendarViewIntent(context, parsedTime));
        long millisUntilEvent = referenceTime.until(parsedTime, ChronoUnit.MILLIS);
        if (millisUntilEvent > MIN_EVENT_FUTURE_MILLIS) {
            actions.add(LegacyClassificationIntentFactory.createCalendarCreateEventIntent(context, parsedTime, type));
        }
        return actions;
    }

    private static List<LabeledIntent> createForFlight(Context context, String text) {
        ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
        actions.add(new LabeledIntent(context.getString(17041189), null, context.getString(17041190), null, new Intent("android.intent.action.WEB_SEARCH").putExtra("query", text), text.hashCode()));
        return actions;
    }

    private static LabeledIntent createCalendarViewIntent(Context context, Instant parsedTime) {
        Uri.Builder builder = CalendarContract.CONTENT_URI.buildUpon();
        builder.appendPath("time");
        ContentUris.appendId(builder, parsedTime.toEpochMilli());
        return new LabeledIntent(context.getString(17041187), null, context.getString(17041188), null, new Intent("android.intent.action.VIEW").setData(builder.build()), 0);
    }

    private static LabeledIntent createCalendarCreateEventIntent(Context context, Instant parsedTime, String type) {
        boolean isAllDay = "date".equals(type);
        return new LabeledIntent(context.getString(17039466), null, context.getString(17039467), null, new Intent("android.intent.action.INSERT").setData(CalendarContract.Events.CONTENT_URI).putExtra("allDay", isAllDay).putExtra("beginTime", parsedTime.toEpochMilli()).putExtra("endTime", parsedTime.toEpochMilli() + DEFAULT_EVENT_DURATION), parsedTime.hashCode());
    }

    private static List<LabeledIntent> createForDictionary(Context context, String text) {
        ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
        actions.add(new LabeledIntent(context.getString(17039849), null, context.getString(17039850), null, new Intent("android.intent.action.DEFINE").putExtra("android.intent.extra.TEXT", text), text.hashCode()));
        return actions;
    }
}

