/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.UnsupportedAppUsage;
import android.app.ActivityManager;
import android.app.IActivityManager;
import android.app.ListFragment;
import android.app.backup.BackupManager;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.RemoteException;
import android.provider.Settings;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class LocalePicker
extends ListFragment {
    private static final String TAG = "LocalePicker";
    private static final boolean DEBUG = false;
    private static final String[] pseudoLocales = new String[]{"en-XA", "ar-XB"};
    LocaleSelectionListener mListener;

    public static String[] getSystemAssetLocales() {
        return Resources.getSystem().getAssets().getLocales();
    }

    public static String[] getSupportedLocales(Context context) {
        return context.getResources().getStringArray(17236107);
    }

    public static List<LocaleInfo> getAllAssetLocales(Context context, boolean isInDeveloperMode) {
        Resources resources = context.getResources();
        String[] locales = LocalePicker.getSystemAssetLocales();
        ArrayList localeList = new ArrayList(locales.length);
        Collections.addAll(localeList, locales);
        Collections.sort(localeList);
        String[] specialLocaleCodes = resources.getStringArray(17236105);
        String[] specialLocaleNames = resources.getStringArray(17236106);
        ArrayList<LocaleInfo> localeInfos = new ArrayList<LocaleInfo>(localeList.size());
        for (String locale : localeList) {
            Locale l = Locale.forLanguageTag(locale.replace('_', '-'));
            if (l == null || "und".equals(l.getLanguage()) || l.getLanguage().isEmpty() || l.getCountry().isEmpty() || !isInDeveloperMode && LocaleList.isPseudoLocale(l)) continue;
            if (localeInfos.isEmpty()) {
                localeInfos.add(new LocaleInfo(LocalePicker.toTitleCase(l.getDisplayLanguage(l)), l));
                continue;
            }
            LocaleInfo previous = localeInfos.get(localeInfos.size() - 1);
            if (previous.locale.getLanguage().equals(l.getLanguage()) && !previous.locale.getLanguage().equals("zz")) {
                previous.label = LocalePicker.toTitleCase(LocalePicker.getDisplayName(previous.locale, specialLocaleCodes, specialLocaleNames));
                localeInfos.add(new LocaleInfo(LocalePicker.toTitleCase(LocalePicker.getDisplayName(l, specialLocaleCodes, specialLocaleNames)), l));
                continue;
            }
            String displayName = LocalePicker.toTitleCase(l.getDisplayLanguage(l));
            localeInfos.add(new LocaleInfo(displayName, l));
        }
        Collections.sort(localeInfos);
        return localeInfos;
    }

    public static ArrayAdapter<LocaleInfo> constructAdapter(Context context) {
        return LocalePicker.constructAdapter(context, 17367183, 16909076);
    }

    public static ArrayAdapter<LocaleInfo> constructAdapter(Context context, final int layoutId, final int fieldId) {
        boolean isInDeveloperMode = Settings.Global.getInt(context.getContentResolver(), "development_settings_enabled", 0) != 0;
        List<LocaleInfo> localeInfos = LocalePicker.getAllAssetLocales(context, isInDeveloperMode);
        final LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        return new ArrayAdapter<LocaleInfo>(context, layoutId, fieldId, localeInfos){

            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                TextView text;
                View view;
                if (convertView == null) {
                    view = inflater.inflate(layoutId, parent, false);
                    text = (TextView)view.findViewById(fieldId);
                    view.setTag(text);
                } else {
                    view = convertView;
                    text = (TextView)view.getTag();
                }
                LocaleInfo item = (LocaleInfo)this.getItem(position);
                text.setText(item.toString());
                text.setTextLocale(item.getLocale());
                return view;
            }
        };
    }

    private static String toTitleCase(String s) {
        if (s.length() == 0) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private static String getDisplayName(Locale l, String[] specialLocaleCodes, String[] specialLocaleNames) {
        String code = l.toString();
        for (int i = 0; i < specialLocaleCodes.length; ++i) {
            if (!specialLocaleCodes[i].equals(code)) continue;
            return specialLocaleNames[i];
        }
        return l.getDisplayName(l);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        ArrayAdapter<LocaleInfo> adapter = LocalePicker.constructAdapter(this.getActivity());
        this.setListAdapter(adapter);
    }

    public void setLocaleSelectionListener(LocaleSelectionListener listener) {
        this.mListener = listener;
    }

    @Override
    public void onResume() {
        super.onResume();
        this.getListView().requestFocus();
    }

    @Override
    public void onListItemClick(ListView l, View v, int position, long id2) {
        if (this.mListener != null) {
            Locale locale = ((LocaleInfo)this.getListAdapter().getItem((int)position)).locale;
            this.mListener.onLocaleSelected(locale);
        }
    }

    @UnsupportedAppUsage
    public static void updateLocale(Locale locale) {
        LocalePicker.updateLocales(new LocaleList(locale));
    }

    @UnsupportedAppUsage
    public static void updateLocales(LocaleList locales) {
        try {
            IActivityManager am = ActivityManager.getService();
            Configuration config = am.getConfiguration();
            config.setLocales(locales);
            config.userSetLocale = true;
            am.updatePersistentConfiguration(config);
            BackupManager.dataChanged("com.android.providers.settings");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @UnsupportedAppUsage
    public static LocaleList getLocales() {
        try {
            return ActivityManager.getService().getConfiguration().getLocales();
        }
        catch (RemoteException e) {
            return LocaleList.getDefault();
        }
    }

    public static class LocaleInfo
    implements Comparable<LocaleInfo> {
        static final Collator sCollator = Collator.getInstance();
        String label;
        final Locale locale;

        public LocaleInfo(String label, Locale locale) {
            this.label = label;
            this.locale = locale;
        }

        public String getLabel() {
            return this.label;
        }

        @UnsupportedAppUsage
        public Locale getLocale() {
            return this.locale;
        }

        public String toString() {
            return this.label;
        }

        @Override
        public int compareTo(LocaleInfo another) {
            return sCollator.compare(this.label, another.label);
        }
    }

    public static interface LocaleSelectionListener {
        public void onLocaleSelected(Locale var1);
    }
}

