/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.pm.ApplicationInfo;
import android.net.Credentials;
import android.net.LocalServerSocket;
import android.net.LocalSocket;
import android.os.FactoryTest;
import android.os.Process;
import android.os.SystemProperties;
import android.os.Trace;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.os.RoSystemProperties;
import com.android.internal.os.ZygoteArguments;
import com.android.internal.os.ZygoteInit;
import com.android.internal.os.ZygoteSecurityException;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.ZygoteHooks;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import libcore.io.IoUtils;

public class Zygote {
    public static final int DEBUG_ENABLE_JDWP = 1;
    public static final int DEBUG_ENABLE_CHECKJNI = 2;
    public static final int DEBUG_ENABLE_ASSERT = 4;
    public static final int DEBUG_ENABLE_SAFEMODE = 8;
    public static final int DEBUG_ENABLE_JNI_LOGGING = 16;
    public static final int DEBUG_GENERATE_DEBUG_INFO = 32;
    public static final int DEBUG_ALWAYS_JIT = 64;
    public static final int DEBUG_NATIVE_DEBUGGABLE = 128;
    public static final int DEBUG_JAVA_DEBUGGABLE = 256;
    public static final int DISABLE_VERIFIER = 512;
    public static final int ONLY_USE_SYSTEM_OAT_FILES = 1024;
    public static final int DEBUG_GENERATE_MINI_DEBUG_INFO = 2048;
    public static final int API_ENFORCEMENT_POLICY_MASK = 12288;
    public static final int API_ENFORCEMENT_POLICY_SHIFT = Integer.numberOfTrailingZeros(12288);
    public static final int PROFILE_SYSTEM_SERVER = 16384;
    public static final int PROFILE_FROM_SHELL = 32768;
    public static final int USE_APP_IMAGE_STARTUP_CACHE = 65536;
    public static final int MOUNT_EXTERNAL_NONE = 0;
    public static final int MOUNT_EXTERNAL_DEFAULT = 1;
    public static final int MOUNT_EXTERNAL_READ = 2;
    public static final int MOUNT_EXTERNAL_WRITE = 3;
    public static final int MOUNT_EXTERNAL_LEGACY = 4;
    public static final int MOUNT_EXTERNAL_INSTALLER = 5;
    public static final int MOUNT_EXTERNAL_FULL = 6;
    public static final int USAP_MANAGEMENT_MESSAGE_BYTES = 8;
    public static final String CHILD_ZYGOTE_SOCKET_NAME_ARG = "--zygote-socket=";
    public static final String CHILD_ZYGOTE_ABI_LIST_ARG = "--abi-list=";
    public static final String CHILD_ZYGOTE_UID_RANGE_START = "--uid-range-start=";
    public static final String CHILD_ZYGOTE_UID_RANGE_END = "--uid-range-end=";
    private static final String ANDROID_SOCKET_PREFIX = "ANDROID_SOCKET_";
    public static final long PROPERTY_CHECK_INTERVAL = 60000L;
    public static final int SOCKET_BUFFER_SIZE = 256;
    protected static final int[][] INT_ARRAY_2D = new int[0][0];
    public static final String PRIMARY_SOCKET_NAME = "zygote";
    public static final String SECONDARY_SOCKET_NAME = "zygote_secondary";
    public static final String USAP_POOL_PRIMARY_SOCKET_NAME = "usap_pool_primary";
    public static final String USAP_POOL_SECONDARY_SOCKET_NAME = "usap_pool_secondary";
    private static final String USAP_ERROR_PREFIX = "Invalid command to USAP: ";

    private Zygote() {
    }

    public static int forkAndSpecialize(int uid, int gid, int[] gids, int runtimeFlags, int[][] rlimits, int mountExternal, String seInfo, String niceName, int[] fdsToClose, int[] fdsToIgnore, boolean startChildZygote, String instructionSet, String appDataDir, int targetSdkVersion) {
        ZygoteHooks.preFork();
        Zygote.resetNicePriority();
        int pid = Zygote.nativeForkAndSpecialize(uid, gid, gids, runtimeFlags, rlimits, mountExternal, seInfo, niceName, fdsToClose, fdsToIgnore, startChildZygote, instructionSet, appDataDir);
        if (pid == 0) {
            Zygote.disableExecuteOnly(targetSdkVersion);
            Trace.setTracingEnabled(true, runtimeFlags);
            Trace.traceBegin(64L, "PostFork");
        }
        ZygoteHooks.postForkCommon();
        return pid;
    }

    private static int nativeForkAndSpecialize(int n, int n2, int[] nArray, int n3, int[][] nArray2, int n4, String string2, String string3, int[] nArray3, int[] nArray4, boolean bl, String string4, String string5) {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeForkAndSpecialize(II[II[[IILjava/lang/String;Ljava/lang/String;[I[IZLjava/lang/String;Ljava/lang/String;)I", true, null);
    }

    public static void specializeAppProcess(int uid, int gid, int[] gids, int runtimeFlags, int[][] rlimits, int mountExternal, String seInfo, String niceName, boolean startChildZygote, String instructionSet, String appDataDir) {
        Zygote.nativeSpecializeAppProcess(uid, gid, gids, runtimeFlags, rlimits, mountExternal, seInfo, niceName, startChildZygote, instructionSet, appDataDir);
        Trace.setTracingEnabled(true, runtimeFlags);
        Trace.traceBegin(64L, "PostFork");
        ZygoteHooks.postForkCommon();
    }

    private static void nativeSpecializeAppProcess(int n, int n2, int[] nArray, int n3, int[][] nArray2, int n4, String string2, String string3, boolean bl, String string4, String string5) {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeSpecializeAppProcess(II[II[[IILjava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", true, null);
    }

    static void nativePreApplicationInit() {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativePreApplicationInit()V", true, null);
    }

    public static int forkSystemServer(int uid, int gid, int[] gids, int runtimeFlags, int[][] rlimits, long permittedCapabilities, long effectiveCapabilities) {
        ZygoteHooks.preFork();
        Zygote.resetNicePriority();
        int pid = Zygote.nativeForkSystemServer(uid, gid, gids, runtimeFlags, rlimits, permittedCapabilities, effectiveCapabilities);
        if (pid == 0) {
            Trace.setTracingEnabled(true, runtimeFlags);
        }
        ZygoteHooks.postForkCommon();
        return pid;
    }

    private static int nativeForkSystemServer(int n, int n2, int[] nArray, int n3, int[][] nArray2, long l, long l2) {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeForkSystemServer(II[II[[IJJ)I", true, null);
    }

    protected static void nativeAllowFileAcrossFork(String string2) {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeAllowFileAcrossFork(Ljava/lang/String;)V", true, null);
    }

    protected static void allowAppFilesAcrossFork(ApplicationInfo appInfo) {
        for (String path : appInfo.getAllApkPaths()) {
            Zygote.nativeAllowFileAcrossFork(path);
        }
    }

    protected static void nativeInstallSeccompUidGidFilter(int n, int n2) {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeInstallSeccompUidGidFilter(II)V", true, null);
    }

    static void initNativeState(boolean isPrimary) {
        Zygote.nativeInitNativeState(isPrimary);
    }

    protected static void nativeInitNativeState(boolean bl) {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeInitNativeState(Z)V", true, null);
    }

    public static String getConfigurationProperty(String propertyName, String defaultValue) {
        return SystemProperties.get(String.join((CharSequence)".", "persist.device_config", "runtime_native", propertyName), defaultValue);
    }

    protected static void emptyUsapPool() {
        Zygote.nativeEmptyUsapPool();
    }

    private static void nativeEmptyUsapPool() {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeEmptyUsapPool()V", true, null);
    }

    public static boolean getConfigurationPropertyBoolean(String propertyName, Boolean defaultValue) {
        return SystemProperties.getBoolean(String.join((CharSequence)".", "persist.device_config", "runtime_native", propertyName), defaultValue);
    }

    static int getUsapPoolCount() {
        return Zygote.nativeGetUsapPoolCount();
    }

    private static int nativeGetUsapPoolCount() {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeGetUsapPoolCount()I", true, null);
    }

    static FileDescriptor getUsapPoolEventFD() {
        FileDescriptor fd = new FileDescriptor();
        fd.setInt$(Zygote.nativeGetUsapPoolEventFD());
        return fd;
    }

    private static int nativeGetUsapPoolEventFD() {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeGetUsapPoolEventFD()I", true, null);
    }

    static Runnable forkUsap(LocalServerSocket usapPoolSocket, int[] sessionSocketRawFDs) {
        FileDescriptor[] pipeFDs = null;
        try {
            pipeFDs = Os.pipe2(OsConstants.O_CLOEXEC);
        }
        catch (ErrnoException errnoEx) {
            throw new IllegalStateException("Unable to create USAP pipe.", errnoEx);
        }
        int pid = Zygote.nativeForkUsap(pipeFDs[0].getInt$(), pipeFDs[1].getInt$(), sessionSocketRawFDs);
        if (pid == 0) {
            IoUtils.closeQuietly(pipeFDs[0]);
            return Zygote.usapMain(usapPoolSocket, pipeFDs[1]);
        }
        IoUtils.closeQuietly(pipeFDs[1]);
        return null;
    }

    private static int nativeForkUsap(int n, int n2, int[] nArray) {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeForkUsap(II[I)I", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Runnable usapMain(LocalServerSocket usapPoolSocket, FileDescriptor writePipe) {
        int pid = Process.myPid();
        Process.setArgV0(Process.is64Bit() ? "usap64" : "usap32");
        LocalSocket sessionSocket = null;
        DataOutputStream usapOutputStream = null;
        Credentials peerCredentials = null;
        ZygoteArguments args = null;
        block19: while (true) {
            try {
                while (true) {
                    sessionSocket = usapPoolSocket.accept();
                    Zygote.blockSigTerm();
                    BufferedReader usapReader = new BufferedReader(new InputStreamReader(sessionSocket.getInputStream()));
                    usapOutputStream = new DataOutputStream(sessionSocket.getOutputStream());
                    peerCredentials = sessionSocket.getPeerCredentials();
                    String[] argStrings = Zygote.readArgumentList(usapReader);
                    if (argStrings != null) {
                        args = new ZygoteArguments(argStrings);
                        Zygote.validateUsapCommand(args);
                        break block19;
                    }
                    Log.e("USAP", "Truncated command received.");
                    IoUtils.closeQuietly(sessionSocket);
                    Zygote.unblockSigTerm();
                }
            }
            catch (Exception ex) {
                Log.e("USAP", ex.getMessage());
                IoUtils.closeQuietly(sessionSocket);
                Zygote.unblockSigTerm();
                continue;
            }
            break;
        }
        try {
            Zygote.applyUidSecurityPolicy(args, peerCredentials);
            Zygote.applyDebuggerSystemProperty(args);
            int[][] rlimits = null;
            if (args.mRLimits != null) {
                rlimits = (int[][])args.mRLimits.toArray((T[])INT_ARRAY_2D);
            }
            try {
                usapOutputStream.writeInt(pid);
            }
            catch (IOException ioEx) {
                Log.e("USAP", "Failed to write response to session socket: " + ioEx.getMessage());
                throw new RuntimeException(ioEx);
            }
            finally {
                IoUtils.closeQuietly(sessionSocket);
                try {
                    Os.close(usapPoolSocket.getFileDescriptor());
                }
                catch (ErrnoException ex) {
                    Log.e("USAP", "Failed to close USAP pool socket");
                    throw new RuntimeException(ex);
                }
            }
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
                DataOutputStream outputStream = new DataOutputStream(buffer);
                outputStream.writeLong(pid);
                outputStream.flush();
                Os.write(writePipe, buffer.toByteArray(), 0, buffer.size());
            }
            catch (Exception ex) {
                Log.e("USAP", String.format("Failed to write PID (%d) to pipe (%d): %s", pid, writePipe.getInt$(), ex.getMessage()));
                throw new RuntimeException(ex);
            }
            finally {
                IoUtils.closeQuietly(writePipe);
            }
            Zygote.specializeAppProcess(args.mUid, args.mGid, args.mGids, args.mRuntimeFlags, rlimits, args.mMountExternal, args.mSeInfo, args.mNiceName, args.mStartChildZygote, args.mInstructionSet, args.mAppDataDir);
            Zygote.disableExecuteOnly(args.mTargetSdkVersion);
            if (args.mNiceName != null) {
                Process.setArgV0(args.mNiceName);
            }
            Trace.traceEnd(64L);
            Runnable runnable = ZygoteInit.zygoteInit(args.mTargetSdkVersion, args.mRemainingArgs, null);
            return runnable;
        }
        finally {
            Zygote.unblockSigTerm();
        }
    }

    private static void blockSigTerm() {
        Zygote.nativeBlockSigTerm();
    }

    private static void nativeBlockSigTerm() {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeBlockSigTerm()V", true, null);
    }

    private static void unblockSigTerm() {
        Zygote.nativeUnblockSigTerm();
    }

    private static void nativeUnblockSigTerm() {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeUnblockSigTerm()V", true, null);
    }

    private static void validateUsapCommand(ZygoteArguments args) {
        if (args.mAbiListQuery) {
            throw new IllegalArgumentException("Invalid command to USAP: --query-abi-list");
        }
        if (args.mPidQuery) {
            throw new IllegalArgumentException("Invalid command to USAP: --get-pid");
        }
        if (args.mPreloadDefault) {
            throw new IllegalArgumentException("Invalid command to USAP: --preload-default");
        }
        if (args.mPreloadPackage != null) {
            throw new IllegalArgumentException("Invalid command to USAP: --preload-package");
        }
        if (args.mPreloadApp != null) {
            throw new IllegalArgumentException("Invalid command to USAP: --preload-app");
        }
        if (args.mStartChildZygote) {
            throw new IllegalArgumentException("Invalid command to USAP: --start-child-zygote");
        }
        if (args.mApiBlacklistExemptions != null) {
            throw new IllegalArgumentException("Invalid command to USAP: --set-api-blacklist-exemptions");
        }
        if (args.mHiddenApiAccessLogSampleRate != -1) {
            throw new IllegalArgumentException("Invalid command to USAP: --hidden-api-log-sampling-rate=");
        }
        if (args.mHiddenApiAccessStatslogSampleRate != -1) {
            throw new IllegalArgumentException("Invalid command to USAP: --hidden-api-statslog-sampling-rate=");
        }
        if (args.mInvokeWith != null) {
            throw new IllegalArgumentException("Invalid command to USAP: --invoke-with");
        }
        if (args.mPermittedCapabilities != 0L || args.mEffectiveCapabilities != 0L) {
            throw new ZygoteSecurityException("Client may not specify capabilities: permitted=0x" + Long.toHexString(args.mPermittedCapabilities) + ", effective=0x" + Long.toHexString(args.mEffectiveCapabilities));
        }
    }

    protected static void disableExecuteOnly(int targetSdkVersion) {
        if (targetSdkVersion < 29 && !Zygote.nativeDisableExecuteOnly()) {
            Log.e("Zygote", "Failed to set libraries to read+execute.");
        }
    }

    private static boolean nativeDisableExecuteOnly() {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeDisableExecuteOnly()Z", true, null) != 0;
    }

    protected static int[] getUsapPipeFDs() {
        return Zygote.nativeGetUsapPipeFDs();
    }

    private static int[] nativeGetUsapPipeFDs() {
        return (int[])OverrideMethod.invokeA("com.android.internal.os.Zygote#nativeGetUsapPipeFDs()[I", true, null);
    }

    protected static boolean removeUsapTableEntry(int usapPID) {
        return Zygote.nativeRemoveUsapTableEntry(usapPID);
    }

    private static boolean nativeRemoveUsapTableEntry(int n) {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeRemoveUsapTableEntry(I)Z", true, null) != 0;
    }

    protected static void applyUidSecurityPolicy(ZygoteArguments args, Credentials peer) throws ZygoteSecurityException {
        if (peer.getUid() == 1000) {
            boolean uidRestricted;
            boolean bl = uidRestricted = FactoryTest.getMode() == 0;
            if (uidRestricted && args.mUidSpecified && args.mUid < 1000) {
                throw new ZygoteSecurityException("System UID may not launch process with UID < 1000");
            }
        }
        if (!args.mUidSpecified) {
            args.mUid = peer.getUid();
            args.mUidSpecified = true;
        }
        if (!args.mGidSpecified) {
            args.mGid = peer.getGid();
            args.mGidSpecified = true;
        }
    }

    protected static void applyDebuggerSystemProperty(ZygoteArguments args) {
        if (RoSystemProperties.DEBUGGABLE) {
            args.mRuntimeFlags |= 1;
        }
    }

    protected static void applyInvokeWithSecurityPolicy(ZygoteArguments args, Credentials peer) throws ZygoteSecurityException {
        int peerUid = peer.getUid();
        if (args.mInvokeWith != null && peerUid != 0 && (args.mRuntimeFlags & 1) == 0) {
            throw new ZygoteSecurityException("Peer is permitted to specify an explicit invoke-with wrapper command only for debuggable applications.");
        }
    }

    protected static void applyInvokeWithSystemProperty(ZygoteArguments args) {
        if (args.mInvokeWith == null && args.mNiceName != null) {
            String property = "wrap." + args.mNiceName;
            args.mInvokeWith = SystemProperties.get(property);
            if (args.mInvokeWith != null && args.mInvokeWith.length() == 0) {
                args.mInvokeWith = null;
            }
        }
    }

    static String[] readArgumentList(BufferedReader socketReader) throws IOException {
        int argc;
        try {
            String argc_string = socketReader.readLine();
            if (argc_string == null) {
                return null;
            }
            argc = Integer.parseInt(argc_string);
        }
        catch (NumberFormatException ex) {
            Log.e("Zygote", "Invalid Zygote wire format: non-int at argc");
            throw new IOException("Invalid wire format");
        }
        if (argc > 1024) {
            throw new IOException("Max arg count exceeded");
        }
        String[] args = new String[argc];
        for (int arg_index = 0; arg_index < argc; ++arg_index) {
            args[arg_index] = socketReader.readLine();
            if (args[arg_index] != null) continue;
            throw new IOException("Truncated request");
        }
        return args;
    }

    static LocalServerSocket createManagedSocketFromInitSocket(String socketName) {
        int fileDesc;
        String fullSocketName = ANDROID_SOCKET_PREFIX + socketName;
        try {
            String env = System.getenv(fullSocketName);
            fileDesc = Integer.parseInt(env);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Socket unset or invalid: " + fullSocketName, ex);
        }
        try {
            FileDescriptor fd = new FileDescriptor();
            fd.setInt$(fileDesc);
            return new LocalServerSocket(fd);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error building socket from file descriptor: " + fileDesc, ex);
        }
    }

    private static void callPostForkSystemServerHooks() {
        ZygoteHooks.postForkSystemServer();
    }

    private static void callPostForkChildHooks(int runtimeFlags, boolean isSystemServer, boolean isZygote, String instructionSet) {
        ZygoteHooks.postForkChild(runtimeFlags, isSystemServer, isZygote, instructionSet);
    }

    static void resetNicePriority() {
        Thread.currentThread().setPriority(5);
    }

    public static void execShell(String command) {
        String[] args = new String[]{"/system/bin/sh", "-c", command};
        try {
            Os.execv(args[0], args);
        }
        catch (ErrnoException e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendQuotedShellArgs(StringBuilder command, String[] args) {
        for (String arg : args) {
            command.append(" '").append(arg.replace("'", "'\\''")).append("'");
        }
    }
}

