/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.content.ComponentName;
import android.graphics.Rect;
import android.hardware.biometrics.IBiometricServiceReceiverInternal;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.internal.statusbar.StatusBarIcon;

public interface IStatusBar
extends IInterface {
    public void setIcon(String var1, StatusBarIcon var2) throws RemoteException;

    public void removeIcon(String var1) throws RemoteException;

    public void disable(int var1, int var2, int var3) throws RemoteException;

    public void animateExpandNotificationsPanel() throws RemoteException;

    public void animateExpandSettingsPanel(String var1) throws RemoteException;

    public void animateCollapsePanels() throws RemoteException;

    public void togglePanel() throws RemoteException;

    public void showWirelessChargingAnimation(int var1) throws RemoteException;

    public void setSystemUiVisibility(int var1, int var2, int var3, int var4, int var5, Rect var6, Rect var7, boolean var8) throws RemoteException;

    public void topAppWindowChanged(int var1, boolean var2) throws RemoteException;

    public void setImeWindowStatus(int var1, IBinder var2, int var3, int var4, boolean var5) throws RemoteException;

    public void setWindowState(int var1, int var2, int var3) throws RemoteException;

    public void showRecentApps(boolean var1) throws RemoteException;

    public void hideRecentApps(boolean var1, boolean var2) throws RemoteException;

    public void toggleRecentApps() throws RemoteException;

    public void toggleSplitScreen() throws RemoteException;

    public void preloadRecentApps() throws RemoteException;

    public void cancelPreloadRecentApps() throws RemoteException;

    public void showScreenPinningRequest(int var1) throws RemoteException;

    public void dismissKeyboardShortcutsMenu() throws RemoteException;

    public void toggleKeyboardShortcutsMenu(int var1) throws RemoteException;

    public void appTransitionPending(int var1) throws RemoteException;

    public void appTransitionCancelled(int var1) throws RemoteException;

    public void appTransitionStarting(int var1, long var2, long var4) throws RemoteException;

    public void appTransitionFinished(int var1) throws RemoteException;

    public void showAssistDisclosure() throws RemoteException;

    public void startAssist(Bundle var1) throws RemoteException;

    public void onCameraLaunchGestureDetected(int var1) throws RemoteException;

    public void showPictureInPictureMenu() throws RemoteException;

    public void showGlobalActionsMenu() throws RemoteException;

    public void onProposedRotationChanged(int var1, boolean var2) throws RemoteException;

    public void setTopAppHidesStatusBar(boolean var1) throws RemoteException;

    public void addQsTile(ComponentName var1) throws RemoteException;

    public void remQsTile(ComponentName var1) throws RemoteException;

    public void clickQsTile(ComponentName var1) throws RemoteException;

    public void handleSystemKey(int var1) throws RemoteException;

    public void showPinningEnterExitToast(boolean var1) throws RemoteException;

    public void showPinningEscapeToast() throws RemoteException;

    public void showShutdownUi(boolean var1, String var2) throws RemoteException;

    public void showBiometricDialog(Bundle var1, IBiometricServiceReceiverInternal var2, int var3, boolean var4, int var5) throws RemoteException;

    public void onBiometricAuthenticated(boolean var1, String var2) throws RemoteException;

    public void onBiometricHelp(String var1) throws RemoteException;

    public void onBiometricError(String var1) throws RemoteException;

    public void hideBiometricDialog() throws RemoteException;

    public void onDisplayReady(int var1) throws RemoteException;

    public void onRecentsAnimationStateChanged(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatusBar {
        private static final String DESCRIPTOR = "com.android.internal.statusbar.IStatusBar";
        static final int TRANSACTION_setIcon = 1;
        static final int TRANSACTION_removeIcon = 2;
        static final int TRANSACTION_disable = 3;
        static final int TRANSACTION_animateExpandNotificationsPanel = 4;
        static final int TRANSACTION_animateExpandSettingsPanel = 5;
        static final int TRANSACTION_animateCollapsePanels = 6;
        static final int TRANSACTION_togglePanel = 7;
        static final int TRANSACTION_showWirelessChargingAnimation = 8;
        static final int TRANSACTION_setSystemUiVisibility = 9;
        static final int TRANSACTION_topAppWindowChanged = 10;
        static final int TRANSACTION_setImeWindowStatus = 11;
        static final int TRANSACTION_setWindowState = 12;
        static final int TRANSACTION_showRecentApps = 13;
        static final int TRANSACTION_hideRecentApps = 14;
        static final int TRANSACTION_toggleRecentApps = 15;
        static final int TRANSACTION_toggleSplitScreen = 16;
        static final int TRANSACTION_preloadRecentApps = 17;
        static final int TRANSACTION_cancelPreloadRecentApps = 18;
        static final int TRANSACTION_showScreenPinningRequest = 19;
        static final int TRANSACTION_dismissKeyboardShortcutsMenu = 20;
        static final int TRANSACTION_toggleKeyboardShortcutsMenu = 21;
        static final int TRANSACTION_appTransitionPending = 22;
        static final int TRANSACTION_appTransitionCancelled = 23;
        static final int TRANSACTION_appTransitionStarting = 24;
        static final int TRANSACTION_appTransitionFinished = 25;
        static final int TRANSACTION_showAssistDisclosure = 26;
        static final int TRANSACTION_startAssist = 27;
        static final int TRANSACTION_onCameraLaunchGestureDetected = 28;
        static final int TRANSACTION_showPictureInPictureMenu = 29;
        static final int TRANSACTION_showGlobalActionsMenu = 30;
        static final int TRANSACTION_onProposedRotationChanged = 31;
        static final int TRANSACTION_setTopAppHidesStatusBar = 32;
        static final int TRANSACTION_addQsTile = 33;
        static final int TRANSACTION_remQsTile = 34;
        static final int TRANSACTION_clickQsTile = 35;
        static final int TRANSACTION_handleSystemKey = 36;
        static final int TRANSACTION_showPinningEnterExitToast = 37;
        static final int TRANSACTION_showPinningEscapeToast = 38;
        static final int TRANSACTION_showShutdownUi = 39;
        static final int TRANSACTION_showBiometricDialog = 40;
        static final int TRANSACTION_onBiometricAuthenticated = 41;
        static final int TRANSACTION_onBiometricHelp = 42;
        static final int TRANSACTION_onBiometricError = 43;
        static final int TRANSACTION_hideBiometricDialog = 44;
        static final int TRANSACTION_onDisplayReady = 45;
        static final int TRANSACTION_onRecentsAnimationStateChanged = 46;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IStatusBar asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IStatusBar) {
                return (IStatusBar)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setIcon";
                }
                case 2: {
                    return "removeIcon";
                }
                case 3: {
                    return "disable";
                }
                case 4: {
                    return "animateExpandNotificationsPanel";
                }
                case 5: {
                    return "animateExpandSettingsPanel";
                }
                case 6: {
                    return "animateCollapsePanels";
                }
                case 7: {
                    return "togglePanel";
                }
                case 8: {
                    return "showWirelessChargingAnimation";
                }
                case 9: {
                    return "setSystemUiVisibility";
                }
                case 10: {
                    return "topAppWindowChanged";
                }
                case 11: {
                    return "setImeWindowStatus";
                }
                case 12: {
                    return "setWindowState";
                }
                case 13: {
                    return "showRecentApps";
                }
                case 14: {
                    return "hideRecentApps";
                }
                case 15: {
                    return "toggleRecentApps";
                }
                case 16: {
                    return "toggleSplitScreen";
                }
                case 17: {
                    return "preloadRecentApps";
                }
                case 18: {
                    return "cancelPreloadRecentApps";
                }
                case 19: {
                    return "showScreenPinningRequest";
                }
                case 20: {
                    return "dismissKeyboardShortcutsMenu";
                }
                case 21: {
                    return "toggleKeyboardShortcutsMenu";
                }
                case 22: {
                    return "appTransitionPending";
                }
                case 23: {
                    return "appTransitionCancelled";
                }
                case 24: {
                    return "appTransitionStarting";
                }
                case 25: {
                    return "appTransitionFinished";
                }
                case 26: {
                    return "showAssistDisclosure";
                }
                case 27: {
                    return "startAssist";
                }
                case 28: {
                    return "onCameraLaunchGestureDetected";
                }
                case 29: {
                    return "showPictureInPictureMenu";
                }
                case 30: {
                    return "showGlobalActionsMenu";
                }
                case 31: {
                    return "onProposedRotationChanged";
                }
                case 32: {
                    return "setTopAppHidesStatusBar";
                }
                case 33: {
                    return "addQsTile";
                }
                case 34: {
                    return "remQsTile";
                }
                case 35: {
                    return "clickQsTile";
                }
                case 36: {
                    return "handleSystemKey";
                }
                case 37: {
                    return "showPinningEnterExitToast";
                }
                case 38: {
                    return "showPinningEscapeToast";
                }
                case 39: {
                    return "showShutdownUi";
                }
                case 40: {
                    return "showBiometricDialog";
                }
                case 41: {
                    return "onBiometricAuthenticated";
                }
                case 42: {
                    return "onBiometricHelp";
                }
                case 43: {
                    return "onBiometricError";
                }
                case 44: {
                    return "hideBiometricDialog";
                }
                case 45: {
                    return "onDisplayReady";
                }
                case 46: {
                    return "onRecentsAnimationStateChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    StatusBarIcon _arg1 = 0 != data.readInt() ? StatusBarIcon.CREATOR.createFromParcel(data) : null;
                    this.setIcon(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.removeIcon(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.disable(_arg0, _arg1, _arg2);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    this.animateExpandNotificationsPanel();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.animateExpandSettingsPanel(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    this.animateCollapsePanels();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    this.togglePanel();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.showWirelessChargingAnimation(_arg0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    Rect _arg5 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    Rect _arg6 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    boolean _arg7 = 0 != data.readInt();
                    this.setSystemUiVisibility(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.topAppWindowChanged(_arg0, _arg1);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    boolean _arg4 = 0 != data.readInt();
                    this.setImeWindowStatus(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.setWindowState(_arg0, _arg1, _arg2);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.showRecentApps(_arg0);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.hideRecentApps(_arg0, _arg1);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    this.toggleRecentApps();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    this.toggleSplitScreen();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    this.preloadRecentApps();
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    this.cancelPreloadRecentApps();
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.showScreenPinningRequest(_arg0);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    this.dismissKeyboardShortcutsMenu();
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.toggleKeyboardShortcutsMenu(_arg0);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.appTransitionPending(_arg0);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.appTransitionCancelled(_arg0);
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    this.appTransitionStarting(_arg0, _arg1, _arg2);
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.appTransitionFinished(_arg0);
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    this.showAssistDisclosure();
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    Bundle _arg0 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.startAssist(_arg0);
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onCameraLaunchGestureDetected(_arg0);
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    this.showPictureInPictureMenu();
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    this.showGlobalActionsMenu();
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.onProposedRotationChanged(_arg0, _arg1);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setTopAppHidesStatusBar(_arg0);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    this.addQsTile(_arg0);
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    this.remQsTile(_arg0);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    this.clickQsTile(_arg0);
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.handleSystemKey(_arg0);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.showPinningEnterExitToast(_arg0);
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    this.showPinningEscapeToast();
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    String _arg1 = data.readString();
                    this.showShutdownUi(_arg0, _arg1);
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    Bundle _arg0 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    IBiometricServiceReceiverInternal _arg1 = IBiometricServiceReceiverInternal.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    boolean _arg3 = 0 != data.readInt();
                    int _arg4 = data.readInt();
                    this.showBiometricDialog(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    String _arg1 = data.readString();
                    this.onBiometricAuthenticated(_arg0, _arg1);
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.onBiometricHelp(_arg0);
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.onBiometricError(_arg0);
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    this.hideBiometricDialog();
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onDisplayReady(_arg0);
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.onRecentsAnimationStateChanged(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IStatusBar impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IStatusBar getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IStatusBar {
            private IBinder mRemote;
            public static IStatusBar sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIcon(String slot, StatusBarIcon icon) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(slot);
                    if (icon != null) {
                        _data.writeInt(1);
                        icon.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setIcon(slot, icon);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeIcon(String slot) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(slot);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeIcon(slot);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disable(int displayId, int state1, int state2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(state1);
                    _data.writeInt(state2);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().disable(displayId, state1, state2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void animateExpandNotificationsPanel() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().animateExpandNotificationsPanel();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateExpandSettingsPanel(String subPanel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(subPanel);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().animateExpandSettingsPanel(subPanel);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void animateCollapsePanels() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().animateCollapsePanels();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void togglePanel() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().togglePanel();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showWirelessChargingAnimation(int batteryLevel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(batteryLevel);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showWirelessChargingAnimation(batteryLevel);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemUiVisibility(int displayId, int vis, int fullscreenStackVis, int dockedStackVis, int mask, Rect fullscreenBounds, Rect dockedBounds, boolean navbarColorManagedByIme) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(vis);
                    _data.writeInt(fullscreenStackVis);
                    _data.writeInt(dockedStackVis);
                    _data.writeInt(mask);
                    if (fullscreenBounds != null) {
                        _data.writeInt(1);
                        fullscreenBounds.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (dockedBounds != null) {
                        _data.writeInt(1);
                        dockedBounds.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(navbarColorManagedByIme ? 1 : 0);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSystemUiVisibility(displayId, vis, fullscreenStackVis, dockedStackVis, mask, fullscreenBounds, dockedBounds, navbarColorManagedByIme);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void topAppWindowChanged(int displayId, boolean menuVisible) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(menuVisible ? 1 : 0);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().topAppWindowChanged(displayId, menuVisible);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImeWindowStatus(int displayId, IBinder token, int vis, int backDisposition, boolean showImeSwitcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(token);
                    _data.writeInt(vis);
                    _data.writeInt(backDisposition);
                    _data.writeInt(showImeSwitcher ? 1 : 0);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setImeWindowStatus(displayId, token, vis, backDisposition, showImeSwitcher);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWindowState(int display, int window, int state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(display);
                    _data.writeInt(window);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setWindowState(display, window, state);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showRecentApps(boolean triggeredFromAltTab) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(triggeredFromAltTab ? 1 : 0);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showRecentApps(triggeredFromAltTab);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideRecentApps(boolean triggeredFromAltTab, boolean triggeredFromHomeKey) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(triggeredFromAltTab ? 1 : 0);
                    _data.writeInt(triggeredFromHomeKey ? 1 : 0);
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hideRecentApps(triggeredFromAltTab, triggeredFromHomeKey);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void toggleRecentApps() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().toggleRecentApps();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void toggleSplitScreen() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().toggleSplitScreen();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void preloadRecentApps() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().preloadRecentApps();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelPreloadRecentApps() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().cancelPreloadRecentApps();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showScreenPinningRequest(int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean _status = this.mRemote.transact(19, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showScreenPinningRequest(taskId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void dismissKeyboardShortcutsMenu() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dismissKeyboardShortcutsMenu();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toggleKeyboardShortcutsMenu(int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(21, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().toggleKeyboardShortcutsMenu(deviceId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionPending(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(22, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().appTransitionPending(displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionCancelled(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(23, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().appTransitionCancelled(displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionStarting(int displayId, long statusBarAnimationsStartTime, long statusBarAnimationsDuration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeLong(statusBarAnimationsStartTime);
                    _data.writeLong(statusBarAnimationsDuration);
                    boolean _status = this.mRemote.transact(24, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().appTransitionStarting(displayId, statusBarAnimationsStartTime, statusBarAnimationsDuration);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionFinished(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(25, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().appTransitionFinished(displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showAssistDisclosure() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showAssistDisclosure();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startAssist(Bundle args) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (args != null) {
                        _data.writeInt(1);
                        args.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(27, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startAssist(args);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCameraLaunchGestureDetected(int source) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(source);
                    boolean _status = this.mRemote.transact(28, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCameraLaunchGestureDetected(source);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showPictureInPictureMenu() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showPictureInPictureMenu();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showGlobalActionsMenu() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showGlobalActionsMenu();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProposedRotationChanged(int rotation, boolean isValid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rotation);
                    _data.writeInt(isValid ? 1 : 0);
                    boolean _status = this.mRemote.transact(31, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onProposedRotationChanged(rotation, isValid);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTopAppHidesStatusBar(boolean hidesStatusBar) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(hidesStatusBar ? 1 : 0);
                    boolean _status = this.mRemote.transact(32, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setTopAppHidesStatusBar(hidesStatusBar);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addQsTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (tile != null) {
                        _data.writeInt(1);
                        tile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(33, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addQsTile(tile);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remQsTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (tile != null) {
                        _data.writeInt(1);
                        tile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(34, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().remQsTile(tile);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clickQsTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (tile != null) {
                        _data.writeInt(1);
                        tile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(35, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clickQsTile(tile);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleSystemKey(int key) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(key);
                    boolean _status = this.mRemote.transact(36, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().handleSystemKey(key);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showPinningEnterExitToast(boolean entering) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(entering ? 1 : 0);
                    boolean _status = this.mRemote.transact(37, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showPinningEnterExitToast(entering);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showPinningEscapeToast() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(38, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showPinningEscapeToast();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showShutdownUi(boolean isReboot, String reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(isReboot ? 1 : 0);
                    _data.writeString(reason);
                    boolean _status = this.mRemote.transact(39, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showShutdownUi(isReboot, reason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showBiometricDialog(Bundle bundle, IBiometricServiceReceiverInternal receiver, int type, boolean requireConfirmation, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bundle != null) {
                        _data.writeInt(1);
                        bundle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    _data.writeInt(type);
                    _data.writeInt(requireConfirmation ? 1 : 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(40, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showBiometricDialog(bundle, receiver, type, requireConfirmation, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricAuthenticated(boolean authenticated, String failureReason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(authenticated ? 1 : 0);
                    _data.writeString(failureReason);
                    boolean _status = this.mRemote.transact(41, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBiometricAuthenticated(authenticated, failureReason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricHelp(String message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(message);
                    boolean _status = this.mRemote.transact(42, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBiometricHelp(message);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricError(String error) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(error);
                    boolean _status = this.mRemote.transact(43, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBiometricError(error);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void hideBiometricDialog() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(44, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hideBiometricDialog();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayReady(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(45, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDisplayReady(displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRecentsAnimationStateChanged(boolean running) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(running ? 1 : 0);
                    boolean _status = this.mRemote.transact(46, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRecentsAnimationStateChanged(running);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStatusBar {
        @Override
        public void setIcon(String slot, StatusBarIcon icon) throws RemoteException {
        }

        @Override
        public void removeIcon(String slot) throws RemoteException {
        }

        @Override
        public void disable(int displayId, int state1, int state2) throws RemoteException {
        }

        @Override
        public void animateExpandNotificationsPanel() throws RemoteException {
        }

        @Override
        public void animateExpandSettingsPanel(String subPanel) throws RemoteException {
        }

        @Override
        public void animateCollapsePanels() throws RemoteException {
        }

        @Override
        public void togglePanel() throws RemoteException {
        }

        @Override
        public void showWirelessChargingAnimation(int batteryLevel) throws RemoteException {
        }

        @Override
        public void setSystemUiVisibility(int displayId, int vis, int fullscreenStackVis, int dockedStackVis, int mask, Rect fullscreenBounds, Rect dockedBounds, boolean navbarColorManagedByIme) throws RemoteException {
        }

        @Override
        public void topAppWindowChanged(int displayId, boolean menuVisible) throws RemoteException {
        }

        @Override
        public void setImeWindowStatus(int displayId, IBinder token, int vis, int backDisposition, boolean showImeSwitcher) throws RemoteException {
        }

        @Override
        public void setWindowState(int display, int window, int state) throws RemoteException {
        }

        @Override
        public void showRecentApps(boolean triggeredFromAltTab) throws RemoteException {
        }

        @Override
        public void hideRecentApps(boolean triggeredFromAltTab, boolean triggeredFromHomeKey) throws RemoteException {
        }

        @Override
        public void toggleRecentApps() throws RemoteException {
        }

        @Override
        public void toggleSplitScreen() throws RemoteException {
        }

        @Override
        public void preloadRecentApps() throws RemoteException {
        }

        @Override
        public void cancelPreloadRecentApps() throws RemoteException {
        }

        @Override
        public void showScreenPinningRequest(int taskId) throws RemoteException {
        }

        @Override
        public void dismissKeyboardShortcutsMenu() throws RemoteException {
        }

        @Override
        public void toggleKeyboardShortcutsMenu(int deviceId) throws RemoteException {
        }

        @Override
        public void appTransitionPending(int displayId) throws RemoteException {
        }

        @Override
        public void appTransitionCancelled(int displayId) throws RemoteException {
        }

        @Override
        public void appTransitionStarting(int displayId, long statusBarAnimationsStartTime, long statusBarAnimationsDuration) throws RemoteException {
        }

        @Override
        public void appTransitionFinished(int displayId) throws RemoteException {
        }

        @Override
        public void showAssistDisclosure() throws RemoteException {
        }

        @Override
        public void startAssist(Bundle args) throws RemoteException {
        }

        @Override
        public void onCameraLaunchGestureDetected(int source) throws RemoteException {
        }

        @Override
        public void showPictureInPictureMenu() throws RemoteException {
        }

        @Override
        public void showGlobalActionsMenu() throws RemoteException {
        }

        @Override
        public void onProposedRotationChanged(int rotation, boolean isValid) throws RemoteException {
        }

        @Override
        public void setTopAppHidesStatusBar(boolean hidesStatusBar) throws RemoteException {
        }

        @Override
        public void addQsTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void remQsTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void clickQsTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void handleSystemKey(int key) throws RemoteException {
        }

        @Override
        public void showPinningEnterExitToast(boolean entering) throws RemoteException {
        }

        @Override
        public void showPinningEscapeToast() throws RemoteException {
        }

        @Override
        public void showShutdownUi(boolean isReboot, String reason) throws RemoteException {
        }

        @Override
        public void showBiometricDialog(Bundle bundle, IBiometricServiceReceiverInternal receiver, int type, boolean requireConfirmation, int userId) throws RemoteException {
        }

        @Override
        public void onBiometricAuthenticated(boolean authenticated, String failureReason) throws RemoteException {
        }

        @Override
        public void onBiometricHelp(String message) throws RemoteException {
        }

        @Override
        public void onBiometricError(String error) throws RemoteException {
        }

        @Override
        public void hideBiometricDialog() throws RemoteException {
        }

        @Override
        public void onDisplayReady(int displayId) throws RemoteException {
        }

        @Override
        public void onRecentsAnimationStateChanged(boolean running) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

