/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.view.View;
import android.view.ViewTreeObserver;

public class OneShotPreDrawListener
implements ViewTreeObserver.OnPreDrawListener,
View.OnAttachStateChangeListener {
    private final View mView;
    private ViewTreeObserver mViewTreeObserver;
    private final Runnable mRunnable;
    private final boolean mReturnValue;

    private OneShotPreDrawListener(View view, boolean returnValue, Runnable runnable) {
        this.mView = view;
        this.mViewTreeObserver = view.getViewTreeObserver();
        this.mRunnable = runnable;
        this.mReturnValue = returnValue;
    }

    public static OneShotPreDrawListener add(View view, Runnable runnable) {
        return OneShotPreDrawListener.add(view, true, runnable);
    }

    public static OneShotPreDrawListener add(View view, boolean returnValue, Runnable runnable) {
        OneShotPreDrawListener listener = new OneShotPreDrawListener(view, returnValue, runnable);
        view.getViewTreeObserver().addOnPreDrawListener(listener);
        view.addOnAttachStateChangeListener(listener);
        return listener;
    }

    @Override
    public boolean onPreDraw() {
        this.removeListener();
        this.mRunnable.run();
        return this.mReturnValue;
    }

    public void removeListener() {
        if (this.mViewTreeObserver.isAlive()) {
            this.mViewTreeObserver.removeOnPreDrawListener(this);
        } else {
            this.mView.getViewTreeObserver().removeOnPreDrawListener(this);
        }
        this.mView.removeOnAttachStateChangeListener(this);
    }

    @Override
    public void onViewAttachedToWindow(View v) {
        this.mViewTreeObserver = v.getViewTreeObserver();
    }

    @Override
    public void onViewDetachedFromWindow(View v) {
        this.removeListener();
    }
}

