/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.AttachInfo_Accessor;
import android.view.View;
import android.widget.FrameLayout;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RenderDrawable
extends RenderAction<DrawableParams> {
    public RenderDrawable(DrawableParams params) {
        super(new DrawableParams(params));
    }

    public Result render() {
        this.checkLock();
        DrawableParams params = (DrawableParams)this.getParams();
        HardwareConfig hardwareConfig = params.getHardwareConfig();
        ResourceValue drawableResource = params.getDrawable();
        BridgeContext context = this.getContext();
        drawableResource = context.getRenderResources().resolveResValue(drawableResource);
        if (drawableResource == null) {
            return Result.Status.ERROR_NOT_A_DRAWABLE.createResult();
        }
        ResourceType resourceType = drawableResource.getResourceType();
        if (resourceType != ResourceType.DRAWABLE && resourceType != ResourceType.MIPMAP) {
            return Result.Status.ERROR_NOT_A_DRAWABLE.createResult();
        }
        Drawable d = ResourceHelper.getDrawable(drawableResource, context);
        if (d == null) {
            return Result.Status.ERROR_NOT_A_DRAWABLE.createResult();
        }
        Boolean allStates = (Boolean)params.getFlag(RenderParamsFlags.FLAG_KEY_RENDER_ALL_DRAWABLE_STATES);
        if (allStates == Boolean.TRUE) {
            List<Object> result;
            if (d instanceof StateListDrawable) {
                result = new ArrayList();
                StateListDrawable stateList = (StateListDrawable)d;
                for (int i = 0; i < stateList.getStateCount(); ++i) {
                    Drawable stateDrawable = stateList.getStateDrawable(i);
                    result.add(this.renderImage(hardwareConfig, stateDrawable, context));
                }
            } else {
                result = Collections.singletonList(this.renderImage(hardwareConfig, d, context));
            }
            return Result.Status.SUCCESS.createResult(result);
        }
        BufferedImage image = this.renderImage(hardwareConfig, d, context);
        return Result.Status.SUCCESS.createResult((Object)image);
    }

    private BufferedImage renderImage(HardwareConfig hardwareConfig, Drawable d, BridgeContext context) {
        FrameLayout content = new FrameLayout(context);
        content.setBackground(d);
        AttachInfo_Accessor.setAttachInfo(content);
        int w = d.getIntrinsicWidth();
        int h = d.getIntrinsicHeight();
        int screenWidth = hardwareConfig.getScreenWidth();
        int screenHeight = hardwareConfig.getScreenHeight();
        if (w == -1 || h == -1) {
            w = screenWidth;
            h = screenHeight;
        } else if (w > screenWidth || h > screenHeight) {
            double scale = Math.min((double)screenWidth / (double)w, (double)screenHeight / (double)h);
            w = (int)Math.floor(scale * (double)w);
            h = (int)Math.floor(scale * (double)h);
        }
        int w_spec = View.MeasureSpec.makeMeasureSpec(w, 0x40000000);
        int h_spec = View.MeasureSpec.makeMeasureSpec(h, 0x40000000);
        content.measure(w_spec, h_spec);
        content.layout(0, 0, w, h);
        AttachInfo_Accessor.dispatchOnPreDraw(content);
        BufferedImage image = this.getImage(w, h);
        Bitmap bitmap = Bitmap_Delegate.createBitmap(image, true, hardwareConfig.getDensity());
        Canvas canvas = new Canvas(bitmap);
        canvas.setDensity(hardwareConfig.getDensity().getDpiValue());
        content.draw(canvas);
        AttachInfo_Accessor.detachFromWindow(content);
        return image;
    }

    protected BufferedImage getImage(int w, int h) {
        BufferedImage image = new BufferedImage(w > 0 ? w : 1, h > 0 ? h : 1, 2);
        Graphics2D gc = image.createGraphics();
        gc.setComposite(AlphaComposite.Src);
        gc.setColor(new Color(0, true));
        gc.fillRect(0, 0, w, h);
        gc.dispose();
        return image;
    }
}

