/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeBoundFieldTypeFix
implements IntentionAction {
    private final PsiField myField;
    private final PsiType myTypeToSet;

    public ChangeBoundFieldTypeFix(PsiField field, PsiType typeToSet) {
        this.myField = field;
        this.myTypeToSet = typeToSet;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message((String)"uidesigner.change.bound.field.type", (Object[])new Object[0]);
        if (string == null) {
            ChangeBoundFieldTypeFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ChangeBoundFieldTypeFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ChangeBoundFieldTypeFix.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ChangeBoundFieldTypeFix.$$$reportNull$$$0(3);
        }
        CommandProcessor.getInstance().executeCommand(this.myField.getProject(), () -> {
            try {
                PsiManager manager = this.myField.getManager();
                this.myField.getTypeElement().replace((PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeElement(this.myTypeToSet));
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myField.getProject(), (String)QuickFixBundle.message((String)"cannot.change.field.exception", (Object[])new Object[]{this.myField.getName(), e.getLocalizedMessage()}), (String)CommonBundle.getErrorTitle()));
            }
        }, this.getText(), null);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/binding/ChangeBoundFieldTypeFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/binding/ChangeBoundFieldTypeFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

