/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.util.Preconditions;
import org.fest.util.Sets;

final class FinderDelegate {
    FinderDelegate() {
    }

    @Nonnull
    @RunsInEDT
    Collection<Component> find(@Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher m) {
        LinkedHashSet found = Sets.newLinkedHashSet();
        for (Component component : FinderDelegate.rootsOf(h)) {
            this.find(h, m, (Component)Preconditions.checkNotNull((Object)component), found);
        }
        return found;
    }

    @RunsInEDT
    private void find(@Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher m, @Nonnull Component root, @Nonnull Set<Component> found) {
        HashSet<Component> allComponents = new HashSet<Component>();
        this.collectAll(h, root, allComponents);
        FinderDelegate.isMatching(allComponents, m, found);
    }

    @Nonnull
    @RunsInEDT
    private static Collection<Component> childrenOfComponent(@Nonnull Component c, @Nonnull ComponentHierarchy h) {
        Collection<Component> children = h.childrenOf(c);
        return (Collection)Preconditions.checkNotNull(children);
    }

    @RunsInEDT
    private static void isMatching(final @Nonnull Set<Component> allComponents, final @Nonnull ComponentMatcher m, final Set<Component> found) {
        GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                for (Component component : allComponents) {
                    if (!m.matches(component)) continue;
                    found.add(component);
                }
                return true;
            }
        });
    }

    @Nonnull
    @RunsInEDT
    <T extends Component> Collection<T> find(@Nonnull ComponentHierarchy h, @Nonnull GenericTypeMatcher<T> m) {
        LinkedHashSet found = Sets.newLinkedHashSet();
        for (Component component : FinderDelegate.rootsOf(h)) {
            this.find(h, m, (Component)Preconditions.checkNotNull((Object)component), found);
        }
        return found;
    }

    @Nonnull
    @RunsInEDT
    private static Collection<? extends Component> rootsOf(final @Nonnull ComponentHierarchy h) {
        Collection<? extends Component> roots = GuiActionRunner.execute(new GuiQuery<Collection<? extends Component>>(){

            @Override
            protected Collection<? extends Component> executeInEDT() {
                return h.roots();
            }
        });
        return (Collection)Preconditions.checkNotNull(roots);
    }

    private <T extends Component> void collectAll(@Nonnull ComponentHierarchy h, @Nonnull Component root, Set<Component> allComponents) {
        for (Component c : FinderDelegate.childrenOfComponent(root, h)) {
            this.collectAll(h, (Component)Preconditions.checkNotNull((Object)c), allComponents);
        }
        allComponents.add(root);
    }

    private <T extends Component> void find(@Nonnull ComponentHierarchy h, @Nonnull GenericTypeMatcher<T> m, @Nonnull Component root, Set<T> found) {
        HashSet<Component> allComponents = new HashSet<Component>();
        this.collectAll(h, root, allComponents);
        this.isMatching(allComponents, m, found);
    }

    private <T extends Component> void isMatching(final @Nonnull Set<Component> allComponents, final @Nonnull GenericTypeMatcher<T> m, final Set<T> found) {
        GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                for (Component component : allComponents) {
                    if (!m.matches(component)) continue;
                    found.add(m.supportedType().cast(component));
                }
                return true;
            }
        });
    }
}

