/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JTreeCellReader;
import org.fest.swing.driver.BasicJTreeCellReader;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.util.Lists;
import org.fest.util.Strings;

class JTreePathFinder {
    private static final String SEPARATOR = "/";
    private JTreeCellReader cellReader;
    private String separator;

    JTreePathFinder() {
        this.replaceCellReader(new BasicJTreeCellReader());
        this.replaceSeparator(SEPARATOR);
    }

    @Nonnull
    @RunsInCurrentThread
    TreePath findMatchingPath(@Nonnull JTree tree, @Nonnull String path) {
        String[] pathStrings = this.splitPath(path);
        TreeModel model = tree.getModel();
        ArrayList newPathValues = Lists.newArrayList();
        Object node = model.getRoot();
        int pathElementCount = pathStrings.length;
        for (int stringIndex = 0; stringIndex < pathElementCount; ++stringIndex) {
            String pathString = pathStrings[stringIndex];
            Object match = null;
            if (stringIndex == 0 && tree.isRootVisible()) {
                if (!pathString.equals(this.value(tree, node))) {
                    throw this.pathNotFound(path);
                }
                newPathValues.add(node);
                continue;
            }
            int childCount = model.getChildCount(node);
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                Object child = model.getChild(node, childIndex);
                if (!pathString.equals(this.value(tree, child))) continue;
                if (match != null) {
                    throw this.multipleMatchingNodes(pathString, this.value(tree, node));
                }
                match = child;
            }
            if (match == null) {
                throw this.pathNotFound(path);
            }
            newPathValues.add(match);
            node = match;
        }
        return new TreePath(newPathValues.toArray());
    }

    @Nonnull
    private LocationUnavailableException pathNotFound(@Nonnull String path) {
        throw new LocationUnavailableException(String.format("Unable to find path %s", Strings.quote((String)path)));
    }

    @Nonnull
    private String[] splitPath(@Nonnull String path) {
        ArrayList result = Lists.newArrayList();
        int separatorSize = this.separator.length();
        int index = 0;
        int pathSize = path.length();
        while (index < pathSize) {
            int separatorPosition = path.indexOf(this.separator, index);
            if (separatorPosition == -1) {
                separatorPosition = pathSize;
            }
            result.add(path.substring(index, separatorPosition));
            index = separatorPosition + separatorSize;
        }
        return result.toArray(new String[result.size()]);
    }

    @Nonnull
    private LocationUnavailableException multipleMatchingNodes(@Nonnull String matchingText, @Nullable Object parentText) {
        String msg = String.format("There is more than one node with value '%s' under %s", matchingText, Strings.quote((Object)parentText));
        throw new LocationUnavailableException(msg);
    }

    @Nullable
    private String value(@Nonnull JTree tree, @Nullable Object modelValue) {
        return this.cellReader.valueAt(tree, modelValue);
    }

    @Nonnull
    String separator() {
        return this.separator;
    }

    void replaceSeparator(@Nonnull String newSeparator) {
        this.separator = newSeparator;
    }

    void replaceCellReader(@Nonnull JTreeCellReader newCellReader) {
        this.cellReader = newCellReader;
    }

    @Nonnull
    JTreeCellReader cellReader() {
        return this.cellReader;
    }
}

