/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.edt;

import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.swing.SwingUtilities;
import org.fest.swing.edt.GuiAction;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.UnexpectedException;
import org.fest.util.Throwables;

@ThreadSafe
public class GuiActionRunner {
    @GuardedBy(value="GuiActionRunner.class")
    private static boolean executeInEDT = true;

    public static synchronized void executeInEDT(boolean b) {
        executeInEDT = b;
    }

    public static synchronized boolean executeInEDT() {
        return executeInEDT;
    }

    @Nullable
    public static <T> T execute(@Nonnull GuiQuery<T> query) {
        if (!GuiActionRunner.executeInEDT()) {
            return GuiActionRunner.executeInCurrentThread(query);
        }
        GuiActionRunner.run(query);
        return GuiActionRunner.resultOf(query);
    }

    @Nullable
    private static <T> T executeInCurrentThread(@Nonnull GuiQuery<T> query) {
        try {
            return query.executeInEDT();
        }
        catch (Throwable e) {
            throw UnexpectedException.unexpected(e);
        }
    }

    public static void execute(@Nonnull GuiTask task) {
        if (!GuiActionRunner.executeInEDT()) {
            GuiActionRunner.executeInCurrentThread(task);
            return;
        }
        GuiActionRunner.run(task);
        GuiActionRunner.rethrowCaughtExceptionIn(task);
    }

    private static void executeInCurrentThread(@Nonnull GuiTask task) {
        try {
            task.executeInEDT();
        }
        catch (Throwable e) {
            throw UnexpectedException.unexpected(e);
        }
    }

    private static void run(@Nonnull GuiAction action) {
        if (SwingUtilities.isEventDispatchThread()) {
            action.run();
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        action.executionNotification(latch);
        SwingUtilities.invokeLater(action);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Nullable
    private static <T> T resultOf(@Nonnull GuiQuery<T> query) {
        T result = query.result();
        query.clearResult();
        GuiActionRunner.rethrowCaughtExceptionIn(query);
        return result;
    }

    private static void rethrowCaughtExceptionIn(@Nonnull GuiAction action) {
        Throwable caughtException = action.catchedException();
        action.clearCaughtException();
        if (caughtException == null) {
            return;
        }
        if (caughtException instanceof RuntimeException) {
            Throwables.appendStackTraceInCurentThreadToThrowable((Throwable)caughtException, (String)"execute");
            throw (RuntimeException)caughtException;
        }
        if (caughtException instanceof Error) {
            caughtException.fillInStackTrace();
            throw (Error)caughtException;
        }
        throw UnexpectedException.unexpected(caughtException);
    }
}

