/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JTreeFixture;
import org.fest.swing.fixture.JTreeNodeFixture;
import org.fest.util.VisibleForTesting;

public class JTreeRowFixture
implements JTreeNodeFixture<JTreeRowFixture> {
    private final int index;
    private final JTreeFixture tree;

    protected JTreeRowFixture(@Nonnull JTreeFixture tree, int index) {
        this.tree = tree;
        this.index = index;
    }

    @Override
    @Nonnull
    public JTreeRowFixture expand() {
        this.tree.expandRow(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture collapse() {
        this.tree.collapseRow(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture select() {
        this.tree.selectRow(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture click() {
        this.tree.clickRow(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture click(@Nonnull MouseButton button) {
        this.tree.clickRow(this.index, button);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture click(@Nonnull MouseClickInfo mouseClickInfo) {
        this.tree.clickRow(this.index, mouseClickInfo);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture doubleClick() {
        this.tree.doubleClickRow(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture rightClick() {
        this.tree.rightClickRow(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture drag() {
        this.tree.drag(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture drop() {
        this.tree.drop(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JPopupMenuFixture showPopupMenu() {
        return this.tree.showPopupMenuAt(this.index);
    }

    @Override
    @Nullable
    public String value() {
        return this.tree.valueAt(this.index);
    }

    public int index() {
        return this.index;
    }

    @Nonnull
    @VisibleForTesting
    JTreeFixture treeFixture() {
        return this.tree;
    }
}

