/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.util.Strings;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Arrays;
import org.fest.util.Preconditions;

public class StringTextMatcher
implements TextMatcher {
    private final String[] values;

    public StringTextMatcher(String ... values) {
        this.values = (String[])Preconditions.checkNotNullOrEmpty((Object[])values);
    }

    @Override
    public boolean isMatching(@Nullable String text) {
        for (String value : this.values) {
            if (!Strings.areEqualOrMatch(value, text)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public String description() {
        return this.onlyOneValue() ? "value" : "values";
    }

    @Override
    @Nonnull
    public String formattedValues() {
        String s = this.onlyOneValue() ? org.fest.util.Strings.quote((String)this.values[0]) : Arrays.format((Object)this.values);
        return (String)Preconditions.checkNotNull((Object)s);
    }

    private boolean onlyOneValue() {
        return this.values.length == 1;
    }
}

