/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.fonts;

import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.MutableFontDetail;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010!\u001a\u00020\u00142\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0014J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010(\u001a\u00020\u001cH\u0016J\u0006\u0010)\u001a\u00020\u0005R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001e\u00a8\u0006*"}, d2={"Lcom/android/ide/common/fonts/FontDetail;", "", "fontFamily", "Lcom/android/ide/common/fonts/FontFamily;", "font", "Lcom/android/ide/common/fonts/MutableFontDetail;", "(Lcom/android/ide/common/fonts/FontFamily;Lcom/android/ide/common/fonts/MutableFontDetail;)V", "detail", "withStyle", "(Lcom/android/ide/common/fonts/FontDetail;Lcom/android/ide/common/fonts/MutableFontDetail;)V", "family", "getFamily", "()Lcom/android/ide/common/fonts/FontFamily;", "fontStyle", "", "getFontStyle", "()Ljava/lang/String;", "fontUrl", "getFontUrl", "hasExplicitStyle", "", "getHasExplicitStyle", "()Z", "italics", "getItalics", "styleName", "getStyleName", "weight", "", "getWeight", "()I", "width", "getWidth", "equals", "other", "generateQuery", "exact", "generateStyleName", "getItalicStyleNameSuffix", "getWeightStyleName", "hashCode", "toMutableFontDetail", "studio.android.sdktools.sdk-common"})
public final class FontDetail {
    @NotNull
    private final FontFamily family;
    private final int weight;
    private final int width;
    private final boolean italics;
    @NotNull
    private final String fontUrl;
    @NotNull
    private final String styleName;
    private final boolean hasExplicitStyle;

    @NotNull
    public final FontFamily getFamily() {
        return this.family;
    }

    public final int getWeight() {
        return this.weight;
    }

    public final int getWidth() {
        return this.width;
    }

    public final boolean getItalics() {
        return this.italics;
    }

    @NotNull
    public final String getFontUrl() {
        return this.fontUrl;
    }

    @NotNull
    public final String getStyleName() {
        return this.styleName;
    }

    public final boolean getHasExplicitStyle() {
        return this.hasExplicitStyle;
    }

    @NotNull
    public final String getFontStyle() {
        return this.italics ? "italic" : "normal";
    }

    @NotNull
    public final MutableFontDetail toMutableFontDetail() {
        return new MutableFontDetail(this.weight, this.width, this.italics, this.fontUrl, this.styleName, false, this.hasExplicitStyle);
    }

    @NotNull
    public final String generateQuery(boolean exact) {
        if (this.weight == 400 && this.width == 100 && !this.italics && !exact) {
            return this.family.getName();
        }
        StringBuilder query = new StringBuilder().append("name=").append(this.family.getName());
        if (this.weight != 400) {
            query.append("&weight=").append(this.weight);
        }
        if (this.italics) {
            query.append("&italic=1");
        }
        if (this.width != 100) {
            query.append("&width=").append(this.width);
        }
        if (exact) {
            query.append("&besteffort=false");
        }
        String string = query.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"query.toString()");
        return string;
    }

    public int hashCode() {
        return Objects.hash(this.weight, this.width, this.italics);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FontDetail && this.weight == ((FontDetail)other).weight && this.width == ((FontDetail)other).width && this.italics == ((FontDetail)other).italics;
    }

    private final String generateStyleName(MutableFontDetail font) {
        CharSequence charSequence = font.getStyleName();
        boolean bl = false;
        if (charSequence.length() > 0) {
            return font.getStyleName();
        }
        return this.getWeightStyleName(font.getWeight()) + this.getItalicStyleNameSuffix(font.getItalics());
    }

    private final String getWeightStyleName(int weight) {
        switch (weight) {
            case 100: {
                return "Thin";
            }
            case 200: {
                return "Extra-Light";
            }
            case 300: {
                return "Light";
            }
            case 400: {
                return "Regular";
            }
            case 500: {
                return "Medium";
            }
            case 600: {
                return "Semi-Bold";
            }
            case 700: {
                return "Bold";
            }
            case 800: {
                return "Extra-Bold";
            }
            case 900: {
                return "Black";
            }
        }
        return weight > 400 ? "Custom-Bold" : "Custom-Light";
    }

    private final String getItalicStyleNameSuffix(boolean italics) {
        return italics ? " Italic" : "";
    }

    public FontDetail(@NotNull FontFamily fontFamily, @NotNull MutableFontDetail font) {
        Intrinsics.checkParameterIsNotNull((Object)fontFamily, (String)"fontFamily");
        Intrinsics.checkParameterIsNotNull((Object)font, (String)"font");
        this.family = fontFamily;
        this.weight = font.getWeight();
        this.width = font.getWidth();
        this.italics = font.getItalics();
        this.fontUrl = font.getFontUrl();
        this.hasExplicitStyle = font.getHasExplicitStyle();
        this.styleName = this.generateStyleName(font);
    }

    public FontDetail(@NotNull FontDetail detail, @NotNull MutableFontDetail withStyle) {
        Intrinsics.checkParameterIsNotNull((Object)detail, (String)"detail");
        Intrinsics.checkParameterIsNotNull((Object)withStyle, (String)"withStyle");
        this.family = detail.family;
        this.weight = withStyle.getWeight();
        this.width = withStyle.getWidth();
        this.italics = withStyle.getItalics();
        this.fontUrl = detail.fontUrl;
        this.hasExplicitStyle = detail.hasExplicitStyle;
        this.styleName = this.generateStyleName(withStyle);
    }
}

