/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.gradle.model.IdeMavenCoordinates;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.level2.BuildFolderPaths;
import com.android.utils.FileUtils;
import com.google.common.base.Strings;
import java.io.File;

public final class IdeLibraries {
    private IdeLibraries() {
    }

    public static String computeAddress(Library library) {
        try {
            if (library.getProject() != null && library instanceof AndroidLibrary) {
                return Strings.nullToEmpty((String)IdeModel.copyNewProperty(() -> ((Library)library).getBuildId(), "")) + library.getProject() + "::" + ((AndroidLibrary)library).getProjectVariant();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        IdeMavenCoordinates coordinate = IdeLibraries.computeResolvedCoordinate(library, new ModelCache());
        String artifactId = coordinate.getArtifactId();
        if (artifactId.startsWith(":")) {
            artifactId = artifactId.substring(1);
        }
        artifactId = artifactId.replace(':', '.');
        String address = coordinate.getGroupId() + ":" + artifactId + ":" + coordinate.getVersion();
        String classifier = coordinate.getClassifier();
        if (classifier != null) {
            address = address + ":" + classifier;
        }
        String packaging = coordinate.getPackaging();
        address = address + "@" + packaging;
        return address.intern();
    }

    public static String computeAddress(Dependencies.ProjectIdentifier projectIdentifier) {
        String address = projectIdentifier.getBuildId() + "@@" + projectIdentifier.getProjectPath();
        return address.intern();
    }

    public static boolean isLocalAarModule(AndroidLibrary androidLibrary, BuildFolderPaths buildFolderPaths) {
        String projectPath = androidLibrary.getProject();
        if (projectPath == null) {
            return false;
        }
        File buildFolderPath = buildFolderPaths.findBuildFolderPath(projectPath, IdeModel.copyNewProperty(() -> ((AndroidLibrary)androidLibrary).getBuildId(), null));
        return buildFolderPath != null && !FileUtils.isFileInDirectory((File)androidLibrary.getBundle(), (File)buildFolderPath);
    }

    public static IdeMavenCoordinates computeResolvedCoordinate(Library library, ModelCache modelCache) {
        if (library.getResolvedCoordinates() != null) {
            return modelCache.computeIfAbsent(library.getResolvedCoordinates(), coordinates -> new IdeMavenCoordinates((MavenCoordinates)coordinates));
        }
        File jarFile = library instanceof JavaLibrary ? ((JavaLibrary)library).getJarFile() : ((AndroidLibrary)library).getBundle();
        return new IdeMavenCoordinates(jarFile);
    }
}

