/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model.level2;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeModel;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;

public final class IdeModuleLibrary
implements Library,
Serializable {
    private static final long serialVersionUID = 5L;
    private final String myArtifactAddress;
    private final String myBuildId;
    private final String myProjectPath;
    private final String myVariant;
    private final int myType;
    private final int myHashCode;

    public IdeModuleLibrary() {
        this.myArtifactAddress = "";
        this.myBuildId = null;
        this.myProjectPath = null;
        this.myVariant = null;
        this.myType = 0;
        this.myHashCode = 0;
    }

    IdeModuleLibrary(Library library, String artifactAddress) {
        this.myType = 3;
        this.myArtifactAddress = artifactAddress;
        this.myBuildId = IdeModel.copyNewProperty(() -> ((Library)library).getBuildId(), null);
        this.myProjectPath = IdeModel.copyNewProperty(() -> ((Library)library).getProjectPath(), null);
        this.myVariant = IdeModel.copyNewProperty(() -> ((Library)library).getVariant(), null);
        this.myHashCode = this.calculateHashCode();
    }

    IdeModuleLibrary(AndroidLibrary library, String artifactAddress) {
        this.myType = 3;
        this.myArtifactAddress = artifactAddress;
        this.myBuildId = IdeModel.copyNewProperty(() -> ((AndroidLibrary)library).getBuildId(), null);
        this.myProjectPath = IdeModel.copyNewProperty(() -> ((AndroidLibrary)library).getProject(), null);
        this.myVariant = IdeModel.copyNewProperty(() -> ((AndroidLibrary)library).getProjectVariant(), null);
        this.myHashCode = this.calculateHashCode();
    }

    IdeModuleLibrary(JavaLibrary library, String artifactAddress) {
        this.myType = 3;
        this.myArtifactAddress = artifactAddress;
        this.myBuildId = IdeModel.copyNewProperty(() -> ((JavaLibrary)library).getBuildId(), null);
        this.myProjectPath = IdeModel.copyNewProperty(() -> ((JavaLibrary)library).getProject(), null);
        this.myVariant = null;
        this.myHashCode = this.calculateHashCode();
    }

    IdeModuleLibrary(String projectPath, String artifactAddress, String buildId) {
        this.myType = 3;
        this.myArtifactAddress = artifactAddress;
        this.myBuildId = buildId;
        this.myProjectPath = projectPath;
        this.myVariant = null;
        this.myHashCode = this.calculateHashCode();
    }

    public int getType() {
        return this.myType;
    }

    public String getArtifactAddress() {
        return this.myArtifactAddress;
    }

    public File getArtifact() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getArtifact()");
    }

    public String getBuildId() {
        return this.myBuildId;
    }

    public String getProjectPath() {
        return this.myProjectPath;
    }

    public String getVariant() {
        return this.myVariant;
    }

    public File getFolder() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getFolder");
    }

    public String getManifest() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getManifest");
    }

    public String getJarFile() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getJarFile");
    }

    public String getCompileJarFile() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getCompileJarFile");
    }

    public String getResFolder() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getResFolder");
    }

    public File getResStaticLibrary() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getResStaticLibrary");
    }

    public String getAssetsFolder() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getAssetsFolder");
    }

    public Collection<String> getLocalJars() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getLocalJars");
    }

    public String getJniFolder() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getJniFolder");
    }

    public String getAidlFolder() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getAidlFolder");
    }

    public String getRenderscriptFolder() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getRenderscriptFolder");
    }

    public String getProguardRules() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getProguardRules");
    }

    public String getLintJar() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getLintJar");
    }

    public String getExternalAnnotations() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getExternalAnnotations");
    }

    public String getPublicResources() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getPublicResources");
    }

    public String getSymbolFile() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getSymbolFile");
    }

    private static UnsupportedOperationException unsupportedMethodForModuleLibrary(String methodName) {
        return new UnsupportedOperationException(methodName + "() cannot be called when getType() returns LIBRARY_MODULE");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeModuleLibrary)) {
            return false;
        }
        IdeModuleLibrary that = (IdeModuleLibrary)o;
        return this.myType == that.myType && Objects.equals(this.myArtifactAddress, that.myArtifactAddress) && Objects.equals(this.myProjectPath, that.myProjectPath) && Objects.equals(this.myBuildId, that.myBuildId) && Objects.equals(this.myVariant, that.myVariant);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myType, this.myArtifactAddress, this.myBuildId, this.myProjectPath, this.myVariant);
    }

    public String toString() {
        return "IdeModuleLibrary{myType=" + this.myType + ", myArtifactAddress='" + this.myArtifactAddress + '\'' + ", myBuildId='" + this.myBuildId + '\'' + ", myProjectPath='" + this.myProjectPath + '\'' + ", myVariant='" + this.myVariant + '\'' + '}';
    }
}

