/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import com.android.ide.common.repository.GradleVersion;
import com.android.utils.XmlUtils;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "readUrlDataAsString", "url", "studio.android.sdktools.sdk-common"})
@JvmName(name="UpdateGoogleMavenRepositoryCache")
public final class UpdateGoogleMavenRepositoryCache {
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        String string = (String)ArraysKt.singleOrNull((Object[])args);
        if (string == null) {
            String string2 = "You have to specify the repo root as only argument.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String root = string;
        if (!new File(root, ".repo").isDirectory()) {
            String string3 = "Invalid directory: should be pointing to the root of a tools checkout directory.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        File dir = new File(root, "tools/base/sdk-common/src/main/resources/versions-offline/");
        if (!dir.exists()) {
            String string4 = dir.getAbsolutePath() + " does not exist.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        FilesKt.deleteRecursively((File)dir);
        dir.mkdir();
        String master = UpdateGoogleMavenRepositoryCache.readUrlDataAsString(GoogleMavenRepositoryKt.GMAVEN_BASE_URL + "master-index.xml");
        File masterFile = new File(dir, "master-index.xml");
        Files.asCharSink((File)masterFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)master);
        String string5 = "Wrote " + masterFile;
        boolean bl = false;
        System.out.println((Object)string5);
        Document document = XmlUtils.parseDocumentSilently((String)master, (boolean)false);
        if (document == null) {
            Intrinsics.throwNpe();
        }
        Document masterDoc = document;
        Element current = XmlUtils.getFirstSubTag((Node)masterDoc.getDocumentElement());
        while (current != null) {
            String group;
            String string6 = group = current.getTagName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"group");
            String relative = StringsKt.replace$default((String)string6, (char)'.', (char)'/', (boolean)false, (int)4, null);
            String groupIndex = UpdateGoogleMavenRepositoryCache.readUrlDataAsString(GoogleMavenRepositoryKt.GMAVEN_BASE_URL + relative + "/group-index.xml");
            StringBuilder sb = new StringBuilder();
            Iterable $this$forEach$iv = StringsKt.lines((CharSequence)groupIndex);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean done;
                String line;
                block16: {
                    String sub;
                    line = (String)element$iv;
                    boolean bl2 = false;
                    int start = StringsKt.indexOf$default((CharSequence)line, (String)"versions=\"", (int)0, (boolean)false, (int)6, null);
                    done = false;
                    if (start == -1) break block16;
                    int end = StringsKt.indexOf$default((CharSequence)line, (String)"\"", (int)(start += "versions=\"".length()), (boolean)false, (int)4, null);
                    String string7 = line;
                    boolean bl3 = false;
                    String string8 = string7;
                    if (string8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8.substring(start, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    GradleVersion max = null;
                    TreeMap maxStablePerMajor = new TreeMap(Collections.reverseOrder());
                    Sequence $this$forEach$iv2 = StringsKt.splitToSequence$default((CharSequence)sub, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        GradleVersion v;
                        block18: {
                            block17: {
                                String it = (String)element$iv2;
                                boolean bl4 = false;
                                Intrinsics.checkExpressionValueIsNotNull((Object)GradleVersion.parse(it), (String)"GradleVersion.parse(it)");
                                if (max == null) break block17;
                                GradleVersion gradleVersion = max;
                                if (gradleVersion == null) {
                                    Intrinsics.throwNpe();
                                }
                                if (v.compareTo(gradleVersion) <= 0) break block18;
                            }
                            max = v;
                        }
                        if (v.isPreview()) continue;
                        maxStablePerMajor.compute(v.getMajor(), (BiFunction)new BiFunction<Integer, GradleVersion, GradleVersion>(v){
                            final /* synthetic */ GradleVersion $v;

                            @Nullable
                            public final GradleVersion apply(@NotNull Integer $noName_0, @Nullable GradleVersion old) {
                                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                return old == null ? this.$v : (GradleVersion)ComparisonsKt.maxOf((Comparable)old, (Comparable)this.$v);
                            }
                            {
                                this.$v = gradleVersion;
                            }
                        });
                    }
                    if (max != null) {
                        String string9 = line;
                        int n = 0;
                        StringBuilder stringBuilder = sb;
                        boolean bl5 = false;
                        String string10 = string9;
                        if (string10 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string11 = string10.substring(n, start);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string12 = string11;
                        stringBuilder.append(string12);
                        Collection collection = maxStablePerMajor.values();
                        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"maxStablePerMajor.values");
                        Collection collection2 = CollectionsKt.take((Iterable)collection, (int)2);
                        GradleVersion gradleVersion = max;
                        if (gradleVersion == null) {
                            Intrinsics.throwNpe();
                        }
                        CollectionsKt.joinTo$default((Iterable)CollectionsKt.toSortedSet((Iterable)CollectionsKt.plus((Collection)collection2, (Object)gradleVersion)), (Appendable)sb, (CharSequence)",", null, null, (int)0, null, null, (int)124, null);
                        string9 = line;
                        stringBuilder = sb;
                        n = 0;
                        String string13 = string9;
                        if (string13 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string14 = string13.substring(end);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"(this as java.lang.String).substring(startIndex)");
                        string12 = string14;
                        stringBuilder.append(string12);
                        sb.append("\n");
                        done = true;
                    }
                }
                if (done) continue;
                sb.append(line).append("\n");
            }
            File file = new File(dir, StringsKt.replace$default((String)relative, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null) + File.separatorChar + "group-index.xml");
            file.getParentFile().mkdirs();
            Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)sb);
            String string15 = "Wrote " + file;
            boolean bl6 = false;
            System.out.println((Object)string15);
            current = XmlUtils.getNextTag((Node)current);
        }
        String string16 = "Updated indices. NOTE: You may need to update the JarContentsTest gradle integration test if the set of packaged xml files has changed. See JarContentsTest for instructions on how to update the test.";
        boolean bl7 = false;
        System.out.println((Object)string16);
    }

    private static final String readUrlDataAsString(String url) {
        String string = Resources.asCharSource((URL)new URL(url), (Charset)Charsets.UTF_8).read();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Resources.asCharSource(U\u2026), Charsets.UTF_8).read()");
        return string;
    }
}

