/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.AsciiString;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.mvstore.Chunk;
import org.jetbrains.mvstore.Cursor;
import org.jetbrains.mvstore.DataUtil;
import org.jetbrains.mvstore.FileStore;
import org.jetbrains.mvstore.LeafPage;
import org.jetbrains.mvstore.MVMap;
import org.jetbrains.mvstore.MVStoreException;
import org.jetbrains.mvstore.MapMetadata;
import org.jetbrains.mvstore.NonLeafPage;
import org.jetbrains.mvstore.Page;
import org.jetbrains.mvstore.RootReference;
import org.jetbrains.mvstore.type.AsciiStringDataType;
import org.jetbrains.mvstore.type.ByteArrayDataType;
import org.jetbrains.mvstore.type.DataType;
import org.jetbrains.mvstore.type.IntDataType;
import org.jetbrains.mvstore.type.KeyableDataType;
import org.jetbrains.mvstore.type.LongDataType;

public final class MVStore
implements AutoCloseable {
    public static final boolean ASSERT_MODE = Boolean.getBoolean("mvstore.assert.mode");
    private static final int MAP_NAME_MAP_ID = 0;
    private static final int LAYOUT_MAP_ID = 1;
    private static final int CHUNK_MAP_ID = 2;
    static final int BLOCK_SIZE = 4096;
    private static final byte FORMAT_WRITE = 2;
    private static final byte FORMAT_READ = 2;
    private static final int MIN_USER_MAP_ID = 5;
    private static final int STATE_OPEN = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_CLOSING = 2;
    private static final int STATE_CLOSED = 3;
    private final ReentrantLock storeLock = new ReentrantLock(true);
    private final ReentrantLock serializationLock = new ReentrantLock(true);
    private final ReentrantLock saveChunkLock = new ReentrantLock(true);
    private final BoundedTaskExecutor serializationExecutor;
    private volatile boolean reuseSpace = true;
    private volatile int state = 0;
    private final FileStore fileStore;
    private final boolean closeFileStoreClose;
    private final Builder config;
    private final Cache<Long, Page<?, ?>> nonLeafPageCache;
    private final Cache<Long, Page<?, ?>> leafPageCache;
    final long nonLeafPageSplitSize;
    final long leafPageSplitSize;
    private final Cache<Integer, LongArrayList> chunksToC;
    private volatile Chunk lastChunk;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private final Queue<RemovedPageInfo> removedPages = new PriorityBlockingQueue<RemovedPageInfo>();
    private final Deque<Chunk> deadChunks = new ArrayDeque<Chunk>();
    private long updateCounter = 0L;
    private long updateAttemptCounter = 0L;
    private final MVMap<Integer, Long> layout;
    private final MVMap<Integer, byte[]> chunkIdToChunkMetadata;
    private final MVMap<AsciiString, MapMetadata> mapNameToMetadata;
    private final MVMap<?, ?>[] metaMaps;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private StoreHeader storeHeader = new StoreHeader();
    private final AtomicInteger lastMapId = new AtomicInteger(4);
    private int lastChunkId;
    private LZ4Compressor compressor;
    private LZ4FastDecompressor decompressor;
    private volatile long currentVersion;
    private final AtomicLong oldestVersionToKeep = new AtomicLong();
    private final Deque<TxCounter> versions = new LinkedList<TxCounter>();
    private volatile TxCounter currentTxCounter = new TxCounter(this.currentVersion);
    private int unsavedMemory;
    private volatile boolean saveNeeded;
    private int retentionTime;
    private long lastCommitTime;
    private volatile long currentStoreVersion = -1L;
    private volatile boolean metaChanged;
    private int autoCommitDelay;
    private long autoCompactLastFileOpCount;
    private volatile MVStoreException panicException;
    private long lastTimeAbsolute;
    private long leafCount;
    private long nonLeafCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MVStore(FileStore fileStore, Builder config) {
        this.closeFileStoreClose = true;
        this.fileStore = fileStore;
        this.config = config;
        if (fileStore != null && config.nonLeafPageCacheSize > 0) {
            long maxNonLeafWeight = (long)config.nonLeafPageCacheSize * 1024L * 1024L;
            long maxLeafWeight = (long)config.leafPageCacheSize * 1024L * 1024L;
            this.nonLeafPageCache = MVStore.createPageCache(maxNonLeafWeight, config.recordCacheStats);
            this.leafPageCache = MVStore.createPageCache(maxLeafWeight, config.recordCacheStats);
            Caffeine chunksToCacheBuilder = Caffeine.newBuilder().maximumWeight(131072L).weigher((key, value) -> value.size());
            if (config.recordCacheStats) {
                chunksToCacheBuilder.recordStats();
            }
            this.chunksToC = chunksToCacheBuilder.build();
            this.nonLeafPageSplitSize = Math.min(maxNonLeafWeight, (long)config.pageSplitSize);
            this.leafPageSplitSize = Math.min(maxLeafWeight, (long)config.pageSplitSize);
        } else {
            this.nonLeafPageCache = null;
            this.leafPageCache = null;
            this.chunksToC = null;
            this.nonLeafPageSplitSize = Long.MAX_VALUE;
            this.leafPageSplitSize = Long.MAX_VALUE;
        }
        this.layout = new MVMap<Integer, Long>(this, 1, IntDataType.INSTANCE, LongDataType.INSTANCE);
        this.chunkIdToChunkMetadata = new MVMap<Integer, byte[]>(this, 2, IntDataType.INSTANCE, ByteArrayDataType.INSTANCE);
        if (fileStore == null) {
            this.serializationExecutor = null;
            this.mapNameToMetadata = this.openMapNameMap();
        } else {
            this.retentionTime = fileStore.getDefaultRetentionTime();
            this.storeLock.lock();
            try {
                this.saveChunkLock.lock();
                try {
                    int storeHeaderSize = 8192;
                    ByteBuf buf = PooledByteBufAllocator.DEFAULT.ioBuffer(storeHeaderSize, storeHeaderSize);
                    try {
                        if (fileStore.size() > (long)storeHeaderSize) {
                            this.readStoreHeader(buf);
                        } else {
                            StoreHeader storeHeader = this.storeHeader;
                            storeHeader.creationTime = this.getTimeAbsolute();
                            storeHeader.format = (short)2;
                            storeHeader.blockSize = 4096;
                            this.currentVersion = 0L;
                            this.layout.setRootPageInfo(0L, -1L);
                            this.chunkIdToChunkMetadata.setRootPageInfo(0L, -1L);
                            if (!fileStore.isReadOnly()) {
                                this.writeStoreHeader(buf);
                            }
                        }
                    }
                    finally {
                        buf.release();
                    }
                }
                finally {
                    this.saveChunkLock.unlock();
                }
            }
            finally {
                this.unlockAndCheckPanicCondition();
            }
            this.lastCommitTime = this.getTimeSinceCreation();
            this.mapNameToMetadata = this.openMapNameMap();
            Int2ObjectMap<MapMetadata> idToMetadata = this.scrubMetaMap();
            this.scrubLayoutMap((Int2ObjectFunction<MapMetadata>)idToMetadata);
            this.autoCommitDelay = config.autoCommitDelay;
            this.serializationExecutor = !fileStore.isReadOnly() && this.autoCommitDelay > 0 && this.isOpen() ? (BoundedTaskExecutor)AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"MVStore Serialization", (int)1, (boolean)false) : null;
        }
        this.metaMaps = new MVMap[]{this.mapNameToMetadata, this.layout, this.chunkIdToChunkMetadata};
        this.onVersionChange(this.currentVersion);
    }

    private static Cache<Long, Page<?, ?>> createPageCache(long maxSizeInBytes, boolean recordCacheStats) {
        Caffeine cacheBuilder = Caffeine.newBuilder().maximumWeight(maxSizeInBytes).weigher((key, value) -> value.getMemory());
        if (recordCacheStats) {
            cacheBuilder.recordStats();
        }
        return cacheBuilder.build();
    }

    @NotNull
    private MVMap<AsciiString, MapMetadata> openMapNameMap() {
        MVMap<AsciiString, MapMetadata> map2 = new MVMap<AsciiString, MapMetadata>(this, 0, AsciiStringDataType.INSTANCE, new MapMetadata.MapMetadataSerializer());
        map2.setRootPageInfo(this.getRootPageInfo(map2.getId()), this.currentVersion - 1L);
        MVMap<AsciiString, MapMetadata> mVMap = map2;
        if (mVMap == null) {
            MVStore.$$$reportNull$$$0(0);
        }
        return mVMap;
    }

    private void scrubLayoutMap(@NotNull Int2ObjectFunction<MapMetadata> idToMetadata) {
        if (idToMetadata == null) {
            MVStore.$$$reportNull$$$0(1);
        }
        HashSet<Integer> keysToRemove = null;
        Iterator<Object> it = this.layout.keyIterator(null);
        while (it.hasNext()) {
            Integer mapId = it.next();
            if (mapId < 5 || idToMetadata.containsKey(mapId.intValue())) continue;
            if (keysToRemove == null) {
                keysToRemove = new HashSet<Integer>();
            }
            keysToRemove.add(mapId);
        }
        if (keysToRemove != null) {
            for (Integer key : keysToRemove) {
                this.layout.remove(key);
            }
        }
    }

    @NotNull
    private Int2ObjectMap<MapMetadata> scrubMetaMap() {
        HashSet<AsciiString> keysToRemove = null;
        int size = this.mapNameToMetadata.size();
        if (size == 0) {
            Int2ObjectMap int2ObjectMap = Int2ObjectMaps.emptyMap();
            if (int2ObjectMap == null) {
                MVStore.$$$reportNull$$$0(2);
            }
            return int2ObjectMap;
        }
        Int2ObjectOpenHashMap idToMetadata = new Int2ObjectOpenHashMap(size);
        Int2ObjectOpenHashMap idToName = new Int2ObjectOpenHashMap(size);
        int maxMapId = this.lastMapId.get();
        Cursor<Object, MapMetadata> cursor = this.mapNameToMetadata.cursor(null);
        while (cursor.hasNext()) {
            MapMetadata metadata;
            AsciiString name = cursor.next();
            int id = metadata.id;
            metadata = cursor.getValue();
            MapMetadata existing = (MapMetadata)idToMetadata.putIfAbsent(id, (Object)metadata);
            if (existing != null) {
                if (keysToRemove == null) {
                    keysToRemove = new HashSet<AsciiString>();
                }
                if (metadata.createVersion <= existing.createVersion) {
                    keysToRemove.add(name);
                    continue;
                }
                keysToRemove.add((AsciiString)idToName.get(id));
                idToMetadata.put(id, (Object)metadata);
            }
            idToName.put(id, (Object)name);
            if (maxMapId >= id) continue;
            maxMapId = id;
        }
        if (maxMapId > this.lastMapId.get()) {
            this.lastMapId.set(maxMapId);
        }
        if (keysToRemove != null) {
            for (AsciiString key : keysToRemove) {
                this.mapNameToMetadata.remove(key);
                this.markMetaChanged();
            }
        }
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = idToMetadata;
        if (int2ObjectOpenHashMap == null) {
            MVStore.$$$reportNull$$$0(3);
        }
        return int2ObjectOpenHashMap;
    }

    private void unlockAndCheckPanicCondition() {
        this.storeLock.unlock();
        if (this.getPanicException() != null) {
            this.closeImmediately();
        }
    }

    private void panic(MVStoreException e) {
        if (this.isOpen()) {
            this.handleException(e);
            this.panicException = e;
        }
        throw e;
    }

    public MVStoreException getPanicException() {
        return this.panicException;
    }

    public <K, V> MVMap<K, V> openMap(@NotNull String name, @NotNull KeyableDataType<K> keyType, @NotNull DataType<V> valueType) {
        if (name == null) {
            MVStore.$$$reportNull$$$0(4);
        }
        if (keyType == null) {
            MVStore.$$$reportNull$$$0(5);
        }
        if (valueType == null) {
            MVStore.$$$reportNull$$$0(6);
        }
        return this.openMap(name, ((MVMap.Builder)new MVMap.Builder().keyType((KeyableDataType)keyType)).valueType((DataType)valueType));
    }

    public <M extends MVMap<K, V>, K, V> M openMap(@NotNull CharSequence nameAsString, @NotNull MVMap.MapBuilder<M, K, V> builder) {
        AsciiString name;
        MapMetadata metadata;
        if (nameAsString == null) {
            MVStore.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            MVStore.$$$reportNull$$$0(8);
        }
        if ((metadata = this.mapNameToMetadata.get(name = AsciiString.of((CharSequence)nameAsString))) != null) {
            MVMap<K, V> map2 = this.getMap(metadata.id);
            if (map2 == null) {
                map2 = this.openMap(metadata, builder);
            }
            assert (builder.getKeyType() == null || map2.getKeyType().getClass().equals(builder.getKeyType().getClass()));
            assert (builder.getValueType() == null || map2.getValueType().getClass().equals(builder.getValueType().getClass()));
            return (M)map2;
        }
        int id = this.lastMapId.incrementAndGet();
        assert (id >= 5 && !this.maps.containsKey(id));
        metadata = new MapMetadata(id, this.currentVersion);
        Object map3 = builder.create(this, id, metadata);
        this.mapNameToMetadata.put(name, metadata);
        long lastStoredVersion = this.currentVersion - 1L;
        ((MVMap)map3).setRootPageInfo(0L, lastStoredVersion);
        this.markMetaChanged();
        MVMap<?, ?> existingMap = this.maps.putIfAbsent(id, (MVMap<?, ?>)map3);
        if (existingMap != null) {
            map3 = existingMap;
        }
        return map3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends MVMap<K, V>, K, V> M openMap(@NotNull MapMetadata metadata, MVMap.MapBuilder<M, K, V> builder) {
        if (metadata == null) {
            MVStore.$$$reportNull$$$0(9);
        }
        this.storeLock.lock();
        try {
            int id = metadata.id;
            MVMap<K, V> map2 = this.getMap(id);
            if (map2 == null) {
                map2 = builder.create(this, id, metadata);
                long root = this.getRootPageInfo(id);
                long lastStoredVersion = this.currentVersion - 1L;
                map2.setRootPageInfo(root, lastStoredVersion);
                this.maps.put(id, map2);
            }
            MVMap<K, V> mVMap = map2;
            return (M)mVMap;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public <K, V> MVMap<K, V> getMap(int id) {
        this.checkOpen();
        MVMap<?, ?> map2 = this.maps.get(id);
        return map2;
    }

    public Set<CharSequence> getMapNames() {
        HashSet<CharSequence> set = new HashSet<CharSequence>();
        this.checkOpen();
        Iterator<Object> iterator = this.mapNameToMetadata.keyIterator(null);
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public MVMap<Integer, Long> getLayoutMap() {
        this.checkOpen();
        return this.layout;
    }

    @TestOnly
    public MVMap<AsciiString, MapMetadata> getMetaMap() {
        this.checkOpen();
        return this.mapNameToMetadata;
    }

    public MVMap<Integer, byte[]> getChunkMap() {
        this.checkOpen();
        return this.chunkIdToChunkMetadata;
    }

    public boolean hasMap(@NotNull CharSequence name) {
        if (name == null) {
            MVStore.$$$reportNull$$$0(10);
        }
        return this.mapNameToMetadata.containsKey(AsciiString.of((CharSequence)name));
    }

    public boolean hasData(@NotNull CharSequence name) {
        MapMetadata metadata;
        if (name == null) {
            MVStore.$$$reportNull$$$0(11);
        }
        return (metadata = this.mapNameToMetadata.get(AsciiString.of((CharSequence)name))) != null && this.getRootPageInfo(metadata.id) != 0L;
    }

    private void markMetaChanged() {
        this.metaChanged = true;
    }

    private void readStoreHeader(ByteBuf buf) {
        Chunk tailChunk;
        Chunk newest = null;
        boolean assumeCleanShutdown = true;
        boolean validStoreHeader = false;
        this.fileStore.readFully(buf, 0L, 8192);
        for (int i = 0; i < 2; ++i) {
            try {
                int headerStart = i * 4096;
                buf.setIndex(headerStart, 8192);
                StoreHeader header = new StoreHeader();
                header.read(buf);
                int headerEnd = buf.readerIndex();
                int checksum = buf.readInt();
                buf.readerIndex(headerStart);
                buf.writerIndex(headerEnd);
                if (DataUtil.getFletcher32(buf, buf.readerIndex(), buf.readableBytes()) != checksum) {
                    assumeCleanShutdown = false;
                    continue;
                }
                boolean bl = assumeCleanShutdown = assumeCleanShutdown && (newest == null || header.lastChunkVersion == newest.version);
                if (newest != null && header.lastChunkVersion <= newest.version) continue;
                validStoreHeader = true;
                this.storeHeader = header;
                int chunkId = header.lastChunkId;
                long blockNumber = header.lastBlockNumber;
                if (blockNumber == 0L) {
                    blockNumber = 2L;
                }
                buf.clear();
                Chunk test = this.readChunkHeaderAndFooter(blockNumber, chunkId, buf);
                if (test == null) continue;
                newest = test;
                continue;
            }
            catch (Exception e) {
                this.handleException(e);
                assumeCleanShutdown = false;
            }
        }
        if (!validStoreHeader) {
            throw new MVStoreException(6, "Store header is corrupt: " + this.fileStore);
        }
        int blockSize = this.storeHeader.blockSize;
        if (blockSize != 4096) {
            throw new MVStoreException(5, "Block size " + blockSize + " is currently not supported");
        }
        long format = this.storeHeader.format;
        if (format > 2L && !this.fileStore.isReadOnly()) {
            throw new MVStoreException(5, "The write format " + format + " is larger than the supported format 2, and the file was not opened in read-only mode");
        }
        format = this.storeHeader.formatRead;
        if (format > 2L) {
            throw new MVStoreException(5, "The read format " + format + " is larger than the supported format 2");
        }
        boolean bl = assumeCleanShutdown = assumeCleanShutdown && newest != null && !this.config.recoveryMode;
        if (assumeCleanShutdown) {
            assumeCleanShutdown = this.storeHeader.cleanShutdown;
        }
        this.chunks.clear();
        long now = System.currentTimeMillis();
        int year = 1970 + (int)(now / 31557600000L);
        if (year < 2014) {
            this.storeHeader.creationTime = now - (long)this.fileStore.getDefaultRetentionTime();
        } else if (now < this.storeHeader.creationTime) {
            this.storeHeader.creationTime = now;
        }
        long fileSize = this.fileStore.size();
        long blocksInStore = fileSize / 4096L;
        Comparator chunkComparator = (one, two) -> {
            if (two.version == one.version) {
                return Long.compare(one.block, two.block);
            }
            return 0;
        };
        if (!assumeCleanShutdown && (tailChunk = this.discoverChunk(blocksInStore)) != null) {
            blocksInStore = tailChunk.block;
            if (newest == null || tailChunk.version > newest.version) {
                newest = tailChunk;
            }
        }
        Long2ObjectOpenHashMap validChunksByLocation = new Long2ObjectOpenHashMap();
        if (newest != null) {
            while (true) {
                validChunksByLocation.put(newest.block, (Object)newest);
                if (newest.next == 0L || newest.next >= blocksInStore) break;
                buf.clear();
                Chunk test = this.readChunkHeaderAndFooter(newest.next, newest.id + 1, buf);
                if (test == null || test.version <= newest.version) break;
                assumeCleanShutdown = false;
                newest = test;
            }
        }
        if (assumeCleanShutdown) {
            PriorityQueue chunksToVerify = new PriorityQueue(20, Collections.reverseOrder(chunkComparator));
            try {
                Chunk chunk;
                this.setLastChunk(newest);
                Cursor<Object, byte[]> cursor = this.chunkIdToChunkMetadata.cursor(null);
                while (cursor.hasNext()) {
                    chunk = this.chunks.computeIfAbsent(cursor.next(), id -> Chunk.readMetadata(id, Unpooled.wrappedBuffer((byte[])((byte[])cursor.getValue()))));
                    assert (chunk.version <= this.currentVersion);
                    chunksToVerify.offer(chunk);
                    if (chunksToVerify.size() != 20) continue;
                    chunksToVerify.poll();
                }
                while (assumeCleanShutdown && (chunk = (Chunk)chunksToVerify.poll()) != null) {
                    buf.clear();
                    Chunk chunk2 = this.readChunkHeaderAndFooter(chunk.block, chunk.id, buf);
                    assumeCleanShutdown = chunk2 != null;
                    if (!assumeCleanShutdown) continue;
                    validChunksByLocation.put(chunk2.block, (Object)chunk2);
                }
            }
            catch (MVStoreException e) {
                this.handleException(e);
                assumeCleanShutdown = false;
            }
        }
        if (!assumeCleanShutdown) {
            boolean quickRecovery = false;
            if (!this.config.recoveryMode) {
                Chunk[] lastChunkCandidates = (Chunk[])validChunksByLocation.values().toArray((Object[])new Chunk[0]);
                Arrays.sort(lastChunkCandidates, chunkComparator);
                Int2ObjectOpenHashMap validChunksById = new Int2ObjectOpenHashMap(lastChunkCandidates.length);
                for (Chunk chunk : lastChunkCandidates) {
                    validChunksById.put(chunk.id, (Object)chunk);
                }
                quickRecovery = this.findLastChunkWithCompleteValidChunkSet(lastChunkCandidates, (Long2ObjectMap<Chunk>)validChunksByLocation, (Int2ObjectMap<Chunk>)validChunksById, false);
            }
            if (!quickRecovery) {
                Chunk chunk;
                long block = blocksInStore;
                while ((chunk = this.discoverChunk(block)) != null) {
                    block = chunk.block;
                    validChunksByLocation.put(block, (Object)chunk);
                }
                Chunk[] lastChunkCandidates = (Chunk[])validChunksByLocation.values().toArray((Object[])new Chunk[0]);
                Arrays.sort(lastChunkCandidates, chunkComparator);
                Int2ObjectOpenHashMap validChunksById = new Int2ObjectOpenHashMap(lastChunkCandidates.length);
                for (Chunk chunk3 : lastChunkCandidates) {
                    validChunksById.put(chunk3.id, (Object)chunk3);
                }
                if (!this.findLastChunkWithCompleteValidChunkSet(lastChunkCandidates, (Long2ObjectMap<Chunk>)validChunksByLocation, (Int2ObjectMap<Chunk>)validChunksById, true) && this.lastChunk != null) {
                    throw new MVStoreException(6, "File is corrupted - unable to recover a valid set of chunks");
                }
            }
        }
        this.fileStore.clear();
        for (Chunk c : this.chunks.values()) {
            if (c.isSaved()) {
                long start = c.block * 4096L;
                int length = c.blockCount * 4096;
                this.fileStore.markUsed(start, length);
            }
            if (c.isLive()) continue;
            this.deadChunks.offer(c);
        }
        if (ASSERT_MODE) assert (this.validateFileLength("on open"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findLastChunkWithCompleteValidChunkSet(Chunk[] lastChunkCandidates, Long2ObjectMap<Chunk> validChunksByLocation, Int2ObjectMap<Chunk> validChunksById, boolean afterFullScan) {
        for (Chunk chunk : lastChunkCandidates) {
            boolean verified = true;
            ByteBuf buf = null;
            try {
                this.setLastChunk(chunk);
                Cursor<Object, byte[]> cursor = this.chunkIdToChunkMetadata.cursor(null);
                while (cursor.hasNext()) {
                    Integer id = cursor.next();
                    Chunk c = Chunk.readMetadata(id, Unpooled.wrappedBuffer((byte[])cursor.getValue()));
                    assert (c.version <= this.currentVersion);
                    Chunk test = this.chunks.putIfAbsent(c.id, c);
                    if (test != null) {
                        c = test;
                    }
                    assert (this.chunks.get(c.id) == c);
                    test = (Chunk)validChunksByLocation.get(c.block);
                    if (test == null || test.id != c.id) {
                        test = (Chunk)validChunksById.get(c.id);
                        if (test != null) {
                            c.block = test.block;
                        } else if (c.isLive()) {
                            if (buf == null) {
                                if (!afterFullScan) {
                                    buf = PooledByteBufAllocator.DEFAULT.ioBuffer(24);
                                }
                            } else {
                                buf.clear();
                            }
                            if (afterFullScan || this.readChunkHeaderAndFooter(c.block, c.id, buf) == null) {
                                verified = false;
                                break;
                            }
                        }
                    }
                    if (c.isLive()) continue;
                    c.block = Long.MAX_VALUE;
                    c.blockCount = Integer.MAX_VALUE;
                    if (c.unused == 0L) {
                        c.unused = this.storeHeader.creationTime;
                    }
                    if (c.unusedAtVersion != 0L) continue;
                    c.unusedAtVersion = -1L;
                }
            }
            catch (Exception ignored) {
                verified = false;
            }
            finally {
                if (buf != null) {
                    buf.release();
                }
            }
            if (!verified) continue;
            return true;
        }
        return false;
    }

    private void setLastChunk(Chunk last) {
        this.chunks.clear();
        this.lastChunk = last;
        this.lastChunkId = 0;
        this.currentVersion = this.lastChunkVersion();
        long layoutRootPageInfo = 0L;
        long chunkMapRootPageInfo = 0L;
        int mapId = 5;
        if (last != null) {
            this.lastChunkId = last.id;
            this.currentVersion = last.version;
            layoutRootPageInfo = last.layoutRootPageInfo;
            chunkMapRootPageInfo = last.chunkMapRootPageInfo;
            mapId = last.mapId;
            this.chunks.put(last.id, last);
        }
        this.lastMapId.set(mapId);
        this.layout.setRootPageInfo(layoutRootPageInfo, this.currentVersion - 1L);
        this.chunkIdToChunkMetadata.setRootPageInfo(chunkMapRootPageInfo, this.currentVersion - 1L);
    }

    private Chunk discoverChunk(long block) {
        long candidateLocation = Long.MAX_VALUE;
        Chunk candidate = null;
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.ioBuffer(24);
        try {
            while (true) {
                Chunk chunk;
                if (block == candidateLocation) {
                    chunk = candidate;
                    return chunk;
                }
                if (block == 2L) {
                    chunk = null;
                    return chunk;
                }
                buf.clear();
                Chunk test = this.readChunkFooter(block, buf);
                if (test != null) {
                    candidateLocation = Long.MAX_VALUE;
                    test = this.readChunkHeaderOptionally(test.block, test.id);
                    if (test != null) {
                        candidate = test;
                        candidateLocation = test.block;
                    }
                }
                if (--block <= candidateLocation || this.readChunkHeaderOptionally(block) == null) continue;
                candidateLocation = Long.MAX_VALUE;
            }
        }
        finally {
            buf.release();
        }
    }

    private Chunk readChunkHeaderAndFooter(long blockNumber, int expectedId, ByteBuf buf) {
        Chunk header;
        try {
            header = this.readChunkHeader(blockNumber, buf);
            if (header.block != blockNumber || header.id != expectedId) {
                return null;
            }
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
        buf.clear();
        Chunk footer = this.readChunkFooter(blockNumber + (long)header.blockCount, buf);
        return footer == null || footer.id != expectedId || footer.block != header.block ? null : header;
    }

    private Chunk readChunkFooter(long blockNumber, ByteBuf buf) {
        try {
            long position = blockNumber * 4096L - 24L;
            if (position < 0L) {
                return null;
            }
            this.fileStore.readFully(buf, position, 24);
            int start = buf.readerIndex();
            int chunkId = buf.readInt();
            long chunkBlock = buf.readLong();
            long chunkVersion = buf.readLong();
            int checksum = buf.readInt();
            if (DataUtil.getFletcher32(buf, start, buf.readerIndex() - start - 4) == checksum) {
                return new Chunk(chunkId, chunkBlock, chunkVersion);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void writeStoreHeader() {
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.ioBuffer(8192);
        try {
            this.writeStoreHeader(buf);
        }
        finally {
            buf.release();
        }
    }

    private void writeStoreHeader(ByteBuf buf) {
        StoreHeader storeHeader = this.storeHeader;
        if (this.lastChunk != null) {
            storeHeader.lastBlockNumber = this.lastChunk.block;
            storeHeader.lastChunkId = this.lastChunk.id;
            storeHeader.lastChunkVersion = this.lastChunk.version;
        }
        buf.clear();
        buf.ensureWritable(8192);
        storeHeader.write(buf);
        int checksum = DataUtil.getFletcher32(buf, buf.readerIndex(), buf.readableBytes());
        buf.writeInt(checksum);
        buf.writeZero(4096 - buf.writerIndex());
        storeHeader.write(buf);
        buf.writeInt(checksum);
        buf.writeZero(8192 - buf.writerIndex());
        this.write(0L, buf);
    }

    private void write(long pos, ByteBuf buf) {
        try {
            this.fileStore.writeFully(buf, pos);
        }
        catch (MVStoreException e) {
            this.panic(e);
        }
    }

    @Override
    public void close() {
        this.closeStore(true, 0);
    }

    public void close(int allowedCompactionTime) {
        this.closeStore(true, allowedCompactionTime);
    }

    public void closeImmediately() {
        try {
            this.closeStore(false, 0);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(boolean normalShutdown, int allowedCompactionTime) {
        while (!this.isClosed()) {
            MVStore.shutdownExecutor(this.serializationExecutor);
            this.storeLock.lock();
            try {
                if (this.state != 0) continue;
                this.state = 1;
                try {
                    try {
                        if (normalShutdown && this.fileStore != null && !this.fileStore.isReadOnly()) {
                            for (MVMap<?, ?> map2 : this.maps.values()) {
                                if (!map2.isClosed()) continue;
                                this.deregisterMapRoot(map2.getId());
                            }
                            this.setRetentionTime(0);
                            this.commit();
                            if (allowedCompactionTime > 0) {
                                this.compactFile(allowedCompactionTime);
                            } else if (allowedCompactionTime < 0) {
                                this.doMaintenance(this.config.autoCompactFillRate);
                            }
                            this.saveChunkLock.lock();
                            try {
                                this.shrinkFileIfPossible(0);
                                this.storeHeader.cleanShutdown = true;
                                this.writeStoreHeader();
                                this.sync();
                                if (ASSERT_MODE) assert (this.validateFileLength("on close"));
                            }
                            finally {
                                this.saveChunkLock.unlock();
                            }
                        }
                        this.state = 2;
                        this.clearCaches();
                        for (MVMap<?, ?> m : new ArrayList(this.maps.values())) {
                            m.close();
                        }
                        this.chunks.clear();
                        this.maps.clear();
                    }
                    finally {
                        if (this.fileStore == null || !this.closeFileStoreClose) continue;
                        this.fileStore.close();
                    }
                }
                finally {
                    this.state = 3;
                }
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    private static void shutdownExecutor(@Nullable BoundedTaskExecutor executor) {
        if (executor != null && !executor.isShutdown()) {
            executor.shutdown();
            try {
                if (executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            executor.clearAndCancelAll();
        }
    }

    private Chunk getChunk(int chunkId) {
        return this.chunks.computeIfAbsent(chunkId, id -> {
            this.checkOpen();
            byte[] metadata = this.chunkIdToChunkMetadata.get(chunkId);
            if (metadata == null) {
                throw new MVStoreException(9, "Chunk " + chunkId + " not found");
            }
            Chunk chunk = Chunk.readMetadata(chunkId, Unpooled.wrappedBuffer((byte[])metadata));
            if (!chunk.isSaved()) {
                throw new MVStoreException(9, "Chunk " + chunkId + " is invalid");
            }
            return chunk;
        });
    }

    private void setWriteVersion(long version) {
        Iterator<MVMap<?, ?>> iter = this.maps.values().iterator();
        while (iter.hasNext()) {
            MVMap<?, ?> map2 = iter.next();
            assert (map2.getId() >= 5);
            if (map2.setWriteVersion(version) != null) continue;
            iter.remove();
        }
        for (MVMap<?, ?> map3 : this.metaMaps) {
            map3.setWriteVersion(version);
        }
        this.onVersionChange(version);
    }

    public long tryCommit() {
        return this.tryCommit(null);
    }

    private long tryCommit(@Nullable Predicate<MVStore> check) {
        if ((!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) && this.storeLock.tryLock()) {
            try {
                if (check == null || check.test(this)) {
                    this.store(false);
                }
            }
            finally {
                this.unlockAndCheckPanicCondition();
            }
        }
        return this.currentVersion;
    }

    public long commit() {
        return this.commit(null);
    }

    private long commit(@Nullable Predicate<MVStore> check) {
        if (!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) {
            if (this.serializationExecutor != null) {
                try {
                    this.serializationExecutor.waitAllTasksExecuted(10L, TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    this.panic(new MVStoreException(3, (Throwable)e));
                }
            }
            this.storeLock.lock();
            try {
                if (check == null || check.test(this)) {
                    this.store(true);
                }
            }
            finally {
                this.unlockAndCheckPanicCondition();
            }
        }
        return this.currentVersion;
    }

    private void store(boolean syncWrite) {
        assert (this.storeLock.isHeldByCurrentThread());
        assert (!this.saveChunkLock.isHeldByCurrentThread());
        if (!this.isOpenOrStopping() || !this.hasUnsavedChanges()) {
            return;
        }
        this.dropUnusedChunks();
        try {
            this.currentStoreVersion = this.currentVersion++;
            if (this.fileStore == null) {
                this.setWriteVersion(this.currentVersion);
                this.metaChanged = false;
            } else {
                if (this.fileStore.isReadOnly()) {
                    throw new MVStoreException(2, "This store is read-only");
                }
                this.storeNow(syncWrite, 0L, () -> this.reuseSpace ? 0L : this.getAfterLastBlock());
            }
        }
        finally {
            this.currentStoreVersion = -1L;
        }
    }

    private void storeNow(boolean syncWrite, long reservedLow, LongSupplier reservedHighSupplier) {
        try {
            boolean finished;
            List<Page<?, ?>> changed;
            long version;
            int currentUnsavedPageCount;
            block8: {
                this.lastCommitTime = this.getTimeSinceCreation();
                currentUnsavedPageCount = this.unsavedMemory;
                version = ++this.currentVersion;
                changed = this.collectChangedMapRoots(version);
                assert (this.storeLock.isHeldByCurrentThread());
                finished = false;
                if (!syncWrite && this.serializationExecutor != null) {
                    try {
                        this.serializationExecutor.execute(() -> this.serializeAndStore(reservedLow, reservedHighSupplier, changed, this.lastCommitTime, version));
                        finished = true;
                    }
                    catch (RejectedExecutionException ignore) {
                        if ($assertionsDisabled || this.serializationExecutor.isShutdown()) break block8;
                        throw new AssertionError();
                    }
                }
            }
            if (!finished) {
                this.serializeAndStore(reservedLow, reservedHighSupplier, changed, this.lastCommitTime, version);
            }
            this.saveNeeded = false;
            this.unsavedMemory = Math.max(0, this.unsavedMemory - currentUnsavedPageCount);
        }
        catch (MVStoreException e) {
            this.panic(e);
        }
        catch (Throwable e) {
            this.panic(new MVStoreException(3, e));
        }
    }

    private List<Page<?, ?>> collectChangedMapRoots(long version) {
        long lastStoredVersion = version - 2L;
        ArrayList changed = new ArrayList();
        Iterator<MVMap<?, ?>> iter = this.maps.values().iterator();
        while (iter.hasNext()) {
            MVMap<?, ?> map2 = iter.next();
            RootReference<?, ?> rootReference = map2.setWriteVersion(version);
            if (rootReference == null) {
                iter.remove();
                continue;
            }
            if (map2.getCreateVersion() >= version || map2.isVolatile() || !map2.hasChangesSince(lastStoredVersion)) continue;
            assert (rootReference.version <= version) : rootReference.version + " > " + version;
            MVStore.addToChanged(changed, rootReference);
        }
        RootReference<AsciiString, MapMetadata> rootReference = this.mapNameToMetadata.setWriteVersion(version);
        if (this.metaChanged || this.mapNameToMetadata.hasChangesSince(lastStoredVersion)) {
            assert (rootReference != null && rootReference.version <= version) : rootReference == null ? "null" : rootReference.version + " > " + version;
            MVStore.addToChanged(changed, rootReference);
        }
        return changed;
    }

    private static void addToChanged(List<Page<?, ?>> changed, RootReference<?, ?> rootReference) {
        Page rootPage = rootReference.root;
        if (!rootPage.isSaved() || rootPage.isLeaf()) {
            changed.add(rootPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeAndStore(long reservedLow, LongSupplier reservedHighSupplier, List<Page<?, ?>> changed, long time, long version) {
        this.serializationLock.lock();
        boolean isFinished = false;
        ByteBuf buf = null;
        try {
            Chunk chunk = this.createChunk(time, version);
            this.chunks.put(chunk.id, chunk);
            int memory = 100;
            for (Page<?, ?> page : changed) {
                memory += page.getUnsavedMemory();
            }
            buf = PooledByteBufAllocator.DEFAULT.ioBuffer(DataUtil.roundUpInt(memory, 4096));
            this.serializeToBuffer(buf, changed, chunk, reservedLow, reservedHighSupplier);
            this.storeBuffer(chunk, buf, changed);
            isFinished = true;
        }
        catch (MVStoreException e) {
            this.panic(e);
        }
        catch (Throwable e) {
            this.panic(new MVStoreException(3, e));
        }
        finally {
            try {
                this.serializationLock.unlock();
            }
            finally {
                if (!isFinished && buf != null) {
                    buf.release();
                }
            }
        }
    }

    private Chunk createChunk(long time, long version) {
        int newChunkId;
        Chunk old;
        int chunkId = this.lastChunkId;
        if (chunkId != 0) {
            Chunk lastChunk = this.chunks.get(chunkId &= 0x3FFFFFF);
            assert (lastChunk != null);
            assert (lastChunk.isSaved());
            assert (lastChunk.version + 1L == version) : lastChunk.version + " " + version;
            this.putChunkMetadata(chunkId, lastChunk);
            time = Math.max(lastChunk.time, time);
        }
        while ((old = this.chunks.get(newChunkId = ++this.lastChunkId & 0x3FFFFFF)) != null) {
            if (old.isSaved()) continue;
            this.panic(new MVStoreException(3, "Last block " + old + " not stored, possibly due to out-of-memory"));
        }
        Chunk c = new Chunk(newChunkId);
        c.layoutRootPageInfo = Long.MAX_VALUE;
        c.chunkMapRootPageInfo = Long.MAX_VALUE;
        c.block = Long.MAX_VALUE;
        c.blockCount = Integer.MAX_VALUE;
        c.time = time;
        c.version = version;
        c.next = Long.MAX_VALUE;
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putChunkMetadata(int chunkId, Chunk lastChunk) {
        byte[] result;
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.heapBuffer(4096);
        try {
            lastChunk.writeMetadata(buf);
            result = ByteBufUtil.getBytes((ByteBuf)buf);
        }
        finally {
            buf.release();
        }
        this.chunkIdToChunkMetadata.put(chunkId, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeToBuffer(ByteBuf buf, List<Page<?, ?>> changed, Chunk chunk, long reservedLow, LongSupplier reservedHighSupplier) {
        buf.writerIndex(buf.writerIndex() + 76);
        long version = chunk.version;
        LongArrayList toc = new LongArrayList();
        for (Page<?, ?> p : changed) {
            int mapId = p.getMapId();
            if (p.getTotalCount() == 0L) {
                this.layout.remove(mapId);
                continue;
            }
            p.writeUnsavedRecursive(chunk, buf, toc);
            this.layout.put(mapId, p.getPosition());
        }
        this.acceptChunkOccupancyChanges(chunk.time, version);
        RootReference<Integer, byte[]> chunkMapRootReference = this.chunkIdToChunkMetadata.setWriteVersion(version);
        assert (chunkMapRootReference != null);
        assert (chunkMapRootReference.version == version) : chunkMapRootReference.version + " != " + version;
        RootReference<Integer, Long> layoutRootReference = this.layout.setWriteVersion(version);
        assert (layoutRootReference != null);
        assert (layoutRootReference.version == version) : layoutRootReference.version + " != " + version;
        this.metaChanged = false;
        this.acceptChunkOccupancyChanges(chunk.time, version);
        this.onVersionChange(version);
        Page chunkMapRoot = chunkMapRootReference.root;
        if (this.chunkIdToChunkMetadata.hasChangesSince(version - 2L) && (!chunkMapRoot.isSaved() || chunkMapRoot.isLeaf())) {
            chunkMapRoot.writeUnsavedRecursive(chunk, buf, toc);
            changed.add(chunkMapRoot);
        }
        chunk.chunkMapRootPageInfo = chunkMapRoot.getPosition();
        Page layoutRoot = layoutRootReference.root;
        layoutRoot.writeUnsavedRecursive(chunk, buf, toc);
        chunk.layoutRootPageInfo = layoutRoot.getPosition();
        changed.add(layoutRoot);
        chunk.mapId = this.lastMapId.get();
        this.writeToC(buf, chunk, toc);
        int chunkLength = buf.writerIndex();
        int length = DataUtil.roundUpInt(chunkLength + 24, 4096);
        this.saveChunkLock.lock();
        try {
            long reservedHigh = reservedHighSupplier.getAsLong();
            long filePosition = this.fileStore.allocate(length, reservedLow, reservedHigh);
            chunk.blockCount = length / 4096;
            chunk.block = filePosition / 4096L;
            if (ASSERT_MODE) assert (this.validateFileLength(chunk));
            chunk.next = reservedLow > 0L || reservedHigh == reservedLow ? this.fileStore.predictAllocation(chunk.blockCount, 0L, 0L) : 0L;
            buf.writerIndex(0);
            chunk.writeHeader(buf);
            buf.ensureWritable(length);
            buf.writerIndex(length - 24);
            chunk.writeFooter(buf);
        }
        finally {
            this.saveChunkLock.unlock();
        }
    }

    private void writeToC(ByteBuf buf, Chunk chunk, LongArrayList toc) {
        chunk.tocPos = buf.writerIndex();
        long[] ids = toc.elements();
        int size = toc.size();
        if (size == 0) {
            return;
        }
        int length = size * 8;
        buf.ensureWritable(length);
        DataUtil.writeLongArray(ids, buf, size);
        for (int i = 0; i < size; ++i) {
            if (DataUtil.isLeafPage(ids[i])) {
                ++this.leafCount;
                continue;
            }
            ++this.nonLeafCount;
        }
        this.chunksToC.put((Object)chunk.id, (Object)toc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBuffer(Chunk chunk, ByteBuf buf, Collection<Page<?, ?>> changed) {
        this.saveChunkLock.lock();
        boolean isBufReleased = false;
        try {
            buf.readerIndex(0);
            long filePosition = chunk.block * 4096L;
            this.fileStore.writeFully(buf, filePosition);
            boolean storeAtEndOfFile = filePosition + (long)buf.writerIndex() >= this.fileStore.size();
            boolean writeStoreHeader = this.isWriteStoreHeader(chunk, storeAtEndOfFile);
            this.lastChunk = chunk;
            if (writeStoreHeader) {
                this.writeStoreHeader(buf);
            }
            isBufReleased = true;
            buf.release();
            if (!storeAtEndOfFile) {
                this.shrinkFileIfPossible(1);
            }
        }
        catch (MVStoreException e) {
            this.panic(e);
        }
        catch (Throwable e) {
            this.panic(new MVStoreException(3, e));
        }
        finally {
            try {
                this.saveChunkLock.unlock();
            }
            finally {
                if (!isBufReleased) {
                    buf.release();
                }
            }
        }
        for (Page<?, ?> p : changed) {
            p.releaseSavedPages();
        }
    }

    private boolean isWriteStoreHeader(Chunk c, boolean storeAtEndOfFile) {
        boolean writeStoreHeader = false;
        if (!storeAtEndOfFile) {
            Chunk lastChunk = this.lastChunk;
            if (lastChunk == null) {
                writeStoreHeader = true;
            } else if (lastChunk.next != c.block) {
                writeStoreHeader = true;
            } else if (lastChunk.version - this.storeHeader.lastChunkVersion > 20L) {
                writeStoreHeader = true;
            } else {
                for (int chunkId = this.storeHeader.lastChunkId; !writeStoreHeader && chunkId <= lastChunk.id; ++chunkId) {
                    writeStoreHeader = !this.chunks.containsKey(chunkId);
                }
            }
        }
        if (this.storeHeader.cleanShutdown) {
            writeStoreHeader = true;
        }
        return writeStoreHeader;
    }

    private static boolean canOverwriteChunk(Chunk c, long oldestVersionToKeep) {
        return !c.isLive() && c.unusedAtVersion < oldestVersionToKeep;
    }

    private boolean isSeasonedChunk(Chunk chunk, long time) {
        return this.retentionTime < 0 || chunk.time + (long)this.retentionTime <= time;
    }

    private long getTimeSinceCreation() {
        return Math.max(0L, this.getTimeAbsolute() - this.storeHeader.creationTime);
    }

    private long getTimeAbsolute() {
        long now = System.currentTimeMillis();
        if (this.lastTimeAbsolute != 0L && now < this.lastTimeAbsolute) {
            now = this.lastTimeAbsolute;
        } else {
            this.lastTimeAbsolute = now;
        }
        return now;
    }

    private void acceptChunkOccupancyChanges(long time, long version) {
        assert (this.serializationLock.isHeldByCurrentThread());
        if (this.lastChunk == null) {
            return;
        }
        HashSet<Chunk> modifiedChunks = null;
        ByteBuf buf = null;
        try {
            while (true) {
                RemovedPageInfo rpi;
                if ((rpi = this.removedPages.peek()) != null && rpi.version < version) {
                    rpi = this.removedPages.poll();
                    assert (rpi != null);
                    assert (rpi.version < version) : rpi + " < " + version;
                    int chunkId = rpi.getPageChunkId();
                    Chunk chunk = this.chunks.get(chunkId);
                    assert (!this.isOpen() || chunk != null) : chunkId;
                    if (chunk == null) continue;
                    if (modifiedChunks == null) {
                        modifiedChunks = new HashSet<Chunk>();
                    }
                    modifiedChunks.add(chunk);
                    if (!chunk.accountForRemovedPage(rpi.getPageNo(), rpi.getPageLength(), rpi.isPinned(), time, rpi.version)) continue;
                    this.deadChunks.offer(chunk);
                    continue;
                }
                if (modifiedChunks == null || modifiedChunks.isEmpty()) {
                    return;
                }
                if (buf == null) {
                    buf = PooledByteBufAllocator.DEFAULT.heapBuffer(4096);
                }
                for (Chunk chunk : modifiedChunks) {
                    buf.clear();
                    chunk.writeMetadata(buf);
                    this.chunkIdToChunkMetadata.put(chunk.id, ByteBufUtil.getBytes((ByteBuf)buf));
                }
                modifiedChunks.clear();
            }
        }
        finally {
            if (buf != null) {
                buf.release();
            }
        }
    }

    private void shrinkFileIfPossible(int minPercent) {
        long fileSize;
        assert (this.saveChunkLock.isHeldByCurrentThread());
        if (this.fileStore.isReadOnly()) {
            return;
        }
        long end = this.getFileLengthInUse();
        if (end >= (fileSize = this.fileStore.size())) {
            return;
        }
        if (minPercent > 0 && fileSize - end < 4096L) {
            return;
        }
        int savedPercent = (int)(100L - end * 100L / fileSize);
        if (savedPercent < minPercent) {
            return;
        }
        if (this.isOpenOrStopping()) {
            this.sync();
        }
        this.fileStore.truncate(end);
    }

    private long getFileLengthInUse() {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        long result = this.fileStore.getFileLengthInUse();
        assert (result == this.measureFileLengthInUse()) : result + " != " + this.measureFileLengthInUse();
        return result;
    }

    private long getAfterLastBlock() {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        return this.fileStore.getAfterLastBlock();
    }

    private long measureFileLengthInUse() {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        long size = 2L;
        for (Chunk c : this.chunks.values()) {
            if (!c.isSaved()) continue;
            size = Math.max(size, c.block + (long)c.blockCount);
        }
        return size * 4096L;
    }

    public boolean hasUnsavedChanges() {
        if (this.metaChanged) {
            return true;
        }
        long lastStoredVersion = this.currentVersion - 1L;
        for (MVMap<?, ?> m : this.maps.values()) {
            if (m.isClosed() || !m.hasChangesSince(lastStoredVersion)) continue;
            return true;
        }
        return this.layout.hasChangesSince(lastStoredVersion) && lastStoredVersion > -1L;
    }

    private Chunk readChunkHeader(long blockNumber, ByteBuf buf) {
        long p = blockNumber * 4096L;
        this.fileStore.readFully(buf, p, 76);
        return Chunk.readChunkHeader(buf, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chunk readChunkHeaderOptionally(long blockNumber) {
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.ioBuffer(76);
        try {
            Chunk chunk = this.readChunkHeader(blockNumber, buf);
            Chunk chunk2 = chunk.block == blockNumber ? chunk : null;
            return chunk2;
        }
        catch (Exception ignore) {
            Chunk chunk = null;
            return chunk;
        }
        finally {
            buf.release();
        }
    }

    private Chunk readChunkHeaderOptionally(long block, int expectedId) {
        Chunk chunk = this.readChunkHeaderOptionally(block);
        return chunk == null || chunk.id != expectedId ? null : chunk;
    }

    public void compactMoveChunks() {
        this.compactMoveChunks(100, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compactMoveChunks(int targetFillRate, long moveSize) {
        boolean result = false;
        this.storeLock.lock();
        try {
            this.checkOpen();
            if (this.serializationExecutor != null) {
                this.serializationExecutor.waitAllTasksExecuted(10L, TimeUnit.MINUTES);
            }
            this.serializationLock.lock();
            try {
                this.saveChunkLock.lock();
                try {
                    if (this.lastChunk != null && this.reuseSpace && this.getFillRate() <= targetFillRate) {
                        result = this.compactMoveChunks(moveSize);
                    }
                }
                finally {
                    this.saveChunkLock.unlock();
                }
            }
            finally {
                this.serializationLock.unlock();
            }
        }
        catch (MVStoreException e) {
            this.panic(e);
        }
        catch (Throwable e) {
            this.panic(new MVStoreException(3, e));
        }
        finally {
            this.unlockAndCheckPanicCondition();
        }
        return result;
    }

    private boolean compactMoveChunks(long moveSize) {
        assert (this.storeLock.isHeldByCurrentThread());
        this.dropUnusedChunks();
        long start = this.fileStore.getFirstFree() / 4096L;
        int freeBlockCount = this.fileStore.freeSpace.getFreeBlockCount();
        if (freeBlockCount == 0) {
            return false;
        }
        List<Chunk> chunksToMove = this.findChunksToMove(start, Math.min(moveSize / 4096L, (long)freeBlockCount));
        if (chunksToMove == null) {
            return false;
        }
        this.compactMoveChunks(chunksToMove);
        return true;
    }

    @Nullable
    private List<Chunk> findChunksToMove(long startBlock, long maxBlocksToMove) {
        if (maxBlocksToMove <= 0L) {
            return null;
        }
        PriorityQueue<Chunk> queue = new PriorityQueue<Chunk>(this.chunks.size() / 2 + 1, (o1, o2) -> {
            int res = Integer.compare(o2.collectPriority, o1.collectPriority);
            if (res != 0) {
                return res;
            }
            return Long.signum(o2.block - o1.block);
        });
        long size = 0L;
        for (Chunk chunk : this.chunks.values()) {
            Chunk removed;
            if (!chunk.isSaved() || chunk.block <= startBlock) continue;
            chunk.collectPriority = this.getMovePriority(chunk);
            queue.offer(chunk);
            size += (long)chunk.blockCount;
            while (size > maxBlocksToMove && (removed = (Chunk)queue.poll()) != null) {
                size -= (long)removed.blockCount;
            }
        }
        if (queue.isEmpty()) {
            return null;
        }
        ArrayList<Chunk> list = new ArrayList<Chunk>(queue);
        list.sort(Chunk.PositionComparator.INSTANCE);
        return list;
    }

    private int getMovePriority(Chunk chunk) {
        return this.fileStore.getMovePriority((int)chunk.block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactMoveChunks(@NotNull List<Chunk> move) {
        if (move == null) {
            MVStore.$$$reportNull$$$0(12);
        }
        assert (this.storeLock.isHeldByCurrentThread());
        assert (this.serializationLock.isHeldByCurrentThread());
        assert (this.saveChunkLock.isHeldByCurrentThread());
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.ioBuffer(8192, 8192);
        try {
            this.writeStoreHeader(buf);
            this.sync();
            long leftmostBlock = move.get((int)0).block;
            long originalBlockCount = this.getAfterLastBlock();
            for (Chunk chunk : move) {
                this.moveChunk(chunk, leftmostBlock, originalBlockCount, buf);
            }
            this.store(leftmostBlock, originalBlockCount);
            this.sync();
            Chunk chunkToMove = this.lastChunk;
            assert (chunkToMove != null);
            long postEvacuationBlockCount = this.getAfterLastBlock();
            boolean chunkToMoveIsAlreadyInside = chunkToMove.block < leftmostBlock;
            boolean movedToEOF = !chunkToMoveIsAlreadyInside;
            for (Chunk c : move) {
                if (c.block < originalBlockCount || !this.moveChunk(c, originalBlockCount, postEvacuationBlockCount, buf)) continue;
                assert (c.block < originalBlockCount);
                movedToEOF = true;
            }
            assert (postEvacuationBlockCount >= this.getAfterLastBlock());
            if (movedToEOF) {
                boolean moved = this.moveChunkInside(chunkToMove, originalBlockCount, buf);
                this.store(originalBlockCount, postEvacuationBlockCount);
                this.sync();
                long lastBoundary = moved || chunkToMoveIsAlreadyInside ? postEvacuationBlockCount : chunkToMove.block;
                boolean bl = moved = !moved && this.moveChunkInside(chunkToMove, lastBoundary, buf);
                if (this.moveChunkInside(this.lastChunk, lastBoundary, buf) || moved) {
                    this.store(lastBoundary, -1L);
                }
            }
        }
        finally {
            buf.release();
        }
        this.shrinkFileIfPossible(0);
        this.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(long reservedLow, long reservedHigh) {
        this.saveChunkLock.unlock();
        try {
            this.serializationLock.unlock();
            try {
                this.storeNow(true, reservedLow, () -> reservedHigh);
            }
            finally {
                this.serializationLock.lock();
            }
        }
        finally {
            this.saveChunkLock.lock();
        }
    }

    private boolean moveChunkInside(Chunk chunkToMove, long boundary, ByteBuf chunkBuffer) {
        boolean res;
        boolean bl = res = chunkToMove.block >= boundary && this.fileStore.predictAllocation(chunkToMove.blockCount, boundary, -1L) < boundary && this.moveChunk(chunkToMove, boundary, -1L, chunkBuffer);
        assert (!res || chunkToMove.block + (long)chunkToMove.blockCount <= boundary);
        return res;
    }

    private boolean moveChunk(Chunk chunk, long reservedAreaLow, long reservedAreaHigh, ByteBuf chunkBuffer) {
        if (!this.chunks.containsKey(chunk.id)) {
            return false;
        }
        long start = chunk.block * 4096L;
        int length = chunk.blockCount * 4096;
        long newPosition = this.fileStore.allocate(length, reservedAreaLow, reservedAreaHigh);
        this.fileStore.copy(start, newPosition, length);
        chunkBuffer.clear();
        this.fileStore.readFully(chunkBuffer, start, 76);
        Chunk chunkFromFile = Chunk.readChunkHeader(chunkBuffer, start);
        long block = newPosition / 4096L;
        assert (reservedAreaHigh > 0L || block <= chunk.block) : block + " " + chunk;
        chunkFromFile.block = block;
        chunkFromFile.next = 0L;
        chunkBuffer.clear();
        chunkFromFile.writeHeader(chunkBuffer);
        this.fileStore.writeFully(chunkBuffer, newPosition);
        chunkBuffer.clear();
        chunkFromFile.writeFooter(chunkBuffer);
        this.fileStore.writeFully(chunkBuffer, newPosition + (long)length - 24L);
        this.fileStore.free(start, length);
        chunk.block = block;
        chunk.next = 0L;
        this.putChunkMetadata(chunk.id, chunk);
        return true;
    }

    public void sync() {
        this.checkOpen();
        FileStore f = this.fileStore;
        if (f != null) {
            f.sync();
        }
    }

    public void compactFile(int maxCompactTime) {
        this.setRetentionTime(0);
        long stopAt = System.nanoTime() + (long)maxCompactTime * 1000000L;
        while (this.compact(95, 0x1000000)) {
            this.sync();
            this.compactMoveChunks(95, 0x1000000L);
            if (System.nanoTime() - stopAt <= 0L) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compact(int targetFillRate, int write) {
        block7: {
            if (!this.reuseSpace || this.lastChunk == null) {
                return false;
            }
            this.checkOpen();
            if (targetFillRate > 0 && this.getChunksFillRate() < targetFillRate) {
                if (!this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) break block7;
                try {
                    boolean bl = this.rewriteChunks(write, 100);
                    this.storeLock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        this.storeLock.unlock();
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rewriteChunks(int writeLimit, int targetFillRate) {
        this.serializationLock.lock();
        try {
            TxCounter txCounter = this.registerVersionUsage();
            try {
                this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.currentVersion);
                Queue<Chunk> old = this.findOldChunks(writeLimit, targetFillRate);
                int oldSize = old.size();
                if (oldSize != 0) {
                    IntOpenHashSet idSet = new IntOpenHashSet(oldSize);
                    for (Chunk c : old) {
                        idSet.add(c.id);
                    }
                    boolean bl = this.compactRewrite((IntSet)idSet) > 0;
                    return bl;
                }
            }
            finally {
                this.deregisterVersionUsage(txCounter);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public int getChunksFillRate() {
        return this.getChunksFillRate(true);
    }

    public int getRewritableChunksFillRate() {
        return this.getChunksFillRate(false);
    }

    private int getChunksFillRate(boolean all) {
        long maxLengthSum = 1L;
        long maxLengthLiveSum = 1L;
        long time = this.getTimeSinceCreation();
        for (Chunk c : this.chunks.values()) {
            if (!all && !this.isRewritable(c, time)) continue;
            assert (c.maxLen >= 0L);
            maxLengthSum += c.maxLen;
            maxLengthLiveSum += c.maxLenLive;
        }
        return (int)(100L * maxLengthLiveSum / maxLengthSum);
    }

    public int getChunkCount() {
        return this.chunks.size();
    }

    public int getPageCount() {
        int count = 0;
        for (Chunk chunk : this.chunks.values()) {
            count += chunk.pageCount;
        }
        return count;
    }

    public int getLivePageCount() {
        int count = 0;
        for (Chunk chunk : this.chunks.values()) {
            count += chunk.getLivePageCount();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getProjectedFillRate(int thresholdChunkFillRate) {
        this.saveChunkLock.lock();
        try {
            int vacatedBlocks = 0;
            long maxLengthSum = 1L;
            long maxLengthLiveSum = 1L;
            long time = this.getTimeSinceCreation();
            for (Chunk c : this.chunks.values()) {
                assert (c.maxLen >= 0L);
                if (!this.isRewritable(c, time) || c.getFillRate() > thresholdChunkFillRate) continue;
                assert (c.maxLen >= c.maxLenLive);
                vacatedBlocks += c.blockCount;
                maxLengthSum += c.maxLen;
                maxLengthLiveSum += c.maxLenLive;
            }
            int additionalBlocks = (int)((long)vacatedBlocks * maxLengthLiveSum / maxLengthSum);
            int n = this.fileStore.getProjectedFillRate(vacatedBlocks - additionalBlocks);
            return n;
        }
        finally {
            this.saveChunkLock.unlock();
        }
    }

    public int getFillRate() {
        this.saveChunkLock.lock();
        try {
            int n = this.fileStore.getFillRate();
            return n;
        }
        finally {
            this.saveChunkLock.unlock();
        }
    }

    @NotNull
    private Queue<Chunk> findOldChunks(int writeLimit, int targetFillRate) {
        assert (this.lastChunk != null);
        long time = this.getTimeSinceCreation();
        PriorityQueue<Chunk> queue = new PriorityQueue<Chunk>(this.chunks.size() / 4 + 1, (o1, o2) -> {
            int comp = Integer.compare(o2.collectPriority, o1.collectPriority);
            if (comp == 0) {
                comp = Long.compare(o2.maxLenLive, o1.maxLenLive);
            }
            return comp;
        });
        long totalSize = 0L;
        long latestVersion = this.lastChunk.version + 1L;
        for (Chunk chunk : this.chunks.values()) {
            Chunk removed;
            int fillRate = chunk.getFillRate();
            if (!this.isRewritable(chunk, time) || fillRate > targetFillRate) continue;
            long age = Math.max(1L, latestVersion - chunk.version);
            chunk.collectPriority = (int)((long)(fillRate * 1000) / age);
            totalSize += chunk.maxLenLive;
            queue.offer(chunk);
            while (totalSize > (long)writeLimit && (removed = queue.poll()) != null) {
                totalSize -= removed.maxLenLive;
            }
        }
        PriorityQueue<Chunk> priorityQueue = queue;
        if (priorityQueue == null) {
            MVStore.$$$reportNull$$$0(13);
        }
        return priorityQueue;
    }

    private boolean isRewritable(Chunk chunk, long time) {
        return chunk.isRewritable() && this.isSeasonedChunk(chunk, time);
    }

    private int compactRewrite(IntSet set) {
        assert (this.storeLock.isHeldByCurrentThread());
        assert (this.currentStoreVersion < 0L);
        this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.currentVersion);
        int rewrittenPageCount = this.rewriteChunks(set, false);
        this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.currentVersion);
        return rewrittenPageCount += this.rewriteChunks(set, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rewriteChunks(IntSet set, boolean secondPass) {
        int rewrittenPageCount = 0;
        IntIterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int chunkId = iterator.nextInt();
            Chunk chunk = this.chunks.get(chunkId);
            LongArrayList toc = this.getToC(chunk);
            for (int pageNo = 0; pageNo < chunk.pageCount && chunk.isLivePage(pageNo); ++pageNo) {
                long tocElement = toc.getLong(pageNo);
                int mapId = DataUtil.getPageMapId(tocElement);
                MVMap<Object, Object> map2 = null;
                if (mapId < 5) {
                    for (MVMap<?, ?> metaMap : this.metaMaps) {
                        if (mapId != metaMap.getId()) continue;
                        map2 = metaMap;
                        break;
                    }
                }
                if (map2 == null) {
                    map2 = this.getMap(mapId);
                }
                if (map2 == null || map2.isClosed()) continue;
                assert (!map2.isSingleWriter());
                if (!secondPass && !DataUtil.isLeafPage(tocElement)) continue;
                long pagePos = DataUtil.getPageInfo(chunkId, tocElement);
                this.serializationLock.unlock();
                try {
                    if (!map2.rewritePage(pagePos)) continue;
                    ++rewrittenPageCount;
                    if (map2 != this.mapNameToMetadata) continue;
                    this.markMetaChanged();
                    continue;
                }
                finally {
                    this.serializationLock.lock();
                }
            }
        }
        return rewrittenPageCount;
    }

    <K, V> Page<K, V> readPage(MVMap<K, V> map2, long pageInfo) {
        try {
            if (!DataUtil.isPageSaved(pageInfo)) {
                throw new MVStoreException(6, "Page is not saved yet");
            }
            Cache<Long, Page<?, ?>> cache = this.getPageCache(DataUtil.isLeafPage(pageInfo));
            Chunk chunk = this.getChunk(DataUtil.getPageChunkId(pageInfo));
            if (cache == null) {
                return this.doReadPage(map2, pageInfo, chunk);
            }
            return (Page)cache.get((Object)pageInfo, info -> this.doReadPage(map2, (long)info, chunk));
        }
        catch (MVStoreException e) {
            if (this.config.recoveryMode) {
                return map2.createEmptyLeaf();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    private <K, V> Page<K, V> doReadPage(@NotNull MVMap<K, V> map2, long pageInfo, @NotNull Chunk chunk) {
        Page page;
        void chunk2;
        if (map2 == null) {
            MVStore.$$$reportNull$$$0(14);
        }
        if (chunk == null) {
            MVStore.$$$reportNull$$$0(15);
        }
        int pageOffset = DataUtil.getPageOffset(pageInfo);
        try {
            Page page2;
            ByteBuf buf = chunk2.readBufferForPage(this.fileStore, pageOffset, pageInfo);
            try {
                page2 = DataUtil.isLeafPage(pageInfo) ? new LeafPage<K, V>(map2, buf, pageInfo, chunk2.id) : new NonLeafPage<K, V>(map2, buf, pageInfo, chunk2.id);
            }
            finally {
                buf.release();
            }
            assert (page2.pageNo >= 0);
            page = page2;
        }
        catch (MVStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MVStoreException(6, "Unable to read the page (info=" + pageInfo + ", chunk=" + chunk2.id + ", offset=" + pageOffset + ")", e);
        }
        if (page == null) {
            MVStore.$$$reportNull$$$0(16);
        }
        return page;
    }

    @NotNull
    private LongArrayList getToC(Chunk chunk) {
        assert (chunk.tocPos != 0);
        LongArrayList toc = (LongArrayList)this.chunksToC.get((Object)chunk.id, __ -> chunk.readToC(this.fileStore));
        assert (toc != null);
        assert (toc.size() == chunk.pageCount) : toc.size() + " != " + chunk.pageCount;
        LongArrayList longArrayList = toc;
        if (longArrayList == null) {
            MVStore.$$$reportNull$$$0(17);
        }
        return longArrayList;
    }

    void accountForRemovedPage(long pos, long version, boolean pinned, int pageNo) {
        assert (DataUtil.isPageSaved(pos));
        if (pageNo < 0) {
            pageNo = this.calculatePageNo(pos);
        }
        this.removedPages.add(new RemovedPageInfo(pos, pinned, version, pageNo));
    }

    private int calculatePageNo(long pageInfo) {
        int pageNo = -1;
        Chunk chunk = this.getChunk(DataUtil.getPageChunkId(pageInfo));
        LongArrayList toC = this.getToC(chunk);
        long[] longs = toC.elements();
        int offset = DataUtil.getPageOffset(pageInfo);
        int low = 0;
        int high = toC.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = DataUtil.getPageOffset(longs[mid]);
            if (midVal < (long)offset) {
                low = mid + 1;
                continue;
            }
            if (midVal > (long)offset) {
                high = mid - 1;
                continue;
            }
            pageNo = mid;
            break;
        }
        return pageNo;
    }

    @NotNull
    LZ4Compressor getCompressor() {
        LZ4Compressor result = this.compressor;
        if (result != null) {
            LZ4Compressor lZ4Compressor = result;
            if (lZ4Compressor == null) {
                MVStore.$$$reportNull$$$0(18);
            }
            return lZ4Compressor;
        }
        result = this.config.compress == 1 ? LZ4Factory.fastestJavaInstance().fastCompressor() : LZ4Factory.fastestJavaInstance().highCompressor(Math.max(9, this.config.compress));
        this.compressor = result;
        LZ4Compressor lZ4Compressor = result;
        if (lZ4Compressor == null) {
            MVStore.$$$reportNull$$$0(19);
        }
        return lZ4Compressor;
    }

    @NotNull
    LZ4FastDecompressor getDecompressor() {
        LZ4FastDecompressor result = this.decompressor;
        if (result == null) {
            this.decompressor = result = LZ4Factory.fastestJavaInstance().fastDecompressor();
        }
        LZ4FastDecompressor lZ4FastDecompressor = result;
        if (lZ4FastDecompressor == null) {
            MVStore.$$$reportNull$$$0(20);
        }
        return lZ4FastDecompressor;
    }

    int getCompressionLevel() {
        return this.config.compress;
    }

    public int getKeysPerPage() {
        return this.config.keysPerPage;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean reuseSpace) {
        this.reuseSpace = reuseSpace;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int ms) {
        this.retentionTime = ms;
    }

    long getOldestVersionToKeep() {
        long storeVersion;
        long v = this.oldestVersionToKeep.get();
        v = Math.max(v - (long)this.config.versionsToKeep, -1L);
        if (this.fileStore != null && (storeVersion = this.lastChunkVersion() - 1L) != -1L && storeVersion < v) {
            v = storeVersion;
        }
        return v;
    }

    private void setOldestVersionToKeep(long oldestVersionToKeep) {
        long current;
        boolean success;
        while (!(success = oldestVersionToKeep <= (current = this.oldestVersionToKeep.get()) || this.oldestVersionToKeep.compareAndSet(current, oldestVersionToKeep))) {
        }
    }

    private long lastChunkVersion() {
        Chunk chunk = this.lastChunk;
        return chunk == null ? 0L : chunk.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isKnownVersion(long version) {
        if (version > this.currentVersion || version < 0L) {
            return false;
        }
        if (version == this.currentVersion || this.chunks.isEmpty()) {
            return true;
        }
        Chunk newestChunkForVersion = null;
        for (Chunk chunkCandidate : this.chunks.values()) {
            if (chunkCandidate.version > version || newestChunkForVersion != null && chunkCandidate.id <= newestChunkForVersion.id) continue;
            newestChunkForVersion = chunkCandidate;
        }
        if (newestChunkForVersion == null) {
            return false;
        }
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.ioBuffer(4096, 4096);
        try {
            newestChunkForVersion = this.readChunkHeader(newestChunkForVersion.block, buf);
            MVMap<Integer, byte[]> oldChunkMap = this.chunkIdToChunkMetadata.openReadOnly(newestChunkForVersion.chunkMapRootPageInfo, version);
            Iterator<Object> it = oldChunkMap.keyIterator(null);
            while (it.hasNext()) {
                Integer chunkKey = it.next();
                if (this.chunkIdToChunkMetadata.containsKey(chunkKey)) continue;
                byte[] metadata = oldChunkMap.get(chunkKey);
                Chunk chunk = Chunk.readMetadata(chunkKey, Unpooled.wrappedBuffer((byte[])metadata));
                buf.clear();
                Chunk test = this.readChunkHeaderAndFooter(chunk.block, chunk.id, buf);
                if (test != null) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (MVStoreException ignore) {
            boolean bl = false;
            return bl;
        }
        finally {
            buf.release();
        }
        return true;
    }

    public void registerUnsavedMemory(int memory) {
        this.unsavedMemory += memory;
        if (this.config.autoCommitBufferSize > 0 && this.unsavedMemory > this.config.autoCommitBufferSize) {
            this.saveNeeded = true;
        }
    }

    boolean isSaveNeeded() {
        return this.saveNeeded;
    }

    void beforeWrite(MVMap<?, ?> map2) {
        if (!this.saveNeeded || this.fileStore == null || !this.isOpenOrStopping()) {
            return;
        }
        if (map2 == this.chunkIdToChunkMetadata) {
            return;
        }
        if (!this.storeLock.isHeldByCurrentThread() && map2.getRoot().isLockedByCurrentThread()) {
            return;
        }
        if (this.serializationExecutor != null && !this.serializationExecutor.isEmpty()) {
            return;
        }
        if (this.config.autoCommitBufferSize > 0 && this.needStore()) {
            this.saveNeeded = false;
            if (!map2.isSingleWriter() && this.requireStore()) {
                if (this.serializationExecutor == null) {
                    this.commit(MVStore::requireStore);
                } else {
                    this.tryCommit(MVStore::needStore);
                }
            } else {
                this.tryCommit(MVStore::needStore);
            }
        }
    }

    private boolean requireStore() {
        return 3 * this.unsavedMemory > 4 * this.config.autoCommitBufferSize;
    }

    private boolean needStore() {
        return this.unsavedMemory > this.config.autoCommitBufferSize;
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTo(long version) {
        this.storeLock.lock();
        try {
            int id;
            block32: {
                TxCounter txCounter;
                this.checkOpen();
                if (version == 0L) {
                    for (MVMap<?, ?> map2 : this.metaMaps) {
                        map2.setInitialRoot(map2.createEmptyLeaf(), -1L);
                    }
                    this.deadChunks.clear();
                    this.removedPages.clear();
                    this.chunks.clear();
                    this.clearCaches();
                    if (this.fileStore != null) {
                        this.saveChunkLock.lock();
                        try {
                            this.fileStore.clear();
                        }
                        finally {
                            this.saveChunkLock.unlock();
                        }
                    }
                    this.lastChunk = null;
                    this.versions.clear();
                    this.currentVersion = version;
                    this.setWriteVersion(version);
                    this.metaChanged = false;
                    for (MVMap mVMap : this.maps.values()) {
                        mVMap.close();
                    }
                    return;
                }
                if (!this.isKnownVersion(version)) {
                    throw new IllegalArgumentException("Unknown version " + version);
                }
                while ((txCounter = this.versions.peekLast()) != null && txCounter.version >= version) {
                    this.versions.removeLast();
                }
                this.currentTxCounter = new TxCounter(version);
                for (MVMap<?, ?> map3 : this.metaMaps) {
                    map3.rollbackTo(version);
                }
                this.metaChanged = false;
                IntArrayList intArrayList = new IntArrayList();
                Chunk keep = null;
                this.serializationLock.lock();
                try {
                    for (Chunk c : this.chunks.values()) {
                        if (c.version > version) {
                            intArrayList.add(c.id);
                            continue;
                        }
                        if (keep != null && keep.version >= c.version) continue;
                        keep = c;
                    }
                    if (intArrayList.isEmpty()) break block32;
                    intArrayList.sort(IntComparators.OPPOSITE_COMPARATOR);
                    this.saveChunkLock.lock();
                    ByteBuf buf = PooledByteBufAllocator.DEFAULT.ioBuffer(8192);
                    try {
                        Chunk c;
                        c = intArrayList.iterator();
                        while (c.hasNext()) {
                            id = (Integer)c.next();
                            Chunk c2 = this.chunks.remove(id);
                            if (c2 == null) continue;
                            long start = c2.block * 4096L;
                            int length = c2.blockCount * 4096;
                            this.freeFileSpace(start, length);
                            buf.clear();
                            buf.ensureWritable(length);
                            buf.setZero(0, length);
                            buf.setIndex(0, length);
                            this.write(start, buf);
                            this.sync();
                        }
                        this.lastChunk = keep;
                        this.writeStoreHeader(buf);
                        buf.clear();
                        this.readStoreHeader(buf);
                    }
                    finally {
                        try {
                            this.saveChunkLock.unlock();
                        }
                        finally {
                            buf.release();
                        }
                    }
                }
                finally {
                    this.serializationLock.unlock();
                }
            }
            this.deadChunks.clear();
            this.removedPages.clear();
            this.clearCaches();
            this.currentVersion = version;
            this.onVersionChange(this.currentVersion);
            for (MVMap<?, ?> m : new ArrayList(this.maps.values())) {
                id = m.getId();
                if (m.getCreateVersion() >= version) {
                    m.close();
                    this.maps.remove(id);
                    continue;
                }
                if (m.rollbackRoot(version)) continue;
                m.setRootPageInfo(this.getRootPageInfo(id), version - 1L);
            }
            assert (!this.hasUnsavedChanges());
        }
        finally {
            this.unlockAndCheckPanicCondition();
        }
    }

    private void clearCaches() {
        if (this.nonLeafPageCache != null) {
            this.nonLeafPageCache.invalidateAll();
            this.leafPageCache.invalidateAll();
            this.chunksToC.invalidateAll();
        }
    }

    private long getRootPageInfo(int mapId) {
        Long root = this.layout.get(mapId);
        return root == null ? 0L : root;
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public StoreHeader getStoreHeader() {
        return this.storeHeader;
    }

    private void checkOpen() {
        if (!this.isOpenOrStopping()) {
            throw new MVStoreException(4, "This store is closed", this.panicException);
        }
    }

    public void renameMap(@NotNull MVMap<?, ?> map2, @NotNull CharSequence _newName) {
        if (map2 == null) {
            MVStore.$$$reportNull$$$0(21);
        }
        if (_newName == null) {
            MVStore.$$$reportNull$$$0(22);
        }
        this.checkOpen();
        int id = map2.getId();
        if (id < 5) {
            throw new IllegalArgumentException("Renaming the meta map is not allowed");
        }
        AsciiString asciiName = AsciiString.of((CharSequence)_newName);
        if (this.mapNameToMetadata.containsKey(asciiName)) {
            throw new IllegalArgumentException("A map named " + asciiName + " already exists");
        }
        MapMetadata existingMetadata = this.mapNameToMetadata.putIfAbsent(asciiName, new MapMetadata(id, map2.getCreateVersion()));
        if (existingMetadata != null) {
            if (existingMetadata.id != id) {
                throw new IllegalArgumentException("A map named " + asciiName + " already exists");
            }
            HashSet<Object> keysToRemove = null;
            Cursor<Object, MapMetadata> cursor = this.mapNameToMetadata.cursor(null);
            while (cursor.hasNext()) {
                AsciiString oldName = cursor.next();
                MapMetadata mapMetadata = cursor.getValue();
                if (mapMetadata.id != id || oldName.equals((Object)asciiName)) continue;
                if (keysToRemove == null) {
                    keysToRemove = new HashSet<Object>();
                }
                keysToRemove.add(oldName);
            }
            if (keysToRemove != null) {
                for (AsciiString asciiString : keysToRemove) {
                    this.mapNameToMetadata.remove(asciiString);
                    this.markMetaChanged();
                }
            }
            return;
        }
        Cursor<Object, MapMetadata> cursor = this.mapNameToMetadata.cursor(null);
        while (cursor.hasNext()) {
            AsciiString oldName = cursor.next();
            MapMetadata metadata = cursor.getValue();
            if (metadata.id != id) continue;
            if (oldName.equals((Object)asciiName)) break;
            this.mapNameToMetadata.remove(oldName);
            break;
        }
        this.markMetaChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMap(MVMap<?, ?> map2) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            if (map2.getId() < 5) {
                throw new IllegalArgumentException("Removing the meta map is not allowed");
            }
            RootReference<?, ?> rootReference = map2.clearIt();
            map2.close();
            this.updateCounter += rootReference.updateCounter;
            this.updateAttemptCounter += rootReference.updateAttemptCounter;
            AsciiString name = (AsciiString)this.getMapName(map2.getId());
            if (this.mapNameToMetadata.remove(name) != null) {
                this.markMetaChanged();
            }
        }
        finally {
            this.storeLock.unlock();
        }
    }

    void deregisterMapRoot(int mapId) {
        if (this.layout.remove(mapId) != null) {
            this.markMetaChanged();
        }
    }

    @Nullable
    public CharSequence getMapName(int id) {
        Cursor<Object, MapMetadata> cursor = this.mapNameToMetadata.cursor(null);
        while (cursor.hasNext()) {
            AsciiString name = cursor.next();
            MapMetadata metadata = cursor.getValue();
            if (metadata.id != id) continue;
            return name;
        }
        return null;
    }

    public void triggerAutoSave() {
        this.triggerAutoSave(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerAutoSave(boolean force) {
        block14: {
            try {
                if (!this.isOpenOrStopping() || this.isReadOnly()) {
                    return;
                }
                if (!force && this.getTimeSinceCreation() <= this.lastCommitTime + (long)this.autoCommitDelay) {
                    return;
                }
                this.tryCommit(null);
                int autoCompactFillRate = this.config.autoCompactFillRate;
                if (autoCompactFillRate == 0) {
                    return;
                }
                int fillRate = this.getFillRate();
                if (fillRate >= autoCompactFillRate && this.lastChunk != null) {
                    int chunksFillRate = this.getRewritableChunksFillRate();
                    int n = chunksFillRate = this.isIdle() ? 100 - (100 - chunksFillRate) / 2 : chunksFillRate;
                    if (chunksFillRate < this.getTargetFillRate() && this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                        try {
                            int writeLimit = this.config.autoCommitBufferSize * fillRate / Math.max(chunksFillRate, 1);
                            if (!this.isIdle()) {
                                writeLimit /= 4;
                            }
                            if (this.rewriteChunks(writeLimit, chunksFillRate)) {
                                this.dropUnusedChunks();
                            }
                        }
                        finally {
                            this.storeLock.unlock();
                        }
                    }
                }
                this.autoCompactLastFileOpCount = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
            }
            catch (InterruptedException autoCompactFillRate) {
            }
            catch (Throwable e) {
                this.handleException(e);
                if (this.config.backgroundExceptionHandler != null) break block14;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMaintenance(int targetFillRate) {
        if (targetFillRate <= 0 || this.lastChunk == null || !this.reuseSpace) {
            return;
        }
        try {
            int lastProjectedFillRate = -1;
            for (int cnt = 0; cnt < 5; ++cnt) {
                int fillRate;
                int projectedFillRate = fillRate = this.getFillRate();
                if (fillRate > targetFillRate && ((projectedFillRate = this.getProjectedFillRate(100)) > targetFillRate || projectedFillRate <= lastProjectedFillRate)) break;
                lastProjectedFillRate = projectedFillRate;
                if (!this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) break;
                try {
                    int writeLimit = this.config.autoCommitBufferSize * targetFillRate / Math.max(projectedFillRate, 1);
                    if ((projectedFillRate >= fillRate || this.rewriteChunks(writeLimit, targetFillRate) && this.dropUnusedChunks() != 0 || cnt <= 0) && this.compactMoveChunks(101, writeLimit)) continue;
                    break;
                }
                finally {
                    this.unlockAndCheckPanicCondition();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private int getTargetFillRate() {
        int targetRate = this.config.autoCompactFillRate;
        if (!this.isIdle()) {
            targetRate /= 2;
        }
        return targetRate;
    }

    private boolean isIdle() {
        return this.autoCompactLastFileOpCount == this.fileStore.getWriteCount() + this.fileStore.getReadCount();
    }

    private void handleException(Throwable error) {
        block3: {
            if (this.config.backgroundExceptionHandler != null) {
                try {
                    this.config.backgroundExceptionHandler.accept(error, this);
                }
                catch (Throwable e) {
                    if (error == e) break block3;
                    error.addSuppressed(e);
                }
            }
        }
    }

    private boolean isOpen() {
        return this.state == 0;
    }

    public boolean isClosed() {
        if (this.isOpen()) {
            return false;
        }
        this.storeLock.lock();
        try {
            assert (this.state == 3);
            boolean bl = true;
            return bl;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private boolean isOpenOrStopping() {
        return this.state <= 1;
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitMemory() {
        return this.config.autoCommitBufferSize;
    }

    public int getUnsavedMemory() {
        return this.unsavedMemory;
    }

    void cachePage(Page<?, ?> page) {
        Cache<Long, Page<?, ?>> cache = this.getPageCache(page.isLeaf());
        if (cache != null) {
            cache.put((Object)page.getPosition(), page);
        }
    }

    public CacheStats getCacheStats(boolean nonLeaf) {
        return nonLeaf ? this.nonLeafPageCache.stats() : this.leafPageCache.stats();
    }

    public boolean isReadOnly() {
        return this.fileStore != null && this.fileStore.isReadOnly();
    }

    public int getLeafRatio() {
        return (int)(this.leafCount * 100L / Math.max(1L, this.leafCount + this.nonLeafCount));
    }

    public double getUpdateFailureRatio() {
        long updateCounter = this.updateCounter;
        long updateAttemptCounter = this.updateAttemptCounter;
        for (MVMap<?, ?> map2 : this.metaMaps) {
            RootReference<?, ?> rootReference = map2.getRoot();
            updateCounter += rootReference.updateCounter;
            updateAttemptCounter += rootReference.updateAttemptCounter;
        }
        for (MVMap mVMap : this.maps.values()) {
            RootReference root = mVMap.getRoot();
            updateCounter += root.updateCounter;
            updateAttemptCounter += root.updateAttemptCounter;
        }
        return updateAttemptCounter == 0L ? 0.0 : 1.0 - (double)updateCounter / (double)updateAttemptCounter;
    }

    public TxCounter registerVersionUsage() {
        TxCounter txCounter;
        while ((txCounter = this.currentTxCounter).incrementAndGet() <= 0) {
            assert (txCounter != this.currentTxCounter) : txCounter;
            txCounter.decrementAndGet();
        }
        return txCounter;
    }

    public void deregisterVersionUsage(TxCounter txCounter) {
        if (txCounter != null && txCounter.decrementAndGet() <= 0) {
            if (this.storeLock.isHeldByCurrentThread()) {
                this.dropUnusedVersions();
            } else if (this.storeLock.tryLock()) {
                try {
                    this.dropUnusedVersions();
                }
                finally {
                    this.storeLock.unlock();
                }
            }
        }
    }

    private void onVersionChange(long version) {
        TxCounter txCounter = this.currentTxCounter;
        assert (txCounter.get() >= 0);
        this.versions.add(txCounter);
        this.currentTxCounter = new TxCounter(version);
        txCounter.decrementAndGet();
        this.dropUnusedVersions();
    }

    private void dropUnusedVersions() {
        TxCounter txCounter;
        while ((txCounter = this.versions.peek()) != null && txCounter.get() < 0) {
            this.versions.poll();
        }
        this.setOldestVersionToKeep((txCounter != null ? txCounter : this.currentTxCounter).version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dropUnusedChunks() {
        assert (this.storeLock.isHeldByCurrentThread());
        int count = 0;
        if (this.deadChunks.isEmpty()) {
            return count;
        }
        long oldestVersionToKeep = this.getOldestVersionToKeep();
        long time = this.getTimeSinceCreation();
        this.saveChunkLock.lock();
        try {
            Chunk chunk;
            while ((chunk = this.deadChunks.poll()) != null && (this.isSeasonedChunk(chunk, time) && MVStore.canOverwriteChunk(chunk, oldestVersionToKeep) || !this.deadChunks.offerFirst(chunk))) {
                LongArrayList toc;
                if (this.chunks.remove(chunk.id) == null) continue;
                LongArrayList longArrayList = toc = this.chunksToC == null ? null : (LongArrayList)this.chunksToC.getIfPresent((Object)chunk.id);
                if (toc != null) {
                    this.chunksToC.invalidate((Object)chunk);
                    LongListIterator iterator = toc.iterator();
                    while (iterator.hasNext()) {
                        long tocElement = iterator.nextLong();
                        long pagePos = DataUtil.getPageInfo(chunk.id, tocElement);
                        this.getPageCache(DataUtil.isLeafPage(pagePos)).invalidate((Object)pagePos);
                    }
                }
                this.chunkIdToChunkMetadata.remove(chunk.id);
                if (chunk.isSaved()) {
                    this.freeChunkSpace(chunk);
                }
                ++count;
            }
        }
        finally {
            this.saveChunkLock.unlock();
        }
        return count;
    }

    private Cache<Long, Page<?, ?>> getPageCache(boolean isLeaf) {
        return isLeaf ? this.leafPageCache : this.nonLeafPageCache;
    }

    private void freeChunkSpace(Chunk chunk) {
        long start = chunk.block * 4096L;
        int length = chunk.blockCount * 4096;
        this.freeFileSpace(start, length);
    }

    private void freeFileSpace(long start, int length) {
        this.fileStore.free(start, length);
        if (ASSERT_MODE) assert (this.validateFileLength(start + ":" + length));
    }

    private boolean validateFileLength(Object msg) {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse() + " " + msg.toString();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/mvstore/MVStore";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToMetadata";
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameAsString";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "move";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "openMapNameMap";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/mvstore/MVStore";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "scrubMetaMap";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findOldChunks";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadPage";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getToC";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompressor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecompressor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "scrubLayoutMap";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "openMap";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compactMoveChunks";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doReadPage";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "renameMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        private int nonLeafPageCacheSize = 16;
        private int leafPageCacheSize = 8;
        private boolean recordCacheStats;
        private boolean recoveryMode;
        private int compress = 1;
        private int pageSplitSize = Integer.MAX_VALUE;
        private int keysPerPage = 129;
        private int autoCommitBufferSize = 0x200000;
        private int autoCommitDelay = 1000;
        private int autoCompactFillRate = 90;
        private int versionsToKeep = 0;
        private BiConsumer<Throwable, MVStore> backgroundExceptionHandler;
        private boolean readOnly;

        public Builder versionsToKeep(int count) {
            this.versionsToKeep = count;
            return this;
        }

        public Builder autoCommitDelay(int ms) {
            this.autoCommitDelay = ms;
            return this;
        }

        public Builder autoCommitDisabled() {
            this.autoCommitDelay = 0;
            return this;
        }

        public Builder autoCommitBufferSize(int kb) {
            this.autoCommitBufferSize = kb * 1024;
            return this;
        }

        public Builder autoCompactFillRate(int percent) {
            this.autoCompactFillRate = percent;
            return this;
        }

        public Builder readOnly() {
            this.readOnly = true;
            return this;
        }

        public Builder keysPerPage(int keysPerPage) {
            this.keysPerPage = keysPerPage;
            return this;
        }

        public Builder recoveryMode() {
            this.recoveryMode = true;
            return this;
        }

        public Builder nonLeafPageCacheSize(int sizeInMb) {
            this.nonLeafPageCacheSize = sizeInMb;
            return this;
        }

        public Builder cacheSize(int sizeInMb) {
            this.leafPageCacheSize = sizeInMb;
            return this;
        }

        public Builder recordCacheStats(boolean recordCacheStats) {
            this.recordCacheStats = recordCacheStats;
            return this;
        }

        public Builder compress() {
            this.compress = 1;
            return this;
        }

        public Builder compressionLevel(int level) {
            this.compress = level;
            return this;
        }

        public Builder compressHigh() {
            this.compress = 2;
            return this;
        }

        public Builder pageSplitSize(int pageSplitSize) {
            this.pageSplitSize = pageSplitSize;
            return this;
        }

        public Builder backgroundExceptionHandler(BiConsumer<Throwable, MVStore> exceptionHandler) {
            this.backgroundExceptionHandler = exceptionHandler;
            return this;
        }

        public MVStore open(@NotNull Path file) throws IOException {
            if (file == null) {
                Builder.$$$reportNull$$$0(0);
            }
            return new MVStore(Builder.createFileStore(file, false, this.readOnly ? FileStore.R : FileStore.RW), this);
        }

        public MVStore truncateAndOpen(@NotNull Path file) throws IOException {
            if (file == null) {
                Builder.$$$reportNull$$$0(1);
            }
            assert (!this.readOnly);
            return new MVStore(Builder.createFileStore(file, false, FileStore.RW_TRUNCATE), this);
        }

        public MVStore openOrNewOnIoError(@NotNull Path file, boolean useFileCache, @NotNull Consumer<Exception> errorConsumer) {
            if (file == null) {
                Builder.$$$reportNull$$$0(2);
            }
            if (errorConsumer == null) {
                Builder.$$$reportNull$$$0(3);
            }
            assert (!this.readOnly);
            FileStore fileStore = null;
            try {
                fileStore = Builder.createFileStore(file, useFileCache, FileStore.RW);
                return new MVStore(fileStore, this);
            }
            catch (IOException e) {
                errorConsumer.accept(e);
            }
            catch (MVStoreException e) {
                if (e.getErrorCode() == 7) {
                    throw e;
                }
                if (fileStore != null) {
                    try {
                        fileStore.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                errorConsumer.accept(e);
            }
            return new MVStore(Builder.truncateAndOpen(file, useFileCache), this);
        }

        @NotNull
        private static FileStore truncateAndOpen(@NotNull Path file, boolean useFileCache) {
            FileStore fileStore;
            if (file == null) {
                Builder.$$$reportNull$$$0(4);
            }
            try {
                fileStore = Builder.createFileStore(file, useFileCache, FileStore.RW_TRUNCATE);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            FileStore fileStore2 = fileStore;
            if (fileStore2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return fileStore2;
        }

        @NotNull
        private static FileStore createFileStore(@NotNull Path file, boolean useFileCache, Set<? extends OpenOption> options) throws IOException {
            if (file == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return new FileStore(file, options, useFileCache);
        }

        public String toString() {
            return "Builder(nonLeafPageCacheSize=" + this.nonLeafPageCacheSize + ",leafPageCacheSize=" + this.leafPageCacheSize + ", recoveryMode=" + this.recoveryMode + ", compress=" + this.compress + ", pageSplitSize=" + this.pageSplitSize + ", keysPerPage=" + this.keysPerPage + ", autoCommitBufferSize=" + this.autoCommitBufferSize + ", autoCommitDelay=" + this.autoCommitDelay + ", autoCompactFillRate=" + this.autoCompactFillRate + ", backgroundExceptionHandler=" + this.backgroundExceptionHandler + ", readOnly=" + this.readOnly + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorConsumer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/mvstore/MVStore$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/mvstore/MVStore$Builder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "truncateAndOpen";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "open";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "truncateAndOpen";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "openOrNewOnIoError";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileStore";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class RemovedPageInfo
    implements Comparable<RemovedPageInfo> {
        final long version;
        final long removedPageInfo;

        RemovedPageInfo(long pagePos, boolean pinned, long version, int pageNo) {
            this.removedPageInfo = RemovedPageInfo.createRemovedPageInfo(pagePos, pinned, pageNo);
            this.version = version;
        }

        @Override
        public int compareTo(RemovedPageInfo other) {
            return Long.compare(this.version, other.version);
        }

        int getPageChunkId() {
            return DataUtil.getPageChunkId(this.removedPageInfo);
        }

        int getPageNo() {
            return DataUtil.getPageOffset(this.removedPageInfo);
        }

        int getPageLength() {
            return DataUtil.getPageMaxLength(this.removedPageInfo);
        }

        boolean isPinned() {
            return (this.removedPageInfo & 1L) == 1L;
        }

        private static long createRemovedPageInfo(long pagePos, boolean isPinned, int pageNo) {
            long result = pagePos & 0xFFFFFFC00000003EL | (long)pageNo << 6 & 0xFFFFFFFFL;
            if (isPinned) {
                result |= 1L;
            }
            return result;
        }

        public String toString() {
            return "RemovedPageInfo{version=" + this.version + ", chunk=" + this.getPageChunkId() + ", pageNo=" + this.getPageNo() + ", len=" + this.getPageLength() + (this.isPinned() ? ", pinned" : "") + "}";
        }
    }

    static final class TxCounter {
        public final long version;
        private volatile int counter;
        private static final AtomicIntegerFieldUpdater<TxCounter> counterUpdater = AtomicIntegerFieldUpdater.newUpdater(TxCounter.class, "counter");

        TxCounter(long version) {
            this.version = version;
        }

        int get() {
            return this.counter;
        }

        int incrementAndGet() {
            return counterUpdater.incrementAndGet(this);
        }

        int decrementAndGet() {
            return counterUpdater.decrementAndGet(this);
        }

        public String toString() {
            return "v=" + this.version + " / cnt=" + this.counter;
        }
    }

    public static final class StoreHeader {
        short format = (short)2;
        short formatRead = (short)2;
        long creationTime;
        long lastChunkVersion;
        int lastChunkId;
        long lastBlockNumber;
        int blockSize = 4096;
        boolean cleanShutdown;

        void read(ByteBuf buf) {
            byte firstByte = buf.readByte();
            byte secondByte = buf.readByte();
            assert (firstByte == 109 && secondByte == 118);
            this.format = buf.readUnsignedByte();
            this.formatRead = buf.readUnsignedByte();
            this.creationTime = buf.readLong();
            this.lastChunkVersion = buf.readLong();
            this.lastChunkId = buf.readInt();
            this.lastBlockNumber = buf.readLong();
            this.blockSize = buf.readInt();
            if (this.blockSize == 0) {
                this.blockSize = 4096;
            }
            this.cleanShutdown = buf.readBoolean();
        }

        void write(ByteBuf buf) {
            buf.writeByte(109);
            buf.writeByte(118);
            buf.writeByte((int)this.format);
            buf.writeByte((int)this.formatRead);
            buf.writeLong(this.creationTime);
            buf.writeLong(this.lastChunkVersion);
            buf.writeInt(this.lastChunkId);
            buf.writeLong(this.lastBlockNumber);
            buf.writeInt(this.blockSize);
            buf.writeBoolean(this.cleanShutdown);
        }

        public String toString() {
            return "StoreHeader(format=" + this.format + ", formatRead=" + this.formatRead + ", creationTime=" + this.creationTime + ", lastChunkVersion=" + this.lastChunkVersion + ", lastChunkId=" + this.lastChunkId + ", lastBlockNumber=" + this.lastBlockNumber + ", blockSize=" + this.blockSize + ", cleanShutdown=" + this.cleanShutdown + ")";
        }
    }
}

