/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.startup;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalSystemConfigurable;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerEx;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import com.intellij.openapi.util.Computable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.startup.GradleProjectSettingsUpdater;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmValidationUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J*\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002J:\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u001a\u0010\u0017\u001a\u0016\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater;", "Lcom/intellij/openapi/externalSystem/settings/ExternalSystemSettingsListenerEx;", "()V", "findRegisteredSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "fixupInternalJdk", "", "project", "Lcom/intellij/openapi/project/Project;", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "fixupUnknownSdk", "isInternalSdk", "", "jdkReference", "", "isSdkName", "isUnknownSdk", "sdkName", "notifyGradleJvmChangeInfo", "gradleJvm", "onProjectsLoaded", "manager", "Lcom/intellij/openapi/externalSystem/ExternalSystemManager;", "settings", "", "Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;", "showGradleProjectSettings", "externalProjectPath", "updateGradleJvm", "intellij.gradle.common"})
public final class GradleProjectSettingsUpdater
implements ExternalSystemSettingsListenerEx {
    public void onProjectsLoaded(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> settings2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(manager, (String)"manager");
        Intrinsics.checkNotNullParameter(settings2, (String)"settings");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        if (!(manager instanceof GradleManager)) {
            return;
        }
        for (ExternalProjectSettings externalProjectSettings : settings2) {
            if (!(externalProjectSettings instanceof GradleProjectSettings)) continue;
            this.updateGradleJvm(project, (GradleProjectSettings)externalProjectSettings);
        }
    }

    private final void updateGradleJvm(Project project, GradleProjectSettings projectSettings) {
        block2: {
            String gradleJvm;
            block1: {
                String string = projectSettings.getGradleJvm();
                if (string == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectSettings.gradleJvm ?: return");
                gradleJvm = string;
                if (!this.isInternalSdk(gradleJvm)) break block1;
                this.fixupInternalJdk(project, projectSettings);
                break block2;
            }
            if (!this.isSdkName(gradleJvm) || !this.isUnknownSdk(gradleJvm)) break block2;
            this.fixupUnknownSdk(project, projectSettings);
        }
    }

    private final void fixupInternalJdk(Project project, GradleProjectSettings projectSettings) {
        ExternalSystemJdkProvider jdkProvider;
        ExternalSystemJdkProvider externalSystemJdkProvider = jdkProvider = ExternalSystemJdkProvider.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemJdkProvider, (String)"jdkProvider");
        Sdk sdk = externalSystemJdkProvider.getInternalJdk();
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"jdkProvider.internalJdk");
        Sdk internalSdk = sdk;
        projectSettings.setGradleJvm(internalSdk.getName());
        this.fixupUnknownSdk(project, projectSettings);
    }

    private final void fixupUnknownSdk(Project project, GradleProjectSettings projectSettings) {
        String string = projectSettings.getGradleJvm();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectSettings.gradleJvm ?: return");
        String gradleJvm = string;
        GradleVersion gradleVersion = projectSettings.resolveGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"projectSettings.resolveGradleVersion()");
        GradleVersion gradleVersion2 = gradleVersion;
        projectSettings.setGradleJvm(null);
        SdkLookupBuilder sdkLookupBuilder = GradleJvmResolutionUtil.getGradleJvmLookupProvider(project, projectSettings).newLookupBuilder().withSdkName(gradleJvm).withVersionFilter((Function1)new Function1<String, Boolean>(gradleVersion2){
            final /* synthetic */ GradleVersion $gradleVersion;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GradleJvmValidationUtil.isSupported(this.$gradleVersion, it);
            }
            {
                this.$gradleVersion = gradleVersion;
                super(1);
            }
        });
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
        Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"ExternalSystemJdkUtil.getJavaSdkType()");
        sdkLookupBuilder.withSdkType(sdkType).withSdkHomeFilter((Function1)fixupUnknownSdk.2.INSTANCE).onSdkNameResolved((Function1)new Function1<Sdk, Unit>(this, projectSettings){
            final /* synthetic */ GradleProjectSettingsUpdater this$0;
            final /* synthetic */ GradleProjectSettings $projectSettings;

            public final void invoke(@Nullable Sdk sdk) {
                Sdk fakeSdk;
                Sdk sdk2;
                Sdk sdk3 = sdk;
                if (sdk3 != null) {
                    Sdk sdk4 = sdk3;
                    GradleProjectSettingsUpdater gradleProjectSettingsUpdater = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    Sdk p1 = sdk4;
                    boolean bl3 = false;
                    sdk2 = GradleProjectSettingsUpdater.access$findRegisteredSdk(gradleProjectSettingsUpdater, p1);
                } else {
                    sdk2 = fakeSdk = null;
                }
                if (fakeSdk != null && this.$projectSettings.getGradleJvm() == null) {
                    this.$projectSettings.setGradleJvm(fakeSdk.getName());
                }
            }
            {
                this.this$0 = gradleProjectSettingsUpdater;
                this.$projectSettings = gradleProjectSettings;
                super(1);
            }
        }).onSdkResolved((Function1)new Function1<Sdk, Unit>(this, projectSettings, gradleJvm, project){
            final /* synthetic */ GradleProjectSettingsUpdater this$0;
            final /* synthetic */ GradleProjectSettings $projectSettings;
            final /* synthetic */ String $gradleJvm;
            final /* synthetic */ Project $project;

            public final void invoke(@Nullable Sdk sdk) {
                if (this.$projectSettings.getGradleJvm() == null) {
                    Object object = sdk;
                    if (object == null || (object = object.getName()) == null) {
                        object = this.$gradleJvm;
                    }
                    this.$projectSettings.setGradleJvm((String)object);
                }
                GradleProjectSettingsUpdater.access$notifyGradleJvmChangeInfo(this.this$0, this.$project, this.$projectSettings, this.$gradleJvm, sdk);
            }
            {
                this.this$0 = gradleProjectSettingsUpdater;
                this.$projectSettings = gradleProjectSettings;
                this.$gradleJvm = string;
                this.$project = project;
                super(1);
            }
        }).executeLookup();
    }

    private final void notifyGradleJvmChangeInfo(Project project, GradleProjectSettings projectSettings, String gradleJvm, Sdk sdk) {
        if (sdk == null) {
            return;
        }
        String string = sdk.getVersionString();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.versionString ?: return");
        String versionString = string;
        String string2 = sdk.getHomePath();
        if (string2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdk.homePath ?: return");
        String homePath = string2;
        String string3 = projectSettings.getExternalProjectPath();
        if (string3 == null) {
            return;
        }
        String externalProjectPath = string3;
        String string4 = SdkListPresenter.presentDetectedSdkPath((String)homePath);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"SdkListPresenter.presentDetectedSdkPath(homePath)");
        String presentablePath = string4;
        String notificationTitle = GradleBundle.message("gradle.notifications.java.home.change.title", new Object[0]);
        String notificationContent = GradleBundle.message("gradle.notifications.java.home.change.content", gradleJvm, versionString, presentablePath);
        String string5 = notificationTitle;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"notificationTitle");
        String string6 = notificationContent;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"notificationContent");
        Notification notification2 = NotificationGroup.createNotification$default((NotificationGroup)GradleNotification.NOTIFICATION_GROUP, (String)string5, (String)string6, (NotificationType)NotificationType.INFORMATION, null, (int)8, null);
        notification2.addAction((AnAction)NotificationAction.createSimple((String)GradleBundle.message("gradle.open.gradle.settings", new Object[0]), (Runnable)new Runnable(this, project, externalProjectPath){
            final /* synthetic */ GradleProjectSettingsUpdater this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;

            public final void run() {
                GradleProjectSettingsUpdater.access$showGradleProjectSettings(this.this$0, this.$project, this.$externalProjectPath);
            }
            {
                this.this$0 = gradleProjectSettingsUpdater;
                this.$project = project;
                this.$externalProjectPath = string;
            }
        }));
        notification2.notify(project);
    }

    private final void showGradleProjectSettings(Project project, String externalProjectPath) {
        ExternalSystemManager manager;
        ExternalSystemManager externalSystemManager = manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        if (externalSystemManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware");
        }
        Configurable configurable = ((ExternalSystemConfigurableAware)externalSystemManager).getConfigurable(project);
        Intrinsics.checkNotNullExpressionValue((Object)configurable, (String)"(manager as ExternalSyst\u2026.getConfigurable(project)");
        Configurable configurable2 = configurable;
        if (configurable2 instanceof AbstractExternalSystemConfigurable) {
            ShowSettingsUtil settingsUtil = ShowSettingsUtil.getInstance();
            settingsUtil.editConfigurable(project, configurable2, new Runnable(configurable2, externalProjectPath){
                final /* synthetic */ Configurable $configurable;
                final /* synthetic */ String $externalProjectPath;

                public final void run() {
                    ((AbstractExternalSystemConfigurable)this.$configurable).selectProject(this.$externalProjectPath);
                }
                {
                    this.$configurable = configurable;
                    this.$externalProjectPath = string;
                }
            });
        }
    }

    private final boolean isUnknownSdk(String sdkName) {
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        Sdk sdk = projectJdkTable.findJdk(sdkName);
        return sdk == null;
    }

    private final boolean isSdkName(String jdkReference) {
        return jdkReference != null && !StringsKt.startsWith$default((CharSequence)jdkReference, (char)'#', (boolean)false, (int)2, null);
    }

    private final boolean isInternalSdk(String jdkReference) {
        return Intrinsics.areEqual((Object)jdkReference, (Object)"#JAVA_INTERNAL");
    }

    private final Sdk findRegisteredSdk(Sdk sdk) {
        boolean $i$f$runReadAction = false;
        return (Sdk)ApplicationManager.getApplication().runReadAction(new Computable<T>(sdk){
            final /* synthetic */ Sdk $sdk$inlined;
            {
                this.$sdk$inlined = sdk;
            }

            public final T compute() {
                boolean bl = false;
                ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                String string = this.$sdk$inlined.getName();
                SdkTypeId sdkTypeId = this.$sdk$inlined.getSdkType();
                Intrinsics.checkNotNullExpressionValue((Object)sdkTypeId, (String)"sdk.sdkType");
                return (T)projectJdkTable.findJdk(string, sdkTypeId.getName());
            }
        });
    }

    public static final /* synthetic */ Sdk access$findRegisteredSdk(GradleProjectSettingsUpdater $this, Sdk sdk) {
        return $this.findRegisteredSdk(sdk);
    }

    public static final /* synthetic */ void access$notifyGradleJvmChangeInfo(GradleProjectSettingsUpdater $this, Project project, GradleProjectSettings projectSettings, String gradleJvm, Sdk sdk) {
        $this.notifyGradleJvmChangeInfo(project, projectSettings, gradleJvm, sdk);
    }

    public static final /* synthetic */ void access$showGradleProjectSettings(GradleProjectSettingsUpdater $this, Project project, String externalProjectPath) {
        $this.showGradleProjectSettings(project, externalProjectPath);
    }
}

