/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.jetbrains.annotations.NotNull;

public abstract class ElementProcessor<T extends PsiElement>
implements ResolveUtil.XmlProcessor {
    private int myInclude;
    private boolean myIsCyclic;
    protected final T myRoot;
    private final Set<PsiElement> myHistory = new ReferenceOpenHashSet();

    public ElementProcessor(T root) {
        this.myRoot = root;
    }

    protected abstract void processTemplate(XmlTag var1);

    protected abstract void processVarOrParam(XmlTag var1);

    protected abstract boolean shouldContinue();

    protected abstract boolean followImport();

    protected boolean isInclude() {
        return this.myInclude > 0;
    }

    public boolean isCyclic() {
        return this.myIsCyclic;
    }

    @Override
    public boolean process(XmlTag tag) {
        if (this.myHistory.contains(tag)) {
            this.myIsCyclic = true;
            return false;
        }
        this.myHistory.add((PsiElement)tag);
        if (XsltSupport.isVariableOrParam(tag)) {
            this.processVarOrParam(tag);
        } else if (XsltSupport.isTemplate(tag, false)) {
            this.processTemplate(tag);
        } else if (XsltSupport.isIncludeOrImport(tag)) {
            if (XsltSupport.isImport(tag) && !this.followImport()) {
                return this.shouldContinue();
            }
            PsiFile containingFile = tag.getContainingFile();
            assert (containingFile != null);
            PsiFile file = containingFile.getOriginalFile();
            PsiFile psiFile = ResolveUtil.resolveFile(tag.getAttribute("href", null), file);
            if (psiFile != null && XsltSupport.isXsltFile(psiFile)) {
                this.processExternalFile(psiFile, tag);
            }
        } else {
            this.processTag(tag);
        }
        return this.shouldContinue();
    }

    protected void processTag(XmlTag tag) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExternalFile(PsiFile psiFile, XmlTag place) {
        XmlDocument document = ((XmlFile)psiFile).getDocument();
        assert (document != null);
        XmlTag rootTag = document.getRootTag();
        assert (rootTag != null);
        ++this.myInclude;
        try {
            rootTag.processElements(new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof XmlTag) {
                        return ElementProcessor.this.process((XmlTag)element);
                    }
                    return ElementProcessor.this.shouldContinue();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/util/ElementProcessor$1", "execute"));
                }
            }, (PsiElement)place);
        }
        finally {
            --this.myInclude;
        }
    }
}

