/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiClassBase;
import com.android.tools.lint.checks.ApiClassOwner;
import com.android.tools.lint.checks.ApiParser;
import com.android.tools.lint.checks.PrivateApiClass;
import com.android.tools.lint.checks.PrivateApiParser;
import com.android.utils.XmlUtils;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class Api<C extends ApiClassBase> {
    private final Map<String, C> mClasses;
    private final Map<String, ApiClassOwner<C>> mContainers;

    public static Api<ApiClass> parseApi(File apiFile) {
        Api<ApiClass> api;
        FileInputStream inputStream = new FileInputStream(apiFile);
        Throwable throwable = null;
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            XmlUtils.configureSaxFactory((SAXParserFactory)parserFactory, (boolean)false, (boolean)false);
            SAXParser parser = XmlUtils.createSaxParser((SAXParserFactory)parserFactory);
            ApiParser apiParser = new ApiParser();
            parser.parse((InputStream)inputStream, (DefaultHandler)apiParser);
            ((InputStream)inputStream).close();
            api = new Api<ApiClass>(apiParser.getClasses(), apiParser.getContainers());
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    Api.$closeResource(throwable, inputStream);
                    throw throwable3;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException(e);
            }
        }
        Api.$closeResource(throwable, inputStream);
        return api;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Api<PrivateApiClass> parseHiddenApi(URL input) {
        try (InputStream inputStream = input.openStream();){
            PrivateApiParser privateApiParser = new PrivateApiParser();
            privateApiParser.parse(inputStream);
            Api<PrivateApiClass> api = new Api<PrivateApiClass>(privateApiParser.getClasses(), privateApiParser.getContainers());
            return api;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Api(Map<String, C> classes, Map<String, ApiClassOwner<C>> containers) {
        this.mClasses = Collections.unmodifiableMap(new MyHashMap<C>(classes));
        this.mContainers = Collections.unmodifiableMap(new MyHashMap<ApiClassOwner<C>>(containers));
    }

    C getClass(String fqcn) {
        return (C)((ApiClassBase)this.mClasses.get(fqcn));
    }

    Map<String, C> getClasses() {
        return this.mClasses;
    }

    Map<String, ApiClassOwner<C>> getContainers() {
        return this.mContainers;
    }

    private static class MyHashMap<V>
    extends THashMap<String, V> {
        private static final TObjectHashingStrategy<String> myHashingStrategy = new TObjectHashingStrategy<String>(){

            public int computeHashCode(String str) {
                int h = 0;
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    c = MyHashMap.normalizeSeparator(c);
                    h = 31 * h + c;
                }
                return h;
            }

            public boolean equals(String s1, String s2) {
                if (s1.length() != s2.length()) {
                    return false;
                }
                for (int i = 0; i < s1.length(); ++i) {
                    if (MyHashMap.normalizeSeparator(s1.charAt(i)) == MyHashMap.normalizeSeparator(s2.charAt(i))) continue;
                    return false;
                }
                return true;
            }
        };

        private static char normalizeSeparator(char c) {
            if (c == '/' || c == '$') {
                c = (char)46;
            }
            return c;
        }

        MyHashMap(Map<String, V> data) {
            super(data, myHashingStrategy);
        }
    }
}

