/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.NodeKeyResolver;
import com.android.manifmerger.OrphanXmlElement;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/manifmerger/IntentFilterNodeKeyResolver;", "Lcom/android/manifmerger/NodeKeyResolver;", "()V", "dataAttributeNames", "Lcom/google/common/collect/ImmutableList;", "", "kotlin.jvm.PlatformType", "keyAttributesNames", "getKeyAttributesNames", "()Lcom/google/common/collect/ImmutableList;", "model", "Lcom/android/manifmerger/ManifestModel;", "getAttributeInfo", "xmlElement", "Lcom/android/manifmerger/OrphanXmlElement;", "attributeName", "getKey", "element", "Lorg/w3c/dom/Element;", "studio.android.sdktools.manifest-merger"})
public final class IntentFilterNodeKeyResolver
implements NodeKeyResolver {
    private static final ManifestModel model;
    private static final ImmutableList<String> dataAttributeNames;
    public static final IntentFilterNodeKeyResolver INSTANCE;

    @Override
    @NotNull
    public ImmutableList<String> getKeyAttributesNames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new String[]{"action#name", "category#name"});
        for (String dataAttributeName : dataAttributeNames) {
            builder.add((Object)("data#" + dataAttributeName));
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return immutableList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getKey(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        OrphanXmlElement xmlElement = new OrphanXmlElement(element, model);
        boolean bl = xmlElement.getType() == ManifestModel.NodeTypes.INTENT_FILTER;
        boolean bl2 = false;
        int n = 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList<String> subElementAttributes = new ArrayList<String>();
        NodeList childNodes = element.getChildNodes();
        n = 0;
        NodeList nodeList = childNodes;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"childNodes");
        int n2 = nodeList.getLength();
        while (n < n2) {
            void i;
            Node child;
            Node node = child = childNodes.item((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"child");
            if (node.getNodeType() == 1) {
                OrphanXmlElement subElement = new OrphanXmlElement((Element)child, model);
                if (subElement.getType() == ManifestModel.NodeTypes.ACTION || subElement.getType() == ManifestModel.NodeTypes.CATEGORY) {
                    String attributeInfo = this.getAttributeInfo(subElement, "name");
                    if (attributeInfo != null) {
                        subElementAttributes.add(attributeInfo);
                    }
                } else if (subElement.getType() == ManifestModel.NodeTypes.DATA) {
                    UnmodifiableIterator unmodifiableIterator = dataAttributeNames.iterator();
                    while (unmodifiableIterator.hasNext()) {
                        String dataAttributeName;
                        String string = dataAttributeName = (String)unmodifiableIterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dataAttributeName");
                        String attributeInfo = this.getAttributeInfo(subElement, string);
                        if (attributeInfo == null) continue;
                        subElementAttributes.add(attributeInfo);
                    }
                }
            }
            ++i;
        }
        CollectionsKt.sort((List)subElementAttributes);
        return Joiner.on((char)'+').join((Iterable)subElementAttributes);
    }

    private final String getAttributeInfo(OrphanXmlElement xmlElement, String attributeName) {
        Element element = xmlElement.getXml();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"xmlElement.xml");
        Element element2 = element;
        Attr attr = element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
        return attr == null ? null : element2.getTagName() + ":" + attributeName + ":" + attr.getValue();
    }

    private IntentFilterNodeKeyResolver() {
    }

    static {
        IntentFilterNodeKeyResolver intentFilterNodeKeyResolver;
        INSTANCE = intentFilterNodeKeyResolver = new IntentFilterNodeKeyResolver();
        model = new ManifestModel();
        dataAttributeNames = ImmutableList.of((Object)"scheme", (Object)"host", (Object)"mimeType", (Object)"port", (Object)"path", (Object)"pathPattern", (Object)"pathPrefix");
    }
}

