/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.ConvertContext;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesConverter;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.reposearch.DependencySearchService;

public class MavenArtifactCoordinatesArtifactIdConverter
extends MavenArtifactCoordinatesConverter {
    @Override
    protected boolean doIsValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
        if (StringUtil.isEmpty((String)id.getGroupId()) || StringUtil.isEmpty((String)id.getArtifactId())) {
            return false;
        }
        if (manager.hasArtifactId(id.getGroupId(), id.getArtifactId())) {
            return true;
        }
        MavenProject mavenProject = this.findMavenProject(context);
        if (mavenProject != null) {
            for (MavenArtifact artifact : mavenProject.findDependencies(id.getGroupId(), id.getArtifactId())) {
                if (!artifact.isResolved()) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public LookupElement createLookupElement(String s) {
        return null;
    }

    @Override
    protected Set<String> doGetVariants(MavenId id, DependencySearchService searchService) {
        return Collections.emptySet();
    }
}

